/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.bamboo.servlet;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.user.BambooUser;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.atlassianuser.EmbeddedCrowdUser;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.seraph.auth.Authenticator;
import com.atlassian.seraph.auth.DefaultAuthenticator;
import com.atlassian.seraph.config.SecurityConfigFactory;
import com.atlassian.seraph.service.rememberme.RememberMeService;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.atlassian.user.impl.DefaultUser;
import com.atlassian.user.search.SearchResult;
import com.atlassian.user.search.page.Pager;
import com.miniorange.sso.saml.MoSAMLException;
import com.miniorange.sso.saml.MoSAMLResponse;
import com.miniorange.sso.saml.bamboo.MoPluginHandler;
import com.miniorange.sso.saml.bamboo.MoSAMLManager;
import com.miniorange.sso.saml.bamboo.MoSAMLSettings;
import com.miniorange.sso.saml.dto.MoIDPConfig;
import com.miniorange.sso.saml.utils.MoEncryptionUtils;
import com.miniorange.sso.saml.utils.MoHttpUtils;
import com.miniorange.sso.saml.utils.MoSAMLUtils;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensaml.xml.ConfigurationException;
import org.opensaml.xml.util.Base64;
import org.springframework.web.util.HtmlUtils;
import org.w3c.dom.Element;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;

@UnrestrictedAccess
public class MoSAMLLoginServlet
extends HttpServlet {
    private static Log LOGGER = LogFactory.getLog(MoSAMLLoginServlet.class);
    private MoSAMLSettings settings;
    private MoSAMLManager samlManager;
    private BambooUserManager bambooUserManager;
    private BambooPermissionManager bambooPermissionManager;
    private final TemplateRenderer renderer;
    private String setup;
    private DirectoryManager directoryManager;
    private MoIDPConfig idpConfig;

    public MoSAMLLoginServlet(MoSAMLSettings settings, BambooUserManager bambooUserManager, MoSAMLManager samlManager, BambooPermissionManager bambooPermissionManager, TemplateRenderer renderer, MoIDPConfig idpConfig, DirectoryManager directoryManager) {
        this.settings = settings;
        this.bambooUserManager = bambooUserManager;
        this.samlManager = samlManager;
        this.bambooPermissionManager = bambooPermissionManager;
        this.renderer = renderer;
        this.idpConfig = idpConfig;
        this.directoryManager = directoryManager;
    }

    public void showTestRegexGroupResult(HttpServletRequest request, HttpServletResponse response) throws IOException {
        StringBuilder output = new StringBuilder("<div style='display:none'>");
        String regexp = request.getParameter("regexp");
        String regexg = request.getParameter("regexg");
        String groupName = request.getParameter("groupName");
        String result = "";
        regexp = StringEscapeUtils.escapeJavaScript(regexp);
        regexp = StringEscapeUtils.escapeHtml(regexp);
        regexg = StringEscapeUtils.escapeJavaScript(regexg);
        regexg = StringEscapeUtils.escapeHtml(regexg);
        groupName = StringEscapeUtils.escapeJavaScript(groupName);
        groupName = StringEscapeUtils.escapeHtml(groupName);
        if (StringUtils.isNotEmpty((CharSequence)regexg) && StringUtils.isNotEmpty((CharSequence)regexp) && StringUtils.isNotEmpty((CharSequence)groupName)) {
            result = MoSAMLLoginServlet.getGroupnameFromRegexMethod(regexp, regexg, groupName);
        }
        output.append("</div>");
        if (StringUtils.isBlank((CharSequence)regexp) || StringUtils.isBlank((CharSequence)regexg) || StringUtils.isBlank((CharSequence)groupName)) {
            output.append("<div style=\"color: #a94442;background-color: #f2dede;padding: 15px;margin-bottom: 20px;text-align:center;border:1px solid #E6B3B2;font-size:18pt;\">TEST FAILED</div><div style=\"color: #a94442;font-size:14pt; margin-bottom:20px;\">Error message: <br> ");
            if (StringUtils.isBlank((CharSequence)regexp)) {
                output.append("<li>Regular Expression field can't left blank</li><br>");
            }
            if (StringUtils.isBlank((CharSequence)regexg)) {
                output.append("<li>Replace with field can't left blank</li><br>");
            }
            if (StringUtils.isBlank((CharSequence)groupName)) {
                output.append("<li>Group Name field can't left blank</li><br>");
            }
            output.append("</div>");
        } else if (StringUtils.isNotEmpty((CharSequence)result) && StringUtils.isNotBlank((CharSequence)groupName)) {
            output.append("<div style='color: #3c763d;background-color: #dff0d8; padding:2%;margin-bottom:20px;text-align:center; border:1px solid #AEDB9A; font-size:18pt;'>Test Regex Result</div>");
            output.append("<table border=\"1\" style=\"width: 100%;\">\n     <tbody><tr>\n        <th>Actual Value</th>\n        <th>Transformed Value</th>\n    </tr>\n    <tr>\n        <td align=\"center\">" + groupName + "</td>\n        <td align=\"center\">" + result + "</td>\n    </tr>    \n    </tbody></table>");
        } else if (StringUtils.isEmpty((CharSequence)result) && StringUtils.isNotBlank((CharSequence)groupName)) {
            output.append("<div style=\"color: #a94442;background-color: #f2dede;padding: 15px;margin-bottom: 20px;text-align:center;border:1px solid #E6B3B2;font-size:18pt;\">TEST FAILED</div><div style=\"color: #a94442;font-size:14pt; margin-bottom:20px;\">Error message: <br> ");
            output.append("<li>Regex not valid for the group Name.</li><br>");
            output.append("</div>");
        }
        output.append("<div style=\"margin:3%;display:block;text-align:center;\"><input style=\"padding:1%;width:100px;background: #0091CD none repeat scroll 0% 0%;cursor: pointer;font-size:15px;border-width: 1px;border-style: solid;border-radius: 3px;white-space: nowrap;box-sizing:border-box;border-color: #0073AA;box-shadow:0px 1px 0px rgba(120,200,230,0.6) inset;color: #FFF;\" type=\"button\" value=\"Done\" onClick=\"self.close();\"></div>");
        response.setContentType("text/html");
        response.getOutputStream().write(output.toString().getBytes("UTF-8"));
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String username = "";
        String email = "";
        LOGGER.debug((Object)"SAMLLoginServlet doGet() called");
        String returnTo = request.getParameter("return_to");
        returnTo = MoSAMLUtils.sanitizeText(returnTo);
        String title = request.getParameter("title");
        String buildNumber = request.getParameter("buildNumber");
        String idpID = request.getParameter("idp");
        this.setup = request.getParameter("setup");
        if (StringUtils.isBlank((CharSequence)idpID) && !this.settings.getIdPList().isEmpty()) {
            idpID = this.settings.getIdPList().get(0);
        }
        HttpSession session = request.getSession();
        session.setAttribute("idpId", (Object)idpID);
        Cookie idpIdCookie = MoHttpUtils.createCookie(request.getRequestURL().toString(), "mo.bamboo-sso.IDPIDCOOKIE", idpID, true, this.settings.getRememberMeCookieEnabled());
        MoHttpUtils.addCookie(response, idpIdCookie);
        if (StringUtils.isNotBlank((CharSequence)idpID)) {
            this.idpConfig = MoPluginHandler.constructIdpConfigObject(idpID);
        }
        if (this.idpConfig == null || StringUtils.isBlank((CharSequence)this.idpConfig.getId())) {
            try {
                LOGGER.error((Object)"Error occurred while generating SAML Request. Error_CODE: IDP_ID_INVALID");
                this.redirectToLoginWithSAMLError(response, null, "cant_send_request");
                return;
            }
            catch (Exception e) {
                LOGGER.error((Object)("Error occurred while generating SAML Request. " + e));
            }
        }
        if (StringUtils.isBlank((CharSequence)returnTo) || StringUtils.endsWith((CharSequence)returnTo, (CharSequence)"/plugins/servlet")) {
            LOGGER.debug((Object)"Session Created");
            returnTo = this.settings.getDashboardUrl();
        } else {
            StringBuffer returnToUrl;
            if (StringUtils.contains((CharSequence)returnTo, (CharSequence)"testregex")) {
                StringBuilder output = new StringBuilder("<div style='display:none'>");
                String regexp = request.getParameter("regexp");
                regexp = StringEscapeUtils.escapeJavaScript(regexp);
                regexp = StringEscapeUtils.escapeHtml(regexp);
                String message = "TEST REGEX....!";
                message = HtmlUtils.htmlEscape((String)message);
                output.append(message);
                output.append("</div>");
                output.append("<div style='color: #3c763d;background-color: #dff0d8; padding:2%;margin-bottom:20px;text-align:center; border:1px solid #AEDB9A; font-size:18pt;'>Test Regex Pattern</div>");
                output.append("<div id=\"testregex\"> <input type=\"text\"  id=\"attrvalue\" name=\"attrvalue\" placeholder=\"Enter Attribute Value\" class=\"text long-field\"  style=\"width:250px;padding:10px; margin-left:20px\"/>&nbsp;&nbsp;&nbsp;<label id=\"result\"/><label id=\"error\"/></div><br><br>");
                output.append("<div style=\"margin:3%;display:block;\"><input id =\"testregex-button\" style=\"padding:1%;width:150px;background: #0091CD none repeat scroll 0% 0%;cursor: pointer;font-size:15px;border-width: 1px;border-style: solid;border-radius: 3px;white-space: nowrap;box-sizing:border-box;border-color: #0073AA;box-shadow:0px 1px 0px rgba(120,200,230,0.6) inset;color: #FFF;\" type=\"button\" value=\"Test Regex\"></div>");
                output.append("<script>var input = document.getElementById(\"attrvalue\");input.addEventListener(\"keyup\", function(event) {if (event.keyCode === 13) {document.getElementById(\"testregex-button\").click();}});document.querySelector(\"#testregex-button\").onclick = function() {var attrValue = document.querySelector(\"#attrvalue\").value;var regexp ='" + MoSAMLUtils.sanitizeText(regexp) + "';console.log('original: '+regexp);if(" + this.isRegexValid(regexp) + "){console.log('Escaped: '+regexp);var regExp = new RegExp(regexp, 'g');var result = regExp.exec(attrValue); var username = '';if (result && result!=\"\") {if(result.length>1){var length = result.length;for(var count = 1; count < length; count++){console.log('Multiple Groups'); console.log(result[count]);username += result[count];}}else{console.log('No groups '+result);username = result[0];}console.log(\"Result...:\" + username);document.querySelector(\"#result\").innerHTML = username;}else { document.querySelector(\"#result\").innerHTML = \"Error : No Pattern Found.\"; }} else { document.querySelector(\"#error\").innerHTML = \"Invalid Regex Expression.\";}}</script>");
                response.setContentType("text/html");
                response.getOutputStream().write(output.toString().getBytes("UTF-8"));
                return;
            }
            if (StringUtils.contains((CharSequence)returnTo, (CharSequence)"testgroupregex")) {
                this.showTestRegexGroupResult(request, response);
                return;
            }
            if (StringUtils.containsIgnoreCase((CharSequence)returnTo, (CharSequence)"displaysamlrequest")) {
                this.displaySamlRequest(request, response, this.idpConfig, this.setup);
                return;
            }
            if (!StringUtils.isBlank((CharSequence)title) && title != null) {
                returnToUrl = new StringBuffer();
                returnToUrl.append(returnTo).append("&").append("title").append("=");
                returnToUrl.append(title);
                returnTo = URLEncoder.encode(returnToUrl.toString(), StandardCharsets.UTF_8.toString());
            }
            if (!StringUtils.isNotBlank((CharSequence)buildNumber) && buildNumber != null) {
                LOGGER.debug((Object)("Build Number : " + buildNumber));
                returnToUrl = new StringBuffer();
                returnToUrl.append(returnTo).append("&").append("buildNumber").append("=");
                returnToUrl.append(buildNumber);
                returnTo = URLEncoder.encode(returnToUrl.toString(), StandardCharsets.UTF_8.toString());
            }
        }
        ArrayList<String> enabledIdps = this.settings.getSsoEnabledForIdPList();
        if (!enabledIdps.contains(this.idpConfig.getId()) && !returnTo.equals("testidpconfiguration")) {
            try {
                LOGGER.debug((Object)("SSO is not enabled for this IDP: " + this.idpConfig.getIdpName() + " : " + this.idpConfig.getId()));
                this.redirectToLoginWithSAMLError(response, null, "sso_not_enabled_for_idp");
                return;
            }
            catch (Exception e) {
                LOGGER.error((Object)"Error occurred while redirecting to error page.");
            }
        }
        if (!(StringUtils.isBlank((CharSequence)this.idpConfig.getRelayState()) || !this.idpConfig.getRelayStateRedirectionType().equals("forceRedirect") || returnTo.equals("displaysamlrequest") || returnTo.equals("displaysamlresponse") || returnTo.equals("testidpconfiguration"))) {
            returnTo = this.idpConfig.getRelayState();
        }
        if (this.idpConfig.getSignedRequest().booleanValue()) {
            this.samlManager.createAuthnRequestAndRedirect(request, response, returnTo, this.idpConfig);
        } else {
            this.samlManager.createUnSignedAuthnRequestAndRedirect(request, response, returnTo, this.idpConfig);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            ArrayList<String> enabledIdps;
            LOGGER.debug((Object)"SAML Login Servlet doPost() called...");
            String username = "";
            String email = "";
            MoSAMLResponse samlResponse = null;
            String relayState = request.getParameter("RelayState");
            relayState = MoSAMLUtils.sanitizeText(relayState);
            String idpid = this.getIdpId(request, response);
            if (StringUtils.isNotBlank((CharSequence)idpid)) {
                if (!this.settings.getIdPList().contains(idpid)) {
                    this.redirectToLoginWithSAMLError(response, null, "cant_find_idp");
                    return;
                }
                this.idpConfig = MoPluginHandler.constructIdpConfigObject(idpid);
            } else if (this.idpConfig == null || this.idpConfig.getId() == null) {
                if (this.settings.getIdPList().size() == 1) {
                    idpid = this.settings.getIdPList().get(0);
                } else {
                    if (!StringUtils.isNotBlank((CharSequence)this.settings.getSsoServiceUrl())) {
                        this.redirectToLoginWithSAMLError(response, null, "cant_find_idp");
                        return;
                    }
                    idpid = "miniorange.saml.DEFAULT_IDP_ID";
                }
                this.idpConfig = MoPluginHandler.constructIdpConfigObject(idpid);
            }
            if (StringUtils.contains((CharSequence)relayState, (CharSequence)"displaysamlresponse")) {
                this.displaySamlResponse(request, response, this.idpConfig, this.setup);
                return;
            }
            if (!this.settings.getEnableSAMLSSO().booleanValue() && !relayState.equals("testidpconfiguration")) {
                try {
                    LOGGER.debug((Object)"SSO is not enabled  ");
                    this.redirectToLoginWithSAMLError(response, null, "sso_not_enabled");
                    return;
                }
                catch (Exception e) {
                    LOGGER.error((Object)"Error occurred while redirecting to error page.");
                }
            }
            if (!(enabledIdps = this.settings.getSsoEnabledForIdPList()).contains(this.idpConfig.getId()) && !relayState.equals("testidpconfiguration")) {
                try {
                    LOGGER.debug((Object)("SSO is not enabled for this IDP: " + this.idpConfig.getIdpName() + " : " + this.idpConfig.getId()));
                    this.redirectToLoginWithSAMLError(response, null, "sso_not_enabled_for_idp");
                    return;
                }
                catch (Exception e) {
                    LOGGER.error((Object)"Error occurred while redirecting to error page.");
                }
            }
            try {
                samlResponse = this.samlManager.readSAMLResponse(request, response, this.idpConfig);
            }
            catch (MoSAMLException e) {
                if (StringUtils.contains((CharSequence)relayState, (CharSequence)"testidpconfiguration")) {
                    this.showTestConfigurationResult(null, request, response, this.setup, e);
                    return;
                }
                this.redirectToLoginWithSAMLError(response, null, "cant_signin_check_configuration");
                return;
            }
            if (StringUtils.contains((CharSequence)samlResponse.getRelayStateURL(), (CharSequence)"testidpconfiguration")) {
                this.showTestConfigurationResult(samlResponse, request, response, this.setup, null);
                return;
            }
            if (!this.settings.isLicenseDefine().booleanValue()) {
                LOGGER.debug((Object)"No Evaluation license installed");
                this.redirectToLoginWithSAMLError(response, null, "cant_signin_no_license");
                return;
            }
            if (samlResponse.getAttributes().get(this.idpConfig.getUsernameAttribute()) != null && samlResponse.getAttributes().get(this.idpConfig.getUsernameAttribute()).length == 1) {
                username = samlResponse.getAttributes().get(this.idpConfig.getUsernameAttribute())[0];
            }
            if (samlResponse.getAttributes().get(this.idpConfig.getEmailAttribute()) != null && samlResponse.getAttributes().get(this.idpConfig.getEmailAttribute()).length == 1) {
                email = samlResponse.getAttributes().get(this.idpConfig.getEmailAttribute())[0];
            }
            username = username.toLowerCase();
            email = email.toLowerCase();
            LOGGER.debug((Object)("Username received: " + username + ", Email received: " + email));
            if (this.idpConfig.getRegexPatternEnabled().booleanValue()) {
                try {
                    Pattern pattern = Pattern.compile(StringUtils.trimToEmpty((String)this.idpConfig.getRegexPattern()));
                    Matcher matcher = pattern.matcher(username);
                    LOGGER.debug((Object)matcher);
                    if (matcher.find()) {
                        username = "";
                        if (matcher.groupCount() > 0) {
                            for (int i = 1; i <= matcher.groupCount(); ++i) {
                                username = username + matcher.group(i);
                            }
                        } else {
                            username = matcher.group();
                        }
                        LOGGER.debug((Object)("Username after regex operation: " + username));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.redirectToLoginWithSAMLError(response, null, "cant_signin_regex_pattern_exception");
                }
            }
            if (StringUtils.isNotBlank((CharSequence)username) && StringUtils.isNotBlank((CharSequence)email)) {
                BambooUser bambooUser = null;
                if (!StringUtils.equalsIgnoreCase((CharSequence)this.idpConfig.getLoginUserAttribute(), (CharSequence)"email")) {
                    LOGGER.debug((Object)"Searching user by username attribute ");
                    bambooUser = this.bambooUserManager.getBambooUser(username);
                } else {
                    LOGGER.debug((Object)"Searching user by email attribute ");
                    SearchResult emailUserSearchResult = this.bambooUserManager.getUsersByEmail(email);
                    Pager pager = emailUserSearchResult.pager();
                    int countUser = 0;
                    String userFoundByEmail = email;
                    for (Object user : pager) {
                        ++countUser;
                        LOGGER.debug((Object)("Class Name : " + user.getClass()));
                        if (user instanceof DefaultUser) {
                            userFoundByEmail = ((DefaultUser)user).getName();
                            continue;
                        }
                        if (user instanceof EmbeddedCrowdUser) {
                            userFoundByEmail = ((EmbeddedCrowdUser)user).getName();
                            continue;
                        }
                        userFoundByEmail = username;
                    }
                    LOGGER.debug((Object)("userFoundByEmail : " + userFoundByEmail));
                    if (countUser > 1) {
                        LOGGER.error((Object)("More than one user found with the same email i.e " + email + " address."));
                        this.redirectToLoginWithSAMLError(response, null, "cant_signin_check_configuration");
                        return;
                    }
                    if (!StringUtils.isEmpty((CharSequence)userFoundByEmail)) {
                        bambooUser = this.bambooUserManager.getBambooUser(userFoundByEmail);
                        LOGGER.debug((Object)("Bamboo user found by email  = " + bambooUser));
                    }
                }
                Authenticator authenticator = SecurityConfigFactory.getInstance().getAuthenticator();
                if (authenticator instanceof DefaultAuthenticator) {
                    Method getUserMethod = DefaultAuthenticator.class.getDeclaredMethod("getUser", String.class);
                    getUserMethod.setAccessible(true);
                    BambooUser userObject = null;
                    if (bambooUser == null) {
                        LOGGER.debug((Object)("User doesn't exist. Creating New User." + this.idpConfig.getAllowUserCreation()));
                        if (!BooleanUtils.toBoolean((Boolean)this.idpConfig.getAllowUserCreation())) {
                            LOGGER.debug((Object)"New user creation is restricted, unable to login new user");
                            this.redirectToLoginWithSAMLError(response, null, "cant_signin_check_configuration");
                            return;
                        }
                        userObject = this.tryCreateOrUpdateUser(username, email, samlResponse);
                    } else {
                        LOGGER.debug((Object)"User exist. Updating User.");
                        if (this.idpConfig.getRegexPatternEnabled().booleanValue() && !email.equals(bambooUser.getEmail())) {
                            LOGGER.debug((Object)"Different Email Found");
                            this.redirectToLoginWithSAMLError(response, null, "cant_signin_check_configuration");
                            return;
                        }
                        userObject = this.updateUserProfile(bambooUser.getName(), email, samlResponse);
                        LOGGER.debug((Object)("Is User with username " + bambooUser.getName() + " active :" + bambooUser.isEnabled()));
                        if (!BooleanUtils.toBoolean((Boolean)bambooUser.isEnabled())) {
                            LOGGER.debug((Object)"User is not allowed to login because user is inactive");
                            this.redirectToLoginWithSAMLError(response, null, "cant_signin_user_inactive");
                            return;
                        }
                    }
                    if (userObject != null) {
                        LOGGER.debug((Object)("Establishing session for: " + userObject));
                        Boolean result = this.authoriseUserAndEstablishSession((DefaultAuthenticator)authenticator, userObject, request, response);
                        if (result.booleanValue()) {
                            LOGGER.debug((Object)("Session created. Redirecting user to " + samlResponse.getRelayStateURL()));
                            String idpNameId = MoEncryptionUtils.encrypt(this.settings.getCustomerTokenKey(), samlResponse.getNameId());
                            Cookie logoutCookie = MoHttpUtils.createCookie(request.getRequestURL().toString(), "LOGOUTCOOKIE", this.idpConfig.getId(), false, this.settings.getRememberMeCookieEnabled());
                            Cookie nameIDCookie = MoHttpUtils.createCookie(request.getRequestURL().toString(), "NAMEIDCOOKIE", idpNameId, false, this.settings.getRememberMeCookieEnabled());
                            Cookie sessionIndexCookie = MoHttpUtils.createCookie(request.getRequestURL().toString(), "SESSIONINDEXCOOKIE", samlResponse.getSessionIndex(), false, this.settings.getRememberMeCookieEnabled());
                            response.addCookie(logoutCookie);
                            response.addCookie(nameIDCookie);
                            response.addCookie(sessionIndexCookie);
                            this.addLastAuthenticationTimestamp(userObject.getName());
                            this.redirectToSuccessfulAuthLandingPage(request, response, samlResponse.getRelayStateURL());
                            return;
                        }
                        LOGGER.debug((Object)"Session could NOT be created. Redirecting user to login page.");
                    }
                }
            }
            LOGGER.error((Object)"Username or email not received in the SAML Response. Please check your configuration.");
        }
        catch (Exception e) {
            LOGGER.error((Object)"An error occurred while verifying the SAML Response.", (Throwable)e);
        }
        this.redirectToLoginWithSAMLError(response, null, "cant_signin_check_configuration");
    }

    private void displaySamlRequest(HttpServletRequest request, HttpServletResponse response, MoIDPConfig idpConfig, String setup) {
        try {
            StringBuilder output = new StringBuilder("<div style='display:none'>");
            String message = idpConfig.getSignedRequest() != false ? this.samlManager.getSignedTestAuthnRequest(idpConfig) : this.samlManager.getUnSignedTestAuthnRequest(idpConfig);
            message = this.XmlFormatter(message);
            JSONObject idpConfigObject = this.settings.getIdpConfig(idpConfig.getId());
            idpConfigObject.put("samlRequest", message);
            this.settings.setIdpConfig(idpConfigObject, idpConfig.getId());
            message = HtmlUtils.htmlEscape((String)message);
            output.append(message);
            output.append("</div>");
            output.append("<br><div style='color: #3c763d;background-color: #dff0d8; padding:2%;margin-bottom:20px;text-align:center; border:1px solid #AEDB9A; font-size:18pt;'>Authentication(SAML) Request</div>");
            output.append("<textarea rows='6' cols='100' word-wrap='break-word;' style='width:100%; margin:0px; height:350px;' id ='reqmessage' readonly>" + message + "</textarea> ");
            if (!StringUtils.equals((CharSequence)setup, (CharSequence)"quicktestconfig")) {
                output.append("<div style=\"margin:3%;display:block;text-align:center;\"><input style=\"padding:1%;width:100px;background: #0091CD none repeat scroll 0% 0%;cursor: pointer;font-size:15px;border-width: 1px;border-style: solid;border-radius: 3px;white-space: nowrap;box-sizing:border-box;border-color: #0073AA;box-shadow:0px 1px 0px rgba(120,200,230,0.6) inset;color: #FFF;\" type=\"button\" value=\"Done\" onClick=\"self.close();\"></div>");
            }
            output.append("<div style=\"margin:3%;display:block;text-align:center;\"><input id =\"copy-req-button\" style=\"padding:1%;width:150px;background: #0091CD none repeat scroll 0% 0%;cursor: pointer;font-size:15px;border-width: 1px;border-style: solid;border-radius: 3px;white-space: nowrap;box-sizing:border-box;border-color: #0073AA;box-shadow:0px 1px 0px rgba(120,200,230,0.6) inset;color: #FFF;\" type=\"button\" value=\"Copy to Clipboard\"></div>");
            output.append("<div style=\"margin:3%;display:block;text-align:center;\"><input id =\"download-button\" style=\"padding:1%;width:200px;background: #0091CD none repeat scroll 0% 0%;cursor: pointer;font-size:15px;border-width: 1px;border-style: solid;border-radius: 3px;white-space: nowrap;box-sizing:border-box;border-color: #0073AA;box-shadow:0px 1px 0px rgba(120,200,230,0.6) inset;color: #FFF;\" type=\"button\" value=\"Download SAMLRequest\" onclick=\"downloadRequest()\"></div>");
            output.append("<script>document.querySelector(\"#copy-req-button\").onclick = function() {document.querySelector(\"#reqmessage\").select();document.execCommand('copy');};</script>");
            output.append("<script>function downloadRequest() {var textToWrite = document.getElementById(\"reqmessage\").value;var blob = new Blob([textToWrite],{type: \"text/xml;charset=utf-8;\"});var fileNameToSaveAs = \"SAMLRequest.xml\";var downloadLink = document.createElement(\"a\");downloadLink.download = fileNameToSaveAs;downloadLink.innerHTML = \"Download File\";if(window.navigator.msSaveOrOpenBlob){navigator.msSaveBlob(blob, \"SAMLRequest.xml\");}if (window.webkitURL != null){downloadLink.href = window.webkitURL.createObjectURL(blob);}else{downloadLink.href = window.URL.createObjectURL(blob);}downloadLink.onclick = destroyClickedElement;document.body.appendChild(downloadLink);downloadLink.style.display = \"none\";downloadLink.click();}function destroyClickedElement(event){document.body.removeChild(event.target);}</script>");
            if (!StringUtils.equalsIgnoreCase((CharSequence)setup, (CharSequence)"quick")) {
                response.setContentType("text/html");
                response.setCharacterEncoding("iso-8859-1");
                response.getOutputStream().write(output.toString().getBytes(StandardCharsets.UTF_8));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error occurred while displaying SAML request.");
        }
    }

    private void displaySamlResponse(HttpServletRequest request, HttpServletResponse response, MoIDPConfig idpConfig, String setup) {
        try {
            StringBuilder output = new StringBuilder("<div style='display:none'>");
            String encodedSAMLResponse = request.getParameter("SAMLResponse");
            String xml = new String(Base64.decode(encodedSAMLResponse), "UTF-8");
            xml = this.XmlFormatter(xml);
            output.append(xml);
            JSONObject idpConfigObject = this.settings.getIdpConfig(idpConfig.getId());
            idpConfigObject.put("samlResponse", xml);
            this.settings.setIdpConfig(idpConfigObject, idpConfig.getId());
            xml = HtmlUtils.htmlEscape((String)xml);
            output.append("</div>");
            output.append("<div style='color: #3c763d;background-color: #dff0d8; padding:2%;margin-bottom:20px;text-align:center; border:1px solid #AEDB9A; font-size:18pt;'>SAML Response</div>");
            output.append("<textarea rows='6' cols='100' word-wrap='break-word;' style='width:100%; margin:0px; height:350px;' id ='resmessage' readonly>" + MoSAMLUtils.sanitizeText(xml) + "</textarea> ");
            if (!StringUtils.equals((CharSequence)setup, (CharSequence)"quicktestconfig")) {
                output.append("<div style=\"margin:3%;display:block;text-align:center;\"><input style=\"padding:1%;width:100px;background: #0091CD none repeat scroll 0% 0%;cursor: pointer;font-size:15px;border-width: 1px;border-style: solid;border-radius: 3px;white-space: nowrap;box-sizing:border-box;border-color: #0073AA;box-shadow:0px 1px 0px rgba(120,200,230,0.6) inset;color: #FFF;\" type=\"button\" value=\"Done\" onClick=\"self.close();\"></div>");
            }
            output.append("<div style=\"margin:3%;display:block;text-align:center;\"><input id =\"copy-res-button\" style=\"padding:1%;width:150px;background: #0091CD none repeat scroll 0% 0%;cursor: pointer;font-size:15px;border-width: 1px;border-style: solid;border-radius: 3px;white-space: nowrap;box-sizing:border-box;border-color: #0073AA;box-shadow:0px 1px 0px rgba(120,200,230,0.6) inset;color: #FFF;\" type=\"button\" value=\"Copy to Clipboard\"></div>");
            output.append("<div style=\"margin:3%;display:block;text-align:center;\"><input id =\"download-button\" style=\"padding:1%;width:200px;background: #0091CD none repeat scroll 0% 0%;cursor: pointer;font-size:15px;border-width: 1px;border-style: solid;border-radius: 3px;white-space: nowrap;box-sizing:border-box;border-color: #0073AA;box-shadow:0px 1px 0px rgba(120,200,230,0.6) inset;color: #FFF;\" type=\"button\" value=\"Download SAMLResponse\" onclick=\"downloadResponse()\"></div>");
            output.append("<script>document.querySelector(\"#copy-res-button\").onclick = function() {document.querySelector(\"#resmessage\").select();document.execCommand('copy');};</script>");
            output.append("<script>function downloadResponse() {var textToWrite = document.getElementById(\"resmessage\").value;var blob = new Blob([textToWrite],{type: \"text/xml;charset=utf-8;\"});var fileNameToSaveAs = \"SAMLResponse.xml\";var downloadLink = document.createElement(\"a\");downloadLink.download = fileNameToSaveAs;downloadLink.innerHTML = \"Download File\";if(window.navigator.msSaveOrOpenBlob){navigator.msSaveBlob(blob, \"SAMLResponse.xml\");}if (window.webkitURL != null){downloadLink.href = window.webkitURL.createObjectURL(blob);}else{downloadLink.href = window.URL.createObjectURL(blob);}downloadLink.onclick = destroyClickedElement;document.body.appendChild(downloadLink);downloadLink.style.display = \"none\";downloadLink.click();}function destroyClickedElement(event){document.body.removeChild(event.target);}</script>");
            if (!StringUtils.equalsIgnoreCase((CharSequence)setup, (CharSequence)"quick")) {
                response.setContentType("text/html");
                response.setCharacterEncoding("iso-8859-1");
                response.getOutputStream().write(output.toString().getBytes(StandardCharsets.UTF_8));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"error occurred while displaying SAML Resposne :", (Throwable)e);
        }
    }

    private void addLastAuthenticationTimestamp(String username) throws OperationNotPermittedException {
        CrowdService crowdService = (CrowdService)ComponentLocator.getComponent(CrowdService.class);
        com.atlassian.crowd.embedded.api.User user = crowdService.getUser(username);
        Calendar cal = Calendar.getInstance();
        crowdService.setUserAttribute(user, "lastAuthenticated", String.valueOf(cal.getTimeInMillis()));
    }

    private Boolean authoriseUserAndEstablishSession(DefaultAuthenticator authenticator, Object userObject, HttpServletRequest request, HttpServletResponse response) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Principal principal = (Principal)userObject;
        Method authUserMethod = DefaultAuthenticator.class.getDeclaredMethod("authoriseUserAndEstablishSession", HttpServletRequest.class, HttpServletResponse.class, Principal.class);
        authUserMethod.setAccessible(true);
        Boolean result = (Boolean)authUserMethod.invoke((Object)authenticator, request, response, principal);
        LOGGER.debug((Object)("Authentication Result: " + result + " Is cookie Enabled?: " + this.settings.getRememberMeCookieEnabled()));
        if (result.booleanValue() && this.settings.getRememberMeCookieEnabled().booleanValue()) {
            RememberMeService rememberMeService = null;
            Method remembermeMethod = DefaultAuthenticator.class.getDeclaredMethod("getRememberMeService", new Class[0]);
            remembermeMethod.setAccessible(true);
            Object returnValue = remembermeMethod.invoke((Object)authenticator, new Object[0]);
            if (!(returnValue instanceof RememberMeService)) {
                LOGGER.debug((Object)"Authenticator method {} did not return a RememberMeService, but a ");
            }
            rememberMeService = (RememberMeService)returnValue;
            String addCookieMethodName = "addRememberMeCookie";
            Class[] parameterTypes = new Class[]{HttpServletRequest.class, HttpServletResponse.class, String.class};
            Object[] parameters = new Object[]{request, response, principal.getName()};
            Class<?> rememberMeServiceClass = rememberMeService.getClass();
            LOGGER.debug((Object)("Scanning methods for " + rememberMeServiceClass.getCanonicalName()));
            Method methodToInvoke = rememberMeServiceClass.getMethod(addCookieMethodName, parameterTypes);
            methodToInvoke.setAccessible(true);
            methodToInvoke.invoke((Object)rememberMeService, parameters);
            LOGGER.debug((Object)("Calling {} succeeded." + addCookieMethodName));
        }
        Cookie userCheckCookie = MoHttpUtils.getCookie(request, "UserCheckCookie");
        boolean userCheckToRememberIDP = false;
        if (userCheckCookie != null) {
            userCheckToRememberIDP = Boolean.parseBoolean(userCheckCookie.getValue());
        }
        if (this.settings.getRememberMyIdpCookieEnabled().booleanValue() && (userCheckToRememberIDP || !this.settings.getUserConsent().booleanValue())) {
            LOGGER.debug((Object)"Creating Cookie to remember User's IDP.");
            Cookie rememberIDPCookie = MoHttpUtils.createCookie(request.getRequestURL().toString(), "mo.jira-sso.REMEMBERIDPCOOKIE", this.idpConfig.getId(), false, this.settings.getRememberMeCookieEnabled());
            int life = 86400 * Integer.parseInt(this.settings.getConfiguredLifeForIdpCookie());
            rememberIDPCookie.setMaxAge(life);
            rememberIDPCookie.setPath("/");
            response.addCookie(rememberIDPCookie);
        }
        return result;
    }

    private void redirectToSuccessfulAuthLandingPage(HttpServletRequest request, HttpServletResponse response, String relayState) throws IOException {
        LOGGER.debug((Object)("RELAY STATE::::" + relayState));
        String redirectUrl = this.settings.getDashboardUrl();
        if (StringUtils.isNotBlank((CharSequence)relayState)) {
            if (StringUtils.contains((CharSequence)relayState, (CharSequence)"://")) {
                if (this.settings.isRelayStateDomainValid(this.idpConfig.getRelayState(), relayState).booleanValue()) {
                    relayState = StringUtils.stripEnd((String)relayState, (String)"/");
                    redirectUrl = StringUtils.isNotBlank((CharSequence)this.idpConfig.getRelayState()) && (this.idpConfig.getRelayStateRedirectionType().equals("forceRedirect") || relayState.equals(this.settings.getSpBaseUrl())) ? this.idpConfig.getRelayState() : relayState;
                } else {
                    redirectUrl = StringUtils.isNotBlank((CharSequence)this.idpConfig.getRelayState()) ? this.idpConfig.getRelayState() : this.settings.getBaseUrl();
                }
            } else {
                redirectUrl = StringUtils.isNotBlank((CharSequence)this.idpConfig.getRelayState()) && (this.idpConfig.getRelayStateRedirectionType().equals("forceRedirect") || relayState.equals("/start.action")) ? this.idpConfig.getRelayState() : this.settings.getBaseUrl().concat(relayState);
            }
        }
        if (StringUtils.contains((CharSequence)redirectUrl, (CharSequence)"/logout") || StringUtils.contains((CharSequence)redirectUrl, (CharSequence)"saml/logout")) {
            redirectUrl = this.settings.getBaseUrl();
        }
        LOGGER.debug((Object)("Redirecting user to " + redirectUrl));
        this.redirect(response, redirectUrl);
    }

    private void redirectToLoginWithSAMLError(HttpServletResponse response, Exception exception, String string) throws ServletException {
        try {
            if (exception != null) {
                LOGGER.error((Object)("SAML Plugin error: " + exception.getMessage()), (Throwable)exception);
            }
            String redirectUrl = this.settings.getLoginPageUrl() + "?samlerror=" + string;
            if (BooleanUtils.toBoolean((Boolean)(this.settings.getEnableErrorMsgTemplate() != false || !StringUtils.equals((CharSequence)this.settings.getDefaultBambooIDP(), (CharSequence)"loginPage") && this.settings.getBambooRedirectionRulesMap().isEmpty() ? 1 : 0))) {
                String baseURL = this.settings.getLoginPageUrl();
                HashMap<String, String> context = new HashMap<String, String>();
                context.put("baseUrl", baseURL);
                response.setContentType("text/html;charset=utf-8");
                String result = this.renderer.renderFragment(this.settings.getErrorMsgTemplate(), context);
                response.getWriter().write(result);
            } else {
                this.redirect(response, redirectUrl);
            }
        }
        catch (IOException ioException) {
            throw new ServletException();
        }
    }

    private BambooUser tryCreateOrUpdateUser(String username, String email, MoSAMLResponse samlResponse) throws UserNotFoundException, OperationFailedException, GroupNotFoundException, OperationNotPermittedException, IllegalArgumentException, EntityException {
        LOGGER.debug((Object)"Creating New User.");
        String fullName = "";
        String firstName = "";
        String lastName = "";
        if (this.idpConfig.getUseSeparateNameAttributes().booleanValue()) {
            if (samlResponse.getAttributes().get(this.idpConfig.getFirstNameAttribute()) != null && samlResponse.getAttributes().get(this.idpConfig.getFirstNameAttribute()).length == 1) {
                firstName = samlResponse.getAttributes().get(this.idpConfig.getFirstNameAttribute())[0];
            }
            if (samlResponse.getAttributes().get(this.idpConfig.getLastNameAttribute()) != null && samlResponse.getAttributes().get(this.idpConfig.getLastNameAttribute()).length == 1) {
                lastName = samlResponse.getAttributes().get(this.idpConfig.getLastNameAttribute())[0];
            }
            fullName = firstName + " " + lastName;
        } else if (samlResponse.getAttributes().get(this.idpConfig.getFullNameAttribute()) != null && samlResponse.getAttributes().get(this.idpConfig.getFullNameAttribute()).length == 1) {
            fullName = samlResponse.getAttributes().get(this.idpConfig.getFullNameAttribute())[0];
        }
        String[] atrArray = this.idpConfig.getRoleAttribute().split(";");
        ArrayList<String> roleValuesList = null;
        Boolean userWithNOIDPGroups = true;
        for (String atr : atrArray) {
            String[] roleValues = samlResponse.getAttributes().get(atr);
            if (userWithNOIDPGroups.booleanValue()) {
                userWithNOIDPGroups = roleValues == null || roleValues.length == 0;
            }
            if (roleValuesList == null) {
                roleValuesList = this.serializeGroups(roleValues);
                continue;
            }
            roleValuesList.addAll(this.serializeGroups(roleValues));
        }
        LOGGER.debug((Object)("\n\n userWithNOIDPGroups = " + userWithNOIDPGroups + "\n\n"));
        HashSet<String> roleValuesHashList = new HashSet<String>();
        for (String s : roleValuesList) {
            roleValuesHashList.add(s);
        }
        roleValuesList = new ArrayList(roleValuesHashList);
        List<String> groupsToAssign = this.getListOfMappedGroupsToAssign(roleValuesList);
        String randomPassword = this.getRandomPassword();
        if (StringUtils.isBlank((CharSequence)fullName)) {
            fullName = username;
        }
        BambooUser createdBombooUser = null;
        boolean addDefaultGroups = !StringUtils.equals((CharSequence)this.idpConfig.getEnableDefaultGroupsFor(), (CharSequence)"doNotAssignDefaultGroup") && (StringUtils.equals((CharSequence)this.idpConfig.getEnableDefaultGroupsFor(), (CharSequence)"NoIDPGroupUsers") && userWithNOIDPGroups == true || StringUtils.equals((CharSequence)this.idpConfig.getEnableDefaultGroupsFor(), (CharSequence)"newUsers") || StringUtils.equals((CharSequence)this.idpConfig.getEnableDefaultGroupsFor(), (CharSequence)"allUsers"));
        ArrayList<String> defaultGroup = new ArrayList<String>();
        if (BooleanUtils.toBoolean((Boolean)addDefaultGroups)) {
            LOGGER.debug((Object)"Assigning default group to new user");
            List<String> defaultGroups = this.idpConfig.getDefaultGroupsList();
            if (defaultGroups != null && defaultGroups.size() > 0) {
                defaultGroup.addAll(defaultGroups);
            } else {
                defaultGroup.add(this.idpConfig.getDefaultGroup());
            }
        }
        if (this.idpConfig.getOnTheFlyGroupCreation().booleanValue()) {
            groupsToAssign = new ArrayList<String>();
            LOGGER.debug((Object)("On the Fly is enabled. Creating user with Username: " + username + ", Email: " + email + ", Name:" + fullName));
            if (roleValuesList != null && !roleValuesList.isEmpty()) {
                LOGGER.debug((Object)"Assigning mapped groups to user");
                groupsToAssign = this.createAndAssignGroups(roleValuesList);
            }
            groupsToAssign.addAll(defaultGroup);
            this.createNewUser(username, randomPassword, fullName, email, firstName, lastName, groupsToAssign);
            createdBombooUser = this.bambooUserManager.getBambooUser(username);
        } else if (this.idpConfig.getCreateUsersIfRoleMapped().booleanValue() && groupsToAssign.size() > 0 || !this.idpConfig.getCreateUsersIfRoleMapped().booleanValue()) {
            LOGGER.debug((Object)("Roles found. Creating user with Username: " + username + ", Email: " + email + ", Name:" + fullName));
            if (groupsToAssign.isEmpty()) {
                LOGGER.debug((Object)("username = " + username + "email = " + email + "fullName = " + fullName + "defaultGroup = " + defaultGroup));
                this.createNewUser(username, randomPassword, fullName, email, firstName, lastName, defaultGroup);
                createdBombooUser = this.bambooUserManager.getBambooUser(username);
            } else {
                LOGGER.debug((Object)("username = " + username + "email = " + email + "fullName = " + fullName + "defaultGroup = " + groupsToAssign));
                groupsToAssign.addAll(defaultGroup);
                this.createNewUser(username, randomPassword, fullName, email, firstName, lastName, groupsToAssign);
                createdBombooUser = this.bambooUserManager.getBambooUser(username);
            }
        }
        return createdBombooUser;
    }

    private void createNewUser(String username, String password, String fullName, String email, String firstName, String lastName, List<String> groupsToAssign) {
        try {
            List directoryObjects = this.directoryManager.findAllDirectories();
            Directory defaultDirectory = !StringUtils.endsWithIgnoreCase((CharSequence)this.idpConfig.getDefaultUserDirectory(), (CharSequence)"miniorange.saml.DEFAULT_USER_DIRECTORY") ? this.directoryManager.findDirectoryByName(this.idpConfig.getDefaultUserDirectory()) : this.directoryManager.findDirectoryByName(this.settings.getDefaultWritableDirectory());
            if (defaultDirectory == null || !defaultDirectory.isActive()) {
                for (Directory dir : directoryObjects) {
                    if (!dir.isActive() || !dir.getAllowedOperations().contains(OperationType.CREATE_USER)) continue;
                    defaultDirectory = dir;
                    break;
                }
            }
            UserTemplate user = new UserTemplate(username, defaultDirectory.getId().longValue());
            user.setActive(true);
            user.setEmailAddress(email);
            user.setDirectoryId(defaultDirectory.getId().longValue());
            user.setName(username);
            user.setDisplayName(fullName);
            user.setFirstName(firstName);
            user.setLastName(lastName);
            PasswordCredential passwordCredential = new PasswordCredential(this.getRandomPassword(), true);
            this.directoryManager.addUser(defaultDirectory.getId().longValue(), user, passwordCredential);
            for (String groupName : groupsToAssign) {
                this.bambooUserManager.addMembership(groupName, username);
            }
        }
        catch (Exception e) {
            LOGGER.debug((Object)("Exception occurs while creating new user." + e.getMessage()));
        }
    }

    private List<String> createAndAssignGroups(ArrayList<String> roleValuesList) {
        ArrayList<String> groupsToAssign = new ArrayList<String>();
        Boolean canCreateNewGroups = this.idpConfig.getCreateNewGroups();
        try {
            for (String groupsName : roleValuesList) {
                Group bambooGroup;
                if (this.bambooUserManager.getGroup(groupsName.trim()) == null && BooleanUtils.toBoolean((Boolean)canCreateNewGroups)) {
                    LOGGER.debug((Object)("Creating New Group : " + groupsName.trim()));
                    this.bambooUserManager.createGroup(groupsName.trim());
                }
                if ((bambooGroup = this.bambooUserManager.getGroup(groupsName.trim())) != null) {
                    LOGGER.debug((Object)("Assigning Bamboo Group to user with name : " + bambooGroup.getName().trim()));
                    groupsToAssign.add(groupsName.trim());
                    continue;
                }
                LOGGER.debug((Object)("Group not present in Bamboo with name : " + groupsName.trim()));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"An Error occurred while creating a list of group for assigning the user");
            e.printStackTrace();
        }
        return groupsToAssign;
    }

    private ArrayList<String> serializeGroups(String[] roleValues) {
        ArrayList<String> trimmedList = new ArrayList<String>();
        if (roleValues != null && roleValues.length != 0) {
            ArrayList<String> roleValuesList = new ArrayList<String>(Arrays.asList(roleValues));
            for (int i = 0; i < roleValuesList.size(); ++i) {
                if (!StringUtils.contains((CharSequence)roleValuesList.get(i), (CharSequence)";")) continue;
                String roleValue = roleValuesList.remove(i);
                ArrayList<String> separatedValues = new ArrayList<String>(Arrays.asList(StringUtils.split((String)roleValue, (String)";")));
                roleValuesList.addAll(separatedValues);
            }
            for (String roleValue : roleValuesList) {
                LOGGER.debug((Object)("Group Regex Pattern Enabled " + this.idpConfig.getGroupRegexPatternEnabled()));
                if (this.idpConfig.getGroupRegexPatternEnabled().booleanValue()) {
                    LOGGER.debug((Object)"Transforming the rolevalue");
                    roleValue = MoSAMLLoginServlet.getGroupnameFromRegexMethod(this.idpConfig.getRegexPatternForGroup(), this.idpConfig.getRegexGroups(), roleValue);
                }
                trimmedList.add(roleValue.trim());
            }
        }
        return trimmedList;
    }

    private List<String> getListOfMappedGroupsToAssign(ArrayList<String> roleValues) {
        ArrayList<String> groupsToAssign = new ArrayList<String>();
        if (roleValues != null && roleValues.size() > 0) {
            HashMap<String, String> roleMapping = this.idpConfig.getRoleMapping();
            for (String key : roleMapping.keySet()) {
                String value = roleMapping.get(key);
                String[] groupNamesConfigured = StringUtils.split((String)value, (String)";");
                for (int i = 0; i < groupNamesConfigured.length; ++i) {
                    Group bambooUsersGroup;
                    String groupValue = groupNamesConfigured[i];
                    if (!roleValues.contains(groupValue) || (bambooUsersGroup = this.bambooUserManager.getGroup(key)) == null) continue;
                    groupsToAssign.add(bambooUsersGroup.toString());
                }
            }
        }
        return groupsToAssign;
    }

    public String getRandomPassword() {
        String SALTCHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890";
        StringBuilder salt = new StringBuilder();
        Random rnd = new Random();
        while (salt.length() < 18) {
            int index = (int)(rnd.nextFloat() * (float)SALTCHARS.length());
            salt.append(SALTCHARS.charAt(index));
        }
        String saltStr = salt.toString();
        return saltStr;
    }

    private BambooUser updateUserProfile(String username, String email, MoSAMLResponse samlResponse) throws Exception {
        block38: {
            Boolean canBeUpdated;
            block39: {
                boolean addDefaultGroups;
                LOGGER.debug((Object)"Update user profile called");
                String fullName = "";
                String firstName = "";
                String lastName = "";
                if (this.idpConfig.getUseSeparateNameAttributes().booleanValue()) {
                    if (samlResponse.getAttributes().get(this.idpConfig.getFirstNameAttribute()) != null && samlResponse.getAttributes().get(this.idpConfig.getFirstNameAttribute()).length == 1) {
                        firstName = samlResponse.getAttributes().get(this.idpConfig.getFirstNameAttribute())[0];
                    }
                    if (samlResponse.getAttributes().get(this.idpConfig.getLastNameAttribute()) != null && samlResponse.getAttributes().get(this.idpConfig.getLastNameAttribute()).length == 1) {
                        lastName = samlResponse.getAttributes().get(this.idpConfig.getLastNameAttribute())[0];
                    }
                    fullName = firstName + " " + lastName;
                } else if (samlResponse.getAttributes().get(this.idpConfig.getFullNameAttribute()) != null && samlResponse.getAttributes().get(this.idpConfig.getFullNameAttribute()).length == 1) {
                    fullName = samlResponse.getAttributes().get(this.idpConfig.getFullNameAttribute())[0];
                }
                if (this.idpConfig.getKeepExistingUserAttributes().booleanValue()) {
                    try {
                        LOGGER.debug((Object)"Updating user attributes.");
                        User user = this.bambooUserManager.getUser(username);
                        DefaultUser defaultUser = new DefaultUser(user);
                        defaultUser.setFullName(fullName);
                        defaultUser.setEmail(email);
                        this.bambooUserManager.saveUser((User)defaultUser);
                    }
                    catch (Exception e) {
                        LOGGER.debug((Object)"An exception occurs while updating user.");
                    }
                }
                String[] atrArray = this.idpConfig.getRoleAttribute().split(";");
                ArrayList<String> roleValuesList = null;
                Boolean userWithNOIDPGroups = true;
                for (String atr : atrArray) {
                    String[] roleValues = samlResponse.getAttributes().get(atr);
                    if (userWithNOIDPGroups.booleanValue()) {
                        userWithNOIDPGroups = roleValues == null || roleValues.length == 0;
                    }
                    if (roleValuesList == null) {
                        roleValuesList = this.serializeGroups(roleValues);
                        continue;
                    }
                    roleValuesList.addAll(this.serializeGroups(roleValues));
                }
                LOGGER.debug((Object)("\n\n userWithNOIDPGroups = " + userWithNOIDPGroups + "\n\n"));
                HashSet<String> roleValuesHashList = new HashSet<String>();
                for (String s : roleValuesList) {
                    roleValuesHashList.add(s);
                }
                roleValuesList = new ArrayList(roleValuesHashList);
                List<String> groupsToAssign = this.getListOfMappedGroupsToAssign(roleValuesList);
                canBeUpdated = this.canGroupBeUpdated(username);
                if (this.idpConfig.getKeepExistingUserRoles().booleanValue()) {
                    LOGGER.debug((Object)("Can groups can be updated: " + canBeUpdated));
                    List existingGroupsOfUser = new ArrayList();
                    existingGroupsOfUser = this.bambooUserManager.getGroupNamesAsList((User)this.bambooUserManager.getBambooUser(username));
                    if (this.idpConfig.getOnTheFlyGroupCreation().booleanValue()) {
                        List<String> onTheFlyGroupsToAssign = new ArrayList();
                        List<String> list = this.idpConfig.getOnTheFlyDoNotRemoveGroups();
                        if (!BooleanUtils.toBoolean((Boolean)this.idpConfig.getOnTheFlyAssignNewGroupsOnly())) {
                            for (String group : existingGroupsOfUser) {
                                if (list.contains(group) || !BooleanUtils.toBoolean((Boolean)canBeUpdated)) continue;
                                try {
                                    if (this.bambooPermissionManager.getAdminGroups().contains(group)) {
                                        LOGGER.debug((Object)(group + " has ADMINISTRATOR permission & checking for single admin "));
                                        LOGGER.debug((Object)("getAdminUsers().size() : " + this.getAdminUsers().size()));
                                        if (this.getAdminUsers().size() > 1) {
                                            this.bambooUserManager.removeMembership(group, username);
                                            LOGGER.debug((Object)("User " + username + " is not a Single Admin so removed from group " + group));
                                            continue;
                                        }
                                        LOGGER.debug((Object)("Unable to delete user with username " + username + " because he is the single admin present in the System."));
                                        continue;
                                    }
                                    this.bambooUserManager.removeMembership(group, username);
                                    LOGGER.debug((Object)("User " + username + " is removed from group " + group));
                                }
                                catch (Exception e) {
                                    LOGGER.debug((Object)("Issue with removing user with name " + username + " from group " + group + " Reason:" + e));
                                }
                            }
                        }
                        LOGGER.debug((Object)"Assigning groups to user from SAML against attribute name.");
                        onTheFlyGroupsToAssign = this.createAndAssignGroups(roleValuesList);
                        for (String newGroups : onTheFlyGroupsToAssign) {
                            if (!BooleanUtils.toBoolean((Boolean)canBeUpdated) || this.isGroupAlreadyAssignedToUser(username, newGroups)) continue;
                            try {
                                this.bambooUserManager.addMembership(newGroups, username);
                                LOGGER.debug((Object)("User " + username + " is added to group " + newGroups));
                            }
                            catch (Exception e) {
                                LOGGER.debug((Object)("Issue with adding user with name " + username + " from group " + newGroups + " Reason:" + e));
                            }
                        }
                    } else if (StringUtils.isNotBlank((CharSequence)this.idpConfig.getRoleAttribute())) {
                        for (String string : groupsToAssign) {
                            if (existingGroupsOfUser.contains(string) || !BooleanUtils.toBoolean((Boolean)canBeUpdated) || this.isGroupAlreadyAssignedToUser(username, string)) continue;
                            try {
                                this.bambooUserManager.addMembership(string, username);
                                LOGGER.debug((Object)("User " + username + " is added to group " + string));
                            }
                            catch (Exception e) {
                                LOGGER.debug((Object)("Issue with adding user with name " + username + " from group " + string + " Reason:" + e));
                            }
                        }
                        HashMap<String, String> roleMapping = this.idpConfig.getRoleMapping();
                        for (Object groups : existingGroupsOfUser) {
                            if (groupsToAssign.contains(groups) || !StringUtils.isNotEmpty((CharSequence)roleMapping.get(groups)) || !BooleanUtils.toBoolean((Boolean)canBeUpdated) || !this.isGroupAlreadyAssignedToUser(username, (String)groups)) continue;
                            try {
                                this.bambooUserManager.removeMembership((String)groups, username);
                                LOGGER.debug((Object)("User " + username + " is removed to group " + (String)groups));
                            }
                            catch (Exception e) {
                                LOGGER.debug((Object)("Issue with removing user with name " + username + " from group " + (String)groups + " Reason:" + e));
                            }
                        }
                    } else {
                        LOGGER.debug((Object)"Group to Attribute is EMPTY");
                    }
                } else {
                    LOGGER.debug((Object)"Update user groups is disabled.");
                }
                boolean bl = addDefaultGroups = StringUtils.equals((CharSequence)this.idpConfig.getEnableDefaultGroupsFor(), (CharSequence)"allUsers") || StringUtils.equals((CharSequence)this.idpConfig.getEnableDefaultGroupsFor(), (CharSequence)"NoIDPGroupUsers") && userWithNOIDPGroups == true;
                if (!BooleanUtils.toBoolean((Boolean)addDefaultGroups)) break block38;
                ArrayList defaultGroup = new ArrayList();
                List<String> list = this.idpConfig.getDefaultGroupsList();
                if (list == null || list.size() <= 0) break block39;
                for (String group : list) {
                    if (!BooleanUtils.toBoolean((Boolean)canBeUpdated) || this.isGroupAlreadyAssignedToUser(username, group)) continue;
                    try {
                        this.bambooUserManager.addMembership(group, username);
                        LOGGER.debug((Object)("User " + username + " is added to group " + group));
                    }
                    catch (Exception e) {
                        LOGGER.debug((Object)("Issue with adding user with name " + username + " from group " + group + " Reason:" + e));
                    }
                }
                break block38;
            }
            if (!BooleanUtils.toBoolean((Boolean)canBeUpdated) || this.isGroupAlreadyAssignedToUser(username, this.idpConfig.getDefaultGroup())) break block38;
            try {
                this.bambooUserManager.addMembership(this.idpConfig.getDefaultGroup(), username);
                LOGGER.debug((Object)("User " + username + " is added to group " + this.idpConfig.getDefaultGroup()));
            }
            catch (Exception e) {
                LOGGER.debug((Object)("Issue with adding user with name " + username + " from group " + this.idpConfig.getDefaultGroup() + " Reason:" + e));
            }
        }
        return this.bambooUserManager.getBambooUser(username);
    }

    private Collection<String> getAdminUsers() {
        HashSet<String> adminUsers = new HashSet<String>();
        adminUsers.addAll(this.bambooPermissionManager.getAdminUsers());
        adminUsers.addAll(this.bambooPermissionManager.getRestrictedAdminUsers());
        for (String groupName : this.bambooPermissionManager.getAdminGroups()) {
            List users = this.bambooUserManager.getMemberNamesAsList(this.bambooUserManager.getGroup(groupName));
            LOGGER.debug((Object)("Users : " + users));
            adminUsers.addAll(users);
        }
        return adminUsers;
    }

    private boolean isGroupAlreadyAssignedToUser(String username, String groupName) {
        List existingGroupsOfUser = new ArrayList();
        existingGroupsOfUser = this.bambooUserManager.getGroupNamesAsList((User)this.bambooUserManager.getBambooUser(username));
        return existingGroupsOfUser.contains(groupName);
    }

    private boolean canGroupBeUpdated(String username) {
        com.atlassian.crowd.embedded.api.User user;
        LOGGER.debug((Object)"canGroupBeUpdated called");
        if (this.settings.getCurrentBuildNumber() < 60604) {
            LOGGER.debug((Object)("Is Read Only : " + this.bambooUserManager.isReadOnly(this.bambooUserManager.getUser(username))));
            return !this.bambooUserManager.isReadOnly(this.bambooUserManager.getUser(username));
        }
        CrowdService crowdService = (CrowdService)ComponentLocator.getComponent(CrowdService.class);
        CrowdDirectoryService crowdDirectoryService = (CrowdDirectoryService)ComponentLocator.getComponent(CrowdDirectoryService.class);
        Directory directory = crowdDirectoryService.findDirectoryById((user = crowdService.getUser(username)).getDirectoryId());
        return directory == null ? false : directory.getAllowedOperations().contains(OperationType.UPDATE_GROUP);
    }

    public BambooUserManager getBambooUserManager() {
        return this.bambooUserManager;
    }

    public void setBambooUserManager(BambooUserManager bambooUserManager) {
        this.bambooUserManager = bambooUserManager;
    }

    public void setSettings(MoSAMLSettings settings) {
        this.settings = settings;
    }

    public void setSamlManager(MoSAMLManager samlManager) {
        this.samlManager = samlManager;
    }

    public BambooPermissionManager getBambooPermissionManager() {
        return this.bambooPermissionManager;
    }

    public void setBambooPermissionManager(BambooPermissionManager bambooPermissionManager) {
        this.bambooPermissionManager = bambooPermissionManager;
    }

    private void redirect(HttpServletResponse response, String url) throws IOException {
        StringBuffer htmlStart = new StringBuffer("<html><head><script>window.onload = function() {window.location.href=\"" + url + "\"};</script></head><body>Please wait...</body></html>");
        response.setContentType("text/html");
        response.getOutputStream().write(htmlStart.toString().getBytes());
    }

    public String XmlFormatter(String xml) {
        try {
            InputSource src = new InputSource(new StringReader(xml));
            Element document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(src).getDocumentElement();
            Boolean keepDeclaration = xml.startsWith("<?xml");
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            LSSerializer writer = impl.createLSSerializer();
            writer.getDomConfig().setParameter("format-pretty-print", Boolean.TRUE);
            writer.getDomConfig().setParameter("xml-declaration", keepDeclaration);
            return writer.writeToString(document);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void showTestConfigurationResult(MoSAMLResponse samlResponse, HttpServletRequest request, HttpServletResponse response, String setup, MoSAMLException e) throws IOException {
        response.setContentType("text/html");
        Boolean testConfigFailed = Boolean.FALSE;
        if (e == null) {
            String username = "";
            StringBuffer htmlStart = new StringBuffer("<div style=\"font-family:Calibri;padding:0 3%;\">");
            String[] usernameArray = samlResponse.getAttributes().get(this.idpConfig.getUsernameAttribute());
            if (usernameArray != null && usernameArray.length == 1) {
                username = usernameArray[0];
            }
            htmlStart = StringUtils.isBlank((CharSequence)username) ? htmlStart.append("<div style=\"color: #a94442;background-color: #f2dede;padding: 15px;margin-bottom: 20px;text-align:center;border:1px solid #E6B3B2;font-size:18pt;\">TEST FAILED</div><div style=\"color: #a94442;font-size:14pt; margin-bottom:20px;\">WARNING: Username attribute not found in the response. Users will not be able to login. [Please check Username attribute in User profile tab it should be similar to attribute Name in IDP.]</div>") : htmlStart.append("<div style=\"color: #3c763d;background-color: #dff0d8; padding:2%;margin-bottom:20px;text-align:center; border:1px solid #AEDB9A; font-size:18pt;\">TEST SUCCESSFUL</div>");
            htmlStart = htmlStart.append("<span style=\"font-size:14pt;\"><b>Hello</b>, " + MoSAMLUtils.sanitizeText(username) + "</span><br/><p style=\"font-weight:bold;font-size:14pt;margin-left:1%;\">ATTRIBUTES RECEIVED:</p><table style=\"border-collapse:collapse;border-spacing:0; display:table;width:100%; font-size:14pt;background-color:#EDEDED;\"><tr style=\"text-align:center;\"><td style=\"font-weight:bold;border:2px solid #949090;padding:2%;\">ATTRIBUTE NAME</td><td style=\"font-weight:bold;padding:2%;border:2px solid #949090; word-wrap:break-word;\">ATTRIBUTE VALUE</td></tr>");
            for (String key : samlResponse.getAttributes().keySet()) {
                htmlStart = htmlStart.append("<tr><td style=\"font-weight:bold;border:2px solid #949090;padding:2%;\">" + MoSAMLUtils.sanitizeText(key) + "</td><td style=\"padding:2%;border:2px solid #949090;word-wrap:break-word;\">");
                String[] values = samlResponse.getAttributes().get(key);
                for (int i = 0; i < values.length; ++i) {
                    htmlStart = i == values.length - 1 ? htmlStart.append(StringUtils.join((Object[])new String[]{MoSAMLUtils.sanitizeText(values[i]), "<br/>"})) : htmlStart.append(StringUtils.join((Object[])new String[]{MoSAMLUtils.sanitizeText(values[i]), "<hr/>"}));
                }
                htmlStart = htmlStart.append("</td></tr>");
            }
            htmlStart = htmlStart.append("</table></div>");
            if (!StringUtils.equals((CharSequence)setup, (CharSequence)"quicktestconfig")) {
                htmlStart = htmlStart.append("<div style=\"margin:3%;display:block;text-align:center;\"><input style=\"padding:1%;width:100px;background: #0091CD none repeat scroll 0% 0%;cursor: pointer;font-size:15px;border-width: 1px;border-style: solid;border-radius: 3px;white-space: nowrap;box-sizing:border-box;border-color: #0073AA;box-shadow:0px 1px 0px rgba(120,200,230,0.6) inset;color: #FFF;\" type=\"button\" value=\"Done\" onClick=\"self.close();\"></div>");
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)setup, (CharSequence)"quick")) {
                response.setContentType("text/html");
                response.setCharacterEncoding("iso-8859-1");
                response.getOutputStream().write(htmlStart.toString().getBytes(StandardCharsets.UTF_8));
            }
        } else {
            testConfigFailed = Boolean.TRUE;
            StringBuffer htmlStart = new StringBuffer("<div style=\"font-family:Calibri;padding:0 3%;\">");
            htmlStart = htmlStart.append("<div style=\"color:#a94442;background-color:#f2dede;padding:15px;margin-bottom:20px;text-align:center;border:1px solid #E6B3B2;font-size:18pt;\">TEST FAILED</div>");
            htmlStart = htmlStart.append("<table style=\"border-collapse:collapse;border-spacing:0; display:table;width:100%;font-size:14pt;\"><tr style=\"padding-top:10px;padding-bottom:10px;\"><td style=\"font-weight:bold;padding:10px 5px 10px 5px;\">Error Code</td><td style=\"word-wrap:break-word;\">" + (Object)((Object)e.getErrorCode()) + "</td></tr><tr><td style=\"font-weight:bold;padding:10px 5px 10px 5px;\">Error Message</td><td style=\"word-wrap:break-word;\">" + e.getMessage() + "</td></tr><tr><td style=\"font-weight:bold;padding:10px 5px 10px 5px;\">Resolution</td><td style=\"word-wrap:break-word;\">" + e.getResolution() + "</tr></table></div>");
            if (!StringUtils.equalsIgnoreCase((CharSequence)setup, (CharSequence)"quick")) {
                response.setContentType("text/html");
                response.setCharacterEncoding("iso-8859-1");
                response.getOutputStream().write(htmlStart.toString().getBytes(StandardCharsets.UTF_8));
            }
        }
        try {
            StringBuffer message = new StringBuffer();
            if (testConfigFailed.booleanValue()) {
                message = message.append("<div style=\"font-family:Calibri;padding:0 3%;\">");
                message = message.append("<div style=\"color:#a94442;background-color:#f2dede;padding:15px;margin-bottom:20px;text-align:center;border:1px solid #E6B3B2;font-size:18pt;\">TEST FAILED</div>");
                message = message.append("<table style=\"border-collapse:collapse;border-spacing:0; display:table;width:100%;font-size:14pt;\"><tr style=\"padding-top:10px;padding-bottom:10px;\"><td style=\"font-weight:bold;padding:10px 5px 10px 5px;\">Error Code</td><td style=\"word-wrap:break-word;\">" + (Object)((Object)e.getErrorCode()) + "</td></tr><tr><td style=\"font-weight:bold;padding:10px 5px 10px 5px;\">Error Message</td><td style=\"word-wrap:break-word;\">" + e.getMessage() + "</td></tr><tr><td style=\"font-weight:bold;padding:10px 5px 10px 5px;\">Resolution</td><td style=\"word-wrap:break-word;\">" + e.getResolution() + "</tr></table></div>");
            } else {
                message = message.append("<div style=\"color: #3c763d;background-color: #dff0d8; padding:2%;margin-bottom:20px;text-align:center; border:1px solid #AEDB9A; font-size:18pt;\">Test complete. You may close this window.</div>");
                this.displaySamlRequest(request, response, this.idpConfig, setup);
                this.displaySamlResponse(request, response, this.idpConfig, setup);
                JSONObject idpConfigObject = this.settings.getIdpConfig(this.idpConfig.getId());
                idpConfigObject.put("testConfig", samlResponse.getAttributes());
                this.settings.setIdpConfig(idpConfigObject, this.idpConfig.getId());
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)setup, (CharSequence)"quick")) {
                response.setCharacterEncoding("iso-8859-1");
                response.setContentType("text/html");
                response.getOutputStream().write(message.toString().getBytes(StandardCharsets.UTF_8));
            }
        }
        catch (Exception ie) {
            LOGGER.error((Object)"Error while getting saml request or response");
        }
    }

    public static String getGroupnameFromRegexMethod(String groupRegexPattern, String regexGroups, String groupName) {
        LOGGER.debug((Object)("Applying regex pattern on Groupname : " + groupName));
        LOGGER.debug((Object)("group regex pattern:" + groupRegexPattern));
        try {
            Pattern pattern = Pattern.compile(StringUtils.trimToEmpty((String)groupRegexPattern));
            LOGGER.debug((Object)("pattern group regex:" + pattern));
            Matcher matcher = pattern.matcher(groupName);
            if (matcher.find()) {
                groupName = "";
                LOGGER.debug((Object)("Matched Groups " + matcher.groupCount()));
                groupName = matcher.groupCount() > 0 ? MoPluginHandler.getGroupNameFromRegex(matcher, StringUtils.trimToEmpty((String)regexGroups)) : matcher.group();
                return groupName;
            }
        }
        catch (Exception e) {
            LOGGER.debug((Object)(" run time exception:" + e));
        }
        return groupName;
    }

    private String getIdpId(HttpServletRequest request, HttpServletResponse response) throws ConfigurationException {
        String idpId = "";
        HttpSession session = request.getSession();
        idpId = (String)session.getAttribute("idpId");
        if (StringUtils.isNotBlank((CharSequence)idpId)) {
            session.removeAttribute("idpId");
            return idpId;
        }
        Cookie idpIdCookie = MoHttpUtils.getCookie(request, "mo.bamboo-sso.IDPIDCOOKIE");
        if (idpIdCookie != null && StringUtils.isNotBlank((CharSequence)(idpId = idpIdCookie.getValue()))) {
            MoHttpUtils.clearCookie(request, response, "mo.bamboo-sso.IDPIDCOOKIE");
            return idpId;
        }
        idpId = request.getParameter("idp");
        if (StringUtils.isNotBlank((CharSequence)idpId)) {
            return idpId;
        }
        String issuer = MoSAMLManager.getIssuerFromResponse(request);
        int issuerCount = 0;
        for (Map.Entry<String, String> issuerEntry : this.settings.getIssuerMap().entrySet()) {
            if (!StringUtils.equals((CharSequence)issuer, (CharSequence)issuerEntry.getValue())) continue;
            idpId = issuerEntry.getKey();
            ++issuerCount;
        }
        if (issuerCount > 1) {
            return null;
        }
        return idpId;
    }

    private Boolean isRegexValid(String regex) {
        try {
            Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            LOGGER.debug((Object)"Invalid Regex Pattern.");
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
}

