/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.bamboo.servlet;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.miniorange.sso.saml.bamboo.MoSAMLSettings;
import com.miniorange.sso.saml.utils.MoHttpUtils;
import java.io.IOException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@UnrestrictedAccess
public class MoDownloadMetadataServlet
extends HttpServlet {
    private static Log LOGGER = LogFactory.getLog(MoDownloadMetadataServlet.class);
    private MoSAMLSettings settings;

    public MoDownloadMetadataServlet(MoSAMLSettings settings) {
        this.settings = settings;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.info((Object)"Downloading metadata");
        String metadata_url = this.settings.getBaseUrl() + "/plugins/servlet/saml/metadata";
        String metadata = MoHttpUtils.sendGetRequest(metadata_url);
        try {
            response.setHeader("Content-Disposition", "attachment; filename=\"sp_metadata.xml\"");
            response.setHeader("Cache-Control", "max-age=0");
            response.setHeader("Pragma", "");
            response.setContentType("application/xml");
            response.getOutputStream().write(metadata.getBytes());
        }
        catch (Exception e) {
            LOGGER.error((Object)("An error occurred while downloading the metadata." + e.getMessage()));
        }
    }

    public MoSAMLSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoSAMLSettings settings) {
        this.settings = settings;
    }
}

