/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.bamboo.action;

import com.atlassian.bamboo.security.xsrf.XsrfTokenUtils;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.miniorange.sso.saml.MoPluginException;
import com.miniorange.sso.saml.bamboo.MoPluginHandler;
import com.miniorange.sso.saml.bamboo.MoSAMLSettings;
import com.miniorange.sso.saml.bamboo.action.MoAddIDPConfigurationAction;
import com.miniorange.sso.saml.dto.MoIDPConfig;
import com.miniorange.sso.saml.utils.MoSAMLUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.interceptor.parameter.StrutsParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoTroubleshootingAction
extends BambooActionSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoAddIDPConfigurationAction.class);
    private UserManager userManager;
    private LoginUriProvider loginUriProvider;
    private MoSAMLSettings settings;
    private String xsrfToken;
    private MoPluginHandler pluginHandler;
    private MoIDPConfig idpConfig;
    private String testConfigResults;
    private String displaySamlResponse;
    private String displaySamlRequest;
    private Map<String, List<String>> attributesMap;
    private Boolean testConfigPerformed = Boolean.FALSE;
    private String idpID;

    public MoTroubleshootingAction(UserManager userManager, LoginUriProvider loginUriProvider, MoSAMLSettings settings) {
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.settings = settings;
    }

    public void doValidate() {
        LOGGER.info("Look n Feel Action doValidate called");
    }

    public String execute() throws Exception {
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        this.xsrfToken = XsrfTokenUtils.getXsrfToken((HttpServletRequest)request);
        UserProfile user = this.userManager.getRemoteUser();
        if (user != null && this.userManager.isAdmin(user.getUserKey())) {
            try {
                if (!this.settings.isValidLicense().booleanValue()) {
                    LOGGER.error("No valid license found");
                    return "upm";
                }
                if (StringUtils.isNotBlank((CharSequence)request.getParameter("idpid"))) {
                    this.idpID = request.getParameter("idpid");
                }
                this.testConfigPerformed = this.settings.checkIfTestConfig(this.idpID);
                LOGGER.debug("Test Configured :" + this.testConfigPerformed);
                this.initializeTroubleshooting();
                return "success";
            }
            catch (MoPluginException e) {
                LOGGER.error("An error occurred while saving your details." + e);
                this.addActionError(e.getMessage());
                return "error";
            }
            catch (Exception e) {
                LOGGER.error("An error occurred while saving your details." + e);
                this.addActionError("An error occured while saving your details. Please check logs for more info.");
                return "error";
            }
        }
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
        return null;
    }

    private void initializeTroubleshooting() {
        this.idpConfig = MoPluginHandler.constructIdpConfigObject(this.idpID);
        this.testConfigPerformed = this.settings.checkIfTestConfig(this.idpID);
        try {
            if (this.testConfigPerformed.booleanValue() && this.idpConfig != null) {
                this.attributesMap = MoSAMLUtils.toMap((JSONObject)this.settings.getIdpConfig(this.idpID).get("testConfig"));
                this.displaySamlResponse = (String)this.settings.getIdpConfig(this.idpID).get("samlResponse");
                this.displaySamlRequest = (String)this.settings.getIdpConfig(this.idpID).get("samlRequest");
            } else {
                this.attributesMap = new HashMap<String, List<String>>();
                this.displaySamlResponse = "";
                this.displaySamlRequest = "";
            }
        }
        catch (Exception e) {
            LOGGER.debug("error getting the test config details from settings.getIdpConfig(this.idpID)");
        }
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    @StrutsParameter
    public HashMap<String, String> getIdpMap() {
        return this.settings.getIdpMap();
    }

    @StrutsParameter
    public ArrayList<String> getIdpList() {
        return this.settings.getIdPList();
    }

    @StrutsParameter
    public UserManager getUserManager() {
        return this.userManager;
    }

    @StrutsParameter
    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    @StrutsParameter
    public LoginUriProvider getLoginUriProvider() {
        return this.loginUriProvider;
    }

    @StrutsParameter
    public void setLoginUriProvider(LoginUriProvider loginUriProvider) {
        this.loginUriProvider = loginUriProvider;
    }

    @StrutsParameter
    public MoSAMLSettings getSettings() {
        return this.settings;
    }

    @StrutsParameter
    public void setSettings(MoSAMLSettings settings) {
        this.settings = settings;
    }

    @StrutsParameter
    public MoPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    @StrutsParameter
    public void setPluginHandler(MoPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }

    @StrutsParameter
    public MoIDPConfig getIdpConfig() {
        return this.idpConfig;
    }

    @StrutsParameter
    public void setIdpConfig(MoIDPConfig idpConfig) {
        this.idpConfig = idpConfig;
    }

    @StrutsParameter
    public String getTestConfigResults() {
        return this.testConfigResults;
    }

    @StrutsParameter
    public void setTestConfigResults(String testConfigResults) {
        this.testConfigResults = testConfigResults;
    }

    @StrutsParameter
    public String getDisplaySamlResponse() {
        return this.displaySamlResponse;
    }

    @StrutsParameter
    public void setDisplaySamlResponse(String displaySamlResponse) {
        this.displaySamlResponse = displaySamlResponse;
    }

    @StrutsParameter
    public String getDisplaySamlRequest() {
        return this.displaySamlRequest;
    }

    @StrutsParameter
    public void setDisplaySamlRequest(String displaySamlRequest) {
        this.displaySamlRequest = displaySamlRequest;
    }

    @StrutsParameter
    public Map<String, List<String>> getAttributesMap() {
        return this.attributesMap;
    }

    @StrutsParameter
    public void setAttributesMap(Map<String, List<String>> attributesMap) {
        this.attributesMap = attributesMap;
    }

    @StrutsParameter
    public Boolean getTestConfigPerformed() {
        return this.testConfigPerformed;
    }

    @StrutsParameter
    public void setTestConfigPerformed(Boolean testConfigPerformed) {
        this.testConfigPerformed = testConfigPerformed;
    }

    @StrutsParameter
    public String getIdpID() {
        return this.idpID;
    }

    @StrutsParameter
    public void setIdpID(String idpID) {
        this.idpID = idpID;
    }

    @StrutsParameter
    public String getXsrfToken() {
        return this.xsrfToken;
    }

    @StrutsParameter
    public void setXsrfToken(String xsrfToken) {
        this.xsrfToken = xsrfToken;
    }

    @StrutsParameter
    public String getLogSettingsUrl() {
        return this.settings.getSpBaseUrl() + "/admin/configLog4j.action";
    }

    @StrutsParameter
    public String getTroubleshootingUrl() {
        return this.settings.getSpBaseUrl() + "/plugins/servlet/troubleshooting/view/";
    }

    @StrutsParameter
    public Collection<String> getSuccessMessages() {
        Collection successMessages = this.getActionMessages();
        ArrayList<String> encodedSuccessMessages = new ArrayList<String>();
        for (String message : successMessages) {
            encodedSuccessMessages.add(MoSAMLUtils.htmlEncode(message));
        }
        return encodedSuccessMessages;
    }

    @StrutsParameter
    public Collection<String> getErrorMessages() {
        Collection errorMessages = this.getActionErrors();
        ArrayList<String> encodedErrorMessages = new ArrayList<String>();
        for (String message : errorMessages) {
            encodedErrorMessages.add(MoSAMLUtils.htmlEncode(message));
        }
        return encodedErrorMessages;
    }
}

