/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.bamboo.action;

import com.atlassian.bamboo.security.xsrf.XsrfTokenUtils;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.miniorange.sso.saml.bamboo.MoSAMLSettings;
import com.miniorange.sso.saml.bamboo.action.MoAddIDPConfigurationAction;
import com.miniorange.sso.saml.utils.MoSAMLUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.interceptor.parameter.StrutsParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoImportExportAction
extends BambooActionSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoAddIDPConfigurationAction.class);
    private UserManager userManager;
    private LoginUriProvider loginUriProvider;
    private MoSAMLSettings settings;
    private Boolean importFileSubmitted;
    private String xsrfToken;

    public MoImportExportAction(UserManager userManager, LoginUriProvider loginUriProvider, MoSAMLSettings settings) {
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.settings = settings;
    }

    public Boolean doValidate() {
        LOGGER.debug("MoImportExportAction: doValidate() called");
        return true;
    }

    public String execute() throws Exception {
        LOGGER.debug("MoImportExportAction execute() called");
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        this.xsrfToken = XsrfTokenUtils.getXsrfToken((HttpServletRequest)request);
        UserProfile user = this.userManager.getRemoteUser();
        if (user != null && this.userManager.isAdmin(user.getUserKey())) {
            try {
                String message = "";
                LOGGER.debug("MoImportExportAction execute submitted: " + this.importFileSubmitted);
                if (!this.settings.isValidLicense().booleanValue()) {
                    LOGGER.error("Invalide License");
                    return "upm";
                }
                if (MoSAMLSettings.isPluginConfigurationFileUploaded.booleanValue()) {
                    MoSAMLSettings.isPluginConfigurationFileUploaded = Boolean.FALSE;
                    if (StringUtils.isNotBlank(this.settings.getSpConfigurationStatus())) {
                        if (StringUtils.equalsIgnoreCase(this.settings.getSpConfigurationStatus(), "success")) {
                            this.addActionMessage(this.getText("samlsso.success.config"));
                        } else {
                            this.addActionError(this.settings.getSpConfigurationStatus());
                        }
                    }
                }
                return "success";
            }
            catch (Exception e) {
                e.printStackTrace();
                return "input";
            }
        }
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
        return null;
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    @StrutsParameter
    public UserManager getUserManager() {
        return this.userManager;
    }

    @StrutsParameter
    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    @StrutsParameter
    public LoginUriProvider getLoginUriProvider() {
        return this.loginUriProvider;
    }

    @StrutsParameter
    public void setLoginUriProvider(LoginUriProvider loginUriProvider) {
        this.loginUriProvider = loginUriProvider;
    }

    @StrutsParameter
    public MoSAMLSettings getSettings() {
        return this.settings;
    }

    @StrutsParameter
    public void setSettings(MoSAMLSettings settings) {
        this.settings = settings;
    }

    @StrutsParameter
    public Boolean getImportFileSubmitted() {
        return this.importFileSubmitted;
    }

    @StrutsParameter
    public void setImportFileSubmitted(Boolean importFileSubmitted) {
        this.importFileSubmitted = importFileSubmitted;
    }

    @StrutsParameter
    public String getXsrfToken() {
        return this.xsrfToken;
    }

    @StrutsParameter
    public void setXsrfToken(String xsrfToken) {
        this.xsrfToken = xsrfToken;
    }

    @StrutsParameter
    public Collection<String> getSuccessMessages() {
        Collection successMessages = this.getActionMessages();
        ArrayList<String> encodedSuccessMessages = new ArrayList<String>();
        for (String message : successMessages) {
            encodedSuccessMessages.add(MoSAMLUtils.htmlEncode(message));
        }
        return encodedSuccessMessages;
    }

    @StrutsParameter
    public Collection<String> getErrorMessages() {
        Collection errorMessages = this.getActionErrors();
        ArrayList<String> encodedErrorMessages = new ArrayList<String>();
        for (String message : errorMessages) {
            encodedErrorMessages.add(MoSAMLUtils.htmlEncode(message));
        }
        return encodedErrorMessages;
    }
}

