/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.bamboo.action;

import com.atlassian.bamboo.security.xsrf.XsrfTokenUtils;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.miniorange.sso.saml.MoPluginException;
import com.miniorange.sso.saml.bamboo.MoPluginHandler;
import com.miniorange.sso.saml.bamboo.MoSAMLSettings;
import com.miniorange.sso.saml.dto.MoIDPConfig;
import com.miniorange.sso.saml.utils.MoSAMLUtils;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

public class MoAdvancedSSOAction
extends BambooActionSupport {
    private static Log LOGGER = LogFactory.getLog(MoAdvancedSSOAction.class);
    private UserManager userManager;
    private LoginUriProvider loginUriProvider;
    private String idpID;
    private String idpName;
    private String timeDelay;
    private MoSAMLSettings settings;
    private Boolean advancedSsoSubmitted;
    private Boolean refreshMetadata;
    private String refreshInterval;
    private Integer customRefreshInterval;
    private String customRefreshIntervalUnit;
    private String inputUrl;
    private String relayState;
    private String relayStateRedirectionType;
    private Boolean allowUserCreation;
    private Boolean enablePassiveSso;
    private Boolean forceAuthentication;
    private Boolean enableButtons;
    private String xsrfToken;
    private HashMap<String, String> directoryList;
    private String defaultUserDirectory;
    private DirectoryManager directoryManager;
    private String customSPEntityID;

    public MoAdvancedSSOAction(UserManager userManager, LoginUriProvider loginUriProvider, MoSAMLSettings settings, DirectoryManager directoryManager) {
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.settings = settings;
        this.directoryManager = directoryManager;
    }

    public Boolean doValidate() {
        Boolean error = false;
        LOGGER.info((Object)"MoAddIDPConfigurationAction : doValidate called");
        if (BooleanUtils.toBoolean((Boolean)this.advancedSsoSubmitted)) {
            try {
                if (Integer.parseInt(this.timeDelay) < 0) {
                    this.addActionError(this.getText("samlsso.timedelay.number.invalid"));
                    error = true;
                }
            }
            catch (NumberFormatException e) {
                this.addActionError("Please enter positive integer for Validate IDP's SAML Response field.");
                error = true;
            }
            if (StringUtils.isNotBlank((CharSequence)this.relayState)) {
                try {
                    this.relayState = MoSAMLUtils.sanitizeText(this.relayState);
                    new URL(this.relayState);
                }
                catch (MalformedURLException e) {
                    LOGGER.error((Object)e.getMessage());
                    this.addActionError("Invalid RelayState URL.");
                    error = true;
                }
            }
            if (!this.isValidDirectory(this.defaultUserDirectory).booleanValue()) {
                this.addActionError("samlsso.error.config.defaultdirectory.invalid");
                error = true;
            }
            if (BooleanUtils.toBoolean((Boolean)this.refreshMetadata)) {
                LOGGER.info((Object)"Validating IDP input URL");
                if (StringUtils.isBlank((CharSequence)this.inputUrl)) {
                    error = true;
                    this.addActionError("Metadata URL cannot be left blank.");
                } else {
                    try {
                        new URL(this.inputUrl);
                    }
                    catch (MalformedURLException e) {
                        LOGGER.error((Object)"Invalid URL", (Throwable)e);
                        this.addActionError("Invalid IDP metadata URL. Please make sure it's not empty and doesn't contain spaces.");
                        error = true;
                    }
                }
            }
            if (StringUtils.isBlank((CharSequence)this.customSPEntityID)) {
                this.customSPEntityID = this.settings.getSpEntityId();
            } else {
                try {
                    this.customSPEntityID = MoSAMLUtils.sanitizeText(this.customSPEntityID);
                    new URL(this.customSPEntityID);
                }
                catch (MalformedURLException e) {
                    LOGGER.error((Object)e.getMessage());
                    this.addActionError("Invalid Custom SP Entity ID.");
                    error = true;
                }
            }
        }
        if (BooleanUtils.toBoolean((Boolean)error)) {
            this.initializeSAMLConfig();
        }
        return error;
    }

    private Boolean isValidDirectory(String selectedDirectory) {
        List writableDirectoryList = this.directoryManager.findAllDirectories();
        for (Directory directory : writableDirectoryList) {
            if (!StringUtils.equals((CharSequence)selectedDirectory, (CharSequence)directory.getName())) continue;
            return true;
        }
        return false;
    }

    public String execute() throws Exception {
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        this.xsrfToken = XsrfTokenUtils.getXsrfToken((HttpServletRequest)request);
        UserProfile user = this.userManager.getRemoteUser();
        if (user != null && this.userManager.isAdmin(user.getUserKey())) {
            try {
                LOGGER.info((Object)"MO AdvancedSSO Action doExecute called ");
                if (!this.settings.isValidLicense().booleanValue()) {
                    LOGGER.error((Object)"No valid license found");
                    return "upm";
                }
                if (StringUtils.isBlank((CharSequence)this.idpID)) {
                    this.idpID = StringUtils.isNotBlank((CharSequence)request.getParameter("idpid")) ? request.getParameter("idpid") : UUID.randomUUID().toString();
                }
                if (BooleanUtils.toBoolean((Boolean)this.advancedSsoSubmitted)) {
                    Boolean error;
                    LOGGER.info((Object)"Advance SSO submitted");
                    if (StringUtils.isBlank((CharSequence)this.idpID)) {
                        this.idpID = "miniorange.saml.DEFAULT_IDP_ID";
                    }
                    if (!(error = this.doValidate()).booleanValue()) {
                        LOGGER.info((Object)"Advance SSO submitted and No errors are there");
                        MoPluginHandler.saveAdvancedOption(this.idpID, this.allowUserCreation, this.defaultUserDirectory, this.forceAuthentication, this.inputUrl, this.timeDelay, this.refreshMetadata, this.refreshInterval, this.customRefreshInterval, this.customRefreshIntervalUnit, this.relayState, this.relayStateRedirectionType, this.enablePassiveSso, this.customSPEntityID);
                        this.addActionMessage(this.getText("samlsso.success.config"));
                        MoIDPConfig moIDPConfig = MoPluginHandler.constructIdpConfigObject(this.idpID);
                    }
                }
                this.initializeSAMLConfig();
                return "success";
            }
            catch (MoPluginException e) {
                LOGGER.error((Object)"MoPluginException = ", (Throwable)e);
                this.addActionError(e.getMessage());
                this.initializeSAMLConfig();
                return "input";
            }
            catch (Exception e) {
                LOGGER.error((Object)"Exception  ", (Throwable)e);
                this.addActionError("An error occurred while saving your details. Please check logs for more info.");
                this.initializeSAMLConfig();
                return "input";
            }
        }
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
        return null;
    }

    private void initializeSAMLConfig() {
        LOGGER.info((Object)"initilizeSAMLConfig Called");
        MoIDPConfig idpConfig = MoPluginHandler.constructIdpConfigObject(this.idpID);
        if (idpConfig == null) {
            LOGGER.debug((Object)"Initiliazling new form");
            this.initializeNewForm();
            return;
        }
        this.idpName = (String)StringUtils.defaultIfBlank((CharSequence)idpConfig.getIdpName(), (CharSequence)"");
        this.allowUserCreation = BooleanUtils.toBooleanDefaultIfNull((Boolean)idpConfig.getAllowUserCreation(), (boolean)true);
        this.defaultUserDirectory = (String)StringUtils.defaultIfBlank((CharSequence)idpConfig.getDefaultUserDirectory(), (CharSequence)this.settings.getDefaultWritableDirectory());
        this.forceAuthentication = BooleanUtils.toBooleanDefaultIfNull((Boolean)idpConfig.getForceAuthentication(), (boolean)false);
        this.timeDelay = StringUtils.defaultString((String)idpConfig.getTimeDelay(), (String)"01");
        this.refreshMetadata = BooleanUtils.toBooleanDefaultIfNull((Boolean)idpConfig.getRefreshMetadata(), (boolean)false);
        this.inputUrl = (String)StringUtils.defaultIfBlank((CharSequence)idpConfig.getInputUrl(), (CharSequence)"");
        this.refreshInterval = (String)StringUtils.defaultIfBlank((CharSequence)idpConfig.getRefreshInterval(), (CharSequence)"hourly");
        this.customRefreshInterval = idpConfig.getCustomRefreshInterval() != null ? idpConfig.getCustomRefreshInterval() : 60;
        this.customRefreshIntervalUnit = (String)StringUtils.defaultIfBlank((CharSequence)idpConfig.getCustomRefreshIntervalUnit(), (CharSequence)"minutes");
        this.relayState = (String)StringUtils.defaultIfBlank((CharSequence)idpConfig.getRelayState(), (CharSequence)"");
        this.relayStateRedirectionType = (String)StringUtils.defaultIfBlank((CharSequence)idpConfig.getRelayStateRedirectionType(), (CharSequence)"forceRedirect");
        this.enableButtons = true;
        this.enablePassiveSso = BooleanUtils.toBooleanDefaultIfNull((Boolean)idpConfig.getEnablePassiveSso(), (boolean)false);
        this.customSPEntityID = (String)StringUtils.defaultIfBlank((CharSequence)idpConfig.getCustomSPEntityID(), (CharSequence)this.settings.getSpEntityId());
    }

    private void initializeNewForm() {
        LOGGER.info((Object)"initializeNewForm Called");
        this.idpName = "";
        this.allowUserCreation = true;
        this.defaultUserDirectory = this.settings.getDefaultWritableDirectory();
        this.enablePassiveSso = Boolean.FALSE;
        this.forceAuthentication = false;
        this.timeDelay = "01";
        this.refreshMetadata = Boolean.FALSE;
        this.inputUrl = "";
        this.refreshInterval = "hourly";
        this.customRefreshInterval = 60;
        this.customRefreshIntervalUnit = "minutes";
        this.relayState = "";
        this.relayStateRedirectionType = "forceRedirect";
        this.enableButtons = false;
        this.customSPEntityID = this.settings.getSpEntityId();
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    @StrutsParameter
    public UserManager getUserManager() {
        return this.userManager;
    }

    @StrutsParameter
    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    @StrutsParameter
    public LoginUriProvider getLoginUriProvider() {
        return this.loginUriProvider;
    }

    @StrutsParameter
    public void setLoginUriProvider(LoginUriProvider loginUriProvider) {
        this.loginUriProvider = loginUriProvider;
    }

    @StrutsParameter
    public String getIdpID() {
        return this.idpID;
    }

    @StrutsParameter
    public void setIdpID(String idpID) {
        this.idpID = idpID;
    }

    @StrutsParameter
    public String getIdpName() {
        return this.idpName;
    }

    @StrutsParameter
    public void setIdpName(String idpName) {
        this.idpName = idpName;
    }

    @StrutsParameter
    public String getTimeDelay() {
        return this.timeDelay;
    }

    @StrutsParameter
    public void setTimeDelay(String timeDelay) {
        this.timeDelay = timeDelay;
    }

    @StrutsParameter
    public MoSAMLSettings getSettings() {
        return this.settings;
    }

    @StrutsParameter
    public void setSettings(MoSAMLSettings settings) {
        this.settings = settings;
    }

    @StrutsParameter
    public Boolean getAdvancedSsoSubmitted() {
        return this.advancedSsoSubmitted;
    }

    @StrutsParameter
    public void setAdvancedSsoSubmitted(Boolean advancedSsoSubmitted) {
        this.advancedSsoSubmitted = advancedSsoSubmitted;
    }

    @StrutsParameter
    public String getXsrfToken() {
        return this.xsrfToken;
    }

    @StrutsParameter
    public void setXsrfToken(String xsrfToken) {
        this.xsrfToken = xsrfToken;
    }

    @StrutsParameter
    public Boolean getRefreshMetadata() {
        return this.refreshMetadata;
    }

    @StrutsParameter
    public void setRefreshMetadata(Boolean refreshMetadata) {
        this.refreshMetadata = refreshMetadata;
    }

    @StrutsParameter
    public String getRefreshInterval() {
        return this.refreshInterval;
    }

    @StrutsParameter
    public void setRefreshInterval(String refreshInterval) {
        this.refreshInterval = refreshInterval;
    }

    @StrutsParameter
    public Integer getCustomRefreshInterval() {
        return this.customRefreshInterval;
    }

    @StrutsParameter
    public void setCustomRefreshInterval(Integer customRefreshInterval) {
        this.customRefreshInterval = customRefreshInterval;
    }

    @StrutsParameter
    public String getCustomRefreshIntervalUnit() {
        return this.customRefreshIntervalUnit;
    }

    @StrutsParameter
    public void setCustomRefreshIntervalUnit(String customRefreshIntervalUnit) {
        this.customRefreshIntervalUnit = customRefreshIntervalUnit;
    }

    @StrutsParameter
    public Boolean getAllowUserCreation() {
        return this.allowUserCreation;
    }

    @StrutsParameter
    public void setAllowUserCreation(Boolean allowUserCreation) {
        this.allowUserCreation = allowUserCreation;
    }

    @StrutsParameter
    public void setDirectoryList(HashMap directoryList) {
        this.directoryList = directoryList;
    }

    @StrutsParameter
    public HashMap<String, String> getDirectoryList() {
        MoIDPConfig idpConfig = MoPluginHandler.constructIdpConfigObject(this.idpID);
        LOGGER.debug((Object)"getDirectoryList");
        this.directoryList = new HashMap();
        List allDirectories = this.directoryManager.findAllDirectories();
        LOGGER.debug((Object)("allDirectories " + allDirectories));
        for (Directory dir : allDirectories) {
            if (dir.isActive() && dir.getAllowedOperations().contains(OperationType.CREATE_USER)) {
                this.directoryList.put(dir.getName(), "writable");
                continue;
            }
            if (!StringUtils.equals((CharSequence)idpConfig.getDefaultUserDirectory(), (CharSequence)dir.getName())) continue;
            this.directoryList.put(dir.getName(), "disabled");
        }
        LOGGER.debug((Object)("directoryList " + this.directoryList));
        return this.directoryList;
    }

    @StrutsParameter
    public void setDefaultUserDirectory(String defaultUserDirectory) {
        this.defaultUserDirectory = defaultUserDirectory;
    }

    @StrutsParameter
    public String getDefaultUserDirectory() {
        return this.defaultUserDirectory;
    }

    @StrutsParameter
    public Boolean getEnablePassiveSso() {
        return this.enablePassiveSso;
    }

    @StrutsParameter
    public void setEnablePassiveSso(Boolean enablePassiveSso) {
        this.enablePassiveSso = enablePassiveSso;
    }

    @StrutsParameter
    public Boolean getForceAuthentication() {
        return this.forceAuthentication;
    }

    @StrutsParameter
    public void setForceAuthentication(Boolean forceAuthentication) {
        this.forceAuthentication = forceAuthentication;
    }

    @StrutsParameter
    public String getInputUrl() {
        return this.inputUrl;
    }

    @StrutsParameter
    public void setInputUrl(String inputUrl) {
        this.inputUrl = inputUrl;
    }

    @StrutsParameter
    public String getRelayState() {
        return this.relayState;
    }

    @StrutsParameter
    public void setRelayState(String relayState) {
        this.relayState = relayState;
    }

    @StrutsParameter
    public String getRelayStateRedirectionType() {
        return this.relayStateRedirectionType;
    }

    @StrutsParameter
    public void setRelayStateRedirectionType(String relayStateRedirectionType) {
        this.relayStateRedirectionType = relayStateRedirectionType;
    }

    @StrutsParameter
    public Boolean getEnableButtons() {
        return this.enableButtons;
    }

    @StrutsParameter
    public void setEnableButtons(Boolean enableButtons) {
        this.enableButtons = enableButtons;
    }

    @StrutsParameter
    public String getCustomSPEntityID() {
        return this.customSPEntityID;
    }

    @StrutsParameter
    public void setCustomSPEntityID(String customSPEntityID) {
        this.customSPEntityID = customSPEntityID;
    }

    @StrutsParameter
    public Collection<String> getSuccessMessages() {
        Collection successMessages = this.getActionMessages();
        ArrayList<String> encodedSuccessMessages = new ArrayList<String>();
        for (String message : successMessages) {
            encodedSuccessMessages.add(MoSAMLUtils.htmlEncode(message));
        }
        return encodedSuccessMessages;
    }

    @StrutsParameter
    public Collection<String> getErrorMessages() {
        Collection errorMessages = this.getActionErrors();
        ArrayList<String> encodedErrorMessages = new ArrayList<String>();
        for (String message : errorMessages) {
            encodedErrorMessages.add(MoSAMLUtils.htmlEncode(message));
        }
        return encodedErrorMessages;
    }
}

