/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.bamboo;

import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.bamboo.util.BuildUtils;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONException;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.Contact;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.user.Group;
import com.atlassian.user.search.page.Pager;
import com.miniorange.sso.saml.bamboo.MoPluginHandler;
import com.miniorange.sso.saml.utils.MoJSONUtils;
import com.miniorange.sso.saml.utils.MoSAMLUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoSAMLSettings {
    private PluginSettings pluginSettings;
    private PluginSettingsFactory pluginSettingsFactory;
    private AgentManager agentManager;
    private AdministrationConfigurationAccessor administrationConfigurationAccessor;
    private PluginLicenseManager pluginLicenseManager;
    private static Log LOGGER = LogFactory.getLog(MoSAMLSettings.class);
    private static final String PUBLIC_CERT_PATH = "/certificates/com/miniorange/sso/saml/bamboo/sp-certificate.crt";
    private static final String PRIVATE_CERT_PATH = "/certificates/com/miniorange/sso/saml/bamboo/sp-key.key";
    private static final String NEW_PUBLIC_CERT_PATH = "/certificates/com/miniorange/sso/saml/bamboo/new-sp-certificate.crt";
    private static final String NEW_PRIVATE_CERT_PATH = "/certificates/com/miniorange/sso/saml/bamboo/new-sp-key.key";
    public static String PUBLIC_CERTIFICATE = "/certificates/com/miniorange/sso/saml/bamboo/new-sp-certificate.crt";
    public static String PRIVATE_CERTIFICATE = "/certificates/com/miniorange/sso/saml/bamboo/new-sp-key.key";
    private static final String LOGOUT_TEMPLATE_PATH = "/templates/com/miniorange/sso/saml/bamboo/logoutTemplate.ftl";
    private static final String LOGIN_TEMPLATE_PATH = "/templates/com/miniorange/sso/saml/bamboo/loginTemplate.ftl";
    private static final String ERRORMSG_TEMPLATE_PATH = "/templates/com/miniorange/sso/saml/bamboo/errorMessageTemplate.ftl";
    public static String LOGOUT_TEMPLATE = "";
    public static String LOGIN_TEMPLATE = "";
    public static String ERRORMSG_TEMPLATE = "";
    public static final String CUSTOMER_TOKEN_KEY = MoSAMLSettings.generateRandomAlphaNumericKey(16);
    public static Boolean isMetadataUpload = Boolean.FALSE;
    public static Boolean isPluginConfigurationFileUploaded = Boolean.FALSE;
    private BambooUserManager bambooUserManager;
    private BambooPermissionManager bambooPermissionManager;
    private final PluginAccessor pluginAccessor;

    public MoSAMLSettings(PluginSettingsFactory pluginSettingsFactory, PluginLicenseManager pluginLicenseManager, AgentManager agentManager, AdministrationConfigurationAccessor administrationConfigurationAccessor, BambooUserManager bambooUserManager, BambooPermissionManager bambooPermissionManager, PluginAccessor pluginAccessor) {
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.pluginSettings = pluginSettingsFactory.createGlobalSettings();
        this.pluginLicenseManager = pluginLicenseManager;
        this.agentManager = agentManager;
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
        this.bambooUserManager = bambooUserManager;
        this.bambooPermissionManager = bambooPermissionManager;
        this.pluginAccessor = pluginAccessor;
    }

    public Boolean getSigning() {
        String signing = (String)this.pluginSettings.get("miniorange.saml.SIGNING");
        if (StringUtils.isBlank((CharSequence)signing)) {
            return Boolean.TRUE;
        }
        return BooleanUtils.toBoolean((String)signing);
    }

    public void setSigning(Boolean signing) {
        this.pluginSettings.put("miniorange.saml.SIGNING", (Object)BooleanUtils.toString((Boolean)signing, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getEncryption() {
        String encryption = (String)this.pluginSettings.get("miniorange.saml.ENCRYPTION");
        if (StringUtils.isBlank((CharSequence)encryption)) {
            return Boolean.FALSE;
        }
        return BooleanUtils.toBoolean((String)encryption);
    }

    public void setEncryption(Boolean encryption) {
        this.pluginSettings.put("miniorange.saml.ENCRYPTION", (Object)BooleanUtils.toString((Boolean)encryption, (String)"true", (String)"false", (String)"false"));
    }

    public String getSpBaseUrl() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.SP_BASE_URL")), (CharSequence)this.getBaseUrl());
    }

    public void setSpBaseUrl(String spBaseUrl) {
        this.pluginSettings.put("miniorange.saml.SP_BASE_URL", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)spBaseUrl, (CharSequence)this.getBaseUrl()))));
    }

    public String getLogSettingsUrl() {
        return this.getSpBaseUrl() + "/admin/configLog4j.action";
    }

    public String getTroubleshootingUrl() {
        return this.getSpBaseUrl() + "/plugins/servlet/troubleshooting/view/";
    }

    public String getSpEntityId() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.SP_ENTITY_ID")), (CharSequence)this.getBaseUrl());
    }

    public void setSpEntityId(String spEntityId) {
        this.pluginSettings.put("miniorange.saml.SP_ENTITY_ID", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)spEntityId, (CharSequence)this.getBaseUrl()))));
    }

    public void setIdpName(String idpName) {
        this.pluginSettings.put("miniorange.saml.IDP_NAME", (Object)StringUtils.defaultIfBlank((CharSequence)idpName, (CharSequence)""));
    }

    public String getIdpName() {
        return (String)this.pluginSettings.get("miniorange.saml.IDP_NAME");
    }

    public String getSsoServiceUrl() {
        return StringUtils.defaultString((String)((String)this.pluginSettings.get("miniorange.saml.SSO_URL")));
    }

    public void setSsoServiceUrl(String ssoServiceUrl) {
        this.pluginSettings.put("miniorange.saml.SSO_URL", (Object)StringUtils.trimToEmpty((String)ssoServiceUrl));
    }

    public String getSloServiceUrl() {
        return StringUtils.defaultString((String)((String)this.pluginSettings.get("miniorange.saml.SLO_URL")));
    }

    public void setSloServiceUrl(String sloServiceUrl) {
        this.pluginSettings.put("miniorange.saml.SLO_URL", (Object)StringUtils.trimToEmpty((String)sloServiceUrl));
    }

    public String getSloResponseLocationUrl() {
        return StringUtils.defaultString((String)((String)this.pluginSettings.get("miniorange.saml.SLO_RESPONSE_LOCATION_URL")));
    }

    public void setSloResponseLocationUrl(String sloResponseLocationUrl) {
        this.pluginSettings.put("miniorange.saml.SLO_RESPONSE_LOCATION_URL", (Object)StringUtils.trimToEmpty((String)sloResponseLocationUrl));
    }

    public String getIdpEntityId() {
        return StringUtils.defaultString((String)((String)this.pluginSettings.get("miniorange.saml.IDP_ENTITY_ID")));
    }

    public void setIdpEntityId(String idpEntityId) {
        this.pluginSettings.put("miniorange.saml.IDP_ENTITY_ID", (Object)StringUtils.trimToEmpty((String)idpEntityId));
    }

    public String getX509Certificate() {
        return StringUtils.defaultString((String)((String)this.pluginSettings.get("miniorange.saml.X509_CERTIFICATE")));
    }

    public void setX509Certificate(String x509Certificate) {
        this.pluginSettings.put("miniorange.saml.X509_CERTIFICATE", (Object)MoSAMLUtils.serializePublicCertificate(x509Certificate));
    }

    public Object getAllX509Certificates() {
        return this.pluginSettings.get("miniorange.saml.ALL_X509_CERTIFICATES");
    }

    public void setAllX509Certificates(List<String> x509certificates) {
        for (String certificate : x509certificates) {
            x509certificates.set(x509certificates.indexOf(certificate), MoSAMLUtils.serializePublicCertificate(certificate));
        }
        this.pluginSettings.put("miniorange.saml.ALL_X509_CERTIFICATES", x509certificates);
    }

    public String getSsoBindingType() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.SSO_BINDING_TYPE")), (CharSequence)"HttpRedirect");
    }

    public void setSsoBindingType(String ssoBindingType) {
        this.pluginSettings.put("miniorange.saml.SSO_BINDING_TYPE", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)ssoBindingType, (CharSequence)"HttpRedirect"))));
    }

    public String getSloBindingType() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.SLO_BINDING_TYPE")), (CharSequence)"HttpRedirect");
    }

    public void setSloBindingType(String sloBindingType) {
        this.pluginSettings.put("miniorange.saml.SLO_BINDING_TYPE", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)sloBindingType, (CharSequence)"HttpRedirect"))));
    }

    public String getLoginUserAttribute() {
        return StringUtils.defaultString((String)((String)this.pluginSettings.get("miniorange.saml.LOGIN_USER_ATTRIBUTE")));
    }

    public void setLoginUserAttribute(String loginUserAttribute) {
        this.pluginSettings.put("miniorange.saml.LOGIN_USER_ATTRIBUTE", (Object)StringUtils.defaultIfBlank((CharSequence)loginUserAttribute, (CharSequence)"username"));
    }

    public String getUsernameAttribute() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.USERNAME_ATTRIBUTE")), (CharSequence)"NameID");
    }

    public void setUsernameAttribute(String usernameAttribute) {
        this.pluginSettings.put("miniorange.saml.USERNAME_ATTRIBUTE", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)usernameAttribute, (CharSequence)"NameID"))));
    }

    public String getEmailAttribute() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.EMAIL_ATTRIBUTE")), (CharSequence)"NameID");
    }

    public void setEmailAttribute(String emailAttribute) {
        this.pluginSettings.put("miniorange.saml.EMAIL_ATTRIBUTE", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)emailAttribute, (CharSequence)"NameID"))));
    }

    public String getFullNameAttribute() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.FULL_NAME_ATTRIBUTE")), (CharSequence)"");
    }

    public void setFullNameAttribute(String fullNameAttribute) {
        this.pluginSettings.put("miniorange.saml.FULL_NAME_ATTRIBUTE", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)fullNameAttribute, (CharSequence)""))));
    }

    public Boolean getUseSeparateNameAttributes() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.USE_SEPARATE_NAME_ATTRIBUTE"))), (boolean)false);
    }

    public void setUseSeparateNameAttributes(Boolean defaultLoginDisabled) {
        this.pluginSettings.put("miniorange.saml.USE_SEPARATE_NAME_ATTRIBUTE", (Object)BooleanUtils.toString((Boolean)defaultLoginDisabled, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getKeepExistingUserAttributes() {
        String keepExistingUserAttributes = (String)this.pluginSettings.get("miniorange.saml.KEEP_EXISTING_ATTRIBUTE");
        if (StringUtils.isBlank((CharSequence)keepExistingUserAttributes)) {
            return Boolean.TRUE;
        }
        return BooleanUtils.toBoolean((String)keepExistingUserAttributes);
    }

    public void setKeepExistingUserAttributes(Boolean keepExistingUserAttributes) {
        this.pluginSettings.put("miniorange.saml.KEEP_EXISTING_ATTRIBUTE", (Object)BooleanUtils.toString((Boolean)keepExistingUserAttributes, (String)"true", (String)"false", (String)"false"));
    }

    public String getFirstNameAttribute() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.FIRST_NAME_ATTRIBUTE")), (CharSequence)"");
    }

    public Boolean getGroupRegexPatternEnabled() {
        return BooleanUtils.toBoolean((String)((String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.GROUP_REGEX_PATTERN_ENABLED")), (CharSequence)"false")));
    }

    public void setGroupRegexPatternEnabled(Boolean groupRegexPatternEnabled) {
        this.pluginSettings.put("miniorange.saml.GROUP_REGEX_PATTERN_ENABLED", (Object)BooleanUtils.toString((Boolean)groupRegexPatternEnabled, (String)"true", (String)"false", (String)"false"));
    }

    public String getRegexPatternForGroup() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.REGEX_PATTERN")), (CharSequence)"");
    }

    public void setRegexPatternForGroup(String regexPatternForGroup) {
        this.pluginSettings.put("miniorange.saml.REGEX_PATTERN_FOR_GROUP", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)regexPatternForGroup, (CharSequence)""))));
    }

    public String getRegexGroups() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.REGEX_GROUPS")), (CharSequence)"");
    }

    public void setRegexGroups(String regexGroups) {
        this.pluginSettings.put("miniorange.saml.REGEX_GROUPS", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)regexGroups, (CharSequence)""))));
    }

    public String getTestRegex() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.TEST_REGEX")), (CharSequence)"");
    }

    public void setTestRegex(String testRegex) {
        this.pluginSettings.put("miniorange.saml.TEST_REGEX", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)testRegex, (CharSequence)""))));
    }

    public void setFirstNameAttribute(String fullNameAttribute) {
        this.pluginSettings.put("miniorange.saml.FIRST_NAME_ATTRIBUTE", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)fullNameAttribute, (CharSequence)""))));
    }

    public String getLastNameAttribute() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.LAST_NAME_ATTRIBUTE")), (CharSequence)"");
    }

    public void setLastNameAttribute(String fullNameAttribute) {
        this.pluginSettings.put("miniorange.saml.LAST_NAME_ATTRIBUTE", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)fullNameAttribute, (CharSequence)""))));
    }

    public Boolean getRegexPatternEnabled() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.ENABLE_REGEX_PATTERN"))), (boolean)false);
    }

    public void setRegexPatternEnabled(Boolean regexPatternEnabled) {
        this.pluginSettings.put("miniorange.saml.ENABLE_REGEX_PATTERN", (Object)BooleanUtils.toString((Boolean)regexPatternEnabled, (String)"true", (String)"false", (String)"false"));
    }

    public String getRegexPattern() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.REGEX_PATTERN")), (CharSequence)"");
    }

    public void setRegexPattern(String regexPattern) {
        this.pluginSettings.put("miniorange.saml.REGEX_PATTERN", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)regexPattern, (CharSequence)""))));
    }

    public String getRoleAttribute() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.ROLE_ATTRIBUTE")), (CharSequence)"");
    }

    public void setRoleAttribute(String roleAttribute) {
        this.pluginSettings.put("miniorange.saml.ROLE_ATTRIBUTE", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)roleAttribute, (CharSequence)""))));
    }

    public String getDefaultGroup() {
        String defaultGroup = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.DEFAULT_GROUP")), (CharSequence)"");
        if (StringUtils.isBlank((CharSequence)defaultGroup) || StringUtils.isEmpty((CharSequence)defaultGroup)) {
            try {
                ArrayList<String> existingGroups = new ArrayList<String>();
                Pager groupObjects = this.bambooUserManager.getGroups();
                for (Group group : groupObjects) {
                    existingGroups.add(group.getName());
                }
                defaultGroup = existingGroups.contains(this.bambooPermissionManager.getDefaultUsersGroup()) ? this.bambooPermissionManager.getDefaultUsersGroup() : (existingGroups.size() > 1 ? (String)existingGroups.get(1) : (String)existingGroups.get(0));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return defaultGroup;
    }

    public void setDefaultGroup(String defaultGroup) {
        this.pluginSettings.put("miniorange.saml.DEFAULT_GROUP", (Object)StringUtils.trimToEmpty((String)defaultGroup));
    }

    public Object getDefaultGroups() {
        if (this.pluginSettings.get("miniorange.saml.DEFAULT_GROUPs") == null) {
            ArrayList<String> defaultGroups = new ArrayList<String>();
            ArrayList<String> existingGroups = new ArrayList<String>();
            Pager groupObjects = this.bambooUserManager.getGroups();
            for (Group group : groupObjects) {
                existingGroups.add(group.getName());
            }
            if (existingGroups.size() > 1) {
                defaultGroups.add((String)existingGroups.get(1));
            } else {
                defaultGroups.add((String)existingGroups.get(0));
            }
            return defaultGroups;
        }
        return this.pluginSettings.get("miniorange.saml.DEFAULT_GROUPs");
    }

    public void setDefaultGroups(List<String> defaultGroups) {
        this.pluginSettings.put("miniorange.saml.DEFAULT_GROUPs", defaultGroups);
    }

    public HashMap<String, String> getRoleMapping() {
        Object roleMapping = this.pluginSettings.get("miniorange.saml.ROLE_MAPPING");
        if (roleMapping != null) {
            return (HashMap)roleMapping;
        }
        return new HashMap<String, String>();
    }

    public Boolean getSignedRequest() {
        String signedRequestStr = (String)this.pluginSettings.get("miniorange.saml.SIGNED_REQUEST");
        if (StringUtils.isBlank((CharSequence)signedRequestStr)) {
            return Boolean.TRUE;
        }
        return BooleanUtils.toBoolean((String)signedRequestStr);
    }

    public void setSignedRequest(Boolean signedRequest) {
        this.pluginSettings.put("miniorange.saml.SIGNED_REQUEST", (Object)BooleanUtils.toString((Boolean)signedRequest, (String)"true", (String)"false", (String)"false"));
    }

    public void setRoleMapping(HashMap<String, String> roleMapping) {
        this.pluginSettings.put("miniorange.saml.ROLE_MAPPING", roleMapping);
    }

    public Boolean getKeepExistingUserRoles() {
        String keepExistingUserRoles = (String)this.pluginSettings.get("miniorange.saml.KEEP_EXISTING_USER_ROLES");
        if (StringUtils.isBlank((CharSequence)keepExistingUserRoles)) {
            return Boolean.FALSE;
        }
        return BooleanUtils.toBoolean((String)keepExistingUserRoles);
    }

    public void setKeepExistingUserRoles(Boolean keepExistingUserRoles) {
        this.pluginSettings.put("miniorange.saml.KEEP_EXISTING_USER_ROLES", (Object)BooleanUtils.toString((Boolean)keepExistingUserRoles, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getCreateUsersIfRoleMapped() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.CREATE_USER_IF_ROLE_MAPPED"))), (boolean)false);
    }

    public void setCreateUsersIfRoleMapped(Boolean createUsersIfRoleMapped) {
        this.pluginSettings.put("miniorange.saml.CREATE_USER_IF_ROLE_MAPPED", (Object)BooleanUtils.toString((Boolean)createUsersIfRoleMapped, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getRestrictUserCreation() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.RESTRICT_USER_CREATION"))), (boolean)false);
    }

    public void setRestrictUserCreation(Boolean restrictUserCreation) {
        this.pluginSettings.put("miniorange.saml.RESTRICT_USER_CREATION", (Object)BooleanUtils.toString((Boolean)restrictUserCreation, (String)"true", (String)"false", (String)"false"));
    }

    public void setEnableDefaultGroupsFor(String enableDefaultGroupsFor) {
        this.pluginSettings.put("miniorange.saml.ENABLE_DEFAULT_GROUPS_FOR", (Object)StringUtils.defaultIfEmpty((CharSequence)enableDefaultGroupsFor, (CharSequence)"newUsers"));
    }

    public String getEnableDefaultGroupsFor() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.ENABLE_DEFAULT_GROUPS_FOR")), (CharSequence)"newUsers");
    }

    public Object getOnTheFlyDoNotRemoveGroups() {
        if (this.pluginSettings.get("miniorange.saml.ON_THE_FLY_DO_NOT_REMOVE_GROUPS") == null) {
            ArrayList<String> defaultExcludeGroups = new ArrayList<String>();
            ArrayList<String> existingGroups = new ArrayList<String>();
            Pager groupObjects = this.bambooUserManager.getGroups();
            for (Group group : groupObjects) {
                existingGroups.add(group.getName());
            }
            defaultExcludeGroups.add((String)existingGroups.get(0));
            return defaultExcludeGroups;
        }
        return this.pluginSettings.get("miniorange.saml.ON_THE_FLY_DO_NOT_REMOVE_GROUPS");
    }

    public void setOnTheFlyDoNotRemoveGroups(List<String> groups) {
        this.pluginSettings.put("miniorange.saml.ON_THE_FLY_DO_NOT_REMOVE_GROUPS", groups);
    }

    public void setCreateNewGroups(Boolean createNewGroups) {
        this.pluginSettings.put("miniorange.saml.ON_THE_FLY_CREATE_NEW_GROUPS", (Object)BooleanUtils.toString((Boolean)createNewGroups, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getCreateNewGroups() {
        String createNewGroups = (String)this.pluginSettings.get("miniorange.saml.ON_THE_FLY_CREATE_NEW_GROUPS");
        if (StringUtils.isBlank((CharSequence)createNewGroups)) {
            return Boolean.TRUE;
        }
        return BooleanUtils.toBoolean((String)createNewGroups);
    }

    public void setOnTheFlyGroupMapping(Boolean createUsersIfRoleMapped) {
        this.pluginSettings.put("miniorange.saml.ON_THE_FLY_GROUP_MAPPING", (Object)BooleanUtils.toString((Boolean)createUsersIfRoleMapped, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getOnTheFlyGroupMapping() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.ON_THE_FLY_GROUP_MAPPING"))), (boolean)false);
    }

    public void setOnTheFlyAssignNewGroupsOnly(Boolean onTheFlyAssignNewGroupsOnly) {
        this.pluginSettings.put("miniorange.saml.ON_THE_FLY_ASSIGN_NEW_GROUPS_ONLY", (Object)BooleanUtils.toString((Boolean)onTheFlyAssignNewGroupsOnly, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getOnTheFlyAssignNewGroupsOnly() {
        String onTheFlyAssignNewGroupsOnly = (String)this.pluginSettings.get("miniorange.saml.ON_THE_FLY_ASSIGN_NEW_GROUPS_ONLY");
        if (StringUtils.isBlank((CharSequence)onTheFlyAssignNewGroupsOnly)) {
            return Boolean.TRUE;
        }
        return BooleanUtils.toBoolean((String)onTheFlyAssignNewGroupsOnly);
    }

    public Boolean getDefaultLoginDisabled() {
        return BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.DISABLE_DEFAULT_LOGIN")));
    }

    public void setDefaultLoginDisabled(Boolean defaultLoginDisabled) {
        this.pluginSettings.put("miniorange.saml.DISABLE_DEFAULT_LOGIN", (Object)BooleanUtils.toString((Boolean)defaultLoginDisabled, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getBackdoorEnabled() {
        return BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.ENABLE_BACKDOOR")));
    }

    public void setRelayState(String relayState) {
        this.pluginSettings.put("miniorange.saml.RELAY_STATE", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)relayState, (CharSequence)""))));
    }

    public String getRelayState() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.RELAY_STATE")), (CharSequence)"");
    }

    public void setRelayStateRedirectionType(String relayStateRedirectionType) {
        this.pluginSettings.put("miniorange.saml.RELAY_STATE_REDIRECTION_TYPE", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)relayStateRedirectionType, (CharSequence)"forceRedirect"))));
    }

    public String getRelayStateRedirectionType() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.RELAY_STATE_REDIRECTION_TYPE")), (CharSequence)"forceRedirect");
    }

    public void setBackdoorEnabled(Boolean backdoorEnabled) {
        this.pluginSettings.put("miniorange.saml.ENABLE_BACKDOOR", (Object)BooleanUtils.toString((Boolean)backdoorEnabled, (String)"true", (String)"false", (String)"false"));
    }

    public String getLoginButtonText() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.LOGIN_BUTTON_TEXT")), (CharSequence)"Use IDP Login");
    }

    public void setLoginButtonText(String loginButtonText) {
        LOGGER.info((Object)"setLoginButtontest called");
        this.pluginSettings.put("miniorange.saml.LOGIN_BUTTON_TEXT", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)loginButtonText, (CharSequence)"Use IDP Login"))));
    }

    public String getPublicSPCertificate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.PUBLIC_SP_CERTIFICATE")), (CharSequence)PUBLIC_CERTIFICATE);
    }

    public void setPublicSPCertificate(String publicSPCertificate) {
        this.pluginSettings.put("miniorange.saml.PUBLIC_SP_CERTIFICATE", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)publicSPCertificate, (CharSequence)PUBLIC_CERTIFICATE))));
    }

    public String getPrivateSPCertificate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.PRIVATE_SP_CERTIFICATE")), (CharSequence)PRIVATE_CERTIFICATE);
    }

    public void setPrivateSPCertificate(String privateSPCertificate) {
        this.pluginSettings.put("miniorange.saml.PRIVATE_SP_CERTIFICATE", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)privateSPCertificate, (CharSequence)PRIVATE_CERTIFICATE))));
    }

    public String getNameIdFormat() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.NAME_ID_FORMAT")), (CharSequence)"urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
    }

    public void setNameIdFormat(String nameIdFormat) {
        this.pluginSettings.put("miniorange.saml.NAME_ID_FORMAT", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)nameIdFormat, (CharSequence)"urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified"))));
    }

    public void setEnableSsoForIdp(Boolean enableSsoForIdp) {
        this.pluginSettings.put("miniorange.saml.ENABLE_SSO_FOR_IDP", (Object)BooleanUtils.toString((Boolean)enableSsoForIdp, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getEnableSsoForIdp() {
        String enableSsoForIdp = (String)this.pluginSettings.get("miniorange.saml.ENABLE_SSO_FOR_IDP");
        if (StringUtils.isBlank((CharSequence)enableSsoForIdp)) {
            return Boolean.TRUE;
        }
        return BooleanUtils.toBoolean((String)enableSsoForIdp);
    }

    public void setIssuerMap(HashMap<String, String> issuerMap) {
        this.pluginSettings.put("miniorange.saml.ISSUER_MAP", issuerMap);
    }

    public HashMap<String, String> getIssuerMap() {
        HashMap issuerMap = (HashMap)this.pluginSettings.get("miniorange.saml.ISSUER_MAP");
        if (issuerMap == null) {
            return new HashMap<String, String>();
        }
        return issuerMap;
    }

    public void setSsoEnabledForIdPList(ArrayList<String> ssoEnabledForIdPList) {
        this.pluginSettings.put("miniorange.saml.SSO_ENABLED_FOR_IDP_LIST", ssoEnabledForIdPList);
    }

    public ArrayList<String> getSsoEnabledForIdPList() {
        ArrayList ssoEnabledForIdPList = (ArrayList)this.pluginSettings.get("miniorange.saml.SSO_ENABLED_FOR_IDP_LIST");
        if (ssoEnabledForIdPList == null) {
            ArrayList<String> idpList = this.getIdPList();
            LOGGER.debug((Object)("Using idpList as ssoEnabledForIdPList: " + idpList));
            return idpList;
        }
        return ssoEnabledForIdPList;
    }

    public void setRedirectionRule(String rule, String ruleName) {
        this.pluginSettings.put("miniorange.saml.REDIRECTION_RULE" + ruleName, (Object)rule);
    }

    public JSONObject getRedirectionRule(String ruleName) {
        String rule = (String)this.pluginSettings.get("miniorange.saml.REDIRECTION_RULE" + ruleName);
        try {
            JSONObject redirectionRule = new JSONObject(rule);
            return redirectionRule;
        }
        catch (JSONException e) {
            LOGGER.error((Object)"An error occurred while getting Redirection Rule", (Throwable)e);
            return null;
        }
    }

    public void setBambooRedirectionRulesMap(String bambooRedirectionRules) {
        this.pluginSettings.put("miniorange.saml.BAMBOO_REDIRECTION_RULES", (Object)bambooRedirectionRules);
    }

    public Map<String, String> getBambooRedirectionRulesMap() {
        String bambooRedirectionRules = this.getBambooRedirectionRuleJson();
        LOGGER.debug((Object)("DB rules in Json " + bambooRedirectionRules));
        Map<String, String> bambooRedirectionRulesMap = new LinkedHashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)bambooRedirectionRules)) {
            return bambooRedirectionRulesMap;
        }
        bambooRedirectionRulesMap = MoJSONUtils.convertJsonToMap(bambooRedirectionRules, bambooRedirectionRulesMap);
        return bambooRedirectionRulesMap;
    }

    public String getBambooRedirectionRuleJson() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.BAMBOO_REDIRECTION_RULES")), (CharSequence)new JSONObject().toString());
    }

    public List<String> convertSelect2StringToList(String groups) {
        ArrayList<String> groupsList = new ArrayList<String>();
        if (StringUtils.isBlank((CharSequence)groups)) {
            return groupsList;
        }
        LOGGER.debug((Object)("multiple groups -" + groups.toString()));
        Collections.addAll(groupsList, StringUtils.split((String)groups, (String)","));
        groupsList.removeAll(Arrays.asList(null, ""));
        return groupsList;
    }

    public void setDefaultRedirectURL(String defaultRedirectURL) {
        this.pluginSettings.put("miniorange.saml.DEFAULT_REDIRECT_URL", (Object)StringUtils.defaultIfBlank((CharSequence)defaultRedirectURL, (CharSequence)""));
    }

    public String getDefaultRedirectURL() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.DEFAULT_REDIRECT_URL")), (CharSequence)"");
    }

    public void deleteRedirectionRule(String ruleId) {
        this.pluginSettings.remove("miniorange.saml.REDIRECTION_RULE" + ruleId);
        Map<String, String> rulesMap = this.getBambooRedirectionRulesMap();
        rulesMap.remove(ruleId);
        String redirectionRules = MoJSONUtils.convertMapToJSON(rulesMap);
        this.setBambooRedirectionRulesMap(redirectionRules);
    }

    public void setDefaultBambooIDP(String defaultBambooIDP) {
        this.pluginSettings.put("miniorange.saml.DEFAULT_BAMBOO_IDP", (Object)StringUtils.defaultIfBlank((CharSequence)defaultBambooIDP, (CharSequence)"loginPage"));
    }

    public String getDefaultBambooIDP() {
        String defaultBambooIDP = this.getSsoEnabledForIdPList().isEmpty() ? "loginPage" : this.getSsoEnabledForIdPList().get(0);
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.DEFAULT_BAMBOO_IDP")), (CharSequence)defaultBambooIDP);
    }

    public String getBaseUrl() {
        String baseURL = this.administrationConfigurationAccessor.getAdministrationConfiguration().getBaseUrl();
        return baseURL;
    }

    public void removeRedirectionRulesForIdp(String idpID) {
        JSONArray redirectionRules = this.getRedirectionRules();
        try {
            for (int i = 0; i < redirectionRules.length(); ++i) {
                JSONObject redirectionRule = redirectionRules.getJSONObject(i);
                String idp = redirectionRule.optString("idp");
                if (!StringUtils.equals((CharSequence)idp, (CharSequence)idpID)) continue;
                String ruleKey = redirectionRule.optString("name");
                this.deleteRedirectionRule(ruleKey);
            }
        }
        catch (JSONException e) {
            LOGGER.error((Object)("An Error Occurred while deleting redirection rule for IDP " + idpID), (Throwable)e);
        }
    }

    public String getLoginPageUrl() {
        return this.getBaseUrl().concat("/userlogin!doDefault.action");
    }

    public String getAdminSessionUrl() {
        return this.getBaseUrl().concat("/authenticate");
    }

    public String getLogoutPageUrl() {
        return this.getBaseUrl().concat("?logout=true");
    }

    public String getDashboardUrl() {
        return this.getBaseUrl().concat("/");
    }

    public String getImportExportPageUrl() {
        return this.getBaseUrl().concat("/plugins/servlet/bamboo-sso/backuprestore.action");
    }

    public String getLoginServletUrl() {
        return this.getSpBaseUrl().concat("/plugins/servlet/saml/auth");
    }

    public String getLogoutServletUrl() {
        return this.getSpBaseUrl().concat("/plugins/servlet/saml/logout");
    }

    public String getRegisterActionUrl() {
        return this.getBaseUrl().concat("/plugins/servlet/bamboo-sso/doregister.action");
    }

    public String getConfigureActionUrl() {
        return this.getBaseUrl().concat("/plugins/servlet/bamboo-sso/configure.action");
    }

    public String getReplaceOldSettingWithNewUrl() {
        return this.getBaseUrl().concat("/plugins/servlet/saml/replaceOldSettingsWithNew");
    }

    public String getResetPluginSettings() {
        return this.getBaseUrl().concat("/plugins/servlet/saml/moconfreset");
    }

    public String getVerifyLicenseActionUrl() {
        return this.getBaseUrl().concat("/plugins/servlet/bamboo-sso/verifylicense.jspa");
    }

    public String getLoginActionUrl() {
        return this.getBaseUrl().concat("/plugins/servlet/bamboo-sso/dologin.action");
    }

    public String getMiniorangeUrl() {
        return "https://auth.miniorange.com/moas";
    }

    public String getCustomerTokenKey() {
        return StringUtils.defaultString((String)CUSTOMER_TOKEN_KEY);
    }

    public Boolean isLicenseDefine() {
        if (this.pluginLicenseManager.getLicense().isDefined()) {
            return true;
        }
        return false;
    }

    public Boolean isValidLicense() {
        try {
            if (this.pluginLicenseManager.getLicense().isDefined() && !((PluginLicense)this.pluginLicenseManager.getLicense().get()).isValid()) {
                return false;
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public Boolean isLicenseValid() {
        if (this.pluginLicenseManager.getLicense().isDefined() && (!((PluginLicense)this.pluginLicenseManager.getLicense().get()).isValid() || ((PluginLicense)this.pluginLicenseManager.getLicense().get()).getError().isDefined())) {
            LOGGER.debug((Object)"Invalid License");
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Boolean isEvaluationOrSubscriptionLicense() {
        PluginLicense pluginLicense;
        if (!this.isLicenseValid().booleanValue() && ((pluginLicense = (PluginLicense)this.pluginLicenseManager.getLicense().get()).isEvaluation() || pluginLicense.isSubscription())) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public String getCurrentLicenseEmail() {
        Contact contact = null;
        String email = "empty";
        try {
            if (this.pluginLicenseManager.getLicense().isDefined()) {
                Iterator itr = ((PluginLicense)this.pluginLicenseManager.getLicense().get()).getContacts().iterator();
                if (itr.hasNext()) {
                    contact = (Contact)itr.next();
                }
                if (contact != null && contact.getEmail() != null) {
                    email = contact.getEmail();
                }
                return email;
            }
            return email;
        }
        catch (Exception e) {
            e.printStackTrace();
            return email;
        }
    }

    public Integer getMaxRemoteAgentsCount() {
        if (this.pluginLicenseManager.getLicense().isDefined()) {
            try {
                Integer licensedAgents = (Integer)((PluginLicense)this.pluginLicenseManager.getLicense().get()).getEdition().get();
                return licensedAgents;
            }
            catch (Exception e) {
                return 0;
            }
        }
        return -1;
    }

    public int getActiveRemoteAgents() {
        List remoteAgentsCount = this.agentManager.getAllRemoteAgents();
        if (remoteAgentsCount != null) {
            return remoteAgentsCount.size();
        }
        return -1;
    }

    public String getUPMURL() {
        return this.getBaseUrl().concat("/plugins/servlet/upm");
    }

    public void setPluginSettingsFactory(PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettings = pluginSettingsFactory.createGlobalSettings();
    }

    public PluginSettings getPluginSettings() {
        return this.pluginSettings;
    }

    public void setPluginSettings(PluginSettings pluginSettings) {
        this.pluginSettings = pluginSettings;
    }

    public AdministrationConfigurationAccessor getAdministrationConfigurationAccessor() {
        return this.administrationConfigurationAccessor;
    }

    public void setAdministrationConfigurationAccessor(AdministrationConfigurationAccessor administrationConfigurationAccessor) {
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
    }

    public AgentManager getAgentManager() {
        return this.agentManager;
    }

    public void setAgentManager(AgentManager agentManager) {
        this.agentManager = agentManager;
    }

    public PluginLicenseManager getPluginLicenseManager() {
        return this.pluginLicenseManager;
    }

    public void setPluginLicenseManager(PluginLicenseManager pluginLicenseManager) {
        this.pluginLicenseManager = pluginLicenseManager;
    }

    public static String generateRandomAlphaNumericKey(int bytes) {
        String randomString = RandomStringUtils.random((int)bytes, (boolean)true, (boolean)true);
        return randomString;
    }

    public void setSpConfigurationStatus(String status) {
        this.pluginSettings.put("miniorange.saml.SP_CONFIGURATION_STATUS", (Object)StringUtils.defaultIfBlank((CharSequence)status, (CharSequence)""));
    }

    public String getSpConfigurationStatus() {
        return (String)this.pluginSettings.get("miniorange.saml.SP_CONFIGURATION_STATUS");
    }

    public String getErrorMsgTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.ERROR_MSG_TEMPLATE")), (CharSequence)ERRORMSG_TEMPLATE);
    }

    public void setErrorMsgTemplate(String errorMsgTemplate) {
        this.pluginSettings.put("miniorange.saml.ERROR_MSG_TEMPLATE", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)errorMsgTemplate, (CharSequence)ERRORMSG_TEMPLATE))));
    }

    public void setPageNumber(String pageNumber) {
        this.pluginSettings.put("miniorange.saml.PAGE_NUMBER", (Object)StringUtils.defaultIfEmpty((CharSequence)pageNumber, (CharSequence)"1"));
    }

    public String getPageNumber(Boolean resetPageNumber) {
        if (resetPageNumber.booleanValue()) {
            return "1";
        }
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.PAGE_NUMBER")), (CharSequence)"1");
    }

    public Boolean getEnableSAMLSSO() {
        String enableSAMLSSO = (String)this.pluginSettings.get("miniorange.saml.ENABLE_SAML_SSO");
        if (StringUtils.isBlank((CharSequence)enableSAMLSSO)) {
            return Boolean.TRUE;
        }
        return BooleanUtils.toBoolean((String)enableSAMLSSO);
    }

    public void setEnableSAMLSSO(Boolean enableSAMLSSO) {
        this.pluginSettings.put("miniorange.saml.ENABLE_SAML_SSO", (Object)BooleanUtils.toString((Boolean)enableSAMLSSO, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getAutoActivateUser() {
        return BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.AUTO_ACTIVATE_USER")));
    }

    public void setAutoActivateUser(Boolean autoActivateUser) {
        this.pluginSettings.put("miniorange.saml.AUTO_ACTIVATE_USER", (Object)BooleanUtils.toString((Boolean)autoActivateUser, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getIsCertificateExpired() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.CERT_EXPIRED"))), (boolean)false);
    }

    public void setIsCertificateExpired(Boolean certificateExpired) {
        this.pluginSettings.put("miniorange.saml.CERT_EXPIRED", (Object)BooleanUtils.toString((Boolean)certificateExpired, (String)"true", (String)"false", (String)"false"));
    }

    public String getPluginName() {
        String pluginKey = this.pluginLicenseManager.getPluginKey();
        Plugin plugin = this.pluginAccessor.getPlugin(pluginKey);
        return plugin.getName();
    }

    public Boolean getNotifyMultipleAdmins() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBooleanObject((String)((String)this.pluginSettings.get("miniorange.saml.NOTIFY_MULTIPLE_ADMINS"))), (boolean)false);
    }

    public String getRecipientsList() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.RECIPIENT_LIST")), (CharSequence)"");
    }

    public void setNotifyMultipleAdmins(Boolean notifyMultipleAdmins) {
        this.pluginSettings.put("miniorange.saml.NOTIFY_MULTIPLE_ADMINS", (Object)BooleanUtils.toString((Boolean)notifyMultipleAdmins, (String)"true", (String)"false", (String)"false"));
    }

    public void setRecipientsList(String recipientsList) {
        this.pluginSettings.put("miniorange.saml.RECIPIENT_LIST", (Object)StringUtils.defaultIfBlank((CharSequence)recipientsList, (CharSequence)""));
    }

    public void saveEmailSettings(Boolean notifyMultipleAdmins, String recipientsList) {
        this.setNotifyMultipleAdmins(notifyMultipleAdmins);
        this.setRecipientsList(recipientsList);
    }

    public Boolean getEnableAutoRedirectDelay() {
        return BooleanUtils.toBoolean((String)StringUtils.defaultString((String)((String)this.pluginSettings.get("miniorange.saml.ENABLE_AUTO_REDIRECT_DELAY")), (String)"true"));
    }

    public void setEnableAutoRedirectDelay(Boolean enableAutoRedirectDelay) {
        this.pluginSettings.put("miniorange.saml.ENABLE_AUTO_REDIRECT_DELAY", (Object)BooleanUtils.toString((Boolean)enableAutoRedirectDelay, (String)"true", (String)"false", (String)"false"));
    }

    public void setEnableAutoRedirect(Boolean enableAutoRedirect) {
        this.pluginSettings.put("miniorange.saml.ENABLE_AUTO_REDIRECT", (Object)BooleanUtils.toString((Boolean)enableAutoRedirect, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getEnableAutoRedirect() {
        String enableAutoRedirect = (String)this.pluginSettings.get("miniorange.saml.ENABLE_AUTO_REDIRECT");
        if (StringUtils.isBlank((CharSequence)enableAutoRedirect)) {
            return Boolean.TRUE;
        }
        return BooleanUtils.toBoolean((String)enableAutoRedirect);
    }

    public void setNumberOfLoginAttempts(String numberOfLoginAttempts) {
        this.pluginSettings.put("miniorange.saml.NUMBER_OF_LOGIN_ATTEMPTS", (Object)StringUtils.trimToEmpty((String)numberOfLoginAttempts));
    }

    public String getNumberOfLoginAttempts() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.NUMBER_OF_LOGIN_ATTEMPTS")), (CharSequence)"3");
    }

    public void setBackdoorKey(String backdoorKey) {
        this.pluginSettings.put("miniorange.saml.BACKDOOR_KEY", (Object)StringUtils.defaultIfBlank((CharSequence)backdoorKey, (CharSequence)"saml_sso"));
    }

    public String getBackdoorKey() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.BACKDOOR_KEY")), (CharSequence)"saml_sso");
    }

    public void setBackdoorValue(String backdoorValue) {
        this.pluginSettings.put("miniorange.saml.BACKDOOR_VALUE", (Object)StringUtils.defaultIfBlank((CharSequence)backdoorValue, (CharSequence)"false"));
    }

    public String getBackdoorValue() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.BACKDOOR_VALUE")), (CharSequence)"false");
    }

    public Boolean getRestrictBackdoor() {
        return BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.RESTRICT_BACKDOOR")));
    }

    public List<String> getBackdoorGroups() {
        ArrayList<String> backdoorGroups = (ArrayList<String>)this.pluginSettings.get("miniorange.saml.BACKDOOR_GROUPS");
        if (backdoorGroups == null) {
            backdoorGroups = new ArrayList<String>();
            backdoorGroups.addAll(this.bambooPermissionManager.getAdminGroups());
        } else if (backdoorGroups.size() == 0) {
            backdoorGroups.addAll(this.bambooPermissionManager.getAdminGroups());
        }
        return backdoorGroups;
    }

    public JSONArray getRedirectionRules() {
        JSONArray rules = new JSONArray();
        Map<Object, Object> rulesMap = new LinkedHashMap();
        rulesMap = this.getBambooRedirectionRulesMap();
        for (String string : rulesMap.keySet()) {
            JSONObject rule = this.getRedirectionRule(string);
            rules.put(rule);
        }
        return rules;
    }

    public void setBackdoorGroups(List<String> backdoorGroups) {
        this.pluginSettings.put("miniorange.saml.BACKDOOR_GROUPS", backdoorGroups);
    }

    public void setRestrictBackdoor(Boolean restrictBackdoor) {
        this.pluginSettings.put("miniorange.saml.RESTRICT_BACKDOOR", (Object)BooleanUtils.toString((Boolean)restrictBackdoor, (String)"true", (String)"false", (String)"false"));
    }

    public String getLogoutTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.LOGOUT_TEMPLATE")), (CharSequence)LOGOUT_TEMPLATE);
    }

    public void setLogoutTemplate(String logoutTemplate) {
        this.pluginSettings.put("miniorange.saml.LOGOUT_TEMPLATE", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)logoutTemplate, (CharSequence)LOGOUT_TEMPLATE))));
    }

    public Boolean getEnableLoginTemplate() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.ENABLE_LOGIN_TEMPLATE"))), (boolean)false);
    }

    public void setEnableLoginTemplate(Boolean enableLoginTemplate) {
        this.pluginSettings.put("miniorange.saml.ENABLE_LOGIN_TEMPLATE", (Object)BooleanUtils.toString((Boolean)enableLoginTemplate, (String)"true", (String)"false", (String)"false"));
    }

    public String getLoginTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.LOGIN_TEMPLATE")), (CharSequence)LOGIN_TEMPLATE);
    }

    public void setLoginTemplate(String loginTemplate) {
        this.pluginSettings.put("miniorange.saml.LOGIN_TEMPLATE", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)loginTemplate, (CharSequence)LOGIN_TEMPLATE))));
    }

    public Boolean getEnableErrorMsgTemplate() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.ENABLE_ERRORMSG_TEMPLATE"))), (boolean)false);
    }

    public void setEnableErrorMsgTemplate(Boolean enableErrorMsgTemplate) {
        this.pluginSettings.put("miniorange.saml.ENABLE_ERRORMSG_TEMPLATE", (Object)BooleanUtils.toString((Boolean)enableErrorMsgTemplate, (String)"true", (String)"false", (String)"false"));
    }

    public void setShowLoginButtons(Boolean showLoginButtons) {
        this.pluginSettings.put("miniorange.saml.SHOW_LOGIN_BUTTON", (Object)BooleanUtils.toString((Boolean)showLoginButtons, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getShowLoginButtons() {
        return BooleanUtils.toBoolean((String)StringUtils.defaultString((String)((String)this.pluginSettings.get("miniorange.saml.SHOW_LOGIN_BUTTON")), (String)"true"));
    }

    public String getTimeDelay() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.TIME_DELAY")), (CharSequence)"01");
    }

    public void setTimeDelay(String timeDelay) {
        this.pluginSettings.put("miniorange.saml.TIME_DELAY", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)timeDelay, (CharSequence)"01"))));
    }

    public Boolean getAllowUserCreation() {
        return BooleanUtils.toBoolean((String)StringUtils.defaultString((String)((String)this.pluginSettings.get("miniorange.saml.ALLOW_USER_CREATION")), (String)"true"));
    }

    public void setAllowUserCreation(Boolean allowUserCreation) {
        this.pluginSettings.put("miniorange.saml.ALLOW_USER_CREATION", (Object)BooleanUtils.toString((Boolean)allowUserCreation, (String)"true", (String)"false", (String)"true"));
    }

    public String getDefaultWritableDirectory() {
        List directoryObjects = MoPluginHandler.directoryManager.findAllDirectories();
        Directory defaultDirectory = (Directory)directoryObjects.get(0);
        for (Directory dir : directoryObjects) {
            if (!dir.isActive() || !dir.getAllowedOperations().contains(OperationType.CREATE_USER) || !StringUtils.equals((CharSequence)dir.getName(), (CharSequence)"Bamboo Internal Directory")) continue;
            return dir.getName();
        }
        return defaultDirectory.getName();
    }

    public Boolean getForceAuthentication() {
        return BooleanUtils.toBoolean((String)StringUtils.defaultString((String)((String)this.pluginSettings.get("miniorange.saml.FORCE_AUTHENTICATION")), (String)"false"));
    }

    public Boolean getEnablePassiveSso() {
        return BooleanUtils.toBoolean((String)StringUtils.defaultString((String)((String)this.pluginSettings.get("miniorange.saml.ENABLE_PASSIVE_SSO")), (String)"false"));
    }

    public void setEnablePassiveSso(Boolean enablePassiveSso) {
        LOGGER.info((Object)"setEnablePassiveSSO called");
        this.pluginSettings.put("miniorange.saml.ENABLE_PASSIVE_SSO", (Object)BooleanUtils.toString((Boolean)enablePassiveSso, (String)"true", (String)"false", (String)"false"));
    }

    public void setAdvancedSSOConfig(JSONObject advnacedSSOConfig, String idpID) {
        this.pluginSettings.put("miniorange.saml.ADVANCED_SSO_CONFIG" + idpID, (Object)advnacedSSOConfig.toString());
    }

    public void setForceAuthentication(Boolean forceAuthentication) {
        this.pluginSettings.put("miniorange.saml.FORCE_AUTHENTICATION", (Object)BooleanUtils.toString((Boolean)forceAuthentication, (String)"true", (String)"false", (String)"false"));
    }

    public JSONObject getAdvancedSSOConfig(String idpID) throws JSONException {
        String advancedSsoConfig = (String)this.pluginSettings.get("miniorange.saml.ADVANCED_SSO_CONFIG" + idpID);
        if (StringUtils.isNotBlank((CharSequence)advancedSsoConfig)) {
            return new JSONObject(advancedSsoConfig);
        }
        return null;
    }

    public boolean checkIfTestConfig(String idpId) {
        try {
            if (this.getIdpConfig(idpId).has("testConfig")) {
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.debug((Object)"Error while checking if test config has been performed");
            return false;
        }
        return false;
    }

    public void setShowIntroPage(Boolean showIntroPage) {
        this.pluginSettings.put("miniorange.saml.SHOW_INTRO_PAGE", (Object)BooleanUtils.toString((Boolean)showIntroPage, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getShowIntroPage() {
        return BooleanUtils.toBoolean((String)StringUtils.defaultString((String)((String)this.pluginSettings.get("miniorange.saml.SHOW_INTRO_PAGE")), (String)"true"));
    }

    public Boolean getisMigrated() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.IS_MIGRATED"))), (boolean)false);
    }

    public void setisMigrated(boolean isMigrated) {
        this.pluginSettings.put("miniorange.saml.IS_MIGRATED", (Object)BooleanUtils.toString((Boolean)isMigrated, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getEnableLogoutTemplate() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.ENABLE_LOGOUT_TEMPLATE"))), (boolean)false);
    }

    public void setEnableLogoutTemplate(Boolean enablelogoutTemplate) {
        this.pluginSettings.put("miniorange.saml.ENABLE_LOGOUT_TEMPLATE", (Object)BooleanUtils.toString((Boolean)enablelogoutTemplate, (String)"true", (String)"false", (String)"false"));
    }

    public String getCustomLogoutURL() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.CUSTOM_LOGOUT_URL")), (CharSequence)"");
    }

    public void setCustomLogoutURL(String customLogoutURL) {
        this.pluginSettings.put("miniorange.saml.CUSTOM_LOGOUT_URL", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)customLogoutURL, (CharSequence)""))));
    }

    public Boolean getRememberMeCookieEnabled() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.REMEMBERME_COOKIE"))), (boolean)false);
    }

    public void setRememberMeCookieEnabled(Boolean isRememberMeCookieEnabled) {
        LOGGER.debug((Object)("is cookie enabled?:" + isRememberMeCookieEnabled));
        this.pluginSettings.put("miniorange.saml.REMEMBERME_COOKIE", (Object)BooleanUtils.toString((Boolean)isRememberMeCookieEnabled, (String)"true", (String)"false", null));
    }

    public void setRememberMyIdpCookieEnabled(Boolean isRememberMyIdpCookieEnabled) {
        this.pluginSettings.put("miniorange.saml.REMEMBERMYIDP_COOKIE", (Object)BooleanUtils.toString((Boolean)isRememberMyIdpCookieEnabled, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getRememberMyIdpCookieEnabled() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.REMEMBERMYIDP_COOKIE"))), (boolean)false);
    }

    public void setConfiguredLifeForIdpCookie(String configuredLifeForIdpCookie) {
        this.pluginSettings.put("mo.jira-sso.CONFIGUREDLIFEFORIDPCOOKIE", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)configuredLifeForIdpCookie, (CharSequence)"14"))));
    }

    public String getConfiguredLifeForIdpCookie() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("mo.jira-sso.CONFIGUREDLIFEFORIDPCOOKIE")), (CharSequence)"14");
    }

    public void setUserConsent(Boolean userConsent) {
        this.pluginSettings.put("mo.jira-sso.USERCONSENT", (Object)BooleanUtils.toString((Boolean)userConsent, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getUserConsent() {
        return BooleanUtils.toBoolean((String)StringUtils.defaultString((String)((String)this.pluginSettings.get("mo.jira-sso.USERCONSENT")), (String)"false"));
    }

    private String getDefaultLogoutTemplate() {
        String logoutTemplate = "<html><head><title>Logout</title>$webResourceManager.requireResource('$pluginproperties.pluginkey:resources')<meta name='decorator' content='atl.general'></head><body class='aui-layout aui-theme-default page-type-login' ><div class='aui-page-panel'><div class='aui-page-panel-inner'><section class='aui-page-panel-content'><header><h1>You have logged out successfully</h1></header><div class='aui-message info'><span class='aui-icon icon-info'></span><p class='title'>You are now logged out. Any automatic login has also been stopped.</p><p>Didn't mean to log out?<a href='$baseUrl'> Log in again.</a><p></div></section></div></div></body></html>";
        return logoutTemplate;
    }

    private String getDefaultErrorMessageTemplate() {
        String errorMessageTemplate = "<html><head><title>SAML SSO Error</title>$webResourceManager.requireResource('$pluginproperties.pluginkey:resources')<meta name='decorator' content='atl.general'></head><body class='aui-layout aui-theme-default page-type-login' ><div class='aui-page-panel'><div class='aui-page-panel-inner'><section class='aui-page-panel-content'><header><h1>SAML Single Sign On Failed</h1></header><div class='aui-message aui-message-error'><p>Please contact your administrator for more information</p></div><p>Click <a href='$baseUrl'>here</a> to go to the login page</p></section></div></div></body></html>";
        return errorMessageTemplate;
    }

    private String getDefaultLoginTemplate() {
        String loginTemplate = "Custom Login Template";
        return loginTemplate;
    }

    public void setMetadataOption(String idpID, String metadataOption) {
        this.pluginSettings.put("miniorange.saml.METADATA_OPTION" + idpID, (Object)StringUtils.defaultIfBlank((CharSequence)metadataOption, (CharSequence)""));
    }

    public String getMetadataOption(String idpID) {
        if (StringUtils.equals((CharSequence)idpID, (CharSequence)"miniorange.saml.DEFAULT_IDP_ID")) {
            return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.METADATA_OPTION")), (CharSequence)"");
        }
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.METADATA_OPTION" + idpID)), (CharSequence)"");
    }

    public String getInputMetadataUrl() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.INPUT_METADATA_URL")), (CharSequence)"");
    }

    public void setInputMetadataUrl(String url) {
        this.pluginSettings.put("miniorange.saml.INPUT_METADATA_URL", (Object)StringUtils.trimToEmpty((String)url));
    }

    public String getIdpMetadataURL() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.IDP_METADATA_URL")), (CharSequence)"");
    }

    public void setIdpMetadataURL(String effectiveUrl) {
        this.pluginSettings.put("miniorange.saml.IDP_METADATA_URL", (Object)StringUtils.trimToEmpty((String)effectiveUrl));
    }

    public Boolean getRefreshMetadata() {
        String refreshMetadata = (String)this.pluginSettings.get("miniorange.saml.REFRESH_METADATA");
        if (StringUtils.isBlank((CharSequence)refreshMetadata)) {
            return Boolean.FALSE;
        }
        return BooleanUtils.toBoolean((String)refreshMetadata);
    }

    public void setRefreshMetadata(Boolean refreshMetadata) {
        this.pluginSettings.put("miniorange.saml.REFRESH_METADATA", (Object)BooleanUtils.toString((Boolean)refreshMetadata, (String)"true", (String)"false", (String)"false"));
    }

    public String getRefreshInterval() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.METADATA_REFRESH_INTERVAL")), (CharSequence)"hourly");
    }

    public void setRefreshInterval(String refreshInterval) {
        if (refreshInterval != null) {
            this.pluginSettings.put("miniorange.saml.METADATA_REFRESH_INTERVAL", (Object)StringUtils.trimToEmpty((String)refreshInterval));
        } else {
            this.pluginSettings.put("miniorange.saml.METADATA_REFRESH_INTERVAL", (Object)StringUtils.trimToEmpty((String)"hourly"));
        }
    }

    public Integer getCustomRefreshInterval() {
        String interval = (String)this.pluginSettings.get("miniorange.saml.CUSTOM_REFRESH_INTERVAL");
        if (NumberUtils.isDigits((String)interval)) {
            return NumberUtils.createInteger((String)interval);
        }
        return MoSAMLUtils.getMetadataRefreshInterval(this.getRefreshInterval(), 60, "minutes");
    }

    public void setCustomRefreshInterval(Integer customRefreshInterval) {
        this.pluginSettings.put("miniorange.saml.CUSTOM_REFRESH_INTERVAL", (Object)String.valueOf(customRefreshInterval));
    }

    public String getCustomRefreshIntervalUnit() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.CUSTOM_REFRESH_INTERVAL_UNIT")), (CharSequence)"minutes");
    }

    public void setCustomRefreshIntervalUnit(String customRefreshIntervalUnit) {
        this.pluginSettings.put("miniorange.saml.CUSTOM_REFRESH_INTERVAL_UNIT", (Object)StringUtils.trimToEmpty((String)customRefreshIntervalUnit));
    }

    public BambooUserManager getBambooUserManager() {
        return this.bambooUserManager;
    }

    public void setBambooUserManager(BambooUserManager bambooUserManager) {
        this.bambooUserManager = bambooUserManager;
    }

    public PluginAccessor getPluginAccessor() {
        return this.pluginAccessor;
    }

    public void setEnablePasswordChange(Boolean enableSAMLSSO) {
        this.pluginSettings.put("miniorange.saml.ENABLE_PASSWORD_CHANGE", (Object)BooleanUtils.toString((Boolean)enableSAMLSSO, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getEnablePasswordChange() {
        String enablePasswordChange = (String)this.pluginSettings.get("miniorange.saml.ENABLE_PASSWORD_CHANGE");
        if (StringUtils.isBlank((CharSequence)enablePasswordChange)) {
            return Boolean.TRUE;
        }
        return BooleanUtils.toBoolean((String)enablePasswordChange);
    }

    public BambooPermissionManager getBambooPermissionManager() {
        return this.bambooPermissionManager;
    }

    public void setBambooPermissionManager(BambooPermissionManager bambooPermissionManager) {
        this.bambooPermissionManager = bambooPermissionManager;
    }

    public void setIdpMap(HashMap<String, String> idpMap) {
        this.pluginSettings.put("miniorange.saml.IDP_MAP", idpMap);
    }

    public HashMap<String, String> getIdpMap() {
        HashMap idpMap = (HashMap)this.pluginSettings.get("miniorange.saml.IDP_MAP");
        if (idpMap == null) {
            return new HashMap<String, String>();
        }
        return idpMap;
    }

    public void setIdPList(ArrayList<String> idpList) {
        this.pluginSettings.put("miniorange.saml.IDP_LIST", idpList);
    }

    public ArrayList<String> getIdPList() {
        ArrayList idpList = (ArrayList)this.pluginSettings.get("miniorange.saml.IDP_LIST");
        if (idpList == null) {
            return new ArrayList<String>();
        }
        return idpList;
    }

    public void setIdpConfig(JSONObject idpConfigObj, String idpName) {
        this.pluginSettings.put("miniorange.saml.IDP_CONFIG" + idpName, (Object)idpConfigObj.toString());
    }

    public JSONObject getIdpConfig(String idpName) throws JSONException {
        String idpConfigString = (String)this.pluginSettings.get("miniorange.saml.IDP_CONFIG" + idpName);
        if (StringUtils.isNotBlank((CharSequence)idpConfigString)) {
            return new JSONObject(idpConfigString);
        }
        return null;
    }

    public void setDomains(String[] domains) {
        ArrayList<String> domainList = new ArrayList<String>(domains.length);
        for (int i = 0; i < domains.length; ++i) {
            domainList.add(i, domains[i]);
        }
        this.pluginSettings.put("miniorange.saml.DOMAINS", domainList);
    }

    public List<String> getDomains() {
        List domains = (List)this.pluginSettings.get("miniorange.saml.DOMAINS");
        return domains != null ? domains : new ArrayList();
    }

    public void setUseDomainMapping(Boolean useDomainMapping) {
        this.pluginSettings.put("miniorange.saml.USE_DOMAIN_MAPPING", (Object)BooleanUtils.toString((Boolean)useDomainMapping, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getUseDomainMapping() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.USE_DOMAIN_MAPPING"))), (boolean)false);
    }

    public void setDomainMapping(HashMap<String, String> domainMapping) {
        this.pluginSettings.put("miniorange.saml.DOMAIN_MAPPING", domainMapping);
    }

    public HashMap<String, String> getDomainMapping() {
        HashMap domainMapping = (HashMap)this.pluginSettings.get("miniorange.saml.DOMAIN_MAPPING");
        return domainMapping != null ? domainMapping : new HashMap();
    }

    public JSONObject getImportMetadataConfig(String idpID) throws JSONException {
        String importMetadataConfig = (String)this.pluginSettings.get("miniorange.saml.DOMAIN_MAPPING" + idpID);
        if (StringUtils.isNotBlank((CharSequence)importMetadataConfig)) {
            return new JSONObject(importMetadataConfig);
        }
        return null;
    }

    public void setImportMetadataConfig(JSONObject importMetadataConfig, String idpID) {
        this.pluginSettings.put("miniorange.saml.DOMAIN_MAPPING" + idpID, (Object)importMetadataConfig.toString());
    }

    public List<String> convertArrayToList(String[] agentGroups) {
        ArrayList<String> agentGroupsList = new ArrayList<String>();
        if (agentGroups != null) {
            for (String agentGroup : agentGroups) {
                agentGroupsList.add(agentGroup);
            }
        }
        return agentGroupsList;
    }

    public List<String> convertJasonArrayToList(JSONArray agentGroupsArray) throws JSONException {
        ArrayList<String> agentGroups = new ArrayList<String>();
        if (agentGroupsArray != null) {
            for (int i = 0; i < agentGroupsArray.length(); ++i) {
                agentGroups.add(agentGroupsArray.getString(i));
            }
        }
        return agentGroups;
    }

    public boolean checkIfAllQuickSetupsComplete() {
        boolean flag = true;
        for (String idp : this.getIdPList()) {
            if (this.checkIfQuickSetupComplete(idp)) continue;
            flag = false;
            break;
        }
        return flag;
    }

    public boolean checkIfQuickSetupComplete(String idpId) {
        LOGGER.debug((Object)("checkIfQuickSetupComplete called for " + idpId));
        try {
            if (this.getIdpConfig(idpId).has("pageNumber")) {
                if (StringUtils.equalsIgnoreCase((CharSequence)((String)this.getIdpConfig(idpId).get("pageNumber")), (CharSequence)"4") || StringUtils.equalsIgnoreCase((CharSequence)((String)this.getIdpConfig(idpId).get("pageNumber")), (CharSequence)"5") || this.getIdpConfig(idpId).has("finishQuickSetup")) {
                    LOGGER.debug((Object)("Quick setup complete for " + idpId));
                    return true;
                }
                if (this.getIdpConfig(idpId).has("attributeMappingSubmitted") && this.getIdpConfig(idpId).has("roleMappingSubmitted")) {
                    LOGGER.debug((Object)("Quick setup not required, manual setup done for " + idpId));
                    return true;
                }
            } else {
                return true;
            }
            LOGGER.debug((Object)("Quick setup not complete for " + idpId + ". Page :" + (String)this.getIdpConfig(idpId).get("pageNumber")));
        }
        catch (Exception e) {
            LOGGER.debug((Object)"Error while checking if quick setup was completed");
            return false;
        }
        return false;
    }

    public int getMaxUsers() {
        int t = 0;
        try {
            if (this.pluginLicenseManager.getLicense().isDefined()) {
                t = (Integer)((PluginLicense)this.pluginLicenseManager.getLicense().get()).getEdition().get();
            }
        }
        catch (Exception e) {
            LOGGER.info((Object)"Unlimited Number of Users");
            return -1;
        }
        return t;
    }

    public void removeIdp(String idpID) {
        this.pluginSettings.remove("miniorange.saml.IDP_CONFIG" + idpID);
        this.pluginSettings.remove("miniorange.saml.METADATA_OPTION" + idpID);
        this.pluginSettings.remove("miniorange.saml.ATTRIBUTE_MAPPING_CONFIG" + idpID);
        this.pluginSettings.remove("miniorange.saml.GROUP_MAPPING_CONFIG" + idpID);
        this.pluginSettings.remove("miniorange.saml.ADVANCED_SSO_CONFIG" + idpID);
        HashMap<String, String> domainMapping = this.getDomainMapping();
        List<String> domains = this.getDomains();
        ArrayList<String> idpList = this.getIdPList();
        HashMap<String, String> idpMap = this.getIdpMap();
        ArrayList<String> ssoEnabledForIdPList = this.getSsoEnabledForIdPList();
        HashMap<String, String> issuerMap = this.getIssuerMap();
        Iterator<Map.Entry<String, String>> domainMappingIterator = domainMapping.entrySet().iterator();
        while (domainMappingIterator.hasNext()) {
            Map.Entry<String, String> currentEntry = domainMappingIterator.next();
            if (!currentEntry.getValue().equals(idpID)) continue;
            domainMappingIterator.remove();
        }
        if (idpList != null && idpList.contains(idpID)) {
            int index = idpList.indexOf(idpID);
            if (domains.size() > index) {
                domains.remove(index);
            }
            idpList.remove(idpID);
            idpMap.remove(idpID);
            ssoEnabledForIdPList.remove(idpID);
            issuerMap.remove(idpID);
        }
        this.setIdpMap(idpMap);
        this.setIdPList(idpList);
        this.setSsoEnabledForIdPList(ssoEnabledForIdPList);
        this.setIssuerMap(issuerMap);
        LOGGER.debug((Object)("[removeIdP] Domain Mapping: " + domainMapping.toString()));
        LOGGER.debug((Object)("[removeIdP] Domains: " + domains.toString()));
        this.setDomainMapping(domainMapping);
        this.setDomains(domains.toArray(new String[0]));
    }

    public void clearPluginSettings() {
        this.pluginSettings.remove("miniorange.saml.IDP_NAME");
        this.pluginSettings.remove("miniorange.saml.ALL_X509_CERTIFICATES");
        this.pluginSettings.remove("miniorange.saml.CREATE_USER_IF_ROLE_MAPPED");
        this.pluginSettings.remove("miniorange.saml.CUSTOM_LOGOUT_URL");
        this.pluginSettings.remove("miniorange.saml.DEFAULT_GROUP");
        this.pluginSettings.remove("miniorange.saml.DEFAULT_GROUPs");
        this.pluginSettings.remove("miniorange.saml.DISABLE_DEFAULT_LOGIN");
        this.pluginSettings.remove("miniorange.saml.EMAIL_ATTRIBUTE");
        this.pluginSettings.remove("miniorange.saml.ENABLE_BACKDOOR");
        this.pluginSettings.remove("miniorange.saml.ENCRYPTION");
        this.pluginSettings.remove("miniorange.saml.FIRST_NAME_ATTRIBUTE");
        this.pluginSettings.remove("miniorange.saml.FULL_NAME_ATTRIBUTE");
        this.pluginSettings.remove("miniorange.saml.IDP_ENTITY_ID");
        this.pluginSettings.remove("miniorange.saml.IDP_METADATA_URL");
        this.pluginSettings.remove("miniorange.saml.KEEP_EXISTING_ATTRIBUTE");
        this.pluginSettings.remove("miniorange.saml.KEEP_EXISTING_USER_ROLES");
        this.pluginSettings.remove("miniorange.saml.LAST_NAME_ATTRIBUTE");
        this.pluginSettings.remove("miniorange.saml.LOGIN_BUTTON_TEXT");
        this.pluginSettings.remove("miniorange.saml.LOGOUT_TEMPLATE");
        this.pluginSettings.remove("miniorange.saml.CUSTOM_REFRESH_INTERVAL");
        this.pluginSettings.remove("miniorange.saml.CUSTOM_REFRESH_INTERVAL_UNIT");
        this.pluginSettings.remove("miniorange.saml.METADATA_REFRESH_INTERVAL");
        this.pluginSettings.remove("miniorange.saml.PRIVATE_SP_CERTIFICATE");
        this.pluginSettings.remove("miniorange.saml.PUBLIC_SP_CERTIFICATE");
        this.pluginSettings.remove("miniorange.saml.ALLOW_USER_CREATION");
        this.pluginSettings.remove("miniorange.saml.REFRESH_METADATA");
        this.pluginSettings.remove("miniorange.saml.RELAY_STATE");
        this.pluginSettings.remove("miniorange.saml.RELAY_STATE_REDIRECTION_TYPE");
        this.pluginSettings.remove("miniorange.saml.ROLE_ATTRIBUTE");
        this.pluginSettings.remove("miniorange.saml.ROLE_MAPPING");
        this.pluginSettings.remove("miniorange.saml.SESSION_TIME");
        this.pluginSettings.remove("miniorange.saml.SIGNED_REQUEST");
        this.pluginSettings.remove("miniorange.saml.SIGNING");
        this.pluginSettings.remove("miniorange.saml.SLO_BINDING_TYPE");
        this.pluginSettings.remove("miniorange.saml.SLO_URL");
        this.pluginSettings.remove("miniorange.saml.SP_BASE_URL");
        this.pluginSettings.remove("miniorange.saml.SP_ENTITY_ID");
        this.pluginSettings.remove("miniorange.saml.SSO_BINDING_TYPE");
        this.pluginSettings.remove("miniorange.saml.SSO_URL");
        this.pluginSettings.remove("miniorange.saml.NAME_ID_FORMAT");
        this.pluginSettings.remove("miniorange.saml.TIME_DELAY");
        this.pluginSettings.remove("miniorange.saml.VALIDATE_SAML_RESPONSE");
        this.pluginSettings.remove("miniorange.saml.USE_SEPARATE_NAME_ATTRIBUTE");
        this.pluginSettings.remove("miniorange.saml.USERNAME_ATTRIBUTE");
        this.pluginSettings.remove("miniorange.saml.X509_CERTIFICATE");
        this.pluginSettings.remove("miniorange.saml.ERROR_MSG_TEMPLATE");
        this.pluginSettings.remove("miniorange.saml.INPUT_METADATA_URL");
        this.pluginSettings.remove("miniorange.saml.METADATA_OPTION");
        this.pluginSettings.remove("miniorange.saml.ENABLE_REGEX_PATTERN");
        this.pluginSettings.remove("miniorange.saml.REGEX_PATTERN");
        this.pluginSettings.remove("miniorange.saml.LOGIN_USER_ATTRIBUTE");
        this.pluginSettings.remove("miniorange.saml.ENABLE_LOGOUT_TEMPLATE");
        this.pluginSettings.remove("miniorange.saml.RESTRICT_USER_CREATION");
        this.pluginSettings.remove("miniorange.saml.DEFAULT_USER_DIRECTORY");
        this.pluginSettings.remove("miniorange.saml.ENABLE_ERRORMSG_TEMPLATE");
        this.pluginSettings.remove("miniorange.saml.ENABLE_SAML_SSO");
        this.pluginSettings.remove("miniorange.saml.ENABLE_DEFAULT_GROUPS_FOR");
        this.pluginSettings.remove("miniorange.saml.ON_THE_FLY_GROUP_MAPPING");
        this.pluginSettings.remove("miniorange.saml.ON_THE_FLY_ASSIGN_NEW_GROUPS_ONLY");
        this.pluginSettings.remove("miniorange.saml.ON_THE_FLY_DO_NOT_REMOVE_GROUPS");
        this.pluginSettings.remove("miniorange.saml.ON_THE_FLY_CREATE_NEW_GROUPS");
        this.pluginSettings.remove("miniorange.saml.ENABLE_AUTO_REDIRECT_DELAY");
        this.pluginSettings.remove("miniorange.saml.BACKDOOR_KEY");
        this.pluginSettings.remove("miniorange.saml.BACKDOOR_VALUE");
        this.pluginSettings.remove("miniorange.saml.RESTRICT_BACKDOOR");
        this.pluginSettings.remove("miniorange.saml.BACKDOOR_GROUPS");
        this.pluginSettings.remove("miniorange.saml.LOGIN_TEMPLATE");
        this.pluginSettings.remove("miniorange.saml.ENABLE_LOGIN_TEMPLATE");
        this.pluginSettings.remove("miniorange.saml.REMEMBERME_COOKIE");
        for (int i = 0; i < this.getIdPList().size(); ++i) {
            this.removeIdp(this.getIdPList().get(i));
        }
        this.pluginSettings.remove("miniorange.saml.DOMAINS");
        this.pluginSettings.remove("miniorange.saml.DOMAIN_MAPPING");
        this.pluginSettings.remove("miniorange.saml.USE_DOMAIN_MAPPING");
        this.pluginSettings.remove("miniorange.saml.IDP_LIST");
        this.pluginSettings.remove("miniorange.saml.IDP_MAP");
        this.pluginSettings.remove("miniorange.saml.ENABLE_PASSWORD_CHANGE");
        this.pluginSettings.remove("miniorange.saml.NUMBER_OF_LOGIN_ATTEMPTS");
        this.pluginSettings.remove("miniorange.saml.BAMBOO_REDIRECTION_RULES");
        this.pluginSettings.remove("miniorange.saml.RESTRICT_LOCAL_AUTHENTICATION");
        this.pluginSettings.remove("miniorange.saml.HIDE_REDIRECTION_FORM");
        this.pluginSettings.remove("miniorange.saml.SSO_ENABLED_FOR_IDP_LIST");
        this.pluginSettings.remove("miniorange.saml.DEFAULT_BAMBOO_IDP");
        this.pluginSettings.remove("miniorange.saml.HEADER_AUTHENTICATION_ATTRIBUTE");
        this.pluginSettings.remove("miniorange.saml.DEFAULT_REDIRECT_URL");
        this.pluginSettings.remove("miniorange.saml.ISSUER_MAP");
        this.pluginSettings.remove("miniorange.saml.ENABLE_HEADER_AUTHENTICATION");
        this.pluginSettings.remove("miniorange.saml.ENABLE_SSO_FOR_IDP");
        this.pluginSettings.remove("miniorange.saml.SHOW_INTRO_PAGE");
        this.pluginSettings.remove("miniorange.saml.PAGE_NUMBER");
        this.pluginSettings.remove("miniorange.saml.IS_MIGRATED");
        this.pluginSettings.remove("miniorange.saml.AUTO_ACTIVATE_USER");
        this.pluginSettings.remove("miniornage.saml.PLUGIN_API_ACCESS_RESTRICTION");
        this.pluginSettings.remove("miniorange.saml.SP_CONFIGURATION_STATUS");
        this.pluginSettings.remove("miniorange.saml.SHOW_LOGIN_BUTTON");
        this.pluginSettings.remove("miniorange.saml.NO_SSO_URLS");
        this.pluginSettings.remove("miniorange.saml.PUBLIC_SP_CERTIFICATE");
        this.pluginSettings.remove("miniorange.saml.PRIVATE_SP_CERTIFICATE");
        this.pluginSettings.remove("miniorange.saml.OLD_CONFIGURED_PRIVATE_SP_CERTIFICATE");
        this.pluginSettings.remove("miniorange.saml.OLD_CONFIGURED_PUBLIC_SP_CERTIFICATE");
        this.pluginSettings.remove("miniorange.saml.SP_CERTIFICATE_EXPIRE_ON");
        this.pluginSettings.remove("miniorange.saml.CERT_EXPIRED");
        this.pluginSettings.remove("miniorange.saml.ORGANIZATION_NAME");
        this.pluginSettings.remove("miniorange.saml.ORGANIZATION_DISPLAY_NAME");
        this.pluginSettings.remove("miniorange.saml.ORGANIZATION_URL");
        this.pluginSettings.remove("miniorange.saml.TECHNICAL_CONTACT_NAME");
        this.pluginSettings.remove("miniorange.saml.TECHNICAL_CONTACT_DISPLAY_NAME");
        this.pluginSettings.remove("miniorange.saml.SUPPORT_CONTACT_NAME");
        this.pluginSettings.remove("miniorange.saml.SUPPORT_CONTACT_EMAIL");
    }

    public void setAttributeMappingConfig(JSONObject attributeMappingConfig, String idpID) {
        this.pluginSettings.put("miniorange.saml.ATTRIBUTE_MAPPING_CONFIG" + idpID, (Object)attributeMappingConfig.toString());
    }

    public JSONObject getAttributeMappingConfig(String idpID) throws JSONException {
        String attributeMappingConfig = (String)this.pluginSettings.get("miniorange.saml.ATTRIBUTE_MAPPING_CONFIG" + idpID);
        if (StringUtils.isNotBlank((CharSequence)attributeMappingConfig)) {
            return new JSONObject(attributeMappingConfig);
        }
        return null;
    }

    public void setGroupMappingConfig(JSONObject groupMappingConfig, String idpID) {
        this.pluginSettings.put("miniorange.saml.GROUP_MAPPING_CONFIG" + idpID, (Object)groupMappingConfig.toString());
    }

    public JSONObject getGroupMappingConfig(String idpID) throws JSONException {
        String groupMappingConfig = (String)this.pluginSettings.get("miniorange.saml.GROUP_MAPPING_CONFIG" + idpID);
        if (StringUtils.isNotBlank((CharSequence)groupMappingConfig)) {
            return new JSONObject(groupMappingConfig);
        }
        return null;
    }

    public void clearOldConfiguration() {
        this.pluginSettings.remove("miniorange.saml.ALL_X509_CERTIFICATES");
        this.pluginSettings.remove("miniorange.saml.CREATE_USER_IF_ROLE_MAPPED");
        this.pluginSettings.remove("miniorange.saml.DEFAULT_GROUP");
        this.pluginSettings.remove("miniorange.saml.DEFAULT_GROUPs");
        this.pluginSettings.remove("miniorange.saml.EMAIL_ATTRIBUTE");
        this.pluginSettings.remove("miniorange.saml.ENCRYPTION");
        this.pluginSettings.remove("miniorange.saml.FIRST_NAME_ATTRIBUTE");
        this.pluginSettings.remove("miniorange.saml.FULL_NAME_ATTRIBUTE");
        this.pluginSettings.remove("miniorange.saml.IDP_ENTITY_ID");
        this.pluginSettings.remove("miniorange.saml.IDP_METADATA_URL");
        this.pluginSettings.remove("miniorange.saml.KEEP_EXISTING_ATTRIBUTE");
        this.pluginSettings.remove("miniorange.saml.KEEP_EXISTING_USER_ROLES");
        this.pluginSettings.remove("miniorange.saml.LAST_NAME_ATTRIBUTE");
        this.pluginSettings.remove("miniorange.saml.CUSTOM_REFRESH_INTERVAL");
        this.pluginSettings.remove("miniorange.saml.CUSTOM_REFRESH_INTERVAL_UNIT");
        this.pluginSettings.remove("miniorange.saml.METADATA_REFRESH_INTERVAL");
        this.pluginSettings.remove("miniorange.saml.REFRESH_METADATA");
        this.pluginSettings.remove("miniorange.saml.ROLE_ATTRIBUTE");
        this.pluginSettings.remove("miniorange.saml.ROLE_MAPPING");
        this.pluginSettings.remove("miniorange.saml.SIGNED_REQUEST");
        this.pluginSettings.remove("miniorange.saml.SIGNING");
        this.pluginSettings.remove("miniorange.saml.SLO_BINDING_TYPE");
        this.pluginSettings.remove("miniorange.saml.SLO_URL");
        this.pluginSettings.remove("miniorange.saml.SSO_BINDING_TYPE");
        this.pluginSettings.remove("miniorange.saml.SSO_URL");
        this.pluginSettings.remove("miniorange.saml.USE_SEPARATE_NAME_ATTRIBUTE");
        this.pluginSettings.remove("miniorange.saml.USERNAME_ATTRIBUTE");
        this.pluginSettings.remove("miniorange.saml.X509_CERTIFICATE");
        this.pluginSettings.remove("miniorange.saml.INPUT_METADATA_URL");
        this.pluginSettings.remove("miniorange.saml.METADATA_OPTION");
        this.pluginSettings.remove("miniorange.saml.ENABLE_REGEX_PATTERN");
        this.pluginSettings.remove("miniorange.saml.REGEX_PATTERN");
        this.pluginSettings.remove("miniorange.saml.LOGIN_USER_ATTRIBUTE");
        this.pluginSettings.remove("miniorange.saml.RESTRICT_USER_CREATION");
        this.pluginSettings.remove("miniorange.saml.DEFAULT_USER_DIRECTORY");
        this.pluginSettings.remove("miniorange.saml.ENABLE_SAML_SSO");
        this.pluginSettings.remove("miniorange.saml.ENABLE_DEFAULT_GROUPS_FOR");
        this.pluginSettings.remove("miniorange.saml.ON_THE_FLY_GROUP_MAPPING");
        this.pluginSettings.remove("miniorange.saml.ON_THE_FLY_ASSIGN_NEW_GROUPS_ONLY");
        this.pluginSettings.remove("miniorange.saml.ON_THE_FLY_DO_NOT_REMOVE_GROUPS");
        this.pluginSettings.remove("miniorange.saml.ON_THE_FLY_CREATE_NEW_GROUPS");
        this.pluginSettings.remove("miniorange.saml.DISABLE_PASSWORD_AUTO_COMPLETE");
    }

    public Integer getCurrentBuildNumber() {
        String buildNumber = BuildUtils.getCurrentBuildNumber();
        return Integer.parseInt(buildNumber);
    }

    public String getOrganizationName() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.ORGANIZATION_NAME")), (CharSequence)"miniorange");
    }

    public void setOrganizationName(String organizationName) {
        this.pluginSettings.put("miniorange.saml.ORGANIZATION_NAME", (Object)StringUtils.defaultIfBlank((CharSequence)organizationName, (CharSequence)"miniorange"));
    }

    public String getOrganizationDisplayName() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.ORGANIZATION_DISPLAY_NAME")), (CharSequence)"miniorange");
    }

    public void setOrganizationDisplayName(String organizationDisplayName) {
        this.pluginSettings.put("miniorange.saml.ORGANIZATION_DISPLAY_NAME", (Object)StringUtils.defaultIfBlank((CharSequence)organizationDisplayName, (CharSequence)"miniorange"));
    }

    public String getOrganizationUrl() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.ORGANIZATION_URL")), (CharSequence)"http://miniorange.com");
    }

    public void setOrganizationUrl(String organizationUrl) {
        this.pluginSettings.put("miniorange.saml.ORGANIZATION_URL", (Object)StringUtils.defaultIfBlank((CharSequence)organizationUrl, (CharSequence)"http://miniorange.com"));
    }

    public String getTechnicalContactName() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.TECHNICAL_CONTACT_NAME")), (CharSequence)"Xecurify");
    }

    public void setTechnicalContactName(String technicalContactName) {
        this.pluginSettings.put("miniorange.saml.TECHNICAL_CONTACT_NAME", (Object)StringUtils.defaultIfBlank((CharSequence)technicalContactName, (CharSequence)"Xecurify"));
    }

    public String getTechnicalContactEmail() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.TECHNICAL_CONTACT_DISPLAY_NAME")), (CharSequence)"info@xecurify.com");
    }

    public void setTechnicalContactEmail(String technicalContactEmail) {
        this.pluginSettings.put("miniorange.saml.TECHNICAL_CONTACT_DISPLAY_NAME", (Object)StringUtils.defaultIfBlank((CharSequence)technicalContactEmail, (CharSequence)"info@xecurify.com"));
    }

    public String getSupportContactName() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.SUPPORT_CONTACT_NAME")), (CharSequence)"Xecurify");
    }

    public void setSupportContactName(String supportContactName) {
        this.pluginSettings.put("miniorange.saml.SUPPORT_CONTACT_NAME", (Object)StringUtils.defaultIfBlank((CharSequence)supportContactName, (CharSequence)"Xecurify"));
    }

    public String getSupportContactEmail() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.SUPPORT_CONTACT_EMAIL")), (CharSequence)"info@xecurify.com");
    }

    public void setSupportContactEmail(String supportContactEmail) {
        this.pluginSettings.put("miniorange.saml.SUPPORT_CONTACT_EMAIL", (Object)StringUtils.defaultIfBlank((CharSequence)supportContactEmail, (CharSequence)"info@xecurify.com"));
    }

    public Boolean getPluginApiAccessRestriction() {
        return BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniornage.saml.PLUGIN_API_ACCESS_RESTRICTION")));
    }

    public void setPluginApiAccessRestriction(Boolean pluginApiAccessRestriction) {
        this.pluginSettings.put("miniornage.saml.PLUGIN_API_ACCESS_RESTRICTION", (Object)BooleanUtils.toString((Boolean)pluginApiAccessRestriction, (String)"true", (String)"false", (String)"false"));
    }

    public void setResetAssertionIDListInterval(String resetAssertionIDListInterval) {
        this.pluginSettings.put("miniorange.saml.ASSERTIONID_RESET_INTERVAL", (Object)StringUtils.trimToEmpty((String)resetAssertionIDListInterval));
    }

    public String getResetAssertionIDListInterval() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.ASSERTIONID_RESET_INTERVAL")), (CharSequence)"daily");
    }

    public Boolean getRestrictDuplicateAssertion() {
        return BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.RESTRICT_DUPLICATE_ASSERTION")));
    }

    public void setRestrictDuplicateAssertion(Boolean restrictDuplicateAssertion) {
        this.pluginSettings.put("miniorange.saml.RESTRICT_DUPLICATE_ASSERTION", (Object)BooleanUtils.toString((Boolean)restrictDuplicateAssertion, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getRestrictLocalAuthentication() {
        if (this.pluginSettings.get("miniorange.saml.RESTRICT_LOCAL_AUTHENTICATION") == null) {
            return Boolean.FALSE;
        }
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.RESTRICT_LOCAL_AUTHENTICATION"))), (boolean)Boolean.TRUE);
    }

    public void setRestrictLocalAuthentication(Boolean restrictLocalAuthentication) {
        this.pluginSettings.put("miniorange.saml.RESTRICT_LOCAL_AUTHENTICATION", (Object)BooleanUtils.toString((Boolean)restrictLocalAuthentication, (String)"true", (String)"false", (String)"false"));
    }

    public boolean getHideRedirectionForm() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.HIDE_REDIRECTION_FORM"))), (boolean)false);
    }

    public void setHideRedirectionForm(boolean hideRedirectionForm) {
        this.pluginSettings.put("miniorange.saml.HIDE_REDIRECTION_FORM", (Object)BooleanUtils.toString((boolean)hideRedirectionForm, (String)"true", (String)"false"));
    }

    public void setCustomResetInterval(Integer customResetIntervalInterval) {
        this.pluginSettings.put("miniorange.saml.CUSTOM_RESET_INTERVAL", (Object)String.valueOf(customResetIntervalInterval));
    }

    public Integer getCustomResetInterval() {
        String interval = (String)this.pluginSettings.get("miniorange.saml.CUSTOM_RESET_INTERVAL");
        if (NumberUtils.isDigits((String)interval)) {
            return NumberUtils.createInteger((String)interval);
        }
        return MoSAMLUtils.getAssertionIDResetInterval(this.getResetAssertionIDListInterval(), 24);
    }

    public Boolean isRelayStateDomainValid(String savedRelayState, String relayState) {
        try {
            URL savedRelayStateUrl;
            URL relayStateURL = new URL(relayState);
            URL baseURL = new URL(this.getBaseUrl());
            if (StringUtils.equalsIgnoreCase((CharSequence)relayStateURL.getHost(), (CharSequence)baseURL.getHost()) && relayState.contains(this.getBaseUrl())) {
                return true;
            }
            if (StringUtils.isNotBlank((CharSequence)savedRelayState) && StringUtils.equalsIgnoreCase((CharSequence)(savedRelayStateUrl = new URL(savedRelayState)).getHost(), (CharSequence)relayStateURL.getHost())) {
                return true;
            }
        }
        catch (MalformedURLException e) {
            LOGGER.debug((Object)("Error in relayState :" + e.getMessage()));
        }
        LOGGER.debug((Object)"Relay state domain is not valid.");
        return false;
    }

    public void setHeaderAuthenticationSettings(Boolean headerAuthentication) {
        this.pluginSettings.put("miniorange.saml.ENABLE_HEADER_AUTHENTICATION", (Object)BooleanUtils.toString((Boolean)headerAuthentication, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getHeaderAuthenticationSettings() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBooleanObject((String)((String)this.pluginSettings.get("miniorange.saml.ENABLE_HEADER_AUTHENTICATION"))), (boolean)false);
    }

    public String getHeaderAuthenticationAttribute() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.HEADER_AUTHENTICATION_ATTRIBUTE")), (CharSequence)"bamboo-user");
    }

    public void setHeaderAuthenticationAttribute(String headerAuthenticationAttribute) {
        this.pluginSettings.put("miniorange.saml.HEADER_AUTHENTICATION_ATTRIBUTE", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)headerAuthenticationAttribute, (CharSequence)"bamboo-user"))));
    }

    public String getHeaderAuthenticationRelayStateAttribute() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.HEADER_AUTHENTICATION_RELAY_STATE_ATTRIBUTE")), (CharSequence)"relay-state-url");
    }

    public void setHeaderAuthenticationRelayStateAttribute(String headerAuthenticationAttribute) {
        this.pluginSettings.put("miniorange.saml.HEADER_AUTHENTICATION_RELAY_STATE_ATTRIBUTE", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)headerAuthenticationAttribute, (CharSequence)"relay-state-url"))));
    }

    public String getNewPublicSPCertificate() {
        try {
            return IOUtils.toString((InputStream)MoSAMLSettings.class.getResourceAsStream(NEW_PUBLIC_CERT_PATH), (String)"UTF-8");
        }
        catch (IOException e) {
            LOGGER.error((Object)"An I/O error occurred while initializing the New Certificate .", (Throwable)e);
            return null;
        }
    }

    public String getNewPrivateSPCertificate() {
        try {
            return IOUtils.toString((InputStream)MoSAMLSettings.class.getResourceAsStream(NEW_PRIVATE_CERT_PATH), (String)"UTF-8");
        }
        catch (IOException e) {
            LOGGER.error((Object)"An I/O error occurred while initializing the New Certificate .", (Throwable)e);
            return null;
        }
    }

    public String getOldConfiguredPublicSPCertificate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.OLD_CONFIGURED_PUBLIC_SP_CERTIFICATE")), (CharSequence)PUBLIC_CERTIFICATE);
    }

    public void setOldConfiguredPublicSPCertificate(String publicSPCertificate) {
        this.pluginSettings.put("miniorange.saml.OLD_CONFIGURED_PUBLIC_SP_CERTIFICATE", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)publicSPCertificate, (CharSequence)PUBLIC_CERTIFICATE))));
    }

    public String getOldConfiguredPrivateSPCertificate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.OLD_CONFIGURED_PRIVATE_SP_CERTIFICATE")), (CharSequence)PRIVATE_CERTIFICATE);
    }

    public void setOldConfiguredPrivateSPCertificate(String publicSPCertificate) {
        this.pluginSettings.put("miniorange.saml.OLD_CONFIGURED_PRIVATE_SP_CERTIFICATE", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)publicSPCertificate, (CharSequence)PRIVATE_CERTIFICATE))));
    }

    public void setSPCertExpireOn(String validTo) {
        try {
            Date from = new Date();
            SimpleDateFormat myformat = new SimpleDateFormat("E MMM dd HH:mm:ss Z yyyy");
            from = myformat.parse(from.toString());
            Date to = myformat.parse(validTo);
            long difference = (to.getTime() - from.getTime()) / 86400000L;
            this.pluginSettings.put("miniorange.saml.SP_CERTIFICATE_EXPIRE_ON", (Object)String.valueOf(difference));
        }
        catch (Exception e) {
            LOGGER.error((Object)"An error occurred while setting certificate expiry date");
        }
    }

    public Long getSPCertExpireOn() {
        String expireOn = (String)this.pluginSettings.get("miniorange.saml.SP_CERTIFICATE_EXPIRE_ON");
        return NumberUtils.createLong((String)expireOn);
    }

    public void setHideDefaultLogin(Boolean hideDefaultLogin) {
        this.pluginSettings.put("miniorange.saml.HIDE_DEFAULT_LOGIN", (Object)BooleanUtils.toString((Boolean)hideDefaultLogin, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getHideDefaultLogin() {
        return BooleanUtils.toBoolean((String)StringUtils.defaultString((String)((String)this.pluginSettings.get("miniorange.saml.HIDE_DEFAULT_LOGIN")), (String)"false"));
    }

    public void setDisablePasswordAutoComplete(Boolean disablePasswordAutoComplete) {
        this.pluginSettings.put("miniorange.saml.DISABLE_PASSWORD_AUTO_COMPLETE", (Object)BooleanUtils.toString((Boolean)disablePasswordAutoComplete, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getDisablePasswordAutoComplete() {
        return BooleanUtils.toBoolean((String)StringUtils.defaultString((String)((String)this.pluginSettings.get("miniorange.saml.DISABLE_PASSWORD_AUTO_COMPLETE")), (String)"false"));
    }

    public List<String> getNoSSOUrls() {
        List noSsoUrls = (List)this.pluginSettings.get("miniorange.saml.NO_SSO_URLS");
        if (noSsoUrls == null) {
            return new ArrayList<String>();
        }
        return noSsoUrls;
    }

    public void setNoSSOUrls(List<String> noSsoUrls) {
        this.pluginSettings.put("miniorange.saml.NO_SSO_URLS", noSsoUrls);
    }

    static {
        try {
            PUBLIC_CERTIFICATE = IOUtils.toString((InputStream)MoSAMLSettings.class.getResourceAsStream(PUBLIC_CERT_PATH), (String)"UTF-8");
            PUBLIC_CERTIFICATE = MoSAMLUtils.serializePublicCertificate(PUBLIC_CERTIFICATE);
            PRIVATE_CERTIFICATE = IOUtils.toString((InputStream)MoSAMLSettings.class.getResourceAsStream(PRIVATE_CERT_PATH), (String)"UTF-8");
            PRIVATE_CERTIFICATE = MoSAMLUtils.serializePrivateCertificate(PRIVATE_CERTIFICATE);
            LOGOUT_TEMPLATE = IOUtils.toString((InputStream)MoSAMLSettings.class.getResourceAsStream(LOGOUT_TEMPLATE_PATH), (String)"UTF-8");
            LOGIN_TEMPLATE = IOUtils.toString((InputStream)MoSAMLSettings.class.getResourceAsStream(LOGIN_TEMPLATE_PATH), (String)"UTF-8");
            ERRORMSG_TEMPLATE = IOUtils.toString((InputStream)MoSAMLSettings.class.getResourceAsStream(ERRORMSG_TEMPLATE_PATH), (String)"UTF-8");
        }
        catch (IOException e) {
            LOGGER.error((Object)"An I/O error occurred while initializing the SAML Settings.", (Throwable)e);
        }
    }
}

