<html>
<head>
    <title>Redirection Rules</title>
    <meta name="decorator" content="atl.general">
    <script>
            <#include "/js/redirectrules.js">
    </script>
    <style>
            <#include "/css/addidp.css">
            <#include "/css/redirectrules.css">
    </style>
</head>
<body>
    <#include "*/saml/headers/samlheader.ftl" parse=true>
<div class="tabs-pane active-pane" id="redirection-rules" role="tabpanel">
    <h1>Redirection Rules</h1>
    <hr class="header"/>
    ${webResourceManager.requireResource('com.atlassian.auiplugin:aui-form-validation')}

    <p>Redirection Rules let you define how users are redirected to an IDP based on email domain, directory, or group.</p>

    <div id="expander-with-replace-text-content" class="aui-expander-content" aria-expanded="true">
        <p><b>Here's how you can do that:</b></p>
        <ol>
             <li>Click "<b> Add Rule</b>".
             </li>
             <li>Select the deciding parameter (directory, group, or domain) in the dropdown after <b>If</b>.
             </li>
             <li>Enter the value for the parameter in the field after <b>equals</b> (e.g., <i>bamboo-users</i> for group).
             </li>
             <li>Choose the IDP or Bamboo's login page in the field after <b>Redirect To</b>.
             </li>
             <li>Rules are applied top-to-bottom; use the arrows to change the order.
             </li>
            </ol>
    </div>
   <p>
    <a id="replace-text-trigger" data-replace-text="Show More ..." class="aui-expander-trigger" aria-controls="expander-with-replace-text-content">Show less</a>
   </p>
    <div class="aui-message aui-message-info">
     <p>Enhance Bamboo security with miniOrange <b><a href="https://marketplace.atlassian.com/apps/1222869" target="_blank">Two factor Authentication(2FA)</a></b> module.
            For Single Sign-On (SSO) logins, our 2FA app bypasses the second factor. Schedule a <b>FREE</b> demo <a href="https://miniorange.atlassian.net/servicedesk/customer/portal/2/group/6/create/66" target="_blank">here</a>. </p>
    </div><br>
    <div id="bamboo-rules">
        <div>
            <h2 style="float: left;">Bamboo Rules&emsp;</h2>
            <button id="add-bamboo-rule" class="aui-button aui-button-primary add-rule">
                <span class="aui-icon aui-icon-small aui-iconfont-add-circle"></span> Add Rule
            </button>&emsp;
            <aui-spinner id="bamboo-order-spinner" class="order-spinner" size="small"></aui-spinner>
            <span id="bamboo-saved-message" class="saved-message"><span
                    class="aui-icon aui-icon-small aui-iconfont-successful-build"></span>&nbsp;All Changes Saved</span>
        </div>
        <hr class="header subsection"/>



        <form id="save-bamboo-order-form" name="save-bamboo-order-form" class="aui" action="" method="POST">

            <input type="hidden" name="action" value="saveOrder"/>
            <table class="aui aui-table-list">
                <thead>
                <tr>
                    <th colspan="2" width="70%">Rules</th>
                    <th width="20%">Order</th>
                    <th width="10%">
                        Actions
                    </th>
                </tr>
                </thead>
                <tbody>

                    <#assign counter = 0>
                    <#assign sizeOfMap = bambooRedirectionRulesMap.size()>
                    <#foreach key in bambooRedirectionRulesMap.keySet()>
                    <tr id="row-${key}">
                        <td colspan="2">
                            <input type="hidden" id="bamboo-rule-${key}" name="ruleKey" value="${key}"/>
                            <b>${key}: </b>
                             <#-- Adding WithHtml to the variable makes sure that the HTML string is not escaped. Weird flex but Ok-->
                            <#assign expressionWithHtml = bambooRedirectionRulesMap.get(key)>
                            ${expressionWithHtml}

                        </td>
                        <td>
                            <#if sizeOfMap gt 1>

                                <a class="bamboo-move-up" style="cursor:pointer"><span
                                        class="aui-icon aui-icon-small aui-iconfont-chevron-double-up">

                                        move up</span></a>
                                &nbsp;
                                <a class="bamboo-move-down" style="cursor:pointer"><span
                                        class="aui-icon aui-icon-small aui-iconfont-chevron-double-down">

                                        move down</span></a>

                            </#if>
                        </td>
                        <td>
                            <a class="edit-rule" data-rule-id="${key}" class="aui-button aui-button-subtle"><span
                                    class="aui-icon aui-icon-small aui-iconfont-edit-filled">edit</span></a>
                            <a class="delete-bamboo-rule" data-rule-id="${key}"
                               class="aui-button aui-button-subtle"><span
                                    class="aui-icon aui-icon-small aui-iconfont-trash"></span></a>
                        </td>
                    </tr>

                        <#assign counter = counter +1>
                    </#foreach>
                </tbody>
            </table>
            <table class="aui">
                <tbody>
                <tr id="row-bamboo-default">
                    <td>
                        <span><b>Default Rule: </b>Redirect the users to</span>&emsp;
                        <aui-select id="defaultBambooIDP" name="defaultBambooIDP"
                                    placeholder="Select Default IDP"
                                    class="default-idp-select">
                            <#foreach idpId in ssoEnabledIdpList>
                                <aui-option id="${idpId}" value="${idpId}"
                                    <#if defaultBambooIDP.equals(idpId)> selected </#if>
                                >${idpMap.get(idpId)}</aui-option>
                            </#foreach>
                            <aui-option id="loginPage" value="loginPage"
                                <#if defaultBambooIDP.equals("loginPage")> selected </#if>
                            >Login Page</aui-option>
                            <aui-option value="redirectUrl"
                                <#if defaultBambooIDP.equals("redirectUrl")> selected </#if>
                            >Redirect to a URL</aui-option>
                        </aui-select>
                    </td>
                </tr>
                <tr id="defaultBambooIDP-redirect-url" style="display: none;">
                    <td>
                        <span><b>URL to redirect Users to :</b></span>
                        <input type="text" value="${defaultRedirectUrl}" id="defaultRedirectUrl" name="defaultRedirectUrl" class="text long-field default-redirect-url">
                        <div id="save-redirect-url-rule" style="display: none; vertical-align: middle;">
                            <a id="save-redirect-url-button"
                               class="aui-button aui-button-subtle aui-icon aui-icon-small aui-iconfont-success"
                               title="save"></a>
                            <a
                                id="cancel-redirect-url-button"
                                class="aui-button aui-button-subtle aui-icon aui-icon-small aui-iconfont-close-dialog"
                                title="cancel"></a>
                        </div>
                    </td>
                </tr>
                </tbody>
            </table>
        </form>
    </div>
    <form id="redirection--form" class="aui long-label" action="" method="POST">
        <div id="advanced settings">
            <div>
                <h2 style="float: left;">Advanced Settings</h2>
            </div>
            <hr class="header subsection" style="width:100%">
            <br>
            <div class="field-group">
                <label for="restrictLocalAuthentication"><strong>Restrict Bamboo Credentials:</strong></label>
                <aui-toggle
                    id="restrictLocalAuthentication"
                    name="restrictLocalAuthentication"
                    label="Restrict Local Authentication for Bamboo"
                    <#if (restrictLocalAuthentication)>checked</#if>
                ></aui-toggle>
                <span style="vertical-align:middle;">
                    <div class="description">
                        When redirection rules indicate that SSO should be used for login, users cannot log in with their Bamboo credentials. Users can only log in using backdoor URLs with their Bamboo credentials.
                    </div>
                </span>
            </div>
            <br>
            <div class="field-group">
                <label for="hideRedirectionForm"><strong>Hide Redirection Form:</strong></label>
                <aui-toggle id="hideRedirectionForm" name="hideRedirectionForm" label="Hide Redirection Form"
                                <#if hideRedirectionForm==true> checked="true" </#if>  value="true"></aui-toggle>
                <span style="vertical-align:middle;">
                    <div class="description">
                        The Redirection form will be hidden when redirection rules are in place, and the Bamboo default login form will be displayed instead.
                    </div>
                </span>
            </div>
        </div>
    </form>
</div>
    <#include "*/saml/createRuleDialogue.ftl" parse=true>
    <#include "*/footer.ftl" parse=true>
</body>
</html>