<style>
    <#include "*/css/documentation.css" parse=true>
</style>
<script type="text/javascript">
    AJS.toInit(function () {
        const documentationData = JSON.parse('${documentationJsonData?js_string}');
        console.log("Parsed documentation data:", documentationData);

        const container = document.getElementById("documentation-grid");

        if (!documentationData || documentationData.length === 0) {
            container.innerHTML = "<p style='color: var(--text-secondary);'>No documentations available.</p>";
            return;
        }

        documentationData.forEach(function(documentation) {
            const card = document.createElement("div");
            card.className = "card";

            card.innerHTML = `
                <div class="card-header">
                    <div class="card-category">SAML</div>
                </div>
                <h3 style="font-size: 16px; color: var(--text-primary); margin: 0 0 12px 0;">` + documentation.title + `</h3>
                <p style="font-size: 14px; color: var(--text-secondary); margin: 0 0 16px 0;">` + documentation.description + `</p>
                <div class="card-footer" style="display: flex;justify-content: flex-end;align-items: center; gap: 8px; font-size: 14px;">
                    <a href="` + documentation.link + `" target="_blank" class="view-btn">
                        Read More
                        <svg viewBox="0 0 24 24">
                            <path d="M8.59 16.59L13.17 12 8.59 7.41 10 6l6 6-6 6-1.41-1.41z"/>
                        </svg>
                    </a>
                </div>
            `;
            container.appendChild(card);
        });
    });
</script>


<div style="margin-top: 30px;">
    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 24px; gap: 12px;">
        <div style="display: flex; align-items: center; gap: 8px;">
            <svg width="16" height="22" viewBox="0 0 16 22" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M3.86857 11.427H12.1314V10.2842H3.86857V11.427ZM3.86857 14.5916H12.1314V13.4487H3.86857V14.5916ZM3.86857 17.7573H8.70286V16.6145H3.86857V17.7573ZM1.84571 21.3607C1.32 21.3607 0.881143 21.1847 0.529143 20.8327C0.177143 20.4807 0.000761905 20.0415 0 19.515V2.63502C0 2.10931 0.176381 1.67045 0.529143 1.31845C0.881905 0.96645 1.32114 0.790069 1.84686 0.789307H10.8571L16 5.93216V19.515C16 20.0407 15.824 20.48 15.472 20.8327C15.12 21.1855 14.6804 21.3615 14.1531 21.3607H1.84571ZM10.2857 6.50359V1.93216H1.84686C1.67086 1.93216 1.50933 2.00531 1.36229 2.15159C1.21524 2.29788 1.1421 2.45902 1.14286 2.63502V19.515C1.14286 19.6903 1.216 19.8514 1.36229 19.9985C1.50857 20.1455 1.66971 20.2186 1.84571 20.2179H14.1543C14.3295 20.2179 14.4907 20.1447 14.6377 19.9985C14.7848 19.8522 14.8579 19.6906 14.8571 19.5139V6.50359H10.2857Z"
                      fill="#0052CC"/>
            </svg>
            <h2 style="font-size: 20px; color: var(--text-primary); margin: 0;">Use Case Documents</h2>
        </div>
    </div>

    <div id="documentation-grid" style="display: grid; grid-template-columns: repeat(3, 1fr); gap: 24px;"> </div>
</div>
