/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.bamboo.action;

import com.atlassian.bamboo.security.xsrf.XsrfTokenUtils;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.plugin.PluginException;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.user.Group;
import com.atlassian.user.search.page.Pager;
import com.miniorange.sso.saml.bamboo.MoPluginHandler;
import com.miniorange.sso.saml.bamboo.MoSAMLSettings;
import com.miniorange.sso.saml.utils.MoSAMLUtils;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.interceptor.parameter.StrutsParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoSignInSettingsAction
extends BambooActionSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoSignInSettingsAction.class);
    private UserManager userManager;
    private LoginUriProvider loginUriProvider;
    private MoSAMLSettings settings;
    private BambooUserManager bambooUserManager;
    private Boolean enableBackdoor;
    private String loginButtonText;
    private Boolean disableDefaultLogin;
    private String relayState;
    private String relayStateRedirectionType;
    private String xsrfToken;
    private Boolean signinSettingsSubmitted;
    private Boolean enablelogoutTemplate;
    private String customLogoutURL;
    private String timeDelay;
    private String logoutTemplate;
    private Boolean enableErrorMsgTemplate;
    private String errorMsgTemplate;
    private Boolean enableSAMLSSO;
    private Boolean enableAutoRedirectDelay;
    private String numberOfLoginAttempts;
    private Boolean backdoorSubmitted;
    private String backdoorKey;
    private String backdoorValue;
    private Boolean restrictBackdoor;
    private String[] backdoorGroups;
    private List<String> backdoorGroupsList;
    private Boolean enableLoginTemplate;
    private String loginTemplate;
    private ArrayList existingGroups;
    private String lowerBuild;
    private Boolean enableRememberMeCookie;
    private Boolean enablePasswordChange;
    private Boolean headerAuthentication;
    private String headerAuthenticationAttribute;
    private Boolean pluginApiAccessRestriction;
    private Boolean enableAutoRedirect;

    public MoSignInSettingsAction(UserManager userManager, LoginUriProvider loginUriProvider, MoSAMLSettings settings, BambooUserManager bambooUserManager) {
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.settings = settings;
        this.bambooUserManager = bambooUserManager;
    }

    public void validate() {
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        if (!BooleanUtils.toBoolean((Boolean)this.signinSettingsSubmitted)) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)this.relayState)) {
            try {
                new URL(this.relayState);
            }
            catch (MalformedURLException e) {
                this.addActionError("Invalid Relay State URL");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.customLogoutURL)) {
            try {
                new URL(this.customLogoutURL);
            }
            catch (MalformedURLException e) {
                this.addActionError("Invalid Custom Logout URL.");
            }
        }
        if (super.hasActionErrors()) {
            this.xsrfToken = XsrfTokenUtils.getXsrfToken((HttpServletRequest)request);
            this.initializeSAMLConfig();
        }
    }

    private Boolean hasError(String backdoorKey, String backdoorValue) {
        if (StringUtils.isBlank((CharSequence)backdoorKey.trim())) {
            this.addActionError("Backdoor query parameter key is invalid. Please make sure it's not empty and doesn't contain spaces.");
            return true;
        }
        if (StringUtils.isBlank((CharSequence)backdoorValue.trim())) {
            this.addActionError("Backdoor query parameter value is invalid. Please make sure it's not empty and doesn't contain spaces.");
            return true;
        }
        if (StringUtils.isBlank((CharSequence)this.backdoorKey) || this.backdoorKey.split("\\s+").length > 1) {
            this.addActionError(this.getText("samlsso.error.config.backdoorkey.invalid"));
            return true;
        }
        if (StringUtils.isBlank((CharSequence)this.backdoorValue) || this.backdoorValue.split("\\s+").length > 1) {
            this.addActionError(this.getText("samlsso.error.config.backdoorvalue.invalid"));
            return true;
        }
        return false;
    }

    public String execute() throws Exception {
        LOGGER.debug("Sign in Settings Action execute called");
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        this.xsrfToken = XsrfTokenUtils.getXsrfToken((HttpServletRequest)request);
        UserProfile user = this.userManager.getRemoteUser();
        if (user != null && this.userManager.isAdmin(user.getUserKey())) {
            try {
                LOGGER.debug("Sign in Settings Action doExecute Submitted: " + this.signinSettingsSubmitted);
                if (!this.settings.isValidLicense().booleanValue()) {
                    return "upm";
                }
                this.lowerBuild = "false";
                this.lowerBuild = this.getLowerBuild();
                LOGGER.debug("signinSettingsSubmitted: " + this.signinSettingsSubmitted);
                LOGGER.debug("backdoorSubmitted: " + this.backdoorSubmitted);
                this.backdoorGroupsList = new ArrayList<String>();
                if (BooleanUtils.toBoolean((Boolean)this.signinSettingsSubmitted)) {
                    if (StringUtils.equalsIgnoreCase((CharSequence)"true", (CharSequence)this.lowerBuild)) {
                        if (this.backdoorGroups != null) {
                            LOGGER.debug("Backdoor groups-" + this.backdoorGroups.length);
                            this.backdoorGroupsList = new ArrayList<String>(Arrays.asList(this.backdoorGroups));
                        }
                    } else {
                        this.backdoorGroupsList = this.settings.convertArrayToList(StringUtils.split((String)this.backdoorGroups[0], (String)","));
                    }
                    MoPluginHandler.saveSigninSettings(this.disableDefaultLogin, this.enableBackdoor, this.loginButtonText, this.relayState, this.relayStateRedirectionType, this.customLogoutURL, this.enablelogoutTemplate, this.timeDelay, this.logoutTemplate, this.enableErrorMsgTemplate, this.errorMsgTemplate, this.enableSAMLSSO, this.enableAutoRedirectDelay, this.numberOfLoginAttempts, this.restrictBackdoor, this.backdoorGroupsList, this.enableLoginTemplate, this.loginTemplate, this.enableRememberMeCookie, this.enablePasswordChange, this.headerAuthentication, this.headerAuthenticationAttribute, this.pluginApiAccessRestriction, this.enableAutoRedirect);
                    this.addActionMessage(this.getText("samlsso.success.config"));
                }
                if (BooleanUtils.toBoolean((Boolean)this.backdoorSubmitted)) {
                    LOGGER.debug("backdoorKey: " + this.backdoorKey);
                    LOGGER.debug("backdoorValue: " + this.backdoorValue);
                    this.backdoorKey = MoSAMLUtils.sanitizeText(this.backdoorKey);
                    this.backdoorValue = MoSAMLUtils.sanitizeText(this.backdoorValue);
                    Boolean error = this.hasError(this.backdoorKey, this.backdoorValue);
                    if (!error.booleanValue()) {
                        MoPluginHandler.saveBackdoorValues(this.backdoorKey, this.backdoorValue);
                        this.addActionMessage(this.getText("samlsso.backdoor.success.config"));
                    }
                }
                this.initializeSAMLConfig();
                return "success";
            }
            catch (PluginException e) {
                e.printStackTrace();
                this.addActionError(e.getMessage());
                return "input";
            }
            catch (Exception e) {
                e.printStackTrace();
                this.addActionError("An error occurred while saving your details. Please check logs for more info.");
                return "input";
            }
        }
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
        return null;
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    private void initializeSAMLConfig() {
        this.disableDefaultLogin = this.settings.getDefaultLoginDisabled();
        this.enableBackdoor = this.settings.getBackdoorEnabled();
        this.relayState = this.settings.getRelayState();
        this.relayStateRedirectionType = this.settings.getRelayStateRedirectionType();
        this.loginButtonText = this.settings.getLoginButtonText();
        this.enablelogoutTemplate = this.settings.getEnableLogoutTemplate();
        this.customLogoutURL = this.settings.getCustomLogoutURL();
        this.timeDelay = this.settings.getTimeDelay();
        this.logoutTemplate = this.settings.getLogoutTemplate();
        this.enableErrorMsgTemplate = this.settings.getEnableErrorMsgTemplate();
        this.errorMsgTemplate = this.settings.getErrorMsgTemplate();
        this.enableSAMLSSO = this.settings.getEnableSAMLSSO();
        this.enableAutoRedirectDelay = this.settings.getEnableAutoRedirectDelay();
        this.numberOfLoginAttempts = this.settings.getNumberOfLoginAttempts();
        this.backdoorKey = this.settings.getBackdoorKey();
        this.backdoorValue = this.settings.getBackdoorValue();
        this.restrictBackdoor = this.settings.getRestrictBackdoor();
        this.backdoorGroupsList = this.settings.getBackdoorGroups();
        this.enableLoginTemplate = this.settings.getEnableLoginTemplate();
        this.loginTemplate = this.settings.getLoginTemplate();
        this.enablePasswordChange = this.settings.getEnablePasswordChange();
        ArrayList existingGroup = this.getExistingGroups();
        this.enableRememberMeCookie = this.settings.getRememberMeCookieEnabled();
        this.lowerBuild = this.getLowerBuild();
        this.headerAuthentication = this.settings.getHeaderAuthenticationSettings();
        this.headerAuthenticationAttribute = this.settings.getHeaderAuthenticationAttribute();
        this.pluginApiAccessRestriction = this.settings.getPluginApiAccessRestriction();
        this.enableAutoRedirect = this.settings.getEnableAutoRedirect();
    }

    @StrutsParameter
    public UserManager getUserManager() {
        return this.userManager;
    }

    @StrutsParameter
    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    @StrutsParameter
    public LoginUriProvider getLoginUriProvider() {
        return this.loginUriProvider;
    }

    @StrutsParameter
    public void setLoginUriProvider(LoginUriProvider loginUriProvider) {
        this.loginUriProvider = loginUriProvider;
    }

    @StrutsParameter
    public MoSAMLSettings getSettings() {
        return this.settings;
    }

    @StrutsParameter
    public void setSettings(MoSAMLSettings settings) {
        this.settings = settings;
    }

    @StrutsParameter
    public Boolean getEnableBackdoor() {
        return this.enableBackdoor;
    }

    @StrutsParameter
    public void setEnableBackdoor(Boolean enableBackdoor) {
        this.enableBackdoor = enableBackdoor;
    }

    @StrutsParameter
    public String getLoginButtonText() {
        return this.loginButtonText;
    }

    @StrutsParameter
    public void setLoginButtonText(String loginButtonText) {
        this.loginButtonText = loginButtonText;
    }

    @StrutsParameter
    public Boolean getDisableDefaultLogin() {
        return this.disableDefaultLogin;
    }

    @StrutsParameter
    public void setDisableDefaultLogin(Boolean disableDefaultLogin) {
        this.disableDefaultLogin = disableDefaultLogin;
    }

    @StrutsParameter
    public String getRelayState() {
        return this.relayState;
    }

    @StrutsParameter
    public void setRelayState(String relayState) {
        this.relayState = relayState;
    }

    @StrutsParameter
    public String getRelayStateRedirectionType() {
        return this.relayStateRedirectionType;
    }

    @StrutsParameter
    public void setRelayStateRedirectionType(String relayStateRedirectionType) {
        this.relayStateRedirectionType = relayStateRedirectionType;
    }

    @StrutsParameter
    public String getXsrfToken() {
        return this.xsrfToken;
    }

    @StrutsParameter
    public void setXsrfToken(String xsrfToken) {
        this.xsrfToken = xsrfToken;
    }

    @StrutsParameter
    public Boolean getSigninSettingsSubmitted() {
        return this.signinSettingsSubmitted;
    }

    @StrutsParameter
    public void setSigninSettingsSubmitted(Boolean signinSettingsSubmitted) {
        this.signinSettingsSubmitted = signinSettingsSubmitted;
    }

    @StrutsParameter
    public Boolean getEnablelogoutTemplate() {
        return this.enablelogoutTemplate;
    }

    @StrutsParameter
    public void setEnablelogoutTemplate(Boolean enablelogoutTemplate) {
        this.enablelogoutTemplate = enablelogoutTemplate;
    }

    @StrutsParameter
    public String getCustomLogoutURL() {
        return this.customLogoutURL;
    }

    @StrutsParameter
    public Boolean getEnablePasswordChange() {
        return this.enablePasswordChange;
    }

    @StrutsParameter
    public void setEnablePasswordChange(Boolean enablePasswordChange) {
        this.enablePasswordChange = enablePasswordChange;
    }

    @StrutsParameter
    public void setCustomLogoutURL(String customLogoutURL) {
        this.customLogoutURL = customLogoutURL;
    }

    @StrutsParameter
    public String getTimeDelay() {
        return this.timeDelay;
    }

    @StrutsParameter
    public void setTimeDelay(String timeDelay) {
        this.timeDelay = timeDelay;
    }

    @StrutsParameter
    public String getLogoutTemplate() {
        return this.logoutTemplate;
    }

    @StrutsParameter
    public void setLogoutTemplate(String logoutTemplate) {
        this.logoutTemplate = logoutTemplate;
    }

    @StrutsParameter
    public Boolean getEnableErrorMsgTemplate() {
        return this.enableErrorMsgTemplate;
    }

    @StrutsParameter
    public void setEnableErrorMsgTemplate(Boolean enableErrorMsgTemplate) {
        this.enableErrorMsgTemplate = enableErrorMsgTemplate;
    }

    @StrutsParameter
    public String getErrorMsgTemplate() {
        return this.errorMsgTemplate;
    }

    @StrutsParameter
    public void setErrorMsgTemplate(String errorMsgTemplate) {
        this.errorMsgTemplate = errorMsgTemplate;
    }

    @StrutsParameter
    public Boolean getEnableSAMLSSO() {
        return this.enableSAMLSSO;
    }

    @StrutsParameter
    public void setEnableSAMLSSO(Boolean enableSAMLSSO) {
        this.enableSAMLSSO = enableSAMLSSO;
    }

    @StrutsParameter
    public Boolean getEnableAutoRedirectDelay() {
        return this.enableAutoRedirectDelay;
    }

    @StrutsParameter
    public void setEnableAutoRedirectDelay(Boolean enableAutoRedirectDelay) {
        this.enableAutoRedirectDelay = enableAutoRedirectDelay;
    }

    @StrutsParameter
    public String getNumberOfLoginAttempts() {
        return this.numberOfLoginAttempts;
    }

    @StrutsParameter
    public void setNumberOfLoginAttempts(String numberOfLoginAttempts) {
        this.numberOfLoginAttempts = numberOfLoginAttempts;
    }

    @StrutsParameter
    public String getBackdoorKey() {
        return this.backdoorKey;
    }

    @StrutsParameter
    public void setBackdoorKey(String backdoorKey) {
        this.backdoorKey = backdoorKey;
    }

    @StrutsParameter
    public String getBackdoorValue() {
        return this.backdoorValue;
    }

    @StrutsParameter
    public void setBackdoorValue(String backdoorValue) {
        this.backdoorValue = backdoorValue;
    }

    @StrutsParameter
    public Boolean getBackdoorSubmitted() {
        return this.backdoorSubmitted;
    }

    @StrutsParameter
    public void setBackdoorSubmitted(Boolean backdoorSubmitted) {
        this.backdoorSubmitted = backdoorSubmitted;
    }

    @StrutsParameter
    public Boolean getRestrictBackdoor() {
        return this.restrictBackdoor;
    }

    @StrutsParameter
    public void setRestrictBackdoor(Boolean restrictBackdoor) {
        this.restrictBackdoor = restrictBackdoor;
    }

    @StrutsParameter
    public String[] getBackdoorGroups() {
        return this.backdoorGroups;
    }

    @StrutsParameter
    public void setBackdoorGroups(String[] backdoorGroups) {
        this.backdoorGroups = backdoorGroups;
    }

    @StrutsParameter
    public List<String> getBackdoorGroupsList() {
        return this.backdoorGroupsList;
    }

    @StrutsParameter
    public void setBackdoorGroupsList(List<String> backdoorGroupsList) {
        this.backdoorGroupsList = backdoorGroupsList;
    }

    @StrutsParameter
    public Boolean getEnableLoginTemplate() {
        return this.enableLoginTemplate;
    }

    @StrutsParameter
    public void setEnableLoginTemplate(Boolean enableLoginTemplate) {
        this.enableLoginTemplate = enableLoginTemplate;
    }

    @StrutsParameter
    public String getLoginTemplate() {
        return this.loginTemplate;
    }

    @StrutsParameter
    public void setLoginTemplate(String loginTemplate) {
        this.loginTemplate = loginTemplate;
    }

    @StrutsParameter
    public Boolean getPluginApiAccessRestriction() {
        return this.pluginApiAccessRestriction;
    }

    @StrutsParameter
    public void setPluginApiAccessRestriction(Boolean pluginApiAccessRestriction) {
        this.pluginApiAccessRestriction = pluginApiAccessRestriction;
    }

    @StrutsParameter
    public Boolean getEnableAutoRedirect() {
        return this.enableAutoRedirect;
    }

    @StrutsParameter
    public void setEnableAutoRedirect(Boolean enableAutoRedirect) {
        this.enableAutoRedirect = enableAutoRedirect;
    }

    @StrutsParameter
    public ArrayList getExistingGroups() {
        try {
            Pager groupObjects = this.bambooUserManager.getGroups();
            this.existingGroups = new ArrayList();
            for (Group group : groupObjects) {
                if (this.existingGroups.contains(group.getName().trim())) continue;
                this.existingGroups.add(group.getName().trim());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.existingGroups;
    }

    @StrutsParameter
    public void setExistingGroups(ArrayList existingGroups) {
        this.existingGroups = existingGroups;
    }

    @StrutsParameter
    public String getLowerBuild() {
        if (this.settings.getCurrentBuildNumber() < 60604) {
            LOGGER.debug("Current Bamboo version is lesser than 6.6.0");
            this.lowerBuild = "true";
        } else {
            this.lowerBuild = "false";
            LOGGER.debug("Current Bamboo version is greater than or equal to 6.6.0");
        }
        return this.lowerBuild;
    }

    @StrutsParameter
    public void setLowerBuild(String lowerBuild) {
        this.lowerBuild = lowerBuild;
    }

    @StrutsParameter
    public Boolean getEnableRememberMeCookie() {
        return this.enableRememberMeCookie;
    }

    @StrutsParameter
    public void setEnableRememberMeCookie(Boolean enableRememberMeCookie) {
        this.enableRememberMeCookie = enableRememberMeCookie;
    }

    @StrutsParameter
    public Boolean getHeaderAuthentication() {
        return this.headerAuthentication;
    }

    @StrutsParameter
    public void setHeaderAuthentication(Boolean headerAuthentication) {
        this.headerAuthentication = headerAuthentication;
    }

    @StrutsParameter
    public String getHeaderAuthenticationAttribute() {
        return this.headerAuthenticationAttribute;
    }

    @StrutsParameter
    public void setHeaderAuthenticationAttribute(String headerAuthenticationAttribute) {
        this.headerAuthenticationAttribute = headerAuthenticationAttribute;
    }

    @StrutsParameter
    public Collection<String> getSuccessMessages() {
        Collection successMessages = this.getActionMessages();
        ArrayList<String> encodedSuccessMessages = new ArrayList<String>();
        for (String message : successMessages) {
            encodedSuccessMessages.add(MoSAMLUtils.htmlEncode(message));
        }
        return encodedSuccessMessages;
    }

    @StrutsParameter
    public Collection<String> getErrorMessages() {
        Collection errorMessages = this.getActionErrors();
        ArrayList<String> encodedErrorMessages = new ArrayList<String>();
        for (String message : errorMessages) {
            encodedErrorMessages.add(MoSAMLUtils.htmlEncode(message));
        }
        return encodedErrorMessages;
    }
}

