/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.bamboo.action;

import com.atlassian.bamboo.security.xsrf.XsrfTokenUtils;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.miniorange.sso.saml.MoPluginException;
import com.miniorange.sso.saml.bamboo.MoPluginHandler;
import com.miniorange.sso.saml.bamboo.MoSAMLSettings;
import com.miniorange.sso.saml.utils.MoSAMLUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.interceptor.parameter.StrutsParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoHeaderBasedAuthAction
extends BambooActionSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoHeaderBasedAuthAction.class);
    private MoSAMLSettings settings;
    private MoPluginHandler pluginHandler;
    private UserManager userManager;
    private LoginUriProvider loginUriProvider;
    private Boolean headerbasedauthSubmitted;
    private Boolean enableHeaderAuthentication;
    private String headerAuthenticationAttribute;
    private I18nResolver i18nResolver;
    private String xsrfToken;

    public MoHeaderBasedAuthAction(MoSAMLSettings settings, MoPluginHandler pluginHandler, UserManager userManager, LoginUriProvider loginUriProvider) {
        this.settings = settings;
        this.pluginHandler = pluginHandler;
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
    }

    public void validate() {
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        LOGGER.info("MoPostLogoutRulesAction  doValidate called");
        boolean error = false;
        if (this.enableHeaderAuthentication != null && StringUtils.isBlank((CharSequence)this.headerAuthenticationAttribute)) {
            this.addActionError(this.getText("samlsso.error.config.headerAuthenticationAttribute.empty"));
            error = true;
        }
        if (!BooleanUtils.toBoolean((Boolean)this.headerbasedauthSubmitted)) {
            return;
        }
        if (super.hasActionErrors()) {
            this.xsrfToken = XsrfTokenUtils.getXsrfToken((HttpServletRequest)request);
            this.initializeHeaderBasedAuth();
        }
        if (error) {
            this.initializeHeaderBasedAuth();
        }
    }

    public String execute() throws Exception {
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        this.xsrfToken = XsrfTokenUtils.getXsrfToken((HttpServletRequest)request);
        UserProfile user = this.userManager.getRemoteUser();
        if (user != null && this.userManager.isAdmin(user.getUserKey())) {
            try {
                LOGGER.info("MoHeaderBasedAuthAction doExecute Submitted: ");
                if (!this.settings.isValidLicense().booleanValue()) {
                    LOGGER.error("No valid license found");
                    return "upm";
                }
                if (BooleanUtils.toBoolean((Boolean)this.headerbasedauthSubmitted)) {
                    this.pluginHandler.saveHeaderBasedAuthSettings(this.enableHeaderAuthentication, this.headerAuthenticationAttribute);
                    this.addActionMessage(this.getText("samlsso.headerbasedauth.save.success"));
                }
                this.initializeHeaderBasedAuth();
                return "success";
            }
            catch (MoPluginException e) {
                LOGGER.error("An error occurred while saving your details." + e);
                this.addActionError(e.getMessage());
                return "error";
            }
            catch (Exception e) {
                LOGGER.error("An error occurred while saving your Header Authentication details." + e);
                this.addActionError("An error occurred while saving your details. Please check logs for more info.");
                return "error";
            }
        }
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
        return null;
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    private void initializeHeaderBasedAuth() {
        this.enableHeaderAuthentication = this.settings.getHeaderAuthenticationSettings();
        this.headerAuthenticationAttribute = this.settings.getHeaderAuthenticationAttribute();
    }

    @StrutsParameter
    public MoSAMLSettings getSettings() {
        return this.settings;
    }

    @StrutsParameter
    public void setSettings(MoSAMLSettings settings) {
        this.settings = settings;
    }

    @StrutsParameter
    public MoPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    @StrutsParameter
    public void setPluginHandler(MoPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }

    @StrutsParameter
    public String getHeaderAuthenticationAttribute() {
        return this.headerAuthenticationAttribute;
    }

    @StrutsParameter
    public void setHeaderAuthenticationAttribute(String headerAuthenticationAttribute) {
        this.headerAuthenticationAttribute = headerAuthenticationAttribute;
    }

    @StrutsParameter
    public Boolean getHeaderbasedauthSubmitted() {
        return this.headerbasedauthSubmitted;
    }

    @StrutsParameter
    public void setHeaderbasedauthSubmitted(Boolean headerbasedauthSubmitted) {
        this.headerbasedauthSubmitted = headerbasedauthSubmitted;
    }

    @StrutsParameter
    public Boolean getEnableHeaderAuthentication() {
        return this.enableHeaderAuthentication;
    }

    @StrutsParameter
    public void setEnableHeaderAuthentication(Boolean enableHeaderAuthentication) {
        this.enableHeaderAuthentication = enableHeaderAuthentication;
    }

    @StrutsParameter
    public String getXsrfToken() {
        return this.xsrfToken;
    }

    @StrutsParameter
    public void setXsrfToken(String xsrfToken) {
        this.xsrfToken = xsrfToken;
    }

    @StrutsParameter
    public Collection<String> getSuccessMessages() {
        Collection successMessages = this.getActionMessages();
        ArrayList<String> encodedSuccessMessages = new ArrayList<String>();
        for (String message : successMessages) {
            encodedSuccessMessages.add(MoSAMLUtils.htmlEncode(message));
        }
        return encodedSuccessMessages;
    }

    @StrutsParameter
    public Collection<String> getErrorMessages() {
        Collection errorMessages = this.getActionErrors();
        ArrayList<String> encodedErrorMessages = new ArrayList<String>();
        for (String message : errorMessages) {
            encodedErrorMessages.add(MoSAMLUtils.htmlEncode(message));
        }
        return encodedErrorMessages;
    }
}

