/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.bamboo.action;

import com.atlassian.bamboo.security.xsrf.XsrfTokenUtils;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.plugin.PluginException;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.miniorange.sso.saml.MoPluginException;
import com.miniorange.sso.saml.bamboo.MoPluginHandler;
import com.miniorange.sso.saml.bamboo.MoSAMLSettings;
import com.miniorange.sso.saml.dto.MoIDPConfig;
import com.miniorange.sso.saml.dto.MoIDPMetadata;
import com.miniorange.sso.saml.utils.MoHttpUtils;
import com.miniorange.sso.saml.utils.MoSAMLUtils;
import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.webwork.dispatcher.multipart.MultiPartRequestWrapper;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.struts2.interceptor.parameter.StrutsParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoFlowDrivenSetupAction
extends BambooActionSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoFlowDrivenSetupAction.class);
    private MoPluginHandler moPluginHandler;
    private MoSAMLSettings settings;
    private LoginUriProvider loginUriProvider;
    private String pageNumber;
    private String setupGuideLink;
    private Boolean error = Boolean.FALSE;
    private String idpGuide;
    private UserManager userManager;
    private String xsrfToken;
    private Boolean resetPageNumber;
    private Boolean spMetaDataSubmitted;
    private Boolean isJCEInstalled;
    private Map<String, String> certificateInfo;
    private Boolean updatedUrls;
    private String updatedSpBaseUrl;
    private String updatedSpEntityId;
    private Boolean configureIdpSubmitted;
    private Boolean foundIdpConfiguration = Boolean.FALSE;
    private Boolean testConfigPerformed = Boolean.FALSE;
    private Boolean configureIdpNextSubmitted;
    private String metadataOption;
    private String customIdpName;
    private String inputUrl;
    private String idpName;
    private String newIdpname;
    private String idpID;
    private String x509Certificate;
    private String[] x509AllCertificates;
    private List<String> certificates;
    private String idpEntityId;
    private String ssoUrl;
    private String ssoBindingType;
    private Boolean signedRequest;
    private String spBaseUrl;
    private Boolean userProfileSubmitted;
    private String userNameAttribute;
    private String userEmailAttribute;
    private String fullNameAttribute;
    private String firstNameAttribute;
    private String lastNameAttribute;
    private String loginAttribute;
    private String nameOption;
    private Boolean useSeparateNameAttributes;
    private Boolean userGroupsSubmitted;
    private String[] defaultGroups;
    private String defaultGroup;
    private List<String> defaultGroupsList;
    private String enableDefaultGroupsFor;
    private Boolean testConfigSubmitted;
    private Map<String, List<String>> attributesMap;
    private String displaySamlResponse;
    private String displaySamlRequest;

    public MoFlowDrivenSetupAction(MoPluginHandler moPluginHandler, MoSAMLSettings settings, LoginUriProvider loginUriProvider, UserManager userManager) {
        this.moPluginHandler = moPluginHandler;
        this.settings = settings;
        this.loginUriProvider = loginUriProvider;
        this.userManager = userManager;
    }

    private void doValidate() {
        this.error = false;
        if (BooleanUtils.toBoolean((Boolean)this.spMetaDataSubmitted)) {
            LOGGER.debug("Sp metadata validation");
        } else if (BooleanUtils.toBoolean((Boolean)this.configureIdpSubmitted)) {
            LOGGER.debug("Configure IDP validation");
            if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)this.customIdpName, (CharSequence)"yes") && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.newIdpname)) {
                this.error = Boolean.TRUE;
                this.addActionError(this.getText("samlsso.error.config.metadata.custom.name.empty"));
            }
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.metadataOption)) {
                this.error = Boolean.TRUE;
                this.addActionError(this.getText("samlsso.error.config.metadata.option.empty"));
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)this.metadataOption) && org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)this.metadataOption, (CharSequence)"manual")) {
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.ssoUrl)) {
                    this.addActionError(this.getText("samlsso.error.config.ssourl.empty"));
                    this.error = true;
                } else {
                    try {
                        new URL(this.ssoUrl);
                    }
                    catch (MalformedURLException e) {
                        LOGGER.error("Invalid URL", (Throwable)e);
                        this.addActionError(this.getText("samlsso.error.config.ssourl.malformed"));
                        this.error = true;
                    }
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.idpEntityId)) {
                    this.addActionError(this.getText("samlsso.error.config.idpentityid.empty"));
                    this.error = true;
                }
                if (this.x509AllCertificates != null) {
                    this.certificates = new ArrayList<String>(Arrays.asList(this.x509AllCertificates));
                    this.certificates.removeAll(Arrays.asList(""));
                    this.x509AllCertificates = this.certificates.toArray(new String[0]);
                }
                if (this.x509AllCertificates != null) {
                    this.certificates = new ArrayList<String>(Arrays.asList(this.x509AllCertificates));
                    this.certificates.removeAll(Arrays.asList(""));
                    this.x509AllCertificates = this.certificates.toArray(new String[0]);
                }
                if (this.x509AllCertificates != null && this.x509AllCertificates.length > 0) {
                    if (this.x509AllCertificates.length == 1) {
                        if (StringUtils.isBlank(this.x509AllCertificates[0])) {
                            this.addActionError(this.getText("samlsso.error.config.certificate.empty"));
                            this.error = true;
                        } else if (!MoSAMLUtils.isValidPublicCertificate(this.x509AllCertificates[0]).booleanValue()) {
                            this.addActionError(this.getText("samlsso.error.config.certificate.invalid"));
                            this.error = true;
                        }
                    } else {
                        for (String certificate : this.x509AllCertificates) {
                            if (MoSAMLUtils.isValidPublicCertificate(certificate).booleanValue() || StringUtils.isBlank(certificate)) continue;
                            this.addActionError("Invalid Signing Certificate " + (Arrays.asList(this.x509AllCertificates).indexOf(certificate) + 1));
                            this.error = true;
                        }
                    }
                } else if (StringUtils.isBlank(this.x509Certificate)) {
                    this.addActionError(this.getText("samlsso.error.config.certificate.empty"));
                    this.error = true;
                } else if (!MoSAMLUtils.isValidPublicCertificate(this.x509Certificate).booleanValue()) {
                    this.addActionError(this.getText("samlsso.error.config.certificate.invalid"));
                    this.error = true;
                }
            }
        } else if (BooleanUtils.toBoolean((Boolean)this.userProfileSubmitted)) {
            LOGGER.debug("User Profile validation");
        } else if (BooleanUtils.toBoolean((Boolean)this.userGroupsSubmitted)) {
            LOGGER.debug("User Groups validation");
            if (this.defaultGroups != null && this.defaultGroups.length <= 0) {
                LOGGER.error("Default group is blank. Please select atleast one default group.");
                this.addActionError(this.getText("samlsso.error.config.defaultgroup.empty"));
                this.error = true;
            }
        } else if (BooleanUtils.toBoolean((Boolean)this.testConfigSubmitted)) {
            LOGGER.debug("Test Configuration validation");
        }
        if (BooleanUtils.toBoolean((Boolean)this.error)) {
            this.initialiseSAMLConfig(org.apache.struts2.ServletActionContext.getRequest());
        }
    }

    public String execute() throws Exception {
        UserProfile user;
        this.resetPageNumber = false;
        LOGGER.debug("Add IDP Action execute() called");
        HttpServletRequest request = org.apache.struts2.ServletActionContext.getRequest();
        HttpServletResponse response = org.apache.struts2.ServletActionContext.getResponse();
        this.xsrfToken = XsrfTokenUtils.getXsrfToken((HttpServletRequest)request);
        LOGGER.debug("REFERER called" + request.getHeader("referer"));
        if (org.apache.commons.lang3.StringUtils.containsIgnoreCase((CharSequence)request.getHeader("referer"), (CharSequence)"supported.action")) {
            this.resetPageNumber = true;
        }
        if ((user = this.userManager.getRemoteUser()) != null && this.userManager.isAdmin(user.getUserKey())) {
            try {
                LOGGER.info("FlowDrivenSetup Action doExecute called");
                if (!this.settings.isValidLicense().booleanValue()) {
                    LOGGER.error("No valid license found");
                    return "upm";
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)request.getParameter("idp"))) {
                    this.idpName = request.getParameter("idp");
                }
                this.doValidate();
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)request.getParameter("idpid"))) {
                    this.idpID = request.getParameter("idpid");
                    String lastPageSubmitted = this.getIdpQuickSetupOptions(this.idpID, "pageNumber");
                    int lastPageNumber = 2;
                    if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)lastPageSubmitted)) {
                        lastPageNumber = Integer.parseInt(lastPageSubmitted);
                    } else if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)request.getParameter("pageNumber"))) {
                        lastPageNumber = Integer.parseInt(request.getParameter("pageNumber"));
                    }
                    if (lastPageNumber == 2 && !this.settings.checkIfTestConfig(this.idpID)) {
                        this.settings.setPageNumber(Integer.toString(lastPageNumber));
                    } else if (lastPageNumber == 2 && this.settings.checkIfTestConfig(this.idpID) && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)this.getIdpQuickSetupOptions(this.idpID, "attributeMappingSubmitted"))) {
                        LOGGER.debug("case 2");
                        this.settings.setPageNumber(Integer.toString(lastPageNumber + 2));
                    } else {
                        LOGGER.debug("case 3");
                        this.settings.setPageNumber(Integer.toString(lastPageNumber + 1));
                    }
                }
                if (BooleanUtils.toBoolean((Boolean)this.spMetaDataSubmitted) && !this.error.booleanValue()) {
                    this.settings.setPageNumber("2");
                    LOGGER.debug("Sp metadata submitted");
                } else if (MoSAMLSettings.isMetadataUpload.booleanValue()) {
                    MoSAMLSettings.isMetadataUpload = Boolean.FALSE;
                    if (request.getSession().getAttribute("idpid") != null) {
                        this.idpID = (String)request.getSession().getAttribute("idpid");
                        request.getSession().removeAttribute("idpid");
                    }
                    if (request.getSession().getAttribute("customIdpname") != null) {
                        this.customIdpName = (String)request.getSession().getAttribute("customIdpname");
                        request.getSession().removeAttribute("customIdpname");
                    }
                    if (request.getSession().getAttribute("newIdpname") != null) {
                        this.newIdpname = (String)request.getSession().getAttribute("newIdpname");
                        request.getSession().removeAttribute("newIdpname");
                    }
                    if (request.getSession().getAttribute("metadataOption") != null) {
                        this.metadataOption = (String)request.getSession().getAttribute("metadataOption");
                        request.getSession().removeAttribute("metadataOption");
                    }
                    if (request.getSession().getAttribute("idp") != null) {
                        this.idpName = (String)request.getSession().getAttribute("idp");
                        request.getSession().removeAttribute("idp");
                    }
                    LOGGER.debug("information retrived... :idpID :" + this.idpID + ", idpName :" + this.idpName + ", custom IDPname :" + this.customIdpName + ", newIDP name :" + this.newIdpname + ", metadata Option :" + this.metadataOption);
                    if (request.getSession().getAttribute("success") != null || request.getSession().getAttribute("error") != null) {
                        if (request.getSession().getAttribute("success") != null) {
                            this.addActionMessage(this.getText("samlsso.success.config"));
                            request.getSession().removeAttribute("success");
                        } else if (request.getSession().getAttribute("error") != null) {
                            this.addActionError(request.getSession().getAttribute("error").toString());
                            request.getSession().removeAttribute("error");
                        }
                    }
                    request.getSession().removeAttribute("error");
                    request.getSession().removeAttribute("success");
                    this.saveIdpQuickSetupOptions(this.idpID, "idpGuide", this.moPluginHandler.getIdpGuides().get(this.idpName));
                    this.saveIdpQuickSetupOptions(this.idpID, "actualIdpName", this.idpName);
                    this.saveIdpQuickSetupOptions(this.idpID, "customIdpName", this.customIdpName);
                    this.saveIdpQuickSetupOptions(this.idpID, "metadataOption", this.metadataOption);
                } else if (BooleanUtils.toBoolean((Boolean)this.configureIdpSubmitted) && !this.error.booleanValue()) {
                    LOGGER.debug("Configure IDP submitted : Save");
                    this.foundIdpConfiguration = Boolean.TRUE;
                    String actualIDPName = this.idpName = request.getParameter("idp");
                    if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)request.getParameter("idpId"))) {
                        this.idpID = UUID.randomUUID().toString();
                        LOGGER.debug("New IDP ID generated : " + this.idpID);
                    }
                    if (!BooleanUtils.toBoolean((Boolean)this.error)) {
                        String finalIdpname = new String();
                        finalIdpname = org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)this.customIdpName, (CharSequence)"yes") ? this.newIdpname : this.idpName;
                        LOGGER.debug("final IDP name : " + finalIdpname);
                        LOGGER.debug("metadataOption : " + this.metadataOption);
                        if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)this.metadataOption, (CharSequence)"fromUrl")) {
                            LOGGER.debug("frmo URL importing metadata...");
                            switch (this.idpName) {
                                case "ADFS": {
                                    MoPluginHandler.saveMetadataOption(this.idpID, "ADFS");
                                    this.handleFetchMetadata("ADFS", finalIdpname);
                                    break;
                                }
                                case "Azure AD": {
                                    MoPluginHandler.saveMetadataOption(this.idpID, "Azure AD");
                                    this.handleFetchMetadata("Azure AD", finalIdpname);
                                    break;
                                }
                                default: {
                                    MoPluginHandler.saveMetadataOption(this.idpID, this.metadataOption);
                                    this.handleFetchMetadata(this.metadataOption, finalIdpname);
                                }
                            }
                            LOGGER.debug("out of switch case method...");
                        } else if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)this.metadataOption, (CharSequence)"fromFile")) {
                            MoPluginHandler.saveMetadataOption(this.idpID, this.metadataOption);
                            this.handleUploadMetadata(finalIdpname);
                        } else if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)this.metadataOption, (CharSequence)"manual")) {
                            ArrayList<Object> x509allcertificates = new ArrayList<String>();
                            if (this.x509Certificate != null) {
                                x509allcertificates.add(org.apache.commons.lang3.StringUtils.trim((String)this.x509Certificate));
                            }
                            if (this.x509AllCertificates != null) {
                                x509allcertificates = new ArrayList<String>(Arrays.asList(this.x509AllCertificates));
                                x509allcertificates.removeAll(Arrays.asList(null, ""));
                                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.x509Certificate)) {
                                    this.x509Certificate = (String)x509allcertificates.get(0);
                                }
                            }
                            MoPluginHandler.saveIdPConfiguration(this.idpID, org.apache.commons.lang3.StringUtils.trim((String)finalIdpname), org.apache.commons.lang3.StringUtils.trim((String)this.idpEntityId), this.ssoBindingType, org.apache.commons.lang3.StringUtils.trim((String)this.ssoUrl), "", "", "", x509allcertificates, org.apache.commons.lang3.StringUtils.trim((String)this.x509Certificate), this.signedRequest, "", Boolean.TRUE);
                            this.addActionMessage(this.getText("samlsso.success.config"));
                        }
                        this.saveIdpQuickSetupOptions(this.idpID, "idpGuide", this.moPluginHandler.getIdpGuides().get(actualIDPName));
                        this.saveIdpQuickSetupOptions(this.idpID, "actualIdpName", actualIDPName);
                        this.saveIdpQuickSetupOptions(this.idpID, "customIdpName", this.customIdpName);
                        this.saveIdpQuickSetupOptions(this.idpID, "metadataOption", this.metadataOption);
                    }
                    this.saveIdpQuickSetupOptions(this.idpID, "pageNumber", "2");
                } else if (BooleanUtils.toBoolean((Boolean)this.configureIdpNextSubmitted) && !this.error.booleanValue()) {
                    this.settings.setPageNumber("3");
                    LOGGER.debug("Configure IDP submitted : Next");
                    if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.idpID)) {
                        if (!this.settings.getIdpMap().isEmpty()) {
                            this.idpID = this.settings.getIdPList().get(0);
                            LOGGER.debug("configure IDP final IDP ID : " + this.idpID);
                        } else {
                            this.idpID = UUID.randomUUID().toString();
                        }
                    }
                    this.testConfigPerformed = this.settings.checkIfTestConfig(this.idpID);
                    this.saveIdpQuickSetupOptions(this.idpID, "pageNumber", "2");
                } else if (BooleanUtils.toBoolean((Boolean)this.userProfileSubmitted) && !this.error.booleanValue()) {
                    this.settings.setPageNumber("4");
                    LOGGER.debug("User Profile submitted");
                    if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.idpID)) {
                        if (!this.settings.getIdpMap().isEmpty()) {
                            this.idpID = this.settings.getIdPList().get(0);
                            LOGGER.debug("user profile IdpID : " + this.idpID);
                        } else {
                            this.idpID = UUID.randomUUID().toString();
                        }
                    }
                    String userNameAttr = org.apache.commons.lang3.StringUtils.split((String)this.userNameAttribute, (String)" ")[0];
                    String userEmailAttr = org.apache.commons.lang3.StringUtils.split((String)this.userEmailAttribute, (String)" ")[0];
                    String userFullNameAttr = "";
                    if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)this.fullNameAttribute)) {
                        userFullNameAttr = org.apache.commons.lang3.StringUtils.split((String)this.fullNameAttribute, (String)" ")[0];
                    }
                    String userFirstNameAttr = "";
                    if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)this.firstNameAttribute)) {
                        userFirstNameAttr = org.apache.commons.lang3.StringUtils.split((String)this.firstNameAttribute, (String)" ")[0];
                    }
                    String userLastNameAttr = "";
                    if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)this.lastNameAttribute)) {
                        userLastNameAttr = org.apache.commons.lang3.StringUtils.split((String)this.lastNameAttribute, (String)" ")[0];
                    }
                    MoPluginHandler.saveAttributeMapping(this.idpID, this.setDefaulttoNameID(userNameAttr), this.setDefaulttoNameID(userEmailAttr), this.setDefaulttoEmpty(userFullNameAttr), this.useSeparateNameAttributes, this.setDefaulttoEmpty(userFirstNameAttr), this.setDefaulttoEmpty(userLastNameAttr), false, "", false, this.loginAttribute);
                    this.saveIdpQuickSetupOptions(this.idpID, "pageNumber", "3");
                    this.testConfigPerformed = this.settings.checkIfTestConfig(this.idpID);
                } else if (BooleanUtils.toBoolean((Boolean)this.userGroupsSubmitted) && !this.error.booleanValue()) {
                    this.settings.setPageNumber("5");
                    LOGGER.debug("User Groups submitted");
                    if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.idpID)) {
                        if (!this.settings.getIdpMap().isEmpty()) {
                            this.idpID = this.settings.getIdPList().get(0);
                            LOGGER.debug("group mapping IdpID : " + this.idpID);
                        } else {
                            this.idpID = UUID.randomUUID().toString();
                        }
                    }
                    List<Object> defaultGroupList = new ArrayList<String>();
                    if (this.defaultGroup != null) {
                        LOGGER.debug("single default group is -" + this.defaultGroup);
                        defaultGroupList.add(this.defaultGroup);
                    }
                    LOGGER.debug("Default Groups : " + this.defaultGroups);
                    if (this.defaultGroups != null) {
                        LOGGER.debug("multiple default groups -" + this.defaultGroups.toString());
                        defaultGroupList = Arrays.asList(org.apache.commons.lang3.StringUtils.split((String)this.defaultGroups[0], (String)","));
                        defaultGroupList.removeAll(Arrays.asList(null, ""));
                    }
                    MoPluginHandler.saveRoleMapping(this.idpID, "", false, false, new HashMap<String, String>(), this.defaultGroup, defaultGroupList, true, this.enableDefaultGroupsFor, false, new ArrayList<String>(), true, true, false, "", "", "");
                    this.initialiseTestConfig();
                    this.saveIdpQuickSetupOptions(this.idpID, "pageNumber", "4");
                } else if (BooleanUtils.toBoolean((Boolean)this.testConfigSubmitted) && !this.error.booleanValue()) {
                    LOGGER.debug("Test Configuration submitted");
                }
                this.initialiseSAMLConfig(request);
                return "input";
            }
            catch (MoPluginException e) {
                LOGGER.error("MoPluginException = ", (Throwable)e);
                this.addActionError(e.getMessage());
                this.initialiseSAMLConfig(request);
                return "input";
            }
            catch (PluginException e) {
                LOGGER.error("PluginException = ", (Throwable)e);
                this.addActionError(e.getMessage());
                this.initialiseSAMLConfig(request);
                return "input";
            }
            catch (Exception e) {
                LOGGER.error("Exception  ", (Throwable)e);
                this.addActionError("An error occurred while saving your details. Please check logs for more info.");
                this.initialiseSAMLConfig(request);
                return "input";
            }
        }
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
        return null;
    }

    private void initialiseTestConfig() {
        MoIDPConfig idpConfig = MoPluginHandler.constructIdpConfigObject(this.idpID);
        this.testConfigPerformed = this.settings.checkIfTestConfig(this.idpID);
        try {
            if (this.testConfigPerformed.booleanValue() && idpConfig != null) {
                LOGGER.debug("3");
                this.attributesMap = MoSAMLUtils.toMap((JSONObject)this.settings.getIdpConfig(this.idpID).get("testConfig"));
                this.displaySamlRequest = (String)this.settings.getIdpConfig(this.idpID).get("samlRequest");
                this.displaySamlResponse = (String)this.settings.getIdpConfig(this.idpID).get("samlResponse");
            }
        }
        catch (Exception e) {
            LOGGER.debug("error getting the test config details from settings.getIdpConfig(this.idpID)");
        }
    }

    private String getIdpQuickSetupOptions(String idpID, String optionName) {
        String optionValue = new String();
        try {
            JSONObject idpConfigObject = this.settings.getIdpConfig(idpID);
            if (idpConfigObject.has(optionName)) {
                optionValue = (String)idpConfigObject.get(optionName);
            }
        }
        catch (Exception e) {
            LOGGER.debug("Error fetching IDP quick setup options");
        }
        return optionValue;
    }

    private void handleFetchMetadata(String metadataOrIDPOption, String idpName) {
        LOGGER.debug("handleFetchMetadata called");
        try {
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.inputUrl)) {
                LOGGER.error("Input Metadata URL is empty");
                this.foundIdpConfiguration = false;
                this.addActionError(this.getText("samlsso.error.url.empty"));
            } else {
                String idpMetadataUrl = this.getIdpMetadataUrl();
                MoPluginHandler.fetchMetadata(this.idpID, idpName, this.inputUrl, idpMetadataUrl, metadataOrIDPOption);
                this.addActionMessage(this.getText("samlsso.success.config"));
            }
        }
        catch (MoPluginException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            this.foundIdpConfiguration = Boolean.FALSE;
            if (e.getErrorCode() == MoPluginException.PluginErrorCode.METADATA_PARSE) {
                throw new MoPluginException(MoPluginException.PluginErrorCode.METADATA_PARSE, this.getText("samlsso.error.invalid.metadata"), e);
            }
            throw new MoPluginException(MoPluginException.PluginErrorCode.METADATA_PARSE, this.getText("samlsso.error.url.connect"), e);
        }
        catch (Exception e) {
            this.foundIdpConfiguration = Boolean.FALSE;
            this.addActionError(this.getText("Invalid Metadata"));
        }
    }

    private void saveIdpQuickSetupOptions(String idpID, String optionName, String optionValue) {
        try {
            JSONObject idpConfigObject = this.settings.getIdpConfig(idpID);
            idpConfigObject.put(optionName, optionValue);
            this.settings.setIdpConfig(idpConfigObject, idpID);
        }
        catch (Exception e) {
            LOGGER.debug("error saving option " + optionName + " for idp " + idpID);
        }
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    private String getIdpMetadataUrl() {
        LOGGER.debug("Getting IdP Metadata URL for IdP");
        String getIdpMetadataUrl = "";
        if (this.inputUrl.contains("https://") || this.inputUrl.contains("http://")) {
            this.metadataOption = "fromUrl";
        }
        switch (this.idpName) {
            case "ADFS": {
                getIdpMetadataUrl = "https://" + this.inputUrl + "/federationmetadata/2007-06/federationmetadata.xml";
                break;
            }
            case "Azure AD": {
                getIdpMetadataUrl = "https://login.microsoftonline.com/" + this.inputUrl + "/FederationMetadata/2007-06/FederationMetadata.xml";
                break;
            }
            default: {
                getIdpMetadataUrl = this.inputUrl;
            }
        }
        return getIdpMetadataUrl;
    }

    private String setDefaulttoNameID(String attributeName) {
        if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)attributeName, (CharSequence)"--Select--")) {
            return "NameID";
        }
        return attributeName;
    }

    private String setDefaulttoEmpty(String attributeName) {
        if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)attributeName, (CharSequence)"--Select--")) {
            return "";
        }
        return attributeName;
    }

    public void initialiseSAMLConfig(HttpServletRequest request) {
        MoIDPConfig idpConfig;
        LOGGER.debug("initialiseSAMLConfig for flow driven called");
        this.pageNumber = this.settings.getPageNumber(this.resetPageNumber);
        this.isJCEInstalled = this.isJCEEnable();
        if (MoHttpUtils.getCookie(request, "miniorange.saml.QUICKSETUP_IDP") != null) {
            LOGGER.debug("Getting IDP from cookie");
            this.idpID = MoHttpUtils.getCookie(request, "miniorange.saml.QUICKSETUP_IDP").getValue();
        }
        if ((idpConfig = MoPluginHandler.constructIdpConfigObject(this.idpID)) != null) {
            LOGGER.debug("IDconfig object found");
            this.idpGuide = this.getIdpQuickSetupOptions(this.idpID, "idpGuide");
            LOGGER.debug("IDPGuide link : " + this.idpGuide);
            this.ssoUrl = (String)org.apache.commons.lang3.StringUtils.defaultIfBlank((CharSequence)idpConfig.getSsoUrl(), (CharSequence)"");
            this.newIdpname = (String)org.apache.commons.lang3.StringUtils.defaultIfBlank((CharSequence)idpConfig.getIdpName(), (CharSequence)"");
            this.inputUrl = (String)org.apache.commons.lang3.StringUtils.defaultIfBlank((CharSequence)idpConfig.getInputUrl(), (CharSequence)"");
            this.idpEntityId = (String)org.apache.commons.lang3.StringUtils.defaultIfBlank((CharSequence)idpConfig.getIdpEntityId(), (CharSequence)"");
            this.certificates = idpConfig.getCertificates();
            this.x509Certificate = (String)org.apache.commons.lang3.StringUtils.defaultIfBlank((CharSequence)idpConfig.getX509Certificate(), (CharSequence)"");
            this.inputUrl = (String)org.apache.commons.lang3.StringUtils.defaultIfBlank((CharSequence)idpConfig.getInputUrl(), (CharSequence)"");
            this.userNameAttribute = (String)org.apache.commons.lang3.StringUtils.defaultIfBlank((CharSequence)idpConfig.getUsernameAttribute(), (CharSequence)"NameID");
            this.userEmailAttribute = (String)org.apache.commons.lang3.StringUtils.defaultIfBlank((CharSequence)idpConfig.getEmailAttribute(), (CharSequence)"NameID");
            this.loginAttribute = (String)org.apache.commons.lang3.StringUtils.defaultIfBlank((CharSequence)idpConfig.getLoginUserAttribute(), (CharSequence)"username");
            this.fullNameAttribute = (String)org.apache.commons.lang3.StringUtils.defaultIfBlank((CharSequence)idpConfig.getFullNameAttribute(), (CharSequence)"");
            this.firstNameAttribute = (String)org.apache.commons.lang3.StringUtils.defaultIfBlank((CharSequence)idpConfig.getFirstNameAttribute(), (CharSequence)"");
            this.lastNameAttribute = (String)org.apache.commons.lang3.StringUtils.defaultIfBlank((CharSequence)idpConfig.getLastNameAttribute(), (CharSequence)"");
            this.useSeparateNameAttributes = BooleanUtils.toBooleanDefaultIfNull((Boolean)idpConfig.getUseSeparateNameAttributes(), (boolean)Boolean.FALSE);
            this.metadataOption = (String)org.apache.commons.lang3.StringUtils.defaultIfBlank((CharSequence)this.getIdpQuickSetupOptions(this.idpID, "metadataOption"), (CharSequence)"fromUrl");
            this.customIdpName = (String)org.apache.commons.lang3.StringUtils.defaultIfBlank((CharSequence)this.getIdpQuickSetupOptions(this.idpID, "customIdpName"), (CharSequence)"yes");
            this.defaultGroup = idpConfig.getDefaultGroup();
            this.defaultGroupsList = idpConfig.getDefaultGroupsList();
            this.enableDefaultGroupsFor = idpConfig.getEnableDefaultGroupsFor();
            this.foundIdpConfiguration = Boolean.TRUE;
            this.ssoBindingType = (String)org.apache.commons.lang3.StringUtils.defaultIfBlank((CharSequence)idpConfig.getSsoBindingType(), (CharSequence)"HttpRedirect");
            this.signedRequest = BooleanUtils.toBooleanDefaultIfNull((Boolean)idpConfig.getSignedRequest(), (boolean)Boolean.TRUE);
            this.spBaseUrl = this.settings.getSpBaseUrl();
        } else {
            LOGGER.debug("New Idp");
            this.idpID = "";
            this.idpName = request.getParameter("idp");
            LOGGER.debug("idpname in initialize method :" + this.idpName);
            this.newIdpname = "";
            this.metadataOption = org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)this.idpName, (CharSequence)"G_Suite") ? "fromFile" : "fromUrl";
            this.idpGuide = this.moPluginHandler.getIdpGuides().get(this.idpName);
            LOGGER.debug("IDP guide new IDP: " + this.idpGuide);
            this.customIdpName = "yes";
            this.inputUrl = this.settings.getIdpMetadataURL();
            this.ssoUrl = this.settings.getSsoServiceUrl();
            this.idpEntityId = this.settings.getIdpEntityId();
            this.x509Certificate = this.settings.getX509Certificate();
            this.userNameAttribute = this.settings.getUsernameAttribute();
            this.userEmailAttribute = this.settings.getEmailAttribute();
            this.loginAttribute = this.settings.getLoginUserAttribute();
            this.fullNameAttribute = this.settings.getFullNameAttribute();
            this.firstNameAttribute = this.settings.getFirstNameAttribute();
            this.lastNameAttribute = this.settings.getLastNameAttribute();
            this.useSeparateNameAttributes = this.settings.getUseSeparateNameAttributes();
            this.defaultGroup = this.settings.getDefaultGroup();
            this.defaultGroupsList = (List)this.settings.getDefaultGroups();
            this.enableDefaultGroupsFor = this.settings.getEnableDefaultGroupsFor();
            this.ssoBindingType = "HttpRedirect";
            this.signedRequest = this.settings.getSignedRequest();
            this.spBaseUrl = this.settings.getSpBaseUrl();
            LOGGER.debug("spBaseUrl " + this.spBaseUrl);
            LOGGER.debug("idp " + this.idpID);
        }
    }

    public boolean isJCEEnable() {
        try {
            return Cipher.getMaxAllowedKeyLength("SHA256") == Integer.MAX_VALUE;
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("No Such Algorithm Exception" + e);
            return false;
        }
    }

    private void handleUploadMetadata(String idpName) {
        block7: {
            LOGGER.debug("handleUploadMetadata called");
            try {
                MultiPartRequestWrapper wrapper = (MultiPartRequestWrapper)ServletActionContext.getRequest();
                if (wrapper.getFiles("xmlFile") == null) {
                    LOGGER.error("Metadata file is empty");
                    this.addActionError(this.getText("samlsso.error.file.empty"));
                } else {
                    File metadataFile = wrapper.getFiles("xmlFile")[0];
                    MoPluginHandler.uploadMetadata(this.idpID, idpName, metadataFile, this.metadataOption);
                    this.addActionMessage(this.getText("samlsso.success.config"));
                }
            }
            catch (MoPluginException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                if ((MoIDPMetadata.entityId == null || StringUtils.isBlank(MoIDPMetadata.entityId)) && (MoIDPMetadata.signingCertificates == null || MoIDPMetadata.signingCertificates.isEmpty())) {
                    this.foundIdpConfiguration = Boolean.FALSE;
                    LOGGER.error("Invalid Metadata File");
                    this.addActionError(this.getText("samlsso.error.invalid.metadata"));
                }
                if (StringUtils.isNotEmpty(MoIDPMetadata.certificate) && MoIDPMetadata.signingCertificates.isEmpty()) {
                    this.foundIdpConfiguration = Boolean.FALSE;
                    LOGGER.error("Invalid X.509 Certificate in Metadata File");
                    this.addActionError(this.getText("samlsso.metadata.error.config.certificate.invalid"));
                }
                if (StringUtils.isEmpty(MoIDPMetadata.certificate)) {
                    this.foundIdpConfiguration = Boolean.FALSE;
                    LOGGER.error("Unable to find X.509Certificate in Metadata File");
                    this.addActionError(this.getText("samlsso.metadata.error.config.certificate.absent"));
                }
                if (!StringUtils.isBlank(MoIDPMetadata.entityId)) break block7;
                this.foundIdpConfiguration = Boolean.FALSE;
                LOGGER.error("Unable to find EntityId in Metadata File");
                this.addActionError(this.getText("samlsso.metadata.error.config.idpentityid.absent"));
            }
        }
    }

    @StrutsParameter
    public MoPluginHandler getMoPluginHandler() {
        return this.moPluginHandler;
    }

    @StrutsParameter
    public void setMoPluginHandler(MoPluginHandler moPluginHandler) {
        this.moPluginHandler = moPluginHandler;
    }

    @StrutsParameter
    public MoSAMLSettings getSettings() {
        return this.settings;
    }

    @StrutsParameter
    public void setSettings(MoSAMLSettings settings) {
        this.settings = settings;
    }

    @StrutsParameter
    public LoginUriProvider getLoginUriProvider() {
        return this.loginUriProvider;
    }

    @StrutsParameter
    public void setLoginUriProvider(LoginUriProvider loginUriProvider) {
        this.loginUriProvider = loginUriProvider;
    }

    @StrutsParameter
    public String getPageNumber() {
        return this.pageNumber;
    }

    @StrutsParameter
    public void setPageNumber(String pageNumber) {
        this.pageNumber = pageNumber;
    }

    @StrutsParameter
    public String getSetupGuideLink() {
        return this.setupGuideLink;
    }

    @StrutsParameter
    public void setSetupGuideLink(String setupGuideLink) {
        this.setupGuideLink = setupGuideLink;
    }

    @StrutsParameter
    public Boolean getError() {
        return this.error;
    }

    @StrutsParameter
    public void setError(Boolean error) {
        this.error = error;
    }

    @StrutsParameter
    public String getIdpGuide() {
        return this.idpGuide;
    }

    @StrutsParameter
    public void setIdpGuide(String idpGuide) {
        this.idpGuide = idpGuide;
    }

    @StrutsParameter
    public UserManager getUserManager() {
        return this.userManager;
    }

    @StrutsParameter
    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    @StrutsParameter
    public Boolean getSpMetaDataSubmitted() {
        return this.spMetaDataSubmitted;
    }

    @StrutsParameter
    public void setSpMetaDataSubmitted(Boolean spMetaDataSubmitted) {
        this.spMetaDataSubmitted = spMetaDataSubmitted;
    }

    @StrutsParameter
    public Boolean getJCEInstalled() {
        return this.isJCEInstalled;
    }

    @StrutsParameter
    public void setJCEInstalled(Boolean JCEInstalled) {
        this.isJCEInstalled = JCEInstalled;
    }

    @StrutsParameter
    public Map<String, String> getCertificateInfo() {
        return this.certificateInfo;
    }

    @StrutsParameter
    public void setCertificateInfo(Map<String, String> certificateInfo) {
        this.certificateInfo = certificateInfo;
    }

    @StrutsParameter
    public Boolean getUpdatedUrls() {
        return this.updatedUrls;
    }

    @StrutsParameter
    public void setUpdatedUrls(Boolean updatedUrls) {
        this.updatedUrls = updatedUrls;
    }

    @StrutsParameter
    public String getUpdatedSpBaseUrl() {
        return this.updatedSpBaseUrl;
    }

    @StrutsParameter
    public void setUpdatedSpBaseUrl(String updatedSpBaseUrl) {
        this.updatedSpBaseUrl = updatedSpBaseUrl;
    }

    @StrutsParameter
    public String getUpdatedSpEntityId() {
        return this.updatedSpEntityId;
    }

    @StrutsParameter
    public void setUpdatedSpEntityId(String updatedSpEntityId) {
        this.updatedSpEntityId = updatedSpEntityId;
    }

    @StrutsParameter
    public Boolean getConfigureIdpSubmitted() {
        return this.configureIdpSubmitted;
    }

    @StrutsParameter
    public void setConfigureIdpSubmitted(Boolean configureIdpSubmitted) {
        this.configureIdpSubmitted = configureIdpSubmitted;
    }

    @StrutsParameter
    public Boolean getFoundIdpConfiguration() {
        return this.foundIdpConfiguration;
    }

    @StrutsParameter
    public void setFoundIdpConfiguration(Boolean foundIdpConfiguration) {
        this.foundIdpConfiguration = foundIdpConfiguration;
    }

    @StrutsParameter
    public Boolean getTestConfigPerformed() {
        return this.testConfigPerformed;
    }

    @StrutsParameter
    public void setTestConfigPerformed(Boolean testConfigPerformed) {
        this.testConfigPerformed = testConfigPerformed;
    }

    @StrutsParameter
    public Boolean getConfigureIdpNextSubmitted() {
        return this.configureIdpNextSubmitted;
    }

    @StrutsParameter
    public void setConfigureIdpNextSubmitted(Boolean configureIdpNextSubmitted) {
        this.configureIdpNextSubmitted = configureIdpNextSubmitted;
    }

    @StrutsParameter
    public String getMetadataOption() {
        return this.metadataOption;
    }

    @StrutsParameter
    public void setMetadataOption(String metadataOption) {
        this.metadataOption = metadataOption;
    }

    @StrutsParameter
    public String getCustomIdpName() {
        return this.customIdpName;
    }

    @StrutsParameter
    public void setCustomIdpName(String customIdpName) {
        this.customIdpName = customIdpName;
    }

    @StrutsParameter
    public String getInputUrl() {
        return this.inputUrl;
    }

    @StrutsParameter
    public void setInputUrl(String inputUrl) {
        this.inputUrl = inputUrl;
    }

    @StrutsParameter
    public String getIdpName() {
        return this.idpName;
    }

    @StrutsParameter
    public void setIdpName(String idpName) {
        this.idpName = idpName;
    }

    @StrutsParameter
    public String getNewIdpname() {
        return this.newIdpname;
    }

    @StrutsParameter
    public void setNewIdpname(String newIdpname) {
        this.newIdpname = newIdpname;
    }

    @StrutsParameter
    public String getIdpID() {
        return this.idpID;
    }

    @StrutsParameter
    public void setIdpID(String idpID) {
        this.idpID = idpID;
    }

    @StrutsParameter
    public String getX509Certificate() {
        return this.x509Certificate;
    }

    @StrutsParameter
    public void setX509Certificate(String x509Certificate) {
        this.x509Certificate = x509Certificate;
    }

    @StrutsParameter
    public String[] getX509AllCertificates() {
        return this.x509AllCertificates;
    }

    @StrutsParameter
    public void setX509AllCertificates(String[] x509AllCertificates) {
        this.x509AllCertificates = x509AllCertificates;
    }

    @StrutsParameter
    public List<String> getCertificates() {
        return this.certificates;
    }

    @StrutsParameter
    public void setCertificates(List<String> certificates) {
        this.certificates = certificates;
    }

    @StrutsParameter
    public String getIdpEntityId() {
        return this.idpEntityId;
    }

    @StrutsParameter
    public void setIdpEntityId(String idpEntityId) {
        this.idpEntityId = idpEntityId;
    }

    @StrutsParameter
    public String getSsoUrl() {
        return this.ssoUrl;
    }

    @StrutsParameter
    public void setSsoUrl(String ssoUrl) {
        this.ssoUrl = ssoUrl;
    }

    @StrutsParameter
    public String getSsoBindingType() {
        return this.ssoBindingType;
    }

    @StrutsParameter
    public void setSsoBindingType(String ssoBindingType) {
        this.ssoBindingType = ssoBindingType;
    }

    @StrutsParameter
    public Boolean getSignedRequest() {
        return this.signedRequest;
    }

    @StrutsParameter
    public void setSignedRequest(Boolean signedRequest) {
        this.signedRequest = signedRequest;
    }

    @StrutsParameter
    public Boolean getUserProfileSubmitted() {
        return this.userProfileSubmitted;
    }

    @StrutsParameter
    public void setUserProfileSubmitted(Boolean userProfileSubmitted) {
        this.userProfileSubmitted = userProfileSubmitted;
    }

    @StrutsParameter
    public String getUserNameAttribute() {
        return this.userNameAttribute;
    }

    @StrutsParameter
    public void setUserNameAttribute(String userNameAttribute) {
        this.userNameAttribute = userNameAttribute;
    }

    @StrutsParameter
    public String getUserEmailAttribute() {
        return this.userEmailAttribute;
    }

    @StrutsParameter
    public void setUserEmailAttribute(String userEmailAttribute) {
        this.userEmailAttribute = userEmailAttribute;
    }

    @StrutsParameter
    public String getFullNameAttribute() {
        return this.fullNameAttribute;
    }

    @StrutsParameter
    public void setFullNameAttribute(String fullNameAttribute) {
        this.fullNameAttribute = fullNameAttribute;
    }

    @StrutsParameter
    public String getFirstNameAttribute() {
        return this.firstNameAttribute;
    }

    @StrutsParameter
    public void setFirstNameAttribute(String firstNameAttribute) {
        this.firstNameAttribute = firstNameAttribute;
    }

    @StrutsParameter
    public String getLastNameAttribute() {
        return this.lastNameAttribute;
    }

    @StrutsParameter
    public void setLastNameAttribute(String lastNameAttribute) {
        this.lastNameAttribute = lastNameAttribute;
    }

    @StrutsParameter
    public String getLoginAttribute() {
        return this.loginAttribute;
    }

    @StrutsParameter
    public void setLoginAttribute(String loginAttribute) {
        this.loginAttribute = loginAttribute;
    }

    @StrutsParameter
    public String getNameOption() {
        return this.nameOption;
    }

    @StrutsParameter
    public void setNameOption(String nameOption) {
        this.nameOption = nameOption;
    }

    @StrutsParameter
    public Boolean getUseSeparateNameAttributes() {
        return this.useSeparateNameAttributes;
    }

    @StrutsParameter
    public void setUseSeparateNameAttributes(Boolean useSeparateNameAttributes) {
        this.useSeparateNameAttributes = useSeparateNameAttributes;
    }

    @StrutsParameter
    public Boolean getUserGroupsSubmitted() {
        return this.userGroupsSubmitted;
    }

    @StrutsParameter
    public void setUserGroupsSubmitted(Boolean userGroupsSubmitted) {
        this.userGroupsSubmitted = userGroupsSubmitted;
    }

    @StrutsParameter
    public String[] getDefaultGroups() {
        return this.defaultGroups;
    }

    @StrutsParameter
    public void setDefaultGroups(String[] defaultGroups) {
        this.defaultGroups = defaultGroups;
    }

    @StrutsParameter
    public String getDefaultGroup() {
        return this.defaultGroup;
    }

    @StrutsParameter
    public void setDefaultGroup(String defaultGroup) {
        this.defaultGroup = defaultGroup;
    }

    @StrutsParameter
    public List<String> getDefaultGroupsList() {
        return this.defaultGroupsList;
    }

    @StrutsParameter
    public void setDefaultGroupsList(List<String> defaultGroupsList) {
        this.defaultGroupsList = defaultGroupsList;
    }

    @StrutsParameter
    public String getEnableDefaultGroupsFor() {
        return this.enableDefaultGroupsFor;
    }

    @StrutsParameter
    public void setEnableDefaultGroupsFor(String enableDefaultGroupsFor) {
        this.enableDefaultGroupsFor = enableDefaultGroupsFor;
    }

    @StrutsParameter
    public Boolean getTestConfigSubmitted() {
        return this.testConfigSubmitted;
    }

    @StrutsParameter
    public void setTestConfigSubmitted(Boolean testConfigSubmitted) {
        this.testConfigSubmitted = testConfigSubmitted;
    }

    @StrutsParameter
    public Map<String, List<String>> getAttributesMap() {
        return this.attributesMap;
    }

    @StrutsParameter
    public void setAttributesMap(Map<String, List<String>> attributesMap) {
        this.attributesMap = attributesMap;
    }

    @StrutsParameter
    public String getDisplaySamlResponse() {
        return this.displaySamlResponse;
    }

    @StrutsParameter
    public void setDisplaySamlResponse(String displaySamlResponse) {
        this.displaySamlResponse = displaySamlResponse;
    }

    @StrutsParameter
    public String getDisplaySamlRequest() {
        return this.displaySamlRequest;
    }

    @StrutsParameter
    public String getXsrfToken() {
        return this.xsrfToken;
    }

    @StrutsParameter
    public void setXsrfToken(String xsrfToken) {
        this.xsrfToken = xsrfToken;
    }

    @StrutsParameter
    public void setDisplaySamlRequest(String displaySamlRequest) {
        this.displaySamlRequest = displaySamlRequest;
    }

    @StrutsParameter
    public String getLogSettingsUrl() {
        return this.settings.getSpBaseUrl() + "/admin/configLog4j.action";
    }

    @StrutsParameter
    public String getTroubleshootingUrl() {
        return this.settings.getSpBaseUrl() + "/plugins/servlet/troubleshooting/view/";
    }

    @StrutsParameter
    public String getSpBaseUrl() {
        return this.spBaseUrl;
    }

    @StrutsParameter
    public void setSpBaseUrl(String spBaseUrl) {
        this.spBaseUrl = spBaseUrl;
    }

    @StrutsParameter
    public Collection<String> getSuccessMessages() {
        Collection successMessages = this.getActionMessages();
        ArrayList<String> encodedSuccessMessages = new ArrayList<String>();
        for (String message : successMessages) {
            encodedSuccessMessages.add(MoSAMLUtils.htmlEncode(message));
        }
        return encodedSuccessMessages;
    }

    @StrutsParameter
    public Collection<String> getErrorMessages() {
        Collection errorMessages = this.getActionErrors();
        ArrayList<String> encodedErrorMessages = new ArrayList<String>();
        for (String message : errorMessages) {
            encodedErrorMessages.add(MoSAMLUtils.htmlEncode(message));
        }
        return encodedErrorMessages;
    }
}

