/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.eclipse.jetty.http.pathmap.MappedResource;
import org.eclipse.jetty.http.pathmap.MatchedResource;
import org.eclipse.jetty.http.pathmap.PathMappings;
import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.thread.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathMappingsHandler
extends Handler.AbstractContainer {
    private static final Logger LOG = LoggerFactory.getLogger(PathMappingsHandler.class);
    private final PathMappings<Handler> mappings = new PathMappings();

    public PathMappingsHandler() {
        this(true);
    }

    public PathMappingsHandler(boolean dynamic) {
        super(dynamic);
    }

    @Override
    public List<Handler> getHandlers() {
        return this.mappings.streamResources().map(MappedResource::getResource).toList();
    }

    public void addMapping(PathSpec pathSpec, Handler handler) {
        Handler.Container container;
        Objects.requireNonNull(pathSpec, "PathSpec cannot be null");
        Objects.requireNonNull(handler, "Handler cannot be null");
        if (!this.isDynamic() && this.isStarted()) {
            throw new IllegalStateException("Cannot add mapping: " + String.valueOf(this));
        }
        if (handler == this) {
            throw new IllegalStateException("Unable to addHandler of self: " + String.valueOf(handler));
        }
        if (handler instanceof Handler.Container && (container = (Handler.Container)handler).getDescendants().contains(this)) {
            throw new IllegalStateException("loop detected: " + String.valueOf(handler));
        }
        Server server = this.getServer();
        if (server != null) {
            handler.setServer(server);
            Invocable.InvocationType serverInvocationType = server.getInvocationType();
            Invocable.InvocationType invocationType = Invocable.InvocationType.NON_BLOCKING;
            invocationType = Invocable.combine(invocationType, handler.getInvocationType());
            if (this.isDynamic() && server.isStarted() && serverInvocationType != invocationType && serverInvocationType != Invocable.InvocationType.BLOCKING) {
                throw new IllegalArgumentException("Cannot change invocation type of started server");
            }
        }
        Handler old = (Handler)this.mappings.get(pathSpec);
        this.mappings.put(pathSpec, (Object)handler);
        this.updateBean(old, handler);
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        Dumpable.dumpObjects(out, indent, this, this.mappings);
    }

    @Override
    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        String pathInContext = Request.getPathInContext(request);
        MatchedResource matchedResource = this.mappings.getMatched(pathInContext);
        if (matchedResource == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No mappings matched {}", (Object)pathInContext);
            }
            return false;
        }
        Handler handler = (Handler)matchedResource.getResource();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Matched {} to {} -> {}", new Object[]{pathInContext, matchedResource.getPathSpec(), handler});
        }
        boolean handled = handler.handle(request, response, callback);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Handled {} {} by {}", new Object[]{handled, pathInContext, handler});
        }
        return handled;
    }
}

