/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.StringUtil;

public class ResponseUtils {
    public static void ensureConsumeAvailableOrNotPersistent(Request request, Response response) {
        if (request.consumeAvailable()) {
            return;
        }
        ResponseUtils.ensureNotPersistent(request, response);
    }

    public static void ensureNotPersistent(Request request, Response response) {
        switch (request.getConnectionMetaData().getHttpVersion()) {
            case HTTP_1_0: {
                response.getHeaders().computeField(HttpHeader.CONNECTION, (h, fields) -> {
                    if (fields == null || fields.isEmpty()) {
                        return null;
                    }
                    String v = fields.stream().flatMap(field -> Stream.of(field.getValues()).filter(s -> !HttpHeaderValue.KEEP_ALIVE.is(s))).collect(Collectors.joining(", "));
                    if (StringUtil.isEmpty(v)) {
                        return null;
                    }
                    return new HttpField(HttpHeader.CONNECTION, v);
                });
                break;
            }
            case HTTP_1_1: {
                response.getHeaders().computeField(HttpHeader.CONNECTION, (h, fields) -> {
                    if (fields == null || fields.isEmpty()) {
                        return HttpFields.CONNECTION_CLOSE;
                    }
                    if (fields.stream().anyMatch(f -> f.contains(HttpHeaderValue.CLOSE.asString()))) {
                        HttpField f2;
                        if (fields.size() == 1 && HttpFields.CONNECTION_CLOSE.equals((Object)(f2 = (HttpField)fields.get(0)))) {
                            return f2;
                        }
                        return new HttpField(HttpHeader.CONNECTION, fields.stream().flatMap(field -> Stream.of(field.getValues()).filter(s -> !HttpHeaderValue.KEEP_ALIVE.is(s))).collect(Collectors.joining(", ")));
                    }
                    return new HttpField(HttpHeader.CONNECTION, Stream.concat(fields.stream().flatMap(field -> Stream.of(field.getValues()).filter(s -> !HttpHeaderValue.KEEP_ALIVE.is(s))), Stream.of(HttpHeaderValue.CLOSE.asString())).collect(Collectors.joining(", ")));
                });
            }
        }
    }

    private ResponseUtils() {
    }
}

