/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.utils;

import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.sal.api.user.UserManager;
import com.miniorange.sso.saml.bamboo.MoPluginHandler;
import com.miniorange.sso.saml.bamboo.MoSAMLSettings;
import com.miniorange.sso.saml.utils.MoHttpUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoSendAlert {
    private BambooPermissionManager bambooPermissionManager;
    private BambooUserManager bambooUserManager;
    private MoSAMLSettings settings;
    private UserManager userManager;
    private static Log LOGGER = LogFactory.getLog(MoSendAlert.class);

    public MoSendAlert(BambooPermissionManager bambooPermissionManager, BambooUserManager bambooUserManager, MoSAMLSettings settings, UserManager userManager) {
        this.bambooPermissionManager = bambooPermissionManager;
        this.bambooUserManager = bambooUserManager;
        this.settings = settings;
        this.userManager = userManager;
    }

    public Boolean sendMail() {
        LOGGER.info((Object)"Sending Alert email to administrator user");
        String adminEmail = this.getAdminEmail();
        try {
            String content = new String();
            content = content + "Hello,<br><br>Email: " + adminEmail + "<br><br>Plugin Name: " + "Bamboo SAML 1.1.19";
            content = content + "<br><br>Details: miniOrange SAML SSO certificates are due to expire in " + this.settings.getSPCertExpireOn() + " days. Kindly visit plugin settings and update certificates.";
            content = content + "<br><br>Thanks<br>Atlassian Admin";
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("customerKey", "16555");
            jsonObject.put("sendEmail", true);
            JSONObject emailObject = new JSONObject();
            emailObject.put("customerKey", "16555");
            emailObject.put("fromEmail", "no-reply@xecurify.com");
            emailObject.put("bccEmail", "no-reply@xecurify.com");
            emailObject.put("fromName", "miniOrange");
            emailObject.put("toEmail", adminEmail);
            emailObject.put("toName", adminEmail);
            emailObject.put("bccEmail", adminEmail);
            emailObject.put("subject", "Alert Email for  Bamboo SAML 1.1.19");
            emailObject.put("content", content);
            jsonObject.put("email", emailObject);
            String json = jsonObject.toString();
            LOGGER.debug((Object)"Sending Email... ");
            StringBuilder url = new StringBuilder("https://auth.miniorange.com/moas");
            url.append("https://auth.miniorange.com/moas/api/notify/send");
            String response1 = MoHttpUtils.sendPostRequest(url.toString(), json, "application/json", MoPluginHandler.getAuthorizationHeaders(Long.valueOf("16555"), "fFd2XcvTGDemZvbw1bcUesNJWEqKbbUq"));
            LOGGER.debug((Object)("Send_feedback response: " + response1));
        }
        catch (Exception e) {
            LOGGER.error((Object)"An error occurred while sending the email alert.", (Throwable)e);
            return false;
        }
        return true;
    }

    private Collection<String> getAdminUsers() {
        HashSet<String> adminUsers = new HashSet<String>();
        adminUsers.addAll(this.bambooPermissionManager.getAdminUsers());
        adminUsers.addAll(this.bambooPermissionManager.getRestrictedAdminUsers());
        for (String groupName : this.bambooPermissionManager.getAdminGroups()) {
            List users = this.bambooUserManager.getMemberNamesAsList(this.bambooUserManager.getGroup(groupName));
            adminUsers.addAll(users);
        }
        return adminUsers;
    }

    private String getAdminEmail() {
        String email = "";
        for (String adminUser : this.getAdminUsers()) {
            email = this.userManager.getUserProfile(adminUser).getEmail();
        }
        return email;
    }

    public BambooPermissionManager getBambooPermissionManager() {
        return this.bambooPermissionManager;
    }

    public void setBambooPermissionManager(BambooPermissionManager bambooPermissionManager) {
        this.bambooPermissionManager = bambooPermissionManager;
    }

    public BambooUserManager getBambooUserManager() {
        return this.bambooUserManager;
    }

    public void setBambooUserManager(BambooUserManager bambooUserManager) {
        this.bambooUserManager = bambooUserManager;
    }

    public MoSAMLSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoSAMLSettings settings) {
        this.settings = settings;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }
}

