/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.bamboo.servlet;

import com.miniorange.sso.saml.bamboo.MoPluginHandler;
import com.miniorange.sso.saml.bamboo.MoSAMLSettings;
import com.miniorange.sso.saml.bamboo.schedulers.MoMetadataJobRunnerImpl;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplaceOldSettingWithNewServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReplaceOldSettingWithNewServlet.class);
    private MoSAMLSettings settings;
    private MoMetadataJobRunnerImpl metadataJobRunnerImpl;

    public ReplaceOldSettingWithNewServlet(MoSAMLSettings settings, MoMetadataJobRunnerImpl metadataJobRunnerImpl) {
        this.settings = settings;
        this.metadataJobRunnerImpl = metadataJobRunnerImpl;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        LOGGER.debug("ReplaceOldSettingWithNewServlet doPost");
        try {
            String idpID = req.getParameter("idpID");
            String idpName = req.getParameter("idpName");
            if (StringUtils.isNotBlank((CharSequence)this.settings.getSsoServiceUrl())) {
                MoPluginHandler.saveIdPConfiguration(idpID, idpName, this.settings.getIdpEntityId(), this.settings.getSsoBindingType(), this.settings.getSsoServiceUrl(), this.settings.getSloResponseLocationUrl(), this.settings.getSloBindingType(), this.settings.getSloServiceUrl(), (List)this.settings.getAllX509Certificates(), this.settings.getX509Certificate(), this.settings.getSignedRequest(), this.settings.getNameIdFormat(), this.settings.getEnableSsoForIdp());
                MoPluginHandler.saveAttributeMapping(idpID, this.settings.getUsernameAttribute(), this.settings.getEmailAttribute(), this.settings.getFullNameAttribute(), this.settings.getUseSeparateNameAttributes(), this.settings.getFirstNameAttribute(), this.settings.getLastNameAttribute(), this.settings.getKeepExistingUserAttributes(), this.settings.getRegexPattern(), this.settings.getRegexPatternEnabled(), this.settings.getLoginUserAttribute());
                MoPluginHandler.saveRoleMapping(idpID, this.settings.getRoleAttribute(), this.settings.getCreateUsersIfRoleMapped(), this.settings.getKeepExistingUserAttributes(), this.settings.getRoleMapping(), this.settings.getDefaultGroup(), (List)this.settings.getDefaultGroups(), this.settings.getRestrictUserCreation(), this.settings.getEnableDefaultGroupsFor(), this.settings.getOnTheFlyGroupMapping(), (List)this.settings.getOnTheFlyDoNotRemoveGroups(), this.settings.getOnTheFlyAssignNewGroupsOnly(), this.settings.getCreateNewGroups(), this.settings.getGroupRegexPatternEnabled(), this.settings.getRegexPatternForGroup(), this.settings.getRegexPattern(), this.settings.getTestRegex());
                MoPluginHandler.saveImportMetadata(idpID, this.settings.getInputMetadataUrl(), this.settings.getIdpMetadataURL(), this.settings.getRefreshMetadata(), this.settings.getRefreshInterval(), this.settings.getCustomRefreshInterval(), this.settings.getCustomRefreshIntervalUnit(), "");
                this.settings.setMetadataOption(idpID, this.settings.getMetadataOption("miniorange.saml.DEFAULT_IDP_ID"));
                MoPluginHandler.saveListIDPConfigurations(idpID, Boolean.TRUE);
                this.metadataJobRunnerImpl.deleteSchedule("miniorange.saml.DEFAULT_IDP_ID");
                MoPluginHandler.toggleSchedulerService(idpID);
                this.settings.clearOldConfiguration();
            }
            String attrsJSON = "success";
            resp.setContentType("text/plain");
            resp.getOutputStream().write(attrsJSON.getBytes());
            resp.getOutputStream().close();
        }
        catch (Exception e) {
            e.printStackTrace();
            String attrsJSON = "error";
            resp.setContentType("text/plain");
            resp.getOutputStream().write(attrsJSON.getBytes());
            resp.getOutputStream().close();
        }
    }

    public MoSAMLSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoSAMLSettings settings) {
        this.settings = settings;
    }

    public MoMetadataJobRunnerImpl getMetadataJobRunnerImpl() {
        return this.metadataJobRunnerImpl;
    }

    public void setMetadataJobRunnerImpl(MoMetadataJobRunnerImpl metadataJobRunnerImpl) {
        this.metadataJobRunnerImpl = metadataJobRunnerImpl;
    }
}

