/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.bamboo.servlet;

import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.miniorange.sso.saml.bamboo.MoSAMLManager;
import com.miniorange.sso.saml.bamboo.MoSAMLSettings;
import com.miniorange.sso.saml.utils.MoHttpRequestWrapper;
import com.miniorange.sso.saml.utils.MoSAMLUtils;
import java.io.BufferedReader;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class MoLoginInterceptorFilter
implements Filter {
    private static final Log LOGGER = LogFactory.getLog(MoLoginInterceptorFilter.class);
    private LoginUriProvider loginUriProvider;
    private MoSAMLManager samlManager;
    private MoSAMLSettings settings;

    @Autowired
    public MoLoginInterceptorFilter(MoSAMLManager samlManager, MoSAMLSettings settings, LoginUriProvider loginUriProvider) {
        this.settings = settings;
        this.loginUriProvider = loginUriProvider;
        this.samlManager = samlManager;
    }

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        MoHttpRequestWrapper wrappedRequest = new MoHttpRequestWrapper(req);
        String requestBody = this.readRequestBody((HttpServletRequest)wrappedRequest);
        String username = MoSAMLUtils.sanitizeText(request.getParameter("os_username"));
        if (request.getParameter("os_username") == null) {
            username = request.getParameter("username");
        }
        String bambooCaptcha = MoSAMLUtils.sanitizeText(request.getParameter("os_captcha"));
        if (username == null && !requestBody.isEmpty()) {
            JSONObject jsonObject = new JSONObject(requestBody);
            username = jsonObject.optString("username");
            bambooCaptcha = jsonObject.optString("captchaId");
        }
        if (bambooCaptcha == "") {
            bambooCaptcha = null;
        }
        LOGGER.debug((Object)("Username get from the request " + username));
        String referer = req.getHeader("referer");
        LOGGER.debug((Object)("referer value :" + referer));
        if (referer != null && referer.contains("saml_sso=false") && StringUtils.isNotEmpty(username) && !this.canUseLocalCredentialsForBackdoorAccess(username).booleanValue()) {
            res.sendRedirect(this.settings.getLoginPageUrl() + "?sign_in_error=true");
            return;
        }
        if (!this.settings.getRestrictLocalAuthentication().booleanValue()) {
            chain.doFilter((ServletRequest)wrappedRequest, (ServletResponse)res);
            return;
        }
        try {
            String backdoorKey = MoSAMLUtils.sanitizeText(this.settings.getBackdoorKey());
            String backdoorValue = MoSAMLUtils.sanitizeText(this.settings.getBackdoorValue());
            Boolean backdoorEnabled = this.settings.getBackdoorEnabled();
            Boolean backdoor = false;
            if (MoSAMLUtils.sanitizeText(request.getParameter(backdoorKey)) != null) {
                backdoor = MoSAMLUtils.sanitizeText(request.getParameter(backdoorKey)).equals(backdoorValue);
            }
            if (!(!this.settings.isLicenseValid().booleanValue() || backdoorEnabled.booleanValue() && backdoor.booleanValue())) {
                if (username == null) {
                    chain.doFilter((ServletRequest)req, (ServletResponse)res);
                    return;
                }
                if ((referer != null && referer.contains("saml_sso=false") || bambooCaptcha != null) && this.settings.getBackdoorEnabled().booleanValue()) {
                    if (StringUtils.isNotEmpty(username) && !this.canUseLocalCredentialsForBackdoorAccess(username).booleanValue()) {
                        Cookie c = new Cookie("mo.bamboo-sso.restrictLocalAuthentication", "true");
                        c.setMaxAge(60);
                        res.addCookie(c);
                        res.sendRedirect(this.settings.getLoginPageUrl() + "?sign_in_error=true");
                        return;
                    }
                } else if (StringUtils.isNotEmpty(username) && !this.canUseLocalCredentials(username).booleanValue()) {
                    LOGGER.debug((Object)"user is not authorized to access, redirecting user");
                    Cookie c = new Cookie("mo.bamboo-sso.restrictLocalAuthentication", "true");
                    c.setMaxAge(60);
                    res.addCookie(c);
                    res.sendRedirect(this.settings.getLoginPageUrl() + "?sign_in_error=true");
                    return;
                }
            }
            chain.doFilter((ServletRequest)wrappedRequest, response);
        }
        catch (Exception e) {
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
        }
    }

    private String readRequestBody(HttpServletRequest request) throws IOException {
        String line;
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader reader = request.getReader();
        while ((line = reader.readLine()) != null) {
            stringBuilder.append(line);
        }
        return stringBuilder.toString();
    }

    public void destroy() {
    }

    public Boolean canUseLocalCredentialsForBackdoorAccess(String username) {
        try {
            if (this.settings.getRestrictBackdoor().booleanValue() && !this.samlManager.checkUserPresentInRestrictBackdoorGroups(username).booleanValue()) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error occurred in canUseLocalCredentialsForBackdoorAccess " + e));
            return Boolean.TRUE;
        }
    }

    private Boolean canUseLocalCredentials(String username) {
        try {
            LOGGER.debug((Object)"Check if user is authorized to login using local credentials");
            String idpName = this.samlManager.processRedirectionRulesAndReturnIDP(username);
            LOGGER.debug((Object)(this.settings.getDefaultBambooIDP() + " idpname " + idpName));
            if (StringUtils.equals(this.settings.getDefaultBambooIDP(), idpName) || StringUtils.equalsIgnoreCase(idpName, "loginPage")) {
                return Boolean.TRUE;
            }
            if (this.settings.getRestrictLocalAuthentication().booleanValue() && StringUtils.equals(this.settings.getDefaultBambooIDP(), "loginPage")) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        catch (Exception e) {
            LOGGER.error((Object)"An error occurred while getting the user's IDP");
            e.printStackTrace();
            return Boolean.FALSE;
        }
    }
}

