/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.bamboo.action;

import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import com.google.gson.Gson;
import com.miniorange.sso.saml.bamboo.MoSAMLSettings;
import com.opencsv.CSVReader;
import com.opencsv.exceptions.CsvValidationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.struts2.interceptor.parameter.StrutsParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoKnowledgeBaseAction
extends BambooActionSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoKnowledgeBaseAction.class);
    private static final String faqs_csv = "csv/miniorange_saml_faq.csv";
    private List<Map<String, String>> faqData;
    private String faqJsonData;
    private List<String> idpList = new ArrayList<String>();
    private int faqsPerPage = 6;
    private int currentPage = 1;
    private MoSAMLSettings settings;

    @PermittedMethods(value={HttpMethod.GET, HttpMethod.POST})
    public String execute() throws Exception {
        LOGGER.debug("Loading Knowledge Base and FAQ data");
        this.parseFaqData();
        if (this.settings != null) {
            this.idpList = this.settings.getIdPList();
        }
        return "success";
    }

    private void parseFaqData() {
        LOGGER.debug("Starting to load FAQ data");
        this.faqData = new ArrayList<Map<String, String>>();
        try (InputStream csvStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(faqs_csv);){
            if (csvStream == null) {
                LOGGER.error("FAQ CSV file not found at {}", (Object)faqs_csv);
                this.setFaqJsonData("[]");
                return;
            }
            LOGGER.debug("CSV file found and opened successfully");
            try (CSVReader csvReader = new CSVReader((Reader)new InputStreamReader(csvStream, StandardCharsets.UTF_8));){
                CharSequence[] line;
                boolean isHeader = true;
                LOGGER.debug("Started reading CSV file");
                while ((line = csvReader.readNext()) != null) {
                    if (isHeader) {
                        isHeader = false;
                        LOGGER.debug("Skipping header row");
                        continue;
                    }
                    if (line.length >= 3) {
                        LOGGER.debug("Processing FAQ row: heading={}", (Object)line[0]);
                        HashMap<String, String> faq = new HashMap<String, String>();
                        faq.put("heading", ((String)line[0]).trim());
                        faq.put("summary", ((String)line[1]).trim());
                        faq.put("readMoreLink", ((String)line[2]).trim());
                        this.faqData.add(faq);
                        continue;
                    }
                    LOGGER.warn("Skipping invalid FAQ row: {}", (Object)String.join((CharSequence)", ", line));
                }
                this.setFaqJsonData(!this.faqData.isEmpty() ? new Gson().toJson(this.faqData) : "[]");
                LOGGER.debug("Successfully loaded {} FAQ entries", (Object)this.faqData.size());
            }
            catch (CsvValidationException | IOException e) {
                LOGGER.error("Error reading FAQ CSV", e);
                this.setFaqJsonData("[]");
            }
        }
        catch (IOException e) {
            LOGGER.error("Error opening FAQ CSV resource", (Throwable)e);
            this.setFaqJsonData("[]");
        }
        LOGGER.debug("FAQ data loading completed");
    }

    @StrutsParameter
    public List<Map<String, String>> getFaqData() {
        LOGGER.debug("Returning FAQ data list with {} entries", (Object)(this.faqData != null ? this.faqData.size() : 0));
        return this.faqData;
    }

    @StrutsParameter
    public String getFaqJsonData() {
        LOGGER.debug("Returning FAQ JSON data");
        return this.faqJsonData != null ? this.faqJsonData : "[]";
    }

    @StrutsParameter
    public void setFaqJsonData(String faqJsonData) {
        this.faqJsonData = faqJsonData;
        LOGGER.debug("Set FAQ JSON data");
    }

    @StrutsParameter
    public List<String> getIdpList() {
        return this.idpList;
    }

    @StrutsParameter
    public void setIdpList(List<String> idpList) {
        this.idpList = idpList;
    }

    @StrutsParameter
    public MoSAMLSettings getSettings() {
        return this.settings;
    }

    @StrutsParameter
    public void setSettings(MoSAMLSettings settings) {
        this.settings = settings;
    }

    @StrutsParameter
    public int getFaqsPerPage() {
        return this.faqsPerPage;
    }

    @StrutsParameter
    public int getCurrentPage() {
        return this.currentPage;
    }
}

