/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.bamboo.action;

import com.atlassian.bamboo.security.xsrf.XsrfTokenUtils;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.plugin.PluginException;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.miniorange.sso.saml.bamboo.MoPluginHandler;
import com.miniorange.sso.saml.bamboo.MoSAMLSettings;
import com.miniorange.sso.saml.utils.MoSAMLUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.interceptor.parameter.StrutsParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoCustomCertificatesAction
extends BambooActionSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoCustomCertificatesAction.class);
    private UserManager userManager;
    private String publicSPCertificate;
    private String privateSPCertificate;
    private Boolean certificateSubmitted;
    private MoSAMLSettings settings;
    private String xsrfToken;
    private LoginUriProvider loginUriProvider;
    private String emailAdsress;
    private String companyName;
    private String orgUnit;
    private String locationName;
    private String countryCode;
    private String validityDays;

    public MoCustomCertificatesAction(UserManager userManager, MoSAMLSettings settings, LoginUriProvider loginUriProvider) {
        this.userManager = userManager;
        this.settings = settings;
        this.loginUriProvider = loginUriProvider;
    }

    public void validate() {
        HttpServletRequest request = ServletActionContext.getRequest();
        if (BooleanUtils.toBoolean((Boolean)this.certificateSubmitted)) {
            if (!StringUtils.isBlank((CharSequence)this.publicSPCertificate) && !MoSAMLUtils.isValidPublicCertificate(this.publicSPCertificate).booleanValue()) {
                this.addActionError("Invalid public certificate.");
            }
            if (!StringUtils.isBlank((CharSequence)this.privateSPCertificate) && !MoSAMLUtils.isValidPrivateCertificate(this.privateSPCertificate).booleanValue()) {
                this.addActionError("Invalid private certificate.");
            }
            if (super.hasActionErrors()) {
                this.xsrfToken = XsrfTokenUtils.getXsrfToken((HttpServletRequest)request);
                this.initializeSAMLConfig();
            }
        }
    }

    public String execute() throws Exception {
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        this.xsrfToken = XsrfTokenUtils.getXsrfToken((HttpServletRequest)request);
        UserProfile user = this.userManager.getRemoteUser();
        if (user != null && this.userManager.isAdmin(user.getUserKey())) {
            try {
                if (!this.settings.isValidLicense().booleanValue()) {
                    return "upm";
                }
                String operation = request.getParameter("operation");
                if ("updated".equalsIgnoreCase(operation)) {
                    this.addActionMessage(this.getText("Public and Private Certificate updated"));
                }
                if (BooleanUtils.toBoolean((Boolean)this.certificateSubmitted) && !this.validateCertificate(this.publicSPCertificate, this.privateSPCertificate).booleanValue()) {
                    MoPluginHandler.saveSPCertificates(this.publicSPCertificate, this.privateSPCertificate);
                    this.addActionMessage(this.getText("samlsso.success.config"));
                }
                this.initializeSAMLConfig();
                return "success";
            }
            catch (PluginException e) {
                e.printStackTrace();
                this.addActionError(e.getMessage());
                return "input";
            }
            catch (Exception e) {
                e.printStackTrace();
                this.addActionError("An error occurred while saving your details. Please check logs for more info.");
                return "input";
            }
        }
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
        return null;
    }

    private void initializeSAMLConfig() {
        this.publicSPCertificate = this.settings.getPublicSPCertificate();
        this.privateSPCertificate = this.settings.getPrivateSPCertificate();
        this.emailAdsress = "";
        this.companyName = "";
        this.countryCode = "";
        this.orgUnit = "";
        this.validityDays = "";
        this.locationName = "";
    }

    Boolean validateCertificate(String publicSPCertificate, String privateSPCertificate) {
        Boolean error = Boolean.FALSE;
        if (StringUtils.isNotBlank((CharSequence)publicSPCertificate) && !MoSAMLUtils.isValidPublicCertificate(publicSPCertificate).booleanValue()) {
            this.addActionError("Invalid public certificate.");
            error = Boolean.TRUE;
        }
        if (StringUtils.isNotBlank((CharSequence)privateSPCertificate) && !MoSAMLUtils.isValidPrivateCertificate(privateSPCertificate).booleanValue()) {
            this.addActionError("Invalid private certificate.");
            error = Boolean.TRUE;
        }
        if (StringUtils.isBlank((CharSequence)privateSPCertificate) || StringUtils.isBlank((CharSequence)publicSPCertificate)) {
            this.addActionError("Certificate cannot be blank.");
            error = Boolean.TRUE;
        }
        return error;
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    @StrutsParameter
    public HashMap<String, String> getIdpMap() {
        return this.settings.getIdpMap();
    }

    @StrutsParameter
    public ArrayList<String> getIdpList() {
        return this.settings.getIdPList();
    }

    @StrutsParameter
    public String getPublicSPCertificate() {
        return this.publicSPCertificate;
    }

    @StrutsParameter
    public void setPublicSPCertificate(String publicSPCertificate) {
        this.publicSPCertificate = publicSPCertificate;
    }

    @StrutsParameter
    public String getPrivateSPCertificate() {
        return this.privateSPCertificate;
    }

    @StrutsParameter
    public void setPrivateSPCertificate(String privateSPCertificate) {
        this.privateSPCertificate = privateSPCertificate;
    }

    @StrutsParameter
    public Boolean getCertificateSubmitted() {
        return this.certificateSubmitted;
    }

    @StrutsParameter
    public void setCertificateSubmitted(Boolean certificateSubmitted) {
        this.certificateSubmitted = certificateSubmitted;
    }

    @StrutsParameter
    public UserManager getUserManager() {
        return this.userManager;
    }

    @StrutsParameter
    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    @StrutsParameter
    public MoSAMLSettings getSettings() {
        return this.settings;
    }

    @StrutsParameter
    public void setSettings(MoSAMLSettings settings) {
        this.settings = settings;
    }

    @StrutsParameter
    public String getXsrfToken() {
        return this.xsrfToken;
    }

    @StrutsParameter
    public void setXsrfToken(String xsrfToken) {
        this.xsrfToken = xsrfToken;
    }

    @StrutsParameter
    public LoginUriProvider getLoginUriProvider() {
        return this.loginUriProvider;
    }

    @StrutsParameter
    public void setLoginUriProvider(LoginUriProvider loginUriProvider) {
        this.loginUriProvider = loginUriProvider;
    }

    @StrutsParameter
    public String getEmailAdsress() {
        return this.emailAdsress;
    }

    @StrutsParameter
    public void setEmailAdsress(String emailAdsress) {
        this.emailAdsress = emailAdsress;
    }

    @StrutsParameter
    public String getCompanyName() {
        return this.companyName;
    }

    @StrutsParameter
    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    @StrutsParameter
    public String getOrgUnit() {
        return this.orgUnit;
    }

    @StrutsParameter
    public void setOrgUnit(String orgUnit) {
        this.orgUnit = orgUnit;
    }

    @StrutsParameter
    public String getLocationName() {
        return this.locationName;
    }

    @StrutsParameter
    public void setLocationName(String locationName) {
        this.locationName = locationName;
    }

    @StrutsParameter
    public String getCountryCode() {
        return this.countryCode;
    }

    @StrutsParameter
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    @StrutsParameter
    public String getValidityDays() {
        return this.validityDays;
    }

    @StrutsParameter
    public void setValidityDays(String validityDays) {
        this.validityDays = validityDays;
    }

    @StrutsParameter
    public Collection<String> getSuccessMessages() {
        Collection successMessages = this.getActionMessages();
        ArrayList<String> encodedSuccessMessages = new ArrayList<String>();
        for (String message : successMessages) {
            encodedSuccessMessages.add(MoSAMLUtils.htmlEncode(message));
        }
        return encodedSuccessMessages;
    }

    @StrutsParameter
    public Collection<String> getErrorMessages() {
        Collection errorMessages = this.getActionErrors();
        ArrayList<String> encodedErrorMessages = new ArrayList<String>();
        for (String message : errorMessages) {
            encodedErrorMessages.add(MoSAMLUtils.htmlEncode(message));
        }
        return encodedErrorMessages;
    }
}

