/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.bamboo.servlet;

import com.atlassian.bamboo.security.xsrf.XsrfTokenUtils;
import com.atlassian.sal.api.user.UserManager;
import com.miniorange.sso.saml.bamboo.MoPluginHandler;
import com.miniorange.sso.saml.bamboo.MoSAMLSettings;
import java.io.File;
import java.io.IOException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.multipart.MultiPartRequestWrapper;
import org.apache.struts2.dispatcher.multipart.UploadedFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoUploadPluginConfigurationServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private MoSAMLSettings settings;
    private String xsrfToken;
    private UserManager userManager;
    private static final Logger LOGGER = LoggerFactory.getLogger(MoUploadPluginConfigurationServlet.class);

    public MoUploadPluginConfigurationServlet(MoSAMLSettings settings, UserManager userManager) {
        this.settings = settings;
        this.userManager = userManager;
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.xsrfToken = XsrfTokenUtils.getXsrfToken((HttpServletRequest)request);
        LOGGER.debug("MoUploadPluginConfigurationServlet: doPost  called");
        MoSAMLSettings.isPluginConfigurationFileUploaded = Boolean.TRUE;
        try {
            this.handleUploadConfigurations(response);
            response.sendRedirect(this.settings.getImportExportPageUrl());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.settings.setSpConfigurationStatus("An error occurred while saving your details.Please check logs for more info.");
            response.sendRedirect(this.settings.getImportExportPageUrl());
        }
    }

    private void handleUploadConfigurations(HttpServletResponse response) throws IOException {
        LOGGER.debug("handleUploadConfigurations called");
        String fileContents = "";
        MultiPartRequestWrapper wrapper = (MultiPartRequestWrapper)ServletActionContext.getRequest();
        UploadedFile[] files = wrapper.getFiles("configFile");
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                UploadedFile file = files[i];
                if (!file.isFile()) continue;
                try {
                    fileContents = FileUtils.readFileToString((File)((File)file.getContent()));
                    if (StringUtils.isEmpty(fileContents)) {
                        this.settings.setSpConfigurationStatus("Uploaded app configuration file is empty.");
                        return;
                    }
                    MoPluginHandler.importConfigurations(fileContents);
                    this.settings.setSpConfigurationStatus("success");
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    LOGGER.debug("exception message = " + e.getMessage());
                    LOGGER.debug("Invalid file is  provided. Could not parse app configuration file.");
                    this.settings.setSpConfigurationStatus("Invalid file is  provided. Could not parse app configuration file.");
                    return;
                }
            }
        }
        LOGGER.debug("An error occurred while uploading the app configuring file.");
        this.settings.setSpConfigurationStatus("An error occurred while uploading the app configuring file.");
    }

    public MoSAMLSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoSAMLSettings settings) {
        this.settings = settings;
    }

    public String getXsrfToken() {
        return this.xsrfToken;
    }

    public void setXsrfToken(String xsrfToken) {
        this.xsrfToken = xsrfToken;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }
}

