/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.bamboo.servlet;

import com.atlassian.json.jsonorg.JSONObject;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.miniorange.sso.saml.bamboo.MoPluginConfigurationsHandler;
import com.miniorange.sso.saml.bamboo.MoPluginHandler;
import com.miniorange.sso.saml.bamboo.MoSAMLSettings;
import com.miniorange.sso.saml.utils.MoHttpUtils;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoFeedbackServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoFeedbackServlet.class);
    private String reason;
    private String feedback_content;
    private String feedback_email;
    private Boolean can_contact;
    private Boolean send_configurations;
    private MoSAMLSettings settings;
    private MoPluginConfigurationsHandler pluginConfigurationsHandler;

    public MoFeedbackServlet(MoSAMLSettings settings, MoPluginConfigurationsHandler pluginConfigurationsHandler) {
        this.settings = settings;
        this.pluginConfigurationsHandler = pluginConfigurationsHandler;
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try {
            LOGGER.debug("Received feedback - reason:" + request.getParameter("reason") + ",feedback_content:" + request.getParameter("feedback_content") + ",feedback_email:" + request.getParameter("feedback_email") + ",can_contact:" + request.getParameter("can_contact"));
            this.reason = request.getParameter("reason");
            this.feedback_content = (String)StringUtils.defaultIfEmpty((CharSequence)request.getParameter("feedback_content"), (CharSequence)"");
            this.feedback_email = (String)StringUtils.defaultIfEmpty((CharSequence)request.getParameter("feedback_email"), (CharSequence)"");
            this.can_contact = BooleanUtils.toBoolean((String)request.getParameter("can_contact"));
            this.send_configurations = BooleanUtils.toBoolean((String)request.getParameter("send_configurations"));
            LOGGER.debug("Sending feedback - reason:" + this.reason + " ,feedback_content:" + this.feedback_content + ",feedback_email:" + this.feedback_email + ",send_configurations");
            String content = new String();
            String canContact = this.can_contact != false ? "yes" : "no";
            content = content + "Hello,<br><br>Email: " + this.feedback_email + "<br><br>Can contact: " + canContact + "<br><br>Plugin Name: " + "Bamboo SAML 1.1.19";
            content = !this.reason.equalsIgnoreCase("Select Reason") ? content + "<br><br>Reason for feedback: " + this.reason : content + "<br><br>Reason for feedback: Not selected. ";
            content = content + "<br><br>Details: " + this.feedback_content;
            try {
                if (this.send_configurations.booleanValue()) {
                    content = content + "<br><br>Plugin configurations : <br><br>";
                    Gson gson = new GsonBuilder().setPrettyPrinting().create();
                    JsonParser jp = new JsonParser();
                    JsonObject je = (JsonObject)jp.parse(this.pluginConfigurationsHandler.generateConfigurationsJson());
                    je.getAsJsonObject("Sign In Settings").remove("Logout Template");
                    je.getAsJsonObject("Sign In Settings").remove("Error Message Template");
                    je.getAsJsonObject("Sign In Settings").remove("Login Template");
                    content = this.returnJsonString(je, content);
                } else {
                    content = content + "<br><br>Plugin configurations: Not sent.";
                }
            }
            catch (Exception e) {
                LOGGER.debug("Error :" + e.toString());
            }
            content = content + "<br><br>Thanks<br>Atlassian Admin";
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("customerKey", "16555");
            jsonObject.put("sendEmail", true);
            JSONObject emailObject = new JSONObject();
            emailObject.put("customerKey", "16555");
            emailObject.put("fromEmail", "no-reply@xecurify.com");
            emailObject.put("bccEmail", "no-reply@xecurify.com");
            emailObject.put("fromName", "miniOrange");
            emailObject.put("toEmail", "atlassiansupport@xecurify.com");
            emailObject.put("toName", "atlassiansupport@xecurify.com");
            emailObject.put("bccEmail", "atlassiansupport@xecurify.com");
            emailObject.put("subject", "Feedback for Bamboo SAML 1.1.19");
            emailObject.put("content", content);
            jsonObject.put("email", emailObject);
            String json = jsonObject.toString();
            String response1 = MoHttpUtils.sendPostRequest("https://auth.miniorange.com/moas/api/notify/send", json, "application/json", MoPluginHandler.getAuthorizationHeaders(Long.valueOf("16555"), "fFd2XcvTGDemZvbw1bcUesNJWEqKbbUq"));
            LOGGER.debug("Send_feedback response: " + response1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String returnJsonString(JsonObject jsonObject, String content) {
        for (Map.Entry entry : jsonObject.entrySet()) {
            if (((String)entry.getKey()).equalsIgnoreCase("Identity Providers")) {
                JsonArray idps = ((JsonElement)entry.getValue()).getAsJsonArray();
                for (int idpCount = 0; idpCount < idps.size(); ++idpCount) {
                    JsonObject idpConfigurations = (JsonObject)idps.get(idpCount);
                    for (Map.Entry subEntry : idpConfigurations.entrySet()) {
                        content = content + "<b>" + (String)subEntry.getKey() + " : </b>" + subEntry.getValue() + "<br>";
                    }
                    content = content + "<br>";
                }
                continue;
            }
            content = content + entry + "<br><br>";
        }
        return content;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getFeedback_content() {
        return this.feedback_content;
    }

    public void setFeedback_content(String feedback_content) {
        this.feedback_content = feedback_content;
    }

    public String getFeedback_email() {
        return this.feedback_email;
    }

    public void setFeedback_email(String feedback_email) {
        this.feedback_email = feedback_email;
    }

    public Boolean getCan_contact() {
        return this.can_contact;
    }

    public void setCan_contact(Boolean can_contact) {
        this.can_contact = can_contact;
    }

    public Boolean getSend_configurations() {
        return this.send_configurations;
    }

    public void setSend_configurations(Boolean send_configurations) {
        this.send_configurations = send_configurations;
    }
}

