/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.bamboo.schedulers;

import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.scheduler.status.JobDetails;
import com.miniorange.sso.saml.bamboo.MoPluginHandler;
import com.miniorange.sso.saml.bamboo.MoSAMLSettings;
import com.miniorange.sso.saml.dto.MoIDPConfig;
import com.miniorange.sso.saml.utils.MoHttpUtils;
import com.miniorange.sso.saml.utils.MoSAMLUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class MoMetadataJobRunnerImpl
implements JobRunner,
InitializingBean,
DisposableBean {
    private static final Random RANDOM = new Random();
    private long SCHEDULE_BASE_INTERVAL_MILLIS = 120000L;
    private static final int SCHEDULE_MAX_JITTER = 10000;
    private static final String JOB_ID_PREFIX = "Job ID =";
    public static final String KEY = MoMetadataJobRunnerImpl.class.getName() + ":instance";
    public static final String JOB_NAME = MoMetadataJobRunnerImpl.class.getName() + ":job";
    public static final String IDP_KEY = MoMetadataJobRunnerImpl.class.getName() + ":idp";
    private final SchedulerService schedulerService;
    private final MoSAMLSettings settings;

    public MoMetadataJobRunnerImpl(SchedulerService schedulerService, MoSAMLSettings settings) {
        this.schedulerService = schedulerService;
        this.settings = settings;
    }

    public void createSchedule(String jobID, long intervalInMillis) throws Exception {
        int jitter = RANDOM.nextInt(10000);
        Date firstRun = new Date(System.currentTimeMillis() + (long)jitter);
        JobRunnerKey JOB = JobRunnerKey.of((String)(MoMetadataJobRunnerImpl.class.getName() + jobID));
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)JOB).withSchedule(Schedule.forInterval((long)intervalInMillis, (Date)firstRun)).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER);
        try {
            JobId jobId = MoMetadataJobRunnerImpl.toJobId(jobID);
            JobDetails existing = this.schedulerService.getJobDetails(jobId);
            if (existing != null) {
                this.schedulerService.unscheduleJob(jobId);
            }
            this.schedulerService.scheduleJob(jobId, jobConfig);
        }
        catch (SchedulerServiceException sse) {
            throw new Exception("Unable to create schedule for job ID '" + jobID + '\'', sse);
        }
    }

    public void deleteSchedule(String jobID) throws Exception {
        JobId jobId = MoMetadataJobRunnerImpl.toJobId(jobID);
        JobRunnerKey JOB = JobRunnerKey.of((String)(MoMetadataJobRunnerImpl.class.getName() + jobID));
        JobDetails jobDetails = this.schedulerService.getJobDetails(jobId);
        if (jobDetails != null) {
            if (!JOB.equals((Object)jobDetails.getJobRunnerKey())) {
                throw new Exception("JobId '" + jobID + "' does not belong to me!");
            }
            this.schedulerService.unscheduleJob(jobId);
        }
    }

    private static JobId toJobId(String jobID) {
        return JobId.of((String)jobID);
    }

    public JobRunnerResponse runJob(JobRunnerRequest request) {
        try {
            String metadataUrl = "";
            String idpID = request.getJobId().toString();
            MoIDPConfig idpConfig = MoPluginHandler.constructIdpConfigObject(idpID.trim());
            if (idpConfig == null) {
                metadataUrl = this.settings.getIdpMetadataURL();
                if (StringUtils.isNotBlank((CharSequence)metadataUrl)) {
                    String metadata;
                    if (this.settings.getRefreshMetadata().booleanValue() && StringUtils.isNotBlank((CharSequence)metadataUrl) && StringUtils.isNotBlank((CharSequence)(metadata = MoHttpUtils.sendGetRequest(metadataUrl)))) {
                        MoPluginHandler.configureFromMetadata("miniorange.saml.DEFAULT_IDP_ID", "IDP", metadata, this.settings.getRefreshMetadata());
                    }
                } else {
                    this.deleteSchedule("miniorange.saml.DEFAULT_IDP_ID");
                }
            } else {
                metadataUrl = idpConfig.getInputUrl();
                if (StringUtils.isNotBlank((CharSequence)metadataUrl)) {
                    String metadata;
                    if (idpConfig.getRefreshMetadata().booleanValue() && StringUtils.isNotBlank((CharSequence)metadataUrl) && StringUtils.isNotBlank((CharSequence)(metadata = MoHttpUtils.sendGetRequest(metadataUrl)))) {
                        MoPluginHandler.configureFromMetadata(idpID, idpConfig.getIdpName(), metadata, true);
                    }
                } else {
                    this.deleteSchedule(idpID);
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return null;
    }

    public void schedule(int interval, MoIDPConfig idpConfig) throws Exception {
        String jobID = idpConfig.getId();
        JobRunnerKey JOB = JobRunnerKey.of((String)(MoMetadataJobRunnerImpl.class.getName() + jobID));
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(12, interval);
        long refreshIntervalInMiliseconds = Integer.toUnsignedLong(interval * 60 * 1000);
        this.schedulerService.registerJobRunner(JOB, (JobRunner)this);
        this.createSchedule(idpConfig.getId(), refreshIntervalInMiliseconds);
    }

    public void destroy() throws Exception {
        JobRunnerKey JOB = JobRunnerKey.of((String)MoMetadataJobRunnerImpl.class.getName());
        this.schedulerService.unregisterJobRunner(JOB);
        this.deleteSchedule("miniorange.saml.DEFAULT_IDP_ID");
    }

    public void afterPropertiesSet() throws Exception {
        JobRunnerKey JOB = JobRunnerKey.of((String)MoMetadataJobRunnerImpl.class.getName());
        this.schedulerService.registerJobRunner(JOB, (JobRunner)this);
        if (this.settings != null && StringUtils.isNotBlank((CharSequence)this.settings.getIdpMetadataURL()) && BooleanUtils.toBoolean((Boolean)this.settings.getRefreshMetadata())) {
            int interval = MoSAMLUtils.getMetadataRefreshInterval(this.settings.getRefreshInterval(), this.settings.getCustomRefreshInterval(), this.settings.getCustomRefreshIntervalUnit());
            this.createSchedule("miniorange.saml.DEFAULT_IDP_ID", interval);
        }
    }

    public SchedulerService getSchedulerService() {
        return this.schedulerService;
    }

    public MoSAMLSettings getSettings() {
        return this.settings;
    }
}

