/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.bamboo.action;

import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.miniorange.sso.saml.MoPluginException;
import com.miniorange.sso.saml.bamboo.MoPluginHandler;
import com.miniorange.sso.saml.bamboo.MoSAMLSettings;
import com.miniorange.sso.saml.dto.MoIDPConfig;
import com.miniorange.sso.saml.utils.MoSAMLUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.interceptor.parameter.StrutsParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoOverviewAction
extends BambooActionSupport {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MoOverviewAction.class);
    private String idpID;
    private String idpName;
    private String idpEntityId;
    private String ssoUrl;
    private String ssoBindingType;
    private String sloUrl;
    private String sloBindingType;
    private String x509Certificate;
    private String signedRequest;
    private String username;
    private String email;
    private String useSeparateNameAttribute;
    private String fullName;
    private String firstNameAttribute;
    private String lastNameAttribute;
    private String keepExistingUserAttributes;
    private String regexPattern;
    private String regexPatternEnabled;
    private String loginUserAttribute;
    private Map<String, String> customAttributeMapping;
    private String roleAttribute;
    private String createUsersIfRoleMapped;
    private String keepExistingUserRoles;
    private HashMap<String, String> roleMapping;
    private List<String> defaultGroups;
    private String enableDefaultGroupsFor;
    private String onTheFlyGroupMapping;
    private String createNewGroups;
    private String onTheFlyAssignNewGroupsOnly;
    private String onTheFlyDoNotRemoveGroups;
    private List<String> onTheFlyDoNotRemoveGroupsList;
    private List<String> certificates;
    private int numberOfCertificates;
    private MoIDPConfig idpConfig;
    private MoSAMLSettings settings;
    private MoPluginHandler pluginHandler;
    private UserManager userManager;
    private LoginUriProvider loginUriProvider;
    private Map<String, String> certificateInfo;

    public MoOverviewAction(MoSAMLSettings settings, MoPluginHandler pluginHandler, MoIDPConfig idpConfig, UserManager userManager, LoginUriProvider loginUriProvider) {
        this.settings = settings;
        this.pluginHandler = pluginHandler;
        this.idpConfig = idpConfig;
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
    }

    public void validate() {
        LOGGER.info("Overview Action doValidate called");
        super.validate();
    }

    public String execute() throws Exception {
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        UserProfile user = this.userManager.getRemoteUser();
        if (user != null && this.userManager.isAdmin(user.getUserKey())) {
            try {
                if (!this.settings.isValidLicense().booleanValue()) {
                    LOGGER.error("No valid license found");
                    return "upm";
                }
                if (StringUtils.isBlank((CharSequence)this.idpID) && StringUtils.isNotBlank((CharSequence)request.getParameter("idpid"))) {
                    this.idpID = request.getParameter("idpid");
                }
                if (StringUtils.isBlank((CharSequence)this.idpID)) {
                    this.idpID = "miniorange.saml.DEFAULT_IDP_ID";
                }
                this.initializeIDPConfig();
                return "success";
            }
            catch (MoPluginException e) {
                LOGGER.error("An error occurred while saving your details. Please check logs for more info.", (Throwable)e);
                this.addActionError(e.getMessage());
                return "input";
            }
        }
        LOGGER.error("In the else part");
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
        return null;
    }

    private void initializeIDPConfig() {
        this.idpConfig = MoPluginHandler.constructIdpConfigObject(this.idpID);
        if (this.idpConfig == null) {
            this.initializeNewForm();
            return;
        }
        this.idpID = this.idpConfig.getId();
        this.idpName = this.idpConfig.getIdpName();
        this.idpEntityId = this.idpConfig.getIdpEntityId();
        this.ssoUrl = this.idpConfig.getSsoUrl();
        this.ssoBindingType = this.replaceString(this.idpConfig.getSsoBindingType());
        this.sloBindingType = this.replaceString(this.idpConfig.getSloBindingType());
        this.x509Certificate = (String)StringUtils.defaultIfBlank((CharSequence)this.idpConfig.getX509Certificate(), (CharSequence)"");
        this.sloUrl = this.idpConfig.getSloUrl();
        this.signedRequest = BooleanUtils.toStringYesNo((Boolean)this.idpConfig.getSignedRequest());
        this.username = this.idpConfig.getUsernameAttribute();
        this.email = this.idpConfig.getEmailAttribute();
        this.useSeparateNameAttribute = BooleanUtils.toStringYesNo((Boolean)this.idpConfig.getUseSeparateNameAttributes());
        this.fullName = this.idpConfig.getFullNameAttribute();
        this.firstNameAttribute = this.idpConfig.getFirstNameAttribute();
        this.lastNameAttribute = this.idpConfig.getLastNameAttribute();
        this.keepExistingUserAttributes = BooleanUtils.toStringYesNo((Boolean)this.idpConfig.getKeepExistingUserAttributes());
        this.regexPattern = this.idpConfig.getRegexPattern();
        this.regexPatternEnabled = BooleanUtils.toStringYesNo((Boolean)this.idpConfig.getRegexPatternEnabled());
        this.loginUserAttribute = this.idpConfig.getLoginUserAttribute();
        this.roleAttribute = this.idpConfig.getRoleAttribute();
        this.createUsersIfRoleMapped = BooleanUtils.toStringYesNo((Boolean)this.idpConfig.getCreateUsersIfRoleMapped());
        this.keepExistingUserRoles = BooleanUtils.toStringYesNo((Boolean)this.idpConfig.getKeepExistingUserRoles());
        this.roleMapping = this.idpConfig.getRoleMapping();
        this.defaultGroups = this.idpConfig.getDefaultGroupsList();
        this.enableDefaultGroupsFor = this.replaceString(this.idpConfig.getEnableDefaultGroupsFor());
        this.onTheFlyGroupMapping = BooleanUtils.toStringYesNo((Boolean)this.idpConfig.getOnTheFlyGroupCreation());
        this.createNewGroups = BooleanUtils.toStringYesNo((Boolean)this.idpConfig.getCreateNewGroups());
        this.onTheFlyAssignNewGroupsOnly = BooleanUtils.toStringYesNo((Boolean)this.idpConfig.getOnTheFlyAssignNewGroupsOnly());
        this.onTheFlyDoNotRemoveGroupsList = this.idpConfig.getOnTheFlyDoNotRemoveGroups();
        this.certificates = this.idpConfig.getCertificates();
        this.numberOfCertificates = this.idpConfig.getCertificates().size();
    }

    private void initializeNewForm() {
        this.idpName = "";
        this.idpEntityId = "";
        this.ssoUrl = "";
        this.ssoBindingType = "Http-redirect";
        this.sloUrl = "";
        this.sloBindingType = "Http-redirect";
        this.x509Certificate = "";
        this.x509Certificate = "";
        this.signedRequest = BooleanUtils.toStringYesNo((Boolean)this.settings.getSignedRequest());
        this.username = this.settings.getUsernameAttribute();
        this.email = this.settings.getEmailAttribute();
        this.useSeparateNameAttribute = BooleanUtils.toStringYesNo((Boolean)this.settings.getUseSeparateNameAttributes());
        this.fullName = this.settings.getFullNameAttribute();
        this.firstNameAttribute = "";
        this.lastNameAttribute = "";
        this.keepExistingUserAttributes = BooleanUtils.toStringYesNo((Boolean)this.settings.getKeepExistingUserAttributes());
        this.regexPattern = "";
        this.regexPatternEnabled = BooleanUtils.toStringYesNo((Boolean)this.settings.getRegexPatternEnabled());
        this.loginUserAttribute = this.settings.getLoginUserAttribute();
        this.roleAttribute = this.settings.getRoleAttribute();
        this.createUsersIfRoleMapped = BooleanUtils.toStringYesNo((Boolean)this.settings.getCreateUsersIfRoleMapped());
        this.keepExistingUserRoles = BooleanUtils.toStringYesNo((Boolean)this.settings.getKeepExistingUserRoles());
        this.roleMapping = this.settings.getRoleMapping();
        this.defaultGroups = (List)this.settings.getDefaultGroups();
        this.enableDefaultGroupsFor = this.replaceString(this.settings.getEnableDefaultGroupsFor());
        this.onTheFlyGroupMapping = BooleanUtils.toStringYesNo((Boolean)this.settings.getOnTheFlyGroupMapping());
        this.createNewGroups = BooleanUtils.toStringYesNo((Boolean)this.settings.getCreateNewGroups());
        this.onTheFlyAssignNewGroupsOnly = BooleanUtils.toStringYesNo((Boolean)this.settings.getOnTheFlyAssignNewGroupsOnly());
        this.onTheFlyDoNotRemoveGroupsList = (List)this.settings.getOnTheFlyDoNotRemoveGroups();
        try {
            this.certificates = this.idpConfig.getCertificates();
            this.numberOfCertificates = this.idpConfig.getCertificates().size();
        }
        catch (Exception e) {
            LOGGER.debug("IDP CONFIG:" + this.idpConfig);
            LOGGER.debug("certificate issue :" + e);
        }
    }

    private URI getUri(HttpServletRequest request) {
        try {
            StringBuffer builder = request.getRequestURL();
            if (request.getQueryString() != null) {
                builder.append("?");
                builder.append(request.getQueryString());
            }
            return URI.create(builder.toString());
        }
        catch (Exception e) {
            LOGGER.debug("get uri error");
            return null;
        }
    }

    private String replaceString(String replace) {
        String value = "";
        switch (replace) {
            case "HttpRedirect": {
                value = "Http-redirect";
                break;
            }
            case "HttpPost": {
                value = "Http-post";
                break;
            }
            case "newUsers": {
                value = "New Users";
                break;
            }
            case "allUsers": {
                value = "All Users";
                break;
            }
            case "doNotAssignDefaultGroup": {
                value = "None";
            }
        }
        return value;
    }

    @StrutsParameter
    public static Logger getLOGGER() {
        return LOGGER;
    }

    @StrutsParameter
    public String getIdpID() {
        return this.idpID;
    }

    @StrutsParameter
    public String getIdpName() {
        return this.idpName;
    }

    @StrutsParameter
    public String getIdpEntityId() {
        return this.idpEntityId;
    }

    @StrutsParameter
    public String getSsoUrl() {
        return this.ssoUrl;
    }

    @StrutsParameter
    public String getSsoBindingType() {
        return this.ssoBindingType;
    }

    @StrutsParameter
    public String getSloUrl() {
        return this.sloUrl;
    }

    @StrutsParameter
    public String getSloBindingType() {
        return this.sloBindingType;
    }

    @StrutsParameter
    public String getUsername() {
        return this.username;
    }

    @StrutsParameter
    public String getEmail() {
        return this.email;
    }

    @StrutsParameter
    public String getUseSeparateNameAttribute() {
        return this.useSeparateNameAttribute;
    }

    @StrutsParameter
    public String getFullName() {
        return this.fullName;
    }

    @StrutsParameter
    public String getFirstNameAttribute() {
        return this.firstNameAttribute;
    }

    @StrutsParameter
    public String getLastNameAttribute() {
        return this.lastNameAttribute;
    }

    @StrutsParameter
    public String getKeepExistingUserAttributes() {
        return this.keepExistingUserAttributes;
    }

    @StrutsParameter
    public String getRegexPattern() {
        return this.regexPattern;
    }

    @StrutsParameter
    public String getRegexPatternEnabled() {
        return this.regexPatternEnabled;
    }

    @StrutsParameter
    public Map<String, String> getCustomAttributeMapping() {
        return this.customAttributeMapping;
    }

    @StrutsParameter
    public String getLoginUserAttribute() {
        return this.loginUserAttribute;
    }

    @StrutsParameter
    public String getRoleAttribute() {
        return this.roleAttribute;
    }

    @StrutsParameter
    public String getCreateUsersIfRoleMapped() {
        return this.createUsersIfRoleMapped;
    }

    @StrutsParameter
    public String getKeepExistingUserRoles() {
        return this.keepExistingUserRoles;
    }

    @StrutsParameter
    public HashMap<String, String> getRoleMapping() {
        return this.roleMapping;
    }

    @StrutsParameter
    public List<String> getDefaultGroups() {
        return this.defaultGroups;
    }

    @StrutsParameter
    public String getEnableDefaultGroupsFor() {
        return this.enableDefaultGroupsFor;
    }

    @StrutsParameter
    public String getOnTheFlyGroupMapping() {
        return this.onTheFlyGroupMapping;
    }

    @StrutsParameter
    public MoIDPConfig getIdpConfig() {
        return this.idpConfig;
    }

    @StrutsParameter
    public MoSAMLSettings getSettings() {
        return this.settings;
    }

    @StrutsParameter
    public MoPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    @StrutsParameter
    public Map<String, String> getCertificateInfo() {
        return MoSAMLUtils.getCertificateInfo(this.settings.getPublicSPCertificate());
    }

    @StrutsParameter
    public String getX509Certificate() {
        return this.x509Certificate;
    }

    @StrutsParameter
    public void setCertificateInfo(Map<String, String> certificateInfo) {
        this.certificateInfo = certificateInfo;
    }

    @StrutsParameter
    public String getSignedRequest() {
        return this.signedRequest;
    }

    @StrutsParameter
    public String getCreateNewGroups() {
        return this.createNewGroups;
    }

    @StrutsParameter
    public String getOnTheFlyAssignNewGroupsOnly() {
        return this.onTheFlyAssignNewGroupsOnly;
    }

    @StrutsParameter
    public String getOnTheFlyDoNotRemoveGroups() {
        return this.onTheFlyDoNotRemoveGroups;
    }

    @StrutsParameter
    public List<String> getOnTheFlyDoNotRemoveGroupsList() {
        return this.onTheFlyDoNotRemoveGroupsList;
    }

    @StrutsParameter
    public List<String> getCertificates() {
        return this.certificates;
    }

    @StrutsParameter
    public void setCertificates(List<String> certificates) {
        this.certificates = certificates;
    }

    @StrutsParameter
    public int getNumberOfCertificates() {
        return this.numberOfCertificates;
    }

    @StrutsParameter
    public void setNumberOfCertificates(int numberOfCertificates) {
        this.numberOfCertificates = numberOfCertificates;
    }

    @StrutsParameter
    public Collection<String> getSuccessMessages() {
        Collection successMessages = this.getActionMessages();
        ArrayList<String> encodedSuccessMessages = new ArrayList<String>();
        for (String message : successMessages) {
            encodedSuccessMessages.add(MoSAMLUtils.htmlEncode(message));
        }
        return encodedSuccessMessages;
    }

    @StrutsParameter
    public Collection<String> getErrorMessages() {
        Collection errorMessages = this.getActionErrors();
        ArrayList<String> encodedErrorMessages = new ArrayList<String>();
        for (String message : errorMessages) {
            encodedErrorMessages.add(MoSAMLUtils.htmlEncode(message));
        }
        return encodedErrorMessages;
    }
}

