/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.bamboo.action;

import com.atlassian.bamboo.security.xsrf.XsrfTokenUtils;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.miniorange.sso.saml.MoPluginException;
import com.miniorange.sso.saml.bamboo.MoPluginHandler;
import com.miniorange.sso.saml.bamboo.MoSAMLSettings;
import com.miniorange.sso.saml.utils.MoSAMLUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.interceptor.parameter.StrutsParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoIdpListAction
extends BambooActionSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoIdpListAction.class);
    private MoSAMLSettings settings;
    private UserManager userManager;
    private LoginUriProvider loginUriProvider;
    private ArrayList<String> idpList;
    private HashMap<String, String> idpMap;
    private Boolean domainsSubmitted;
    private String[] domains;
    private List<String> domainsList;
    private Boolean useDomainMapping;
    private Boolean showAcsUrlMessage;
    private String xsrfToken;
    private Boolean showIntroPage;
    private ArrayList<Boolean> enableSsoForIdp;
    private String idpID;
    private HashMap<String, Boolean> enableSsoForIdpMap;

    public MoIdpListAction(UserManager userManager, LoginUriProvider loginUriProvider, MoSAMLSettings settings) {
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.settings = settings;
    }

    private Boolean doValidate() {
        LOGGER.info("Validating IdP List and Domain Mapping");
        Boolean error = false;
        if (BooleanUtils.toBoolean((Boolean)this.domainsSubmitted) && !MoPluginHandler.isValidDomainMapping(this.domains, this.useDomainMapping).booleanValue()) {
            this.addActionError("Domains cannot be left empty. Also each IDP should have at least one domain name.");
            error = true;
        }
        return error;
    }

    public String execute() throws Exception {
        LOGGER.debug("doExecute: MoIdpListAction doExecute Called");
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        this.xsrfToken = XsrfTokenUtils.getXsrfToken((HttpServletRequest)request);
        UserProfile user = this.userManager.getRemoteUser();
        if (user != null && this.userManager.isAdmin(user.getUserKey())) {
            try {
                if (!this.settings.isValidLicense().booleanValue()) {
                    LOGGER.error("No valid license found");
                    return "upm";
                }
                this.idpID = "";
                this.idpMap = this.settings.getIdpMap();
                this.idpList = this.settings.getIdPList();
                String status = request.getParameter("status");
                String operation = request.getParameter("operation");
                if (StringUtils.isNotBlank((CharSequence)this.settings.getSsoServiceUrl())) {
                    String idpID = UUID.randomUUID().toString();
                    String idpName = "IDP";
                    MoPluginHandler.replaceOldSettingsWithNew(idpID, idpName);
                }
                if (StringUtils.isNotBlank((CharSequence)request.getParameter("reset")) && StringUtils.equals((CharSequence)request.getParameter("reset"), (CharSequence)"success")) {
                    this.addActionMessage("Plugin reset successful.");
                }
                String validTo = this.getCertificateInfo().get("Valid To");
                if (StringUtils.isNotBlank((CharSequence)operation) && operation.equals("delete")) {
                    if (StringUtils.isNotBlank((CharSequence)status)) {
                        if (status.equals("success")) {
                            this.addActionMessage("IDP Deleted Successfully");
                        } else if (status.equals("empty")) {
                            this.addActionError("IDP ID received was empty");
                        } else if (status.equals("missing")) {
                            this.addActionError("IDP does not exist");
                        } else if (status.equals("error")) {
                            this.addActionError("Problem with deleting IDP");
                        }
                    }
                } else if (StringUtils.isNotBlank((CharSequence)status)) {
                    if (status.equals("success")) {
                        this.addActionMessage("SAML settings updated");
                        if (this.settings.getIdPList().size() >= 2) {
                            this.showAcsUrlMessage = true;
                        }
                    } else if (status.equals("duplicate")) {
                        this.addActionError("IDP already exists. IDP Names must be unique.");
                    }
                }
                this.initializeIdpListConfig();
                return "success";
            }
            catch (MoPluginException e) {
                LOGGER.error(e.getMessage());
                e.printStackTrace();
                this.addActionError(e.getMessage());
                this.initializeIdpListConfig();
                return "input";
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                e.printStackTrace();
                this.addActionError("An error occurred while saving your details. Please check logs for more info.");
                LOGGER.error("An error occurred while saving Idp config details " + e.getMessage() + " with Cause" + e.getCause());
                this.initializeIdpListConfig();
                return "input";
            }
        }
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
        return null;
    }

    private void initializeIdpListConfig() {
        this.idpMap = this.settings.getIdpMap();
        this.domainsList = this.settings.getDomains();
        this.useDomainMapping = this.settings.getUseDomainMapping();
        this.enableSsoForIdpMap = this.getEnableSsoForIdpMap();
        this.showIntroPage = this.settings.getShowIntroPage();
    }

    public HashMap<String, Boolean> getEnableSsoForIdpMap() {
        ArrayList<String> idpList = this.getIdpList();
        HashMap<String, Boolean> enableSsoForIdpMap = new HashMap<String, Boolean>();
        for (String idpID : idpList) {
            JSONObject idpConfigObj = this.settings.getIdpConfig(idpID);
            enableSsoForIdpMap.put(idpID, idpConfigObj.optBoolean("miniorange.saml.ENABLE_SSO_FOR_IDP", Boolean.TRUE));
        }
        return enableSsoForIdpMap;
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    @StrutsParameter
    public MoSAMLSettings getSettings() {
        return this.settings;
    }

    @StrutsParameter
    public void setSettings(MoSAMLSettings settings) {
        this.settings = settings;
    }

    @StrutsParameter
    public UserManager getUserManager() {
        return this.userManager;
    }

    @StrutsParameter
    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    @StrutsParameter
    public LoginUriProvider getLoginUriProvider() {
        return this.loginUriProvider;
    }

    @StrutsParameter
    public void setLoginUriProvider(LoginUriProvider loginUriProvider) {
        this.loginUriProvider = loginUriProvider;
    }

    @StrutsParameter
    public String[] getDomains() {
        return this.domains;
    }

    @StrutsParameter
    public void setDomains(String[] domains) {
        this.domains = domains;
    }

    @StrutsParameter
    public Boolean getDomainsSubmitted() {
        return this.domainsSubmitted;
    }

    @StrutsParameter
    public void setDomainsSubmitted(Boolean domainsSubmitted) {
        this.domainsSubmitted = domainsSubmitted;
    }

    @StrutsParameter
    public List<String> getDomainsList() {
        return this.domainsList;
    }

    @StrutsParameter
    public void setDomainsList(List<String> domainsList) {
        this.domainsList = domainsList;
    }

    @StrutsParameter
    public Boolean getUseDomainMapping() {
        return this.useDomainMapping;
    }

    @StrutsParameter
    public void setUseDomainMapping(Boolean useDomainMapping) {
        this.useDomainMapping = useDomainMapping;
    }

    @StrutsParameter
    public HashMap<String, String> getIdpMap() {
        return this.idpMap;
    }

    @StrutsParameter
    public void setIdpMap(HashMap<String, String> idpMap) {
        this.idpMap = idpMap;
    }

    @StrutsParameter
    public ArrayList<String> getIdpList() {
        this.idpList = this.settings.getIdPList();
        return this.idpList;
    }

    @StrutsParameter
    public void setIdpList(ArrayList<String> idpList) {
        idpList = this.settings.getIdPList();
        this.idpList = idpList;
    }

    @StrutsParameter
    public Boolean getShowAcsUrlMessage() {
        return this.showAcsUrlMessage;
    }

    @StrutsParameter
    public void setShowAcsUrlMessage(Boolean showAcsUrlMessage) {
        this.showAcsUrlMessage = showAcsUrlMessage;
    }

    @StrutsParameter
    public String getXsrfToken() {
        return this.xsrfToken;
    }

    @StrutsParameter
    public void setXsrfToken(String xsrfToken) {
        this.xsrfToken = xsrfToken;
    }

    @StrutsParameter
    public String getIdpID() {
        return this.idpID;
    }

    @StrutsParameter
    public void setIdpID(String idpID) {
        this.idpID = idpID;
    }

    @StrutsParameter
    public Boolean getShowIntroPage() {
        return this.showIntroPage;
    }

    @StrutsParameter
    public void setShowIntroPage(Boolean showIntroPage) {
        this.showIntroPage = showIntroPage;
    }

    @StrutsParameter
    public ArrayList<Boolean> getEnableSsoForIdp() {
        return this.enableSsoForIdp;
    }

    @StrutsParameter
    public void setEnableSsoForIdp(ArrayList<Boolean> enableSsoForIdp) {
        this.enableSsoForIdp = enableSsoForIdp;
    }

    @StrutsParameter
    public Map<String, String> getCertificateInfo() {
        return MoSAMLUtils.getCertificateInfo(this.settings.getPublicSPCertificate());
    }

    @StrutsParameter
    public Collection<String> getSuccessMessages() {
        Collection successMessages = this.getActionMessages();
        ArrayList<String> encodedSuccessMessages = new ArrayList<String>();
        for (String message : successMessages) {
            encodedSuccessMessages.add(MoSAMLUtils.htmlEncode(message));
        }
        return encodedSuccessMessages;
    }

    @StrutsParameter
    public Collection<String> getErrorMessages() {
        Collection errorMessages = this.getActionErrors();
        ArrayList<String> encodedErrorMessages = new ArrayList<String>();
        for (String message : errorMessages) {
            encodedErrorMessages.add(MoSAMLUtils.htmlEncode(message));
        }
        return encodedErrorMessages;
    }
}

