/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.bamboo.action;

import com.atlassian.bamboo.security.xsrf.XsrfTokenUtils;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.plugin.PluginException;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.user.Group;
import com.atlassian.user.search.page.Pager;
import com.miniorange.sso.saml.bamboo.MoPluginHandler;
import com.miniorange.sso.saml.bamboo.MoSAMLSettings;
import com.miniorange.sso.saml.bamboo.MoSAMLUserManager;
import com.miniorange.sso.saml.dto.MoIDPConfig;
import com.miniorange.sso.saml.utils.MoSAMLUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.interceptor.parameter.StrutsParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoGroupMappingAction
extends BambooActionSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoGroupMappingAction.class);
    private UserManager userManager;
    private LoginUriProvider loginUriProvider;
    private MoSAMLSettings settings;
    private BambooUserManager bambooUserManager;
    private String roleAttribute;
    private String defaultGroup;
    private String[] defaultGroups;
    private List<String> defaultGroupsList;
    private Map<String, String> roleMapping;
    private Boolean createUsersIfRoleMapped;
    private Boolean keepExistingUserRoles;
    private ArrayList existingGroups;
    private String xsrfToken;
    private Boolean roleMappingSubmitted;
    private Boolean restrictUserCreation;
    private String enableDefaultGroupsFor;
    private Boolean groupRegexPatternEnabled = false;
    private String regexPatternForGroup;
    private String regexGroups;
    private String testRegex;
    private Boolean onTheFlyGroupCreation;
    private String[] onTheFlyDoNotRemoveGroups;
    private List<String> onTheFlyDoNotRemoveGroupsList;
    private Boolean createNewGroups;
    private Boolean onTheFlyAssignNewGroupsOnly;
    private Boolean gmIdpChanged;
    private String idpName;
    private String idpID;
    private HashMap<String, String> idpMap;
    private String lowerBuild;
    private MoSAMLUserManager moSAMLUserManager;
    private Boolean enableButtons;

    public MoGroupMappingAction(UserManager userManager, LoginUriProvider loginUriProvider, MoSAMLSettings settings, BambooUserManager bambooUserManager) {
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.settings = settings;
        this.bambooUserManager = bambooUserManager;
    }

    public Boolean doValidate() {
        LOGGER.debug("GroupMapping Action execute");
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        Boolean isError = Boolean.FALSE;
        if (!BooleanUtils.toBoolean((Boolean)this.roleMappingSubmitted)) {
            return isError;
        }
        if (this.defaultGroups != null && this.defaultGroups.length <= 0) {
            LOGGER.error("Default group is blank. Please select atleast one default group.");
            this.addActionError("Please select atleast one default group.");
            isError = true;
        }
        if (BooleanUtils.toBoolean((Boolean)this.onTheFlyGroupCreation) && StringUtils.isBlank((CharSequence)this.roleAttribute)) {
            LOGGER.error("Group Attribute can't be blank when On The Fly Group Mapping is enabled.");
            this.addActionError("Group Attribute is Required if On the Fly Group Mapping is enabled.");
            isError = true;
        }
        if (BooleanUtils.toBoolean((Boolean)isError)) {
            this.xsrfToken = XsrfTokenUtils.getXsrfToken((HttpServletRequest)request);
            this.initializeSAMLConfig();
        }
        return isError;
    }

    public String execute() throws Exception {
        LOGGER.debug("GroupMapping action execute() called");
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        response.setContentType("text/html");
        response.setCharacterEncoding("UTF-8");
        this.xsrfToken = XsrfTokenUtils.getXsrfToken((HttpServletRequest)request);
        LOGGER.debug("Regexpatternenabled = " + this.groupRegexPatternEnabled);
        this.lowerBuild = "false";
        LOGGER.debug("Current Build Number : " + this.settings.getCurrentBuildNumber());
        this.lowerBuild = this.getLowerBuild();
        UserProfile user = this.userManager.getRemoteUser();
        if (user != null && this.userManager.isAdmin(user.getUserKey())) {
            try {
                LOGGER.debug("GroupMapping Action execute Submitted: " + this.roleMappingSubmitted);
                if (!this.settings.isValidLicense().booleanValue()) {
                    return "upm";
                }
                if (StringUtils.isNotBlank((CharSequence)request.getParameter("idpid"))) {
                    this.idpID = request.getParameter("idpid");
                }
                if (BooleanUtils.toBoolean((Boolean)this.roleMappingSubmitted) && !BooleanUtils.toBoolean((Boolean)this.doValidate())) {
                    List<Object> defaultGroupList = new ArrayList<String>();
                    HashMap<String, String> roleMapping = new HashMap<String, String>();
                    int totalNumberOfRoles = Integer.parseInt(request.getParameter("totalNumberOfRoles"));
                    for (int i = 0; i < totalNumberOfRoles; ++i) {
                        String key = StringUtils.trimToEmpty((String)request.getParameter("userGroupKey_" + i));
                        String value = StringUtils.trimToEmpty((String)request.getParameter("userGroupValue_" + i));
                        if (!StringUtils.isNotEmpty((CharSequence)key) || !StringUtils.isNotEmpty((CharSequence)value) || StringUtils.equalsIgnoreCase((CharSequence)"select-group-to-map", (CharSequence)key) || BooleanUtils.toBoolean((Boolean)roleMapping.containsKey(key))) continue;
                        roleMapping.put(key.trim(), value.trim());
                    }
                    if (this.defaultGroup != null) {
                        LOGGER.debug("single default group is -" + this.defaultGroup);
                        defaultGroupList.add(this.defaultGroup);
                    }
                    if (this.defaultGroups != null) {
                        LOGGER.debug("multiple default groups -" + this.defaultGroups.length);
                        defaultGroupList = StringUtils.equalsIgnoreCase((CharSequence)"true", (CharSequence)this.lowerBuild) ? new ArrayList<String>(Arrays.asList(this.defaultGroups)) : Arrays.asList(StringUtils.split((String)this.defaultGroups[0], (String)","));
                        defaultGroupList.removeAll(Arrays.asList(null, ""));
                    }
                    if (this.onTheFlyDoNotRemoveGroups != null) {
                        LOGGER.debug("Excluded groups from on-the-fly group mapping-" + this.onTheFlyDoNotRemoveGroups.length);
                        this.onTheFlyDoNotRemoveGroupsList = StringUtils.equalsIgnoreCase((CharSequence)"true", (CharSequence)this.lowerBuild) ? new ArrayList<String>(Arrays.asList(this.onTheFlyDoNotRemoveGroups)) : Arrays.asList(StringUtils.split((String)this.onTheFlyDoNotRemoveGroups[0], (String)","));
                        this.onTheFlyDoNotRemoveGroupsList.removeAll(Arrays.asList(null, ""));
                    }
                    if (StringUtils.isBlank((CharSequence)this.idpID)) {
                        this.idpID = "miniorange.saml.DEFAULT_IDP_ID";
                    }
                    MoPluginHandler.saveRoleMapping(this.idpID, this.roleAttribute, BooleanUtils.toBoolean((Boolean)this.createUsersIfRoleMapped), BooleanUtils.toBoolean((Boolean)this.keepExistingUserRoles), roleMapping, this.defaultGroup, defaultGroupList, BooleanUtils.toBoolean((Boolean)this.restrictUserCreation), this.enableDefaultGroupsFor, BooleanUtils.toBoolean((Boolean)this.onTheFlyGroupCreation), this.onTheFlyDoNotRemoveGroupsList, this.onTheFlyAssignNewGroupsOnly, this.createNewGroups, this.groupRegexPatternEnabled, this.regexPatternForGroup, this.regexGroups, this.testRegex);
                    this.addActionMessage(this.getText("samlsso.success.config"));
                }
                if (StringUtils.isBlank((CharSequence)this.idpID)) {
                    if (!this.settings.getIdpMap().isEmpty()) {
                        this.idpID = this.settings.getIdPList().get(0);
                    } else {
                        this.idpID = UUID.randomUUID().toString();
                        if (StringUtils.isNotBlank((CharSequence)this.settings.getSsoServiceUrl())) {
                            this.idpName = "IDP";
                            MoPluginHandler.replaceOldSettingsWithNew(this.idpID, this.idpName);
                        } else {
                            this.initializeNewForm();
                            return "success";
                        }
                    }
                }
                this.initializeSAMLConfig();
                return "success";
            }
            catch (PluginException e) {
                e.printStackTrace();
                this.addActionError(e.getMessage());
                return "input";
            }
            catch (Exception e) {
                e.printStackTrace();
                this.addActionError("An error occurred while saving your details. Please check logs for more info.");
                return "input";
            }
        }
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
        return null;
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    private void initializeNewForm() {
        this.createUsersIfRoleMapped = this.settings.getCreateUsersIfRoleMapped();
        this.keepExistingUserRoles = this.settings.getKeepExistingUserRoles();
        this.defaultGroupsList = (List)this.settings.getDefaultGroups();
        this.roleMapping = new TreeMap<String, String>(this.settings.getRoleMapping());
        this.roleAttribute = this.settings.getRoleAttribute();
        this.restrictUserCreation = this.settings.getRestrictUserCreation();
        this.enableDefaultGroupsFor = this.settings.getEnableDefaultGroupsFor();
        this.onTheFlyGroupCreation = this.settings.getOnTheFlyGroupMapping();
        this.onTheFlyAssignNewGroupsOnly = this.settings.getOnTheFlyAssignNewGroupsOnly();
        this.onTheFlyDoNotRemoveGroupsList = (List)this.settings.getOnTheFlyDoNotRemoveGroups();
        this.createNewGroups = this.settings.getCreateNewGroups();
        ArrayList<String> existingGroup = this.getExistingGroups();
        this.defaultGroup = this.settings.getDefaultGroup();
        this.groupRegexPatternEnabled = BooleanUtils.toBooleanDefaultIfNull((Boolean)this.settings.getGroupRegexPatternEnabled(), (boolean)false);
        this.regexPatternForGroup = (String)StringUtils.defaultIfBlank((CharSequence)this.settings.getRegexPatternForGroup(), (CharSequence)"");
        this.regexGroups = StringUtils.defaultString((String)this.settings.getRegexGroups(), (String)"");
        this.testRegex = (String)StringUtils.defaultIfBlank((CharSequence)this.settings.getTestRegex(), (CharSequence)"");
        this.lowerBuild = this.getLowerBuild();
        this.idpName = "";
        this.enableButtons = false;
    }

    private void initializeSAMLConfig() {
        MoIDPConfig idpConfig = MoPluginHandler.constructIdpConfigObject(this.idpID);
        if (idpConfig == null) {
            this.initializeNewForm();
            return;
        }
        this.createUsersIfRoleMapped = idpConfig.getCreateUsersIfRoleMapped();
        this.keepExistingUserRoles = idpConfig.getKeepExistingUserRoles();
        this.defaultGroupsList = idpConfig.getDefaultGroupsList();
        this.roleMapping = new TreeMap<String, String>(idpConfig.getRoleMapping());
        this.roleAttribute = idpConfig.getRoleAttribute();
        this.restrictUserCreation = idpConfig.getRestrictUserCreation();
        this.enableDefaultGroupsFor = idpConfig.getEnableDefaultGroupsFor();
        this.onTheFlyGroupCreation = BooleanUtils.toBooleanDefaultIfNull((Boolean)idpConfig.getOnTheFlyGroupCreation(), (boolean)false);
        this.onTheFlyDoNotRemoveGroupsList = idpConfig.getOnTheFlyDoNotRemoveGroups();
        this.onTheFlyAssignNewGroupsOnly = idpConfig.getOnTheFlyAssignNewGroupsOnly();
        this.createNewGroups = BooleanUtils.toBooleanDefaultIfNull((Boolean)idpConfig.getCreateNewGroups(), (boolean)true);
        ArrayList<String> existingGroup = this.getExistingGroups();
        this.defaultGroup = idpConfig.getDefaultGroup();
        this.groupRegexPatternEnabled = BooleanUtils.toBooleanDefaultIfNull((Boolean)idpConfig.getGroupRegexPatternEnabled(), (boolean)false);
        this.regexPatternForGroup = (String)StringUtils.defaultIfBlank((CharSequence)idpConfig.getRegexPatternForGroup(), (CharSequence)"");
        this.regexGroups = StringUtils.defaultString((String)idpConfig.getRegexGroups(), (String)"");
        this.testRegex = (String)StringUtils.defaultIfBlank((CharSequence)idpConfig.getTestRegex(), (CharSequence)"");
        this.lowerBuild = this.getLowerBuild();
        this.idpName = idpConfig.getIdpName();
        this.enableButtons = true;
    }

    @StrutsParameter
    public UserManager getUserManager() {
        return this.userManager;
    }

    @StrutsParameter
    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    @StrutsParameter
    public LoginUriProvider getLoginUriProvider() {
        return this.loginUriProvider;
    }

    @StrutsParameter
    public void setLoginUriProvider(LoginUriProvider loginUriProvider) {
        this.loginUriProvider = loginUriProvider;
    }

    @StrutsParameter
    public MoSAMLSettings getSettings() {
        return this.settings;
    }

    @StrutsParameter
    public void setSettings(MoSAMLSettings settings) {
        this.settings = settings;
    }

    @StrutsParameter
    public String getRoleAttribute() {
        return this.roleAttribute;
    }

    @StrutsParameter
    public void setRoleAttribute(String roleAttribute) {
        this.roleAttribute = roleAttribute;
    }

    @StrutsParameter
    public String getDefaultGroup() {
        return this.defaultGroup;
    }

    @StrutsParameter
    public void setDefaultGroup(String defaultGroup) {
        this.defaultGroup = defaultGroup;
    }

    @StrutsParameter
    public Map<String, String> getRoleMapping() {
        return this.roleMapping;
    }

    @StrutsParameter
    public void setRoleMapping(Map<String, String> roleMapping) {
        this.roleMapping = roleMapping;
    }

    @StrutsParameter
    public Boolean getCreateUsersIfRoleMapped() {
        return this.createUsersIfRoleMapped;
    }

    @StrutsParameter
    public void setCreateUsersIfRoleMapped(Boolean createUsersIfRoleMapped) {
        this.createUsersIfRoleMapped = createUsersIfRoleMapped;
    }

    @StrutsParameter
    public Boolean getKeepExistingUserRoles() {
        return this.keepExistingUserRoles;
    }

    @StrutsParameter
    public void setKeepExistingUserRoles(Boolean keepExistingUserRoles) {
        this.keepExistingUserRoles = keepExistingUserRoles;
    }

    @StrutsParameter
    public ArrayList<String> getExistingGroups() {
        try {
            Pager groupObjects = this.bambooUserManager.getGroups();
            this.existingGroups = new ArrayList();
            for (Group group : groupObjects) {
                this.existingGroups.add(group.getName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.existingGroups;
    }

    @StrutsParameter
    public void setExistingGroups(ArrayList existingGroups) {
        this.existingGroups = existingGroups;
    }

    @StrutsParameter
    public String getXsrfToken() {
        return this.xsrfToken;
    }

    @StrutsParameter
    public void setXsrfToken(String xsrfToken) {
        this.xsrfToken = xsrfToken;
    }

    @StrutsParameter
    public Boolean getRoleMappingSubmitted() {
        return this.roleMappingSubmitted;
    }

    @StrutsParameter
    public void setRoleMappingSubmitted(Boolean roleMappingSubmitted) {
        this.roleMappingSubmitted = roleMappingSubmitted;
    }

    @StrutsParameter
    public BambooUserManager getBambooUserManager() {
        return this.bambooUserManager;
    }

    @StrutsParameter
    public void setBambooUserManager(BambooUserManager bambooUserManager) {
        this.bambooUserManager = bambooUserManager;
    }

    @StrutsParameter
    public Boolean getRestrictUserCreation() {
        return this.restrictUserCreation;
    }

    @StrutsParameter
    public void setRestrictUserCreation(Boolean restrictUserCreation) {
        this.restrictUserCreation = restrictUserCreation;
    }

    @StrutsParameter
    public String[] getDefaultGroups() {
        return this.defaultGroups;
    }

    @StrutsParameter
    public void setDefaultGroups(String[] defaultGroups) {
        this.defaultGroups = defaultGroups;
    }

    @StrutsParameter
    public List<String> getDefaultGroupsList() {
        return this.defaultGroupsList;
    }

    @StrutsParameter
    public void setDefaultGroupsList(List<String> defaultGroupsList) {
        this.defaultGroupsList = defaultGroupsList;
    }

    @StrutsParameter
    public Boolean getGmIdpChanged() {
        return this.gmIdpChanged;
    }

    @StrutsParameter
    public void setGmIdpChanged(Boolean gmIdpChanged) {
        this.gmIdpChanged = gmIdpChanged;
    }

    @StrutsParameter
    public String getIdpName() {
        return this.idpName;
    }

    @StrutsParameter
    public void setIdpName(String idpName) {
        this.idpName = idpName;
    }

    @StrutsParameter
    public String getIdpID() {
        return this.idpID;
    }

    @StrutsParameter
    public void setIdpID(String idpID) {
        this.idpID = idpID;
    }

    @StrutsParameter
    public HashMap<String, String> getIdpMap() {
        this.idpMap = this.settings.getIdpMap();
        return this.idpMap;
    }

    @StrutsParameter
    public void setIdpMap(HashMap<String, String> idpMap) {
        this.idpMap = idpMap;
    }

    @StrutsParameter
    public String getEnableDefaultGroupsFor() {
        return this.enableDefaultGroupsFor;
    }

    @StrutsParameter
    public void setEnableDefaultGroupsFor(String enableDefaultGroupsFor) {
        this.enableDefaultGroupsFor = enableDefaultGroupsFor;
    }

    @StrutsParameter
    public Boolean getOnTheFlyGroupCreation() {
        return this.onTheFlyGroupCreation;
    }

    @StrutsParameter
    public void setOnTheFlyGroupCreation(Boolean onTheFlyGroupCreation) {
        this.onTheFlyGroupCreation = onTheFlyGroupCreation;
    }

    @StrutsParameter
    public String[] getOnTheFlyDoNotRemoveGroups() {
        return this.onTheFlyDoNotRemoveGroups;
    }

    @StrutsParameter
    public void setOnTheFlyDoNotRemoveGroups(String[] onTheFlyDoNotRemoveGroups) {
        this.onTheFlyDoNotRemoveGroups = onTheFlyDoNotRemoveGroups;
    }

    @StrutsParameter
    public List<String> getOnTheFlyDoNotRemoveGroupsList() {
        return this.onTheFlyDoNotRemoveGroupsList;
    }

    @StrutsParameter
    public void setOnTheFlyDoNotRemoveGroupsList(List<String> onTheFlyDoNotRemoveGroupsList) {
        this.onTheFlyDoNotRemoveGroupsList = onTheFlyDoNotRemoveGroupsList;
    }

    @StrutsParameter
    public Boolean getOnTheFlyAssignNewGroupsOnly() {
        return this.onTheFlyAssignNewGroupsOnly;
    }

    @StrutsParameter
    public void setOnTheFlyAssignNewGroupsOnly(Boolean onTheFlyAssignNewGroupsOnly) {
        this.onTheFlyAssignNewGroupsOnly = onTheFlyAssignNewGroupsOnly;
    }

    @StrutsParameter
    public Boolean getCreateNewGroups() {
        return this.createNewGroups;
    }

    @StrutsParameter
    public void setCreateNewGroups(Boolean createNewGroups) {
        this.createNewGroups = createNewGroups;
    }

    @StrutsParameter
    public String getLowerBuild() {
        if (this.settings.getCurrentBuildNumber() < 60604) {
            LOGGER.debug("Current Bamboo version is lesser than 6.6.0");
            this.lowerBuild = "true";
        } else {
            this.lowerBuild = "false";
            LOGGER.debug("Current Bamboo version is greater than or equal to 6.6.0");
        }
        return this.lowerBuild;
    }

    @StrutsParameter
    public void setLowerBuild(String lowerBuild) {
        this.lowerBuild = lowerBuild;
    }

    @StrutsParameter
    public Boolean getEnableButtons() {
        return this.enableButtons;
    }

    @StrutsParameter
    public void setEnableButtons(Boolean enableButtons) {
        this.enableButtons = enableButtons;
    }

    @StrutsParameter
    public Boolean getGroupRegexPatternEnabled() {
        return this.groupRegexPatternEnabled;
    }

    @StrutsParameter
    public void setGroupRegexPatternEnabled(Boolean groupRegexPatternEnabled) {
        this.groupRegexPatternEnabled = groupRegexPatternEnabled;
    }

    @StrutsParameter
    public String getRegexPatternForGroup() {
        return this.regexPatternForGroup;
    }

    @StrutsParameter
    public void setRegexPatternForGroup(String regexPatternForGroup) {
        this.regexPatternForGroup = regexPatternForGroup;
    }

    @StrutsParameter
    public String getRegexGroups() {
        return this.regexGroups;
    }

    @StrutsParameter
    public void setRegexGroups(String regexGroups) {
        this.regexGroups = regexGroups;
    }

    @StrutsParameter
    public String getTestRegex() {
        return this.testRegex;
    }

    @StrutsParameter
    public void setTestRegex(String testRegex) {
        this.testRegex = testRegex;
    }

    @StrutsParameter
    public Collection<String> getSuccessMessages() {
        Collection successMessages = this.getActionMessages();
        ArrayList<String> encodedSuccessMessages = new ArrayList<String>();
        for (String message : successMessages) {
            encodedSuccessMessages.add(MoSAMLUtils.htmlEncode(message));
        }
        return encodedSuccessMessages;
    }

    @StrutsParameter
    public Collection<String> getErrorMessages() {
        Collection errorMessages = this.getActionErrors();
        ArrayList<String> encodedErrorMessages = new ArrayList<String>();
        for (String message : errorMessages) {
            encodedErrorMessages.add(MoSAMLUtils.htmlEncode(message));
        }
        return encodedErrorMessages;
    }
}

