AJS.$(function () {

	AJS.$(".aui-nav li").removeClass("aui-nav-selected");
	AJS.$("#mo-idps-advanced").addClass("aui-nav-selected");
	AJS.$("#mo-saml").addClass("aui-nav-selected");

	refreshMetadataSettings();

	AJS.$("#refreshMetadata").change(function () {
		refreshMetadataSettings();
	});

	AJS.$("#refreshInterval").change(function () {
		var value = AJS.$("#refreshInterval").val();
		if (value == "custom") {
			AJS.$("#customRefreshValue").show();
			AJS.$("#customRefreshInterval").prop("required", true);
		} else {
			AJS.$("#customRefreshValue").hide();
			AJS.$("#customRefreshInterval").prop("required", false);
		}
	});

	AJS.$("#allowUserCreation").change(function () {
         if(document.getElementById("allowUserCreation").checked){
             AJS.$("#selectDefaultDirectoryDiv").show();
         } else {
             AJS.$("#selectDefaultDirectoryDiv").hide();
         }
    });

        AJS.$("#defaultUserDirectory").change(function(){
            showDirectoryPermissionError();
        });

        AJS.$("#createDirectoryButton").click(function (e) {
            e.preventDefault();
            AJS.dialog2("#create-dir-section").show();
        });

        AJS.$("#dir-dialog-close-button").click(function(e){
            e.preventDefault();
            AJS.dialog2("#create-dir-section").hide();
        })

       AJS.$("#createDirectorySubmitButton").click(function(){
                   var dirName = AJS.$("#directoryName").val();
                   AJS.$.ajax({
                       url: AJS.contextPath() + "/plugins/servlet/saml/moapi",
                       data: {
                           "action" : "createNewDirectory",
                           "directoryName" : dirName
                       },
                       type: "POST",
                       async:true,
                       error: function (response){
                           AJS.dialog2("#create-dir-section").hide();
                           AJS.flag({
                               title: 'Error!',
                               type: 'error',
                               close: 'manual',
                               body: '<p>' + JSON.parse(response.responseText) +  '</p>'
                           });
                       },

                       success: function(response){
                           AJS.dialog2("#create-dir-section").hide();
                           AJS.flag({
                               title: 'Success!',
                               type: 'success',
                               close: 'auto',
                               body: '<p>New internal directory created successfully.</p>'
                           });
                           setTimeout(function(){
                               location.reload(false);
                           }, 1000);
                       }
                   });
               });

	function refreshMetadataSettings() {
		var refreshMetadata = document.getElementById('refreshMetadata');
		if (refreshMetadata.checked) {
			AJS.$("#refreshInterval").prop("disabled", false);
			AJS.$("#inputUrl").prop("required", true);
			if (AJS.$("#refreshInterval").val() == "custom") {
				AJS.$("#customRefreshValue").show();
				AJS.$("#customRefreshInterval").prop("required", true);
			} else {
				AJS.$("#customRefreshValue").hide();
				AJS.$("#customRefreshInterval").prop("required", false);
			}
		} else {
			console.log("refresh not set to custom");
			AJS.$("#refreshInterval").prop("disabled", true);
			AJS.$("#inputUrl").prop("required", false);
			AJS.$("#customRefreshValue").hide();
			AJS.$("#customRefreshInterval").prop("required", false);
		}

	}

	function showDirectoryPermissionError(){
    	    if(AJS.$("#defaultUserDirectory option:selected").attr("id") == "readOnlyDir"){
    //            AJS.flag({
    //                title: 'Invalid Directory Configured',
    //                type: 'warning',
    //                close: 'manual',
    //                body: '<p>The directory you selected to create a new user appears to be READ_ONLY. Plxease set up a valid directory.</p>'
    //            });
                AJS.$("#dirPermissionError").show();
            } else{
                AJS.$("#dirPermissionError").hide();
            }
    }

});