/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.bamboo.servlet;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.user.BambooUser;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.seraph.auth.Authenticator;
import com.atlassian.seraph.auth.DefaultAuthenticator;
import com.atlassian.seraph.config.SecurityConfigFactory;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.sso.saml.bamboo.MoPluginHandler;
import com.miniorange.sso.saml.bamboo.MoSAMLManager;
import com.miniorange.sso.saml.bamboo.MoSAMLSettings;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Principal;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@UnrestrictedAccess
public class MoHeaderAuthenticationServlet
extends HttpServlet {
    private static Log LOGGER = LogFactory.getLog(MoHeaderAuthenticationServlet.class);
    private MoSAMLSettings settings;
    private BambooUserManager bambooUserManager;
    private BambooPermissionManager bambooPermissionManager;
    private MoSAMLManager samlManager;
    private MoPluginHandler moPluginHandler;
    private final TemplateRenderer renderer;

    public MoHeaderAuthenticationServlet(MoSAMLSettings settings, BambooPermissionManager bambooPermissionManager, BambooUserManager bambooUserManager, TemplateRenderer renderer, MoPluginHandler moPluginHandler, MoSAMLManager samlManager) {
        this.settings = settings;
        this.bambooPermissionManager = bambooPermissionManager;
        this.bambooUserManager = bambooUserManager;
        this.samlManager = samlManager;
        this.moPluginHandler = moPluginHandler;
        this.renderer = renderer;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug((Object)"MoHeaderAuthentication: doGet called");
        this.handleHeaderBasedAuthentication(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug((Object)"MoHeaderAuthentication: doPost called");
        this.handleHeaderBasedAuthentication(request, response);
    }

    private void handleHeaderBasedAuthentication(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Boolean isAuthenticated = Boolean.FALSE;
        try {
            if (this.settings.getHeaderAuthenticationSettings().booleanValue()) {
                if (!this.settings.isEvaluationOrSubscriptionLicense().booleanValue() || this.settings.isEvaluationOrSubscriptionLicense().booleanValue() && this.settings.isValidLicense().booleanValue()) {
                    isAuthenticated = this.validateHeaderAndLogin(request, response);
                } else {
                    LOGGER.debug((Object)"Invalid license");
                }
            } else {
                LOGGER.info((Object)"Header based authentication is disabled");
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("An exception occurred in header based authentication. Redirecting to the login page. " + e));
        }
        String redirectUrl = this.settings.getSpBaseUrl();
        if (isAuthenticated.booleanValue() && !StringUtils.isBlank((CharSequence)request.getHeader(this.settings.getHeaderAuthenticationRelayStateAttribute()))) {
            redirectUrl = request.getHeader(this.settings.getHeaderAuthenticationRelayStateAttribute());
        }
        LOGGER.debug((Object)("Redirecting user to: " + redirectUrl));
        response.sendRedirect(redirectUrl);
    }

    private Boolean validateHeaderAndLogin(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String username = request.getHeader(this.settings.getHeaderAuthenticationAttribute());
        Authenticator authenticator = SecurityConfigFactory.getInstance().getAuthenticator();
        if (this.bambooUserManager.getBambooUser(username) == null) {
            LOGGER.error((Object)"User does not exist. Redirecting to the login page");
            return Boolean.FALSE;
        }
        LOGGER.debug((Object)("creating session for user: " + username));
        BambooUser bambooUser = this.bambooUserManager.getBambooUser(username);
        this.authoriseUserAndEstablishSession((DefaultAuthenticator)authenticator, bambooUser, request, response);
        LOGGER.info((Object)"User session established");
        return Boolean.TRUE;
    }

    private void authoriseUserAndEstablishSession(DefaultAuthenticator authenticator, Object userObject, HttpServletRequest request, HttpServletResponse response) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Principal principal = (Principal)userObject;
        Method authUserMethod = DefaultAuthenticator.class.getDeclaredMethod("authoriseUserAndEstablishSession", HttpServletRequest.class, HttpServletResponse.class, Principal.class);
        authUserMethod.setAccessible(true);
        authUserMethod.invoke((Object)authenticator, request, response, principal);
    }
}

