/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.bamboo.action;

import com.atlassian.bamboo.security.xsrf.XsrfTokenUtils;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.plugin.PluginException;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.miniorange.sso.saml.bamboo.MoPluginHandler;
import com.miniorange.sso.saml.bamboo.MoSAMLSettings;
import com.miniorange.sso.saml.dto.MoIDPConfig;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoAttributeMappingAction
extends BambooActionSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoAttributeMappingAction.class);
    private UserManager userManager;
    private LoginUriProvider loginUriProvider;
    private MoSAMLSettings settings;
    private String usernameAttribute;
    private String emailAttribute;
    private String fullNameAttribute;
    private Boolean useSeparateNameAttributes;
    private Boolean keepExistingUserAttributes;
    private String firstNameAttribute;
    private String lastNameAttribute;
    private Boolean regexPatternEnabled;
    private String regexPattern;
    private Boolean attributeMappingSubmitted;
    private String loginUserAttribute;
    private ArrayList userLoginOptions;
    private String xsrfToken;
    private Boolean amIdpChanged;
    private String idpID;
    private String idpName;
    private HashMap<String, String> idpMap;
    private Boolean enableButtons;
    private Boolean testConfigPerformed;

    public MoAttributeMappingAction(UserManager userManager, LoginUriProvider loginUriProvider, MoSAMLSettings settings) {
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.settings = settings;
    }

    public void validate() {
        LOGGER.debug("AttributeMapping Action validate() called");
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        if (!BooleanUtils.toBoolean((Boolean)this.attributeMappingSubmitted)) {
            return;
        }
        if (BooleanUtils.toBoolean((Boolean)this.regexPatternEnabled)) {
            if (StringUtils.isBlank((CharSequence)this.regexPattern)) {
                this.addActionError("Regex pattern can not be left blank.");
            }
            try {
                Pattern.compile(this.regexPattern);
            }
            catch (PatternSyntaxException exception) {
                this.addActionError("Regular expression is not valid");
            }
        }
        if (super.hasActionErrors()) {
            this.xsrfToken = XsrfTokenUtils.getXsrfToken((HttpServletRequest)request);
            this.initializeSAMLConfig();
        }
    }

    public String execute() throws Exception {
        LOGGER.debug("AttributeMapping Action execute() called");
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        this.xsrfToken = XsrfTokenUtils.getXsrfToken((HttpServletRequest)request);
        UserProfile user = this.userManager.getRemoteUser();
        if (user != null && this.userManager.isAdmin(user.getUserKey())) {
            try {
                LOGGER.debug("AttributeMapping Action execute Submitted: " + this.attributeMappingSubmitted);
                if (!this.settings.isValidLicense().booleanValue()) {
                    LOGGER.debug("Invalide License");
                    return "upm";
                }
                LOGGER.debug("User Login  option = " + this.loginUserAttribute);
                if (StringUtils.isNotBlank((CharSequence)request.getParameter("idpid"))) {
                    this.idpID = request.getParameter("idpid");
                }
                if (BooleanUtils.toBoolean((Boolean)this.attributeMappingSubmitted)) {
                    if (StringUtils.isBlank((CharSequence)this.idpID)) {
                        this.idpID = "miniorange.saml.DEFAULT_IDP_ID";
                    }
                    String userNameAttr = StringUtils.split((String)this.usernameAttribute, (String)" ")[0];
                    String userEmailAttr = StringUtils.split((String)this.emailAttribute, (String)" ")[0];
                    String userFullNameAttr = "";
                    if (StringUtils.isNotEmpty((CharSequence)this.fullNameAttribute)) {
                        userFullNameAttr = StringUtils.split((String)this.fullNameAttribute, (String)" ")[0];
                    }
                    String userFirstNameAttr = "";
                    if (StringUtils.isNotEmpty((CharSequence)this.firstNameAttribute)) {
                        userFirstNameAttr = StringUtils.split((String)this.firstNameAttribute, (String)" ")[0];
                    }
                    String userLastNameAttr = "";
                    if (StringUtils.isNotEmpty((CharSequence)this.lastNameAttribute)) {
                        userLastNameAttr = StringUtils.split((String)this.lastNameAttribute, (String)" ")[0];
                    }
                    MoPluginHandler.saveAttributeMapping(this.idpID, this.setDefaultToNameID(userNameAttr), this.setDefaultToNameID(userEmailAttr), this.setDefaultToEmpty(userFullNameAttr), this.useSeparateNameAttributes, this.setDefaultToEmpty(userFirstNameAttr), this.setDefaultToEmpty(userLastNameAttr), this.keepExistingUserAttributes, this.regexPattern, this.regexPatternEnabled, this.loginUserAttribute);
                    this.addActionMessage(this.getText("samlsso.success.config"));
                }
                if (StringUtils.isBlank((CharSequence)this.idpID)) {
                    if (!this.settings.getIdpMap().isEmpty()) {
                        this.idpID = this.settings.getIdPList().get(0);
                    } else if (StringUtils.isNotBlank((CharSequence)this.settings.getSsoServiceUrl())) {
                        this.idpID = UUID.randomUUID().toString();
                        this.idpName = "IDP";
                        MoPluginHandler.replaceOldSettingsWithNew(this.idpID, this.idpName);
                    } else {
                        this.initializeNewForm();
                        return "success";
                    }
                }
                this.initializeSAMLConfig();
                return "success";
            }
            catch (PluginException e) {
                e.printStackTrace();
                this.addActionError(e.getMessage());
                return "input";
            }
            catch (Exception e) {
                e.printStackTrace();
                this.addActionError("An error occurred while saving your details. Please check logs for more info.");
                return "input";
            }
        }
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
        return null;
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    private void initializeNewForm() {
        this.idpName = "";
        this.usernameAttribute = "NameID";
        this.emailAttribute = "NameID";
        this.fullNameAttribute = "";
        this.useSeparateNameAttributes = false;
        this.firstNameAttribute = "";
        this.lastNameAttribute = "";
        this.keepExistingUserAttributes = false;
        this.regexPattern = "";
        this.regexPatternEnabled = false;
        this.loginUserAttribute = "username";
        this.enableButtons = false;
        this.testConfigPerformed = this.settings.checkIfTestConfig(this.idpID);
    }

    private void initializeSAMLConfig() {
        MoIDPConfig idpConfig = MoPluginHandler.constructIdpConfigObject(this.idpID);
        if (idpConfig == null) {
            this.initializeNewForm();
            return;
        }
        this.idpName = idpConfig.getIdpName();
        this.usernameAttribute = idpConfig.getUsernameAttribute();
        this.emailAttribute = idpConfig.getEmailAttribute();
        this.fullNameAttribute = idpConfig.getFullNameAttribute();
        this.useSeparateNameAttributes = idpConfig.getUseSeparateNameAttributes();
        this.firstNameAttribute = idpConfig.getFirstNameAttribute();
        this.lastNameAttribute = idpConfig.getLastNameAttribute();
        this.keepExistingUserAttributes = idpConfig.getKeepExistingUserAttributes();
        this.regexPattern = idpConfig.getRegexPattern();
        this.regexPatternEnabled = idpConfig.getRegexPatternEnabled();
        this.loginUserAttribute = idpConfig.getLoginUserAttribute();
        this.enableButtons = true;
        this.testConfigPerformed = this.settings.checkIfTestConfig(this.idpID);
    }

    private String setDefaultToNameID(String attributeName) {
        if (StringUtils.equalsIgnoreCase((CharSequence)attributeName, (CharSequence)"--Select--")) {
            return "NameID";
        }
        return attributeName;
    }

    private String setDefaultToEmpty(String attributeName) {
        if (StringUtils.equalsIgnoreCase((CharSequence)attributeName, (CharSequence)"--Select--")) {
            return "";
        }
        return attributeName;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public LoginUriProvider getLoginUriProvider() {
        return this.loginUriProvider;
    }

    public void setLoginUriProvider(LoginUriProvider loginUriProvider) {
        this.loginUriProvider = loginUriProvider;
    }

    public MoSAMLSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoSAMLSettings settings) {
        this.settings = settings;
    }

    public String getUsernameAttribute() {
        return this.usernameAttribute;
    }

    public void setUsernameAttribute(String usernameAttribute) {
        this.usernameAttribute = usernameAttribute;
    }

    public String getEmailAttribute() {
        return this.emailAttribute;
    }

    public void setEmailAttribute(String emailAttribute) {
        this.emailAttribute = emailAttribute;
    }

    public String getFullNameAttribute() {
        return this.fullNameAttribute;
    }

    public void setFullNameAttribute(String fullNameAttribute) {
        this.fullNameAttribute = fullNameAttribute;
    }

    public Boolean getUseSeparateNameAttributes() {
        return this.useSeparateNameAttributes;
    }

    public void setUseSeparateNameAttributes(Boolean useSeparateNameAttributes) {
        this.useSeparateNameAttributes = useSeparateNameAttributes;
    }

    public Boolean getKeepExistingUserAttributes() {
        return this.keepExistingUserAttributes;
    }

    public void setKeepExistingUserAttributes(Boolean keepExistingUserAttributes) {
        this.keepExistingUserAttributes = keepExistingUserAttributes;
    }

    public String getFirstNameAttribute() {
        return this.firstNameAttribute;
    }

    public void setFirstNameAttribute(String firstNameAttribute) {
        this.firstNameAttribute = firstNameAttribute;
    }

    public String getLastNameAttribute() {
        return this.lastNameAttribute;
    }

    public void setLastNameAttribute(String lastNameAttribute) {
        this.lastNameAttribute = lastNameAttribute;
    }

    public String getXsrfToken() {
        return this.xsrfToken;
    }

    public void setXsrfToken(String xsrfToken) {
        this.xsrfToken = xsrfToken;
    }

    public Boolean getAttributeMappingSubmitted() {
        return this.attributeMappingSubmitted;
    }

    public void setAttributeMappingSubmitted(Boolean attributeMappingSubmitted) {
        this.attributeMappingSubmitted = attributeMappingSubmitted;
    }

    public Boolean getRegexPatternEnabled() {
        return this.regexPatternEnabled;
    }

    public void setRegexPatternEnabled(Boolean regexPatternEnabled) {
        this.regexPatternEnabled = regexPatternEnabled;
    }

    public String getRegexPattern() {
        return this.regexPattern;
    }

    public void setRegexPattern(String regexPattern) {
        this.regexPattern = regexPattern;
    }

    public String getLoginUserAttribute() {
        return this.loginUserAttribute;
    }

    public void setLoginUserAttribute(String loginUserAttribute) {
        this.loginUserAttribute = loginUserAttribute;
    }

    public ArrayList getUserLoginOptions() {
        this.userLoginOptions = new ArrayList();
        this.userLoginOptions.add("username");
        this.userLoginOptions.add("email");
        return this.userLoginOptions;
    }

    public void setUserLoginOptions(ArrayList userLoginOptions) {
        this.userLoginOptions = userLoginOptions;
    }

    public Boolean getAmIdpChanged() {
        return this.amIdpChanged;
    }

    public void setAmIdpChanged(Boolean amIdpChanged) {
        this.amIdpChanged = amIdpChanged;
    }

    public String getIdpID() {
        return this.idpID;
    }

    public void setIdpID(String idpID) {
        this.idpID = idpID;
    }

    public String getIdpName() {
        return this.idpName;
    }

    public void setIdpName(String idpName) {
        this.idpName = idpName;
    }

    public HashMap<String, String> getIdpMap() {
        this.idpMap = this.settings.getIdpMap();
        return this.idpMap;
    }

    public void setIdpMap(HashMap<String, String> idpMap) {
        this.idpMap = idpMap;
    }

    public Boolean getEnableButtons() {
        return this.enableButtons;
    }

    public void setEnableButtons(Boolean enableButtons) {
        this.enableButtons = enableButtons;
    }

    public Boolean getTestConfigPerformed() {
        return this.testConfigPerformed;
    }

    public void setTestConfigPerformed(Boolean testConfigPerformed) {
        this.testConfigPerformed = testConfigPerformed;
    }
}

