/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.bamboo.servlet;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.json.jsonorg.JSONException;
import com.atlassian.json.jsonorg.JSONObject;
import com.google.gson.Gson;
import com.miniorange.sso.saml.MoConfigAjaxAttributes;
import com.miniorange.sso.saml.bamboo.MoPluginHandler;
import com.miniorange.sso.saml.bamboo.MoSAMLSettings;
import com.miniorange.sso.saml.dto.MoIDPConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class MoConfigurationServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoConfigurationServlet.class);
    private static final Gson gson = new Gson();
    private MoSAMLSettings settings;

    public MoConfigurationServlet(MoSAMLSettings settings) {
        this.settings = settings;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Configuration action doGet called");
        String action = request.getParameter("action");
        String referer = request.getHeader("referer");
        LOGGER.debug("Referer Header:" + referer);
        try {
            if (this.settings.getPluginApiAccessRestriction().booleanValue() && !StringUtils.startsWith((CharSequence)referer, (CharSequence)this.settings.getSpBaseUrl())) {
                LOGGER.error("Access Denied. API Restriction is enabled and request is not originated from the Bamboo.");
                response.sendError(403, "Access Denied. You are not allowed to access this page.");
                return;
            }
            if (!this.settings.isEvaluationOrSubscriptionLicense().booleanValue()) {
                this.getConfiguration(request, response, true);
            } else if (this.settings.isEvaluationOrSubscriptionLicense().booleanValue() && this.settings.isValidLicense().booleanValue()) {
                this.getConfiguration(request, response, true);
            } else {
                this.getConfiguration(request, response, false);
            }
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while getting the plugin's configuration.", (Throwable)e);
        }
    }

    public void getConfiguration(HttpServletRequest request, HttpServletResponse response, Boolean hasValidLicense) {
        try {
            String attrsJSON;
            Boolean isConfigured = false;
            if (BooleanUtils.toBoolean((Boolean)hasValidLicense)) {
                if ((this.settings.getIdpMap().size() > 0 || StringUtils.isNotBlank((CharSequence)this.settings.getSsoServiceUrl())) && BooleanUtils.toBoolean((Boolean)this.settings.getEnableSAMLSSO())) {
                    isConfigured = true;
                }
                Boolean canUserSaveDetails = false;
                if (this.settings.getIdpMap().size() > 0 || StringUtils.isNotBlank((CharSequence)this.settings.getSsoServiceUrl())) {
                    canUserSaveDetails = true;
                }
                Boolean sloConfigured = this.isSloConfigured(request);
                Boolean customLogoutUrlConfigured = StringUtils.isNotBlank((CharSequence)this.settings.getCustomLogoutURL());
                Boolean customLogoutTemplateEnabled = BooleanUtils.toBoolean((Boolean)this.settings.getEnableLogoutTemplate());
                Boolean enableAutoRedirectDelay = BooleanUtils.toBoolean((Boolean)this.settings.getEnableAutoRedirectDelay());
                Boolean enableAutoRedirect = BooleanUtils.toBoolean((Boolean)this.settings.getEnableAutoRedirect());
                String numberOfLoginAttempts = this.settings.getNumberOfLoginAttempts();
                HashMap<String, String> idpMap = this.settings.getIdpMap();
                ArrayList<String> idpList = this.settings.getIdPList();
                Boolean useDomainMapping = this.settings.getUseDomainMapping() != false && idpList.size() > 1;
                String username = request.getParameter("username");
                String idp = StringUtils.isNotBlank((CharSequence)username) ? this.getIdPFromUsername(username.trim()) : "";
                String backdoorKey = this.settings.getBackdoorKey();
                String backdoorValue = this.settings.getBackdoorValue();
                Boolean restrictBackdoor = this.settings.getRestrictBackdoor();
                Boolean enableLoginTemplate = this.settings.getEnableLoginTemplate();
                String loginTemplate = this.settings.getLoginTemplate();
                Boolean enablePasswordChange = this.settings.getEnablePasswordChange();
                Boolean headerAuthentication = BooleanUtils.toBoolean((Boolean)this.settings.getHeaderAuthenticationSettings());
                String headerAuthenticationAttribute = this.settings.getHeaderAuthenticationAttribute();
                String defaultBambooIDP = this.settings.getDefaultBambooIDP();
                String defaultRedirectUrl = this.settings.getDefaultRedirectURL();
                Boolean enableSAMLSSO = this.settings.getEnableSAMLSSO();
                Boolean showLoginButtons = this.settings.getShowLoginButtons();
                Boolean hideDefaultLogin = this.settings.getHideDefaultLogin();
                Boolean pluginApiAccessRestriction = this.settings.getPluginApiAccessRestriction();
                String resetAssertionIDListInterval = this.settings.getResetAssertionIDListInterval();
                int customResetInterval = this.settings.getCustomResetInterval();
                ArrayList<String> ssoEnabledForIdpList = this.settings.getSsoEnabledForIdPList();
                MoConfigAjaxAttributes attrs = new MoConfigAjaxAttributes(isConfigured, this.settings.getDefaultLoginDisabled(), this.settings.getBackdoorEnabled(), enableAutoRedirectDelay, numberOfLoginAttempts, this.settings.getLoginButtonText(), sloConfigured, customLogoutUrlConfigured, backdoorKey, backdoorValue, customLogoutTemplateEnabled, idpMap, idpList, useDomainMapping, idp, restrictBackdoor, enableLoginTemplate, loginTemplate, canUserSaveDetails, enablePasswordChange, headerAuthentication, headerAuthenticationAttribute, defaultBambooIDP, defaultRedirectUrl, enableSAMLSSO, showLoginButtons, hideDefaultLogin, pluginApiAccessRestriction, resetAssertionIDListInterval, customResetInterval, ssoEnabledForIdpList, enableAutoRedirect);
                attrsJSON = gson.toJson((Object)attrs);
            } else {
                JSONObject json = new JSONObject();
                try {
                    json.put("configured", BooleanUtils.toBoolean((Boolean)isConfigured));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                attrsJSON = json.toString();
            }
            response.setContentType("application/json");
            response.getOutputStream().write(attrsJSON.getBytes());
            response.getOutputStream().close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getIdPFromUsername(String username) {
        if (username.indexOf("@") > 0) {
            String domain = username.substring(username.indexOf("@") + 1);
            HashMap<String, String> domainMapping = this.settings.getDomainMapping();
            if (domainMapping.containsKey(domain)) {
                return domainMapping.get(domain);
            }
        }
        return "";
    }

    public void setSettings(MoSAMLSettings settings) {
        this.settings = settings;
    }

    private Boolean isSloConfigured(HttpServletRequest request) {
        LOGGER.debug("isSloConfigured Called");
        try {
            Cookie logoutCookie = this.getCookie("LOGOUTCOOKIE", request);
            if (logoutCookie != null) {
                String idpName = logoutCookie.getValue();
                LOGGER.debug("[isSloConfigured] idpName: " + idpName);
                MoIDPConfig idpConfig = MoPluginHandler.constructIdpConfigObject(idpName);
                LOGGER.debug("IDP Config " + idpConfig);
                if (idpConfig == null) {
                    return Boolean.FALSE;
                }
                return StringUtils.isNotBlank((CharSequence)idpConfig.getSloUrl());
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            LOGGER.error("Error Occurred while geting configurations");
        }
        return Boolean.FALSE;
    }

    private Cookie getCookie(String cookieName, HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(cookieName)) continue;
                return cookie;
            }
        }
        return null;
    }
}

