/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.bamboo.action;

import com.atlassian.bamboo.security.xsrf.XsrfTokenUtils;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.plugin.PluginException;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.miniorange.sso.saml.bamboo.MoPluginHandler;
import com.miniorange.sso.saml.bamboo.MoSAMLSettings;
import com.miniorange.sso.saml.bamboo.action.MoSupportedIdpsAction;
import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoSessionManagementAction
extends BambooActionSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoSupportedIdpsAction.class);
    private MoPluginHandler moPluginHandler;
    private MoSAMLSettings settings;
    private UserManager userManager;
    private LoginUriProvider loginUriProvider;
    private String xsrfToken;
    private Boolean rememberMeSubmitted;
    private Boolean enableRememberMeCookie;
    private Boolean enableRememberMyIdpCookie;
    private String configuredLifeForIdpCookie;
    private Boolean userConsent;

    public MoSessionManagementAction(MoPluginHandler moPluginHandler, MoSAMLSettings settings, UserManager userManager, LoginUriProvider loginUriProvider) {
        this.moPluginHandler = moPluginHandler;
        this.settings = settings;
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
    }

    public void validate() {
        LOGGER.info("Session Management Action doValidate called");
    }

    public String execute() throws Exception {
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        this.xsrfToken = XsrfTokenUtils.getXsrfToken((HttpServletRequest)request);
        UserProfile user = this.userManager.getRemoteUser();
        if (user != null && this.userManager.isAdmin(user.getUserKey())) {
            try {
                LOGGER.debug("Session Management doExecute called");
                if (!this.settings.isValidLicense().booleanValue()) {
                    LOGGER.error("No valid license found.");
                    return "upm";
                }
                if (BooleanUtils.toBoolean((Boolean)this.rememberMeSubmitted)) {
                    this.settings.setRememberMeCookieEnabled(BooleanUtils.toBoolean((Boolean)this.enableRememberMeCookie));
                    this.settings.setRememberMyIdpCookieEnabled(BooleanUtils.toBoolean((Boolean)this.enableRememberMyIdpCookie));
                    this.settings.setConfiguredLifeForIdpCookie(this.configuredLifeForIdpCookie);
                    this.settings.setUserConsent(this.userConsent);
                    this.addActionMessage(this.getText("samlsso.success.config"));
                }
                this.initialiseConfig();
                return "success";
            }
            catch (PluginException e) {
                LOGGER.error("An plugin exception occurred while initializing service provider configuration", (Throwable)e);
                this.addActionError(e.getMessage());
                return "input";
            }
            catch (Exception e) {
                LOGGER.error("An error occurred while initializing service provider configuration", (Throwable)e);
                this.addActionError("An error occured while saving your details. Please check logs for more info.");
                return "input";
            }
        }
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
        return null;
    }

    public void initialiseConfig() {
        this.enableRememberMeCookie = BooleanUtils.toBoolean((Boolean)this.settings.getRememberMeCookieEnabled());
        this.enableRememberMyIdpCookie = BooleanUtils.toBoolean((Boolean)this.settings.getRememberMyIdpCookieEnabled());
        this.configuredLifeForIdpCookie = (String)StringUtils.defaultIfBlank((CharSequence)this.settings.getConfiguredLifeForIdpCookie(), (CharSequence)"");
        this.userConsent = BooleanUtils.toBoolean((Boolean)this.settings.getUserConsent());
        if (this.enableRememberMyIdpCookie.booleanValue()) {
            this.settings.setEnableLogoutTemplate(Boolean.TRUE);
        }
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    public MoPluginHandler getMoPluginHandler() {
        return this.moPluginHandler;
    }

    public void setMoPluginHandler(MoPluginHandler moPluginHandler) {
        this.moPluginHandler = moPluginHandler;
    }

    public MoSAMLSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoSAMLSettings settings) {
        this.settings = settings;
    }

    public Boolean getRememberMeSubmitted() {
        return this.rememberMeSubmitted;
    }

    public void setRememberMeSubmitted(Boolean rememberMeSubmitted) {
        this.rememberMeSubmitted = rememberMeSubmitted;
    }

    public Boolean getEnableRememberMeCookie() {
        return this.enableRememberMeCookie;
    }

    public void setEnableRememberMeCookie(Boolean enableRememberMeCookie) {
        this.enableRememberMeCookie = enableRememberMeCookie;
    }

    public String getXsrfToken() {
        return this.xsrfToken;
    }

    public void setXsrfToken(String xsrfToken) {
        this.xsrfToken = xsrfToken;
    }

    public Boolean getEnableRememberMyIdpCookie() {
        return this.enableRememberMyIdpCookie;
    }

    public void setEnableRememberMyIdpCookie(Boolean enableRememberMyIdpCookie) {
        this.enableRememberMyIdpCookie = enableRememberMyIdpCookie;
    }

    public String getConfiguredLifeForIdpCookie() {
        return this.configuredLifeForIdpCookie;
    }

    public void setConfiguredLifeForIdpCookie(String configuredLifeForIdpCookie) {
        this.configuredLifeForIdpCookie = configuredLifeForIdpCookie;
    }

    public Boolean getUserConsent() {
        return this.userConsent;
    }

    public void setUserConsent(Boolean userConsent) {
        this.userConsent = userConsent;
    }
}

