/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.bamboo.servlet;

import com.atlassian.bamboo.security.xsrf.XsrfTokenUtils;
import com.miniorange.sso.saml.MoPluginException;
import com.miniorange.sso.saml.bamboo.MoPluginHandler;
import com.miniorange.sso.saml.bamboo.MoSAMLSettings;
import com.miniorange.sso.saml.utils.MoSAMLUtils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.multipart.MultiPartRequestWrapper;
import org.apache.struts2.dispatcher.multipart.UploadedFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoMetadataUpload
extends HttpServlet {
    private MoSAMLSettings settings;
    private String xsrfToken;
    private static final Logger LOGGER = LoggerFactory.getLogger(MoMetadataUpload.class);

    public MoMetadataUpload(MoSAMLSettings settings) {
        this.settings = settings;
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        block25: {
            String fileContents = null;
            String uploadMetadataStatus = null;
            String idpID = null;
            String setupType = null;
            String idpName = null;
            String metadataOption = null;
            String customIDPName = null;
            String newIdpName = null;
            this.xsrfToken = XsrfTokenUtils.getXsrfToken((HttpServletRequest)request);
            try {
                this.settings.setSpConfigurationStatus(null);
                String urlSubmitted = request.getParameter("urlSubmitted");
                String fileSubmitted = request.getParameter("fileSubmitted");
                setupType = request.getParameter("setupType");
                MoSAMLSettings.isMetadataUpload = Boolean.TRUE;
                if (BooleanUtils.toBoolean((String)urlSubmitted)) {
                    idpID = request.getParameter("idpID").trim();
                    idpName = request.getParameter("idpName").trim();
                    String metadataUrlString = request.getParameter("inputUrl").trim();
                    String effectiveUrl = this.getIdpMetadataUrl(metadataUrlString, metadataOption = request.getParameter("metadataOption"));
                    Boolean hasError = this.validateSPConfigurationImportMetadataUrl(request, effectiveUrl);
                    if (!hasError.booleanValue()) {
                        try {
                            MoPluginHandler.fetchMetadata(idpID, idpName, metadataUrlString, effectiveUrl, metadataOption);
                            request.getSession().setAttribute("success", (Object)"success");
                        }
                        catch (MoPluginException e) {
                            if (e.getErrorCode() == MoPluginException.PluginErrorCode.METADATA_PARSE) {
                                request.getSession().setAttribute("error", (Object)"An error occurred while parsing metadata.");
                            }
                            request.getSession().setAttribute("error", (Object)"Connection to Metadata URL failed. Download the metadata file and upload it using Import From Metadata option.");
                        }
                    }
                    response.sendRedirect("addidp.action?idpid=" + idpID);
                    break block25;
                }
                if (BooleanUtils.toBoolean((String)fileSubmitted)) {
                    MultiPartRequestWrapper wrapper = (MultiPartRequestWrapper)ServletActionContext.getRequest();
                    UploadedFile[] files = wrapper.getFiles("xmlFile");
                    if (files != null) {
                        idpID = wrapper.getParameter("idpID").trim();
                        idpName = wrapper.getParameter("idpName").trim();
                        metadataOption = wrapper.getParameter("metadataOption");
                        customIDPName = wrapper.getParameter("customIdpName");
                        newIdpName = wrapper.getParameter("newIdpname");
                        if (StringUtils.isEmpty((CharSequence)idpID)) {
                            idpID = UUID.randomUUID().toString();
                        }
                        String finalIdpname = StringUtils.equalsIgnoreCase((CharSequence)customIDPName, (CharSequence)"yes") && StringUtils.isNotBlank((CharSequence)newIdpName) ? newIdpName : idpName;
                        for (int var6 = 0; var6 < files.length; ++var6) {
                            UploadedFile file = files[var6];
                            if (!file.isFile()) continue;
                            try {
                                fileContents = FileUtils.readFileToString((File)((File)file.getContent()));
                                fileContents = fileContents.replaceAll("[^\\x20-\\x7e]", "");
                                if (StringUtils.isEmpty((CharSequence)fileContents)) {
                                    request.getSession().setAttribute("error", (Object)"Selected metadata file is empty.");
                                } else {
                                    uploadMetadataStatus = this.setAllFields(idpID, finalIdpname, fileContents, metadataOption);
                                    if (StringUtils.contains((CharSequence)uploadMetadataStatus, (CharSequence)"error")) {
                                        request.getSession().setAttribute("error", (Object)"Invalid IDP Metadata provided. Could not parse metadata.");
                                    } else if (StringUtils.contains((CharSequence)uploadMetadataStatus, (CharSequence)"success")) {
                                        request.getSession().setAttribute("success", (Object)"success");
                                    }
                                }
                            }
                            catch (Exception var9) {
                                request.getSession().setAttribute("error", (Object)"Invalid IDP Metadata provided. Could not parse metadata.");
                            }
                            if (StringUtils.equalsIgnoreCase((CharSequence)setupType, (CharSequence)"manualSetup")) {
                                LOGGER.debug("manual setup flow... succeed :" + uploadMetadataStatus);
                                response.sendRedirect("addidp.action?idpid=" + idpID);
                            } else if (StringUtils.equalsIgnoreCase((CharSequence)setupType, (CharSequence)"quickSetup")) {
                                request.getSession().setAttribute("idp", (Object)idpName);
                                request.getSession().setAttribute("idpid", (Object)idpID);
                                request.getSession().setAttribute("customIdpname", (Object)customIDPName);
                                request.getSession().setAttribute("newIdpname", (Object)newIdpName);
                                request.getSession().setAttribute("metadataOption", (Object)metadataOption);
                                response.sendRedirect("flowdrivensetup.action?idp=" + idpName);
                            }
                            return;
                        }
                        break block25;
                    }
                    LOGGER.debug("no file found...");
                    if (StringUtils.equalsIgnoreCase((CharSequence)setupType, (CharSequence)"manualSetup")) {
                        request.getSession().setAttribute("error", (Object)"Selected metadata file is empty.");
                        response.sendRedirect("addidp.action?idpid=" + idpID);
                    } else if (StringUtils.equalsIgnoreCase((CharSequence)setupType, (CharSequence)"quickSetup")) {
                        idpName = wrapper.getParameter("idpName").trim();
                        request.getSession().setAttribute("idp", (Object)idpName);
                        request.getSession().setAttribute("error", (Object)"Selected metadata file is empty.");
                        response.sendRedirect("flowdrivensetup.action?idp=" + idpName);
                    }
                    break block25;
                }
                request.getSession().setAttribute("error", (Object)"Connection to Metadata URL failed. Download the metadata file and upload it using Import From Metadata option.");
                response.sendRedirect("addidp.action?idpid=" + idpID);
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                request.getSession().setAttribute("error", (Object)"Connection to Metadata URL failed. Download the metadata file and upload it using Import From Metadata option.");
                if (StringUtils.equals(setupType, (CharSequence)"manualSetup")) {
                    response.sendRedirect("addidp.action?idpid=" + idpID);
                }
                if (!StringUtils.equals((CharSequence)setupType, (CharSequence)"quickSetup")) break block25;
                response.sendRedirect("flowdrivensetup.action?idp=" + idpName);
            }
        }
    }

    private String setAllFields(String idpID, String idpName, String fileContents, String metadataOption) {
        HashMap<String, Object> attrs = MoSAMLUtils.parseXml(fileContents);
        if (((String)attrs.get("message")).equals("error") || attrs.get("idpEntityId") == null || attrs.get("singleSignOnUrl") == null || attrs.get("X509Certificate") == null || attrs.get("allX509Certificates") == null || ((List)attrs.get("allX509Certificates")).size() == 0) {
            return "error";
        }
        String idpEntityId = (String)attrs.get("idpEntityId");
        String ssoBinding = (String)attrs.get("ssoBinding");
        String singleSignOnUrl = (String)attrs.get("singleSignOnUrl");
        String sloBinding = (String)attrs.get("sloBinding");
        String singleLogoutUrl = (String)attrs.get("singleLogoutUrl");
        String sloResponseLocationUrl = (String)attrs.get("sloResponseLocationUrl");
        List allX509Certificates = (List)attrs.get("allX509Certificates");
        String x509Certificate = (String)attrs.get("X509Certificate");
        String nameIdFormat = "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified";
        String authnContextClass = "";
        String otherAuthnContextClass = "";
        Boolean enableSsoForIdp = Boolean.TRUE;
        Boolean isRequestSigned = Boolean.TRUE;
        this.settings.setMetadataOption(idpID, (String)StringUtils.defaultIfBlank((CharSequence)metadataOption, (CharSequence)""));
        MoPluginHandler.saveIdPConfiguration(idpID, idpName, idpEntityId, ssoBinding, singleSignOnUrl, sloBinding, singleLogoutUrl, sloResponseLocationUrl, allX509Certificates, x509Certificate, isRequestSigned, nameIdFormat, enableSsoForIdp);
        MoPluginHandler.saveAdvancedOption(idpID, true, false, "", "", false, "hourly", 60, "minutes", "", "forceRedirect", true, "");
        MoPluginHandler.toggleSchedulerService(idpID);
        return "success";
    }

    public MoSAMLSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoSAMLSettings settings) {
        this.settings = settings;
    }

    public String getXsrfToken() {
        return this.xsrfToken;
    }

    public void setXsrfToken(String xsrfToken) {
        this.xsrfToken = xsrfToken;
    }

    private String getIdpMetadataUrl(String inputUrl, String metadataOption) {
        String getIdpMetadataUrl = "";
        switch (metadataOption) {
            case "ADFS": {
                getIdpMetadataUrl = "https://" + inputUrl + "/federationmetadata/2007-06/federationmetadata.xml";
                break;
            }
            case "Azure AD": {
                getIdpMetadataUrl = "https://login.microsoftonline.com/" + inputUrl + "/FederationMetadata/2007-06/FederationMetadata.xml";
                break;
            }
            default: {
                getIdpMetadataUrl = inputUrl;
            }
        }
        return getIdpMetadataUrl;
    }

    private Boolean validateSPConfigurationImportMetadataUrl(HttpServletRequest request, String importUrl) throws IOException {
        LOGGER.debug("Validating SP Configuration Data.");
        if (StringUtils.isBlank((CharSequence)importUrl)) {
            request.getSession().setAttribute("error", (Object)"Import Metadata URL can not be left blank.");
            return Boolean.TRUE;
        }
        try {
            new URL(importUrl);
        }
        catch (MalformedURLException e) {
            request.getSession().setAttribute("error", (Object)"Invalid Metadata URL.");
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

