/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.bamboo.action;

import com.atlassian.bamboo.security.xsrf.XsrfTokenUtils;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.miniorange.sso.saml.MoPluginException;
import com.miniorange.sso.saml.bamboo.MoPluginHandler;
import com.miniorange.sso.saml.bamboo.MoSAMLSettings;
import com.miniorange.sso.saml.bamboo.action.MoAddIDPConfigurationAction;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoLooknFeelAction
extends BambooActionSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoAddIDPConfigurationAction.class);
    private UserManager userManager;
    private LoginUriProvider loginUriProvider;
    private MoSAMLSettings settings;
    private String loginButtonText;
    private Boolean looknfeelSettingsSubmitted;
    private String status;
    private Boolean enableLoginTemplate;
    private String loginTemplate;
    private String errorMsgTemplate;
    private Boolean enableErrorMsgTemplate;
    private Boolean showLoginButtons;
    private Boolean hideDefaultLogin;
    private String xsrfToken;

    public MoLooknFeelAction(UserManager userManager, LoginUriProvider loginUriProvider, MoSAMLSettings settings) {
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.settings = settings;
    }

    public void doValidate() {
        this.loginTemplate = StringUtils.equals((CharSequence)this.loginTemplate, null) ? this.settings.getLoginTemplate() : this.loginTemplate;
        this.errorMsgTemplate = StringUtils.equals((CharSequence)this.errorMsgTemplate, null) ? this.settings.getErrorMsgTemplate() : this.errorMsgTemplate;
    }

    public String execute() throws Exception {
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        this.xsrfToken = XsrfTokenUtils.getXsrfToken((HttpServletRequest)request);
        UserProfile user = this.userManager.getRemoteUser();
        if (user != null && this.userManager.isAdmin(user.getUserKey())) {
            try {
                if (!this.settings.isValidLicense().booleanValue()) {
                    LOGGER.error("No valid license found");
                    return "upm";
                }
                if (BooleanUtils.toBoolean((Boolean)this.looknfeelSettingsSubmitted)) {
                    this.doValidate();
                    MoPluginHandler.saveLookAndFeelSettings(StringUtils.trim((String)this.loginButtonText), this.errorMsgTemplate, this.enableErrorMsgTemplate, this.enableLoginTemplate, this.loginTemplate, this.showLoginButtons, this.hideDefaultLogin);
                    this.addActionMessage(this.getText("samlsso.success.config"));
                    LOGGER.debug("settings saved successfully");
                }
                this.initializeSAMLConfig();
                return "success";
            }
            catch (MoPluginException e) {
                this.addActionError(e.getMessage());
                return "input";
            }
            catch (Exception e) {
                LOGGER.error("An error occurred while saving your details.", (Throwable)e);
                this.addActionError("An error occurred while saving your details. Please check logs for more info.");
                return "input";
            }
        }
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
        return null;
    }

    private void initializeSAMLConfig() {
        this.loginButtonText = this.settings.getLoginButtonText();
        this.enableLoginTemplate = this.settings.getEnableLoginTemplate();
        this.loginTemplate = this.settings.getLoginTemplate();
        this.enableLoginTemplate = this.settings.getEnableLoginTemplate();
        this.errorMsgTemplate = this.settings.getErrorMsgTemplate();
        this.enableErrorMsgTemplate = this.settings.getEnableErrorMsgTemplate();
        this.showLoginButtons = this.settings.getShowLoginButtons();
        this.hideDefaultLogin = this.settings.getHideDefaultLogin();
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    public HashMap<String, String> getIdpMap() {
        return this.settings.getIdpMap();
    }

    public ArrayList<String> getIdpList() {
        return this.settings.getIdPList();
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public LoginUriProvider getLoginUriProvider() {
        return this.loginUriProvider;
    }

    public void setLoginUriProvider(LoginUriProvider loginUriProvider) {
        this.loginUriProvider = loginUriProvider;
    }

    public MoSAMLSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoSAMLSettings settings) {
        this.settings = settings;
    }

    public String getLoginButtonText() {
        return this.loginButtonText;
    }

    public void setLoginButtonText(String loginButtonText) {
        this.loginButtonText = loginButtonText;
    }

    public Boolean getLooknfeelSettingsSubmitted() {
        return this.looknfeelSettingsSubmitted;
    }

    public void setLooknfeelSettingsSubmitted(Boolean looknfeelSettingsSubmitted) {
        this.looknfeelSettingsSubmitted = looknfeelSettingsSubmitted;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Boolean getEnableLoginTemplate() {
        return this.enableLoginTemplate;
    }

    public void setEnableLoginTemplate(Boolean enableLoginTemplate) {
        this.enableLoginTemplate = enableLoginTemplate;
    }

    public String getLoginTemplate() {
        return this.loginTemplate;
    }

    public void setLoginTemplate(String loginTemplate) {
        this.loginTemplate = loginTemplate;
    }

    public String getErrorMsgTemplate() {
        return this.errorMsgTemplate;
    }

    public void setErrorMsgTemplate(String errorMsgTemplate) {
        this.errorMsgTemplate = errorMsgTemplate;
    }

    public Boolean getEnableErrorMsgTemplate() {
        return this.enableErrorMsgTemplate;
    }

    public void setEnableErrorMsgTemplate(Boolean enableErrorMsgTemplate) {
        this.enableErrorMsgTemplate = enableErrorMsgTemplate;
    }

    public Boolean getShowLoginButtons() {
        return this.showLoginButtons;
    }

    public void setShowLoginButtons(Boolean showLoginButtons) {
        this.showLoginButtons = showLoginButtons;
    }

    public Boolean getHideDefaultLogin() {
        return this.hideDefaultLogin;
    }

    public void setHideDefaultLogin(Boolean hideDefaultLogin) {
        this.hideDefaultLogin = hideDefaultLogin;
    }

    public String getXsrfToken() {
        return this.xsrfToken;
    }

    public void setXsrfToken(String xsrfToken) {
        this.xsrfToken = xsrfToken;
    }
}

