/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.bamboo.action;

import com.atlassian.bamboo.security.xsrf.XsrfTokenUtils;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.miniorange.sso.saml.MoPluginException;
import com.miniorange.sso.saml.bamboo.MoPluginHandler;
import com.miniorange.sso.saml.bamboo.MoSAMLSettings;
import com.miniorange.sso.saml.bamboo.action.MoAddIDPConfigurationAction;
import com.miniorange.sso.saml.dto.MoIDPConfig;
import com.miniorange.sso.saml.utils.MoSAMLUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoTroubleshootingAction
extends BambooActionSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoAddIDPConfigurationAction.class);
    private UserManager userManager;
    private LoginUriProvider loginUriProvider;
    private MoSAMLSettings settings;
    private String xsrfToken;
    private MoPluginHandler pluginHandler;
    private MoIDPConfig idpConfig;
    private String testConfigResults;
    private String displaySamlResponse;
    private String displaySamlRequest;
    private Map<String, List<String>> attributesMap;
    private Boolean testConfigPerformed = Boolean.FALSE;
    private String idpID;

    public MoTroubleshootingAction(UserManager userManager, LoginUriProvider loginUriProvider, MoSAMLSettings settings) {
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.settings = settings;
    }

    public void doValidate() {
        LOGGER.info("Look n Feel Action doValidate called");
    }

    public String execute() throws Exception {
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        this.xsrfToken = XsrfTokenUtils.getXsrfToken((HttpServletRequest)request);
        UserProfile user = this.userManager.getRemoteUser();
        if (user != null && this.userManager.isAdmin(user.getUserKey())) {
            try {
                if (!this.settings.isValidLicense().booleanValue()) {
                    LOGGER.error("No valid license found");
                    return "upm";
                }
                if (StringUtils.isNotBlank((CharSequence)request.getParameter("idpid"))) {
                    this.idpID = request.getParameter("idpid");
                }
                this.testConfigPerformed = this.settings.checkIfTestConfig(this.idpID);
                LOGGER.debug("Test Configured :" + this.testConfigPerformed);
                this.initializeTroubleshooting();
                return "success";
            }
            catch (MoPluginException e) {
                LOGGER.error("An error occurred while saving your details." + e);
                this.addActionError(e.getMessage());
                return "error";
            }
            catch (Exception e) {
                LOGGER.error("An error occurred while saving your details." + e);
                this.addActionError("An error occured while saving your details. Please check logs for more info.");
                return "error";
            }
        }
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
        return null;
    }

    private void initializeTroubleshooting() {
        this.idpConfig = MoPluginHandler.constructIdpConfigObject(this.idpID);
        this.testConfigPerformed = this.settings.checkIfTestConfig(this.idpID);
        try {
            if (this.testConfigPerformed.booleanValue() && this.idpConfig != null) {
                this.attributesMap = MoSAMLUtils.toMap((JSONObject)this.settings.getIdpConfig(this.idpID).get("testConfig"));
                this.displaySamlResponse = (String)this.settings.getIdpConfig(this.idpID).get("samlResponse");
                this.displaySamlRequest = (String)this.settings.getIdpConfig(this.idpID).get("samlRequest");
            } else {
                this.attributesMap = new HashMap<String, List<String>>();
                this.displaySamlResponse = "";
                this.displaySamlRequest = "";
            }
        }
        catch (Exception e) {
            LOGGER.debug("error getting the test config details from settings.getIdpConfig(this.idpID)");
        }
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    public HashMap<String, String> getIdpMap() {
        return this.settings.getIdpMap();
    }

    public ArrayList<String> getIdpList() {
        return this.settings.getIdPList();
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public LoginUriProvider getLoginUriProvider() {
        return this.loginUriProvider;
    }

    public void setLoginUriProvider(LoginUriProvider loginUriProvider) {
        this.loginUriProvider = loginUriProvider;
    }

    public MoSAMLSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoSAMLSettings settings) {
        this.settings = settings;
    }

    public MoPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    public void setPluginHandler(MoPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }

    public MoIDPConfig getIdpConfig() {
        return this.idpConfig;
    }

    public void setIdpConfig(MoIDPConfig idpConfig) {
        this.idpConfig = idpConfig;
    }

    public String getTestConfigResults() {
        return this.testConfigResults;
    }

    public void setTestConfigResults(String testConfigResults) {
        this.testConfigResults = testConfigResults;
    }

    public String getDisplaySamlResponse() {
        return this.displaySamlResponse;
    }

    public void setDisplaySamlResponse(String displaySamlResponse) {
        this.displaySamlResponse = displaySamlResponse;
    }

    public String getDisplaySamlRequest() {
        return this.displaySamlRequest;
    }

    public void setDisplaySamlRequest(String displaySamlRequest) {
        this.displaySamlRequest = displaySamlRequest;
    }

    public Map<String, List<String>> getAttributesMap() {
        return this.attributesMap;
    }

    public void setAttributesMap(Map<String, List<String>> attributesMap) {
        this.attributesMap = attributesMap;
    }

    public Boolean getTestConfigPerformed() {
        return this.testConfigPerformed;
    }

    public void setTestConfigPerformed(Boolean testConfigPerformed) {
        this.testConfigPerformed = testConfigPerformed;
    }

    public String getIdpID() {
        return this.idpID;
    }

    public void setIdpID(String idpID) {
        this.idpID = idpID;
    }

    public String getXsrfToken() {
        return this.xsrfToken;
    }

    public void setXsrfToken(String xsrfToken) {
        this.xsrfToken = xsrfToken;
    }

    public String getLogSettingsUrl() {
        return this.settings.getSpBaseUrl() + "/admin/configLog4j.action";
    }

    public String getTroubleshootingUrl() {
        return this.settings.getSpBaseUrl() + "/plugins/servlet/troubleshooting/view/";
    }
}

