/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.bamboo.schedulers;

import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.sal.api.scheduling.PluginScheduler;
import com.miniorange.sso.saml.bamboo.MoSAMLSettings;
import com.miniorange.sso.saml.bamboo.schedulers.CertificateExpiryCheck;
import com.miniorange.sso.saml.bamboo.schedulers.CertificateValidatorTask;
import com.miniorange.sso.saml.utils.MoSendAlert;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CertificateExpiryCheckImpl
implements CertificateExpiryCheck,
LifecycleAware {
    public static final String KEY = CertificateExpiryCheckImpl.class.getName() + ":instance";
    private static final String JOB_NAME = CertificateExpiryCheckImpl.class.getName() + ":job";
    private final Log LOGGER = LogFactory.getLog(CertificateExpiryCheckImpl.class);
    private MoSAMLSettings moSAMLSettings;
    private PluginScheduler pluginScheduler;
    private Long interval = 86400000L;
    private MoSendAlert moSendAlert;

    public CertificateExpiryCheckImpl(MoSAMLSettings moSAMLSettings, PluginScheduler pluginScheduler, MoSendAlert moSendAlert) {
        this.moSAMLSettings = moSAMLSettings;
        this.pluginScheduler = pluginScheduler;
        this.moSendAlert = moSendAlert;
    }

    public void onStart() {
        this.reschedule(this.interval);
    }

    @Override
    public void reschedule(Long interval) {
        this.LOGGER.info((Object)"Rescheduling the Certificate Check Expiry");
        this.pluginScheduler.scheduleJob(JOB_NAME, CertificateValidatorTask.class, (Map)new HashMap<String, Object>(){
            {
                this.put(KEY, CertificateExpiryCheckImpl.this);
                this.put("moSAMLSettings", CertificateExpiryCheckImpl.this.moSAMLSettings);
                this.put("moSendAlert", CertificateExpiryCheckImpl.this.moSendAlert);
            }
        }, new Date(), interval.longValue());
    }

    public void onStop() {
    }

    public String getPublicSPCertificate() {
        return this.moSAMLSettings.getPublicSPCertificate();
    }

    public void setPluginScheduler(PluginScheduler pluginScheduler) {
        this.pluginScheduler = pluginScheduler;
    }

    public void setSettings(MoSAMLSettings settings) {
        this.moSAMLSettings = settings;
    }
}

