<html>
<head>
    <title>SAML SSO Configuration</title>
    <meta name="decorator" content="atl.general">
    <script>
            <#include "/js/sessionmanagement.js">
    </script>
</head>
<body>
    <#include "*/saml/headers/samlheader.ftl" parse=true>
<div class="tabs-pane active-pane" id="configure-sp" role="tabpanel">
    <h2>Remember-Me Settings</h2>
    <hr class="header"/>
    <form id="remember-me-form" name="remember-me-form" class="aui long-label" action="" method="POST">
    <input type="hidden" name="atl_token" value="${xsrfToken}" />
        <input type="hidden" name="rememberMeSubmitted" value="true"/>

        <#if settings.getIdPList().size() gt 1 >
            <div id="enable-remember-my-idp" class="field-group" style="margin-top: 15px;" >
                <label for="enableRememberMyIdpCookie">Remember My IDP</label>
                <aui-toggle id="enableRememberMyIdpCookie" name="enableRememberMyIdpCookie"  <#if enableRememberMyIdpCookie == true>
                            checked="true" </#if> label="Enable Remember-My-Idp Cookie" value="true"></aui-toggle>
                <div class="description">User's selected IDP will be remembered when he login for first time. After successfully logging in with an IdP, a cookie will be set in their browsers that will allow them to skip the selection page in the future.
                <br>
                Note: Enabling this feature will also enable the 'Custom Logout Template'.
                </div>
            </div>
                <div id="RememberMyIdpCookielife" class="field-group">
                    <div id="user-Consent" >
                        <aui-toggle id="userConsent" name="userConsent"  <#if userConsent == true>
                                    checked="true" </#if> label="User Consent" value="true"></aui-toggle>
                        <label for="userConsent">Ask For User's Consent</label>
                        <div class="description">User's Consent will be taken to Remember IDP or not.
                        </div>
                    </div>
                    <br>
                    <p style="display:inline;"><label>Remember IDP for</label></p>
                    <span id="saved_cookieLife_div">
                        <p id= savedConfiguredLifeForIdpCookie style="display:inline; margin-left:10px;" > ${configuredLifeForIdpCookie} </p>
                        <label for="configuredLifeForIdpCookie">Days</label>
                        <a id="edit-cookieLife-button" class="aui-button aui-button-subtle aui-icon aui-icon-small aui-iconfont-edit"
                            title="edit cookie life"  style="width: auto;"></a>
                    </span>
                    <span id="edit_cookieLife_div" style="cursor:default; display: none">
                            <input type=number name=configuredLifeForIdpCookie id=configuredLifeForIdpCookie value="${configuredLifeForIdpCookie}"
                            placeholder=" Enter Life of Cookie" class="text short-field"
                            style="text-align: center !important; margin-left:10px; "/>
                            <label for="configuredLifeForIdpCookie">Days</label>
                            <br>
                        <a id="save-cookieLife-button"
                            class="aui-button aui-button-subtle aui-icon aui-icon-small aui-iconfont-success" title="save" style= "margin-left:320px; width: auto;" ></a> <a
                        id="cancel-cookieLife-button"
                        class="aui-button aui-button-subtle aui-icon aui-icon-small aui-iconfont-close-dialog" title="cancel" style= "margin-left:-10px;width: auto;"></a>
                    </span>
                </div>
            <div class="field-group">
                <input type="submit" value="Save" class="aui-button aui-button-primary" style="width:100px;"/>
            </div>
            <br>
            <br>
        </#if>

        <div id="enable-remember-my-login" class="field-group">
            <label for="enableRememberMeCookie">Set Remember Me-Cookie</label>
            <aui-toggle id="enableRememberMeCookie" name="enableRememberMeCookie" <#if enableRememberMeCookie==true>
                        checked </#if> label="Enable Remember-Me Cookie" value="true"
                        onchange="enableRememberMe()"></aui-toggle>
            <div class="description">User stays logged in until user explicitly
                logs out.
            </div>
            <br>
        </div>



    </form>
    <br>
    <p style="font-size:16pt;">User Session Timeout</p>
    <hr class="header"/>
    <div style="padding-left: 1%">
        <p>
            An end-user's session in Bamboo will timeout after 30 minutes of inactivity. This is the
            default
            value for session timeout.
        </p>
        <p>You can change the user session timeout.</p>
        <p>
        <ol style="line-height: 220%">
            <li>
                Open<code id="p2" class="copyable" style="display: inline; border:0px !important; padding: 5px 0 5px 0px !important; margin: 0em !important;" >
                &lt;bamboo-installation folder&gt;\atlassian-bamboo\WEB-INF\web.xml </code>
                <span id="p2-copied-message" title="Copied" class="copy-title" style="display:none"></span>
            </li>
            <li>
                Set value of &lt;session-timeout&gt; tag in minutes. By default it is 30. You can set
                it
                to 0 for unlimited login time.
            </li>
        </ol>
        </p>
    </div>
</div>
<br><br>
    <#include "*/footer.ftl" parse=true>
</body>
</html>