/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.binding.encoding;

import java.io.UnsupportedEncodingException;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.saml2.binding.encoding.HTTPPostEncoder;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.security.SecurityConfiguration;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.SecurityHelper;
import org.opensaml.xml.security.SigningUtil;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.keyinfo.KeyInfoGenerator;
import org.opensaml.xml.signature.KeyInfo;
import org.opensaml.xml.util.Base64;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPPostSimpleSignEncoder
extends HTTPPostEncoder {
    private final Logger log = LoggerFactory.getLogger(HTTPPostSimpleSignEncoder.class);
    private boolean signProtocolMessageWithXMLDSIG;

    public HTTPPostSimpleSignEncoder(VelocityEngine engine, String templateId) {
        super(engine, templateId);
        this.signProtocolMessageWithXMLDSIG = false;
    }

    public HTTPPostSimpleSignEncoder(VelocityEngine engine, String templateId, boolean signXMLProtocolMessage) {
        super(engine, templateId);
        this.signProtocolMessageWithXMLDSIG = signXMLProtocolMessage;
    }

    @Override
    public String getBindingURI() {
        return "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign";
    }

    @Override
    protected void signMessage(SAMLMessageContext messageContext) throws MessageEncodingException {
        if (this.signProtocolMessageWithXMLDSIG) {
            super.signMessage(messageContext);
        }
    }

    @Override
    protected void populateVelocityContext(VelocityContext velocityContext, SAMLMessageContext messageContext, String endpointURL) throws MessageEncodingException {
        String kiBase64;
        super.populateVelocityContext(velocityContext, messageContext, endpointURL);
        Credential signingCredential = messageContext.getOuboundSAMLMessageSigningCredential();
        if (signingCredential == null) {
            this.log.debug("No signing credential was supplied, skipping HTTP-Post simple signing");
            return;
        }
        String sigAlgURI = this.getSignatureAlgorithmURI(signingCredential, null);
        velocityContext.put("SigAlg", sigAlgURI);
        String formControlData = this.buildFormDataToSign(velocityContext, messageContext, sigAlgURI);
        velocityContext.put("Signature", this.generateSignature(signingCredential, sigAlgURI, formControlData));
        KeyInfoGenerator kiGenerator = SecurityHelper.getKeyInfoGenerator(signingCredential, null, null);
        if (kiGenerator != null && !DatatypeHelper.isEmpty(kiBase64 = this.buildKeyInfo(signingCredential, kiGenerator))) {
            velocityContext.put("KeyInfo", kiBase64);
        }
    }

    protected String buildKeyInfo(Credential signingCredential, KeyInfoGenerator kiGenerator) throws MessageEncodingException {
        try {
            KeyInfo keyInfo = kiGenerator.generate(signingCredential);
            if (keyInfo != null) {
                Marshaller marshaller = Configuration.getMarshallerFactory().getMarshaller(keyInfo);
                if (marshaller == null) {
                    this.log.error("No KeyInfo marshaller available from configuration");
                    throw new MessageEncodingException("No KeyInfo marshaller was configured");
                }
                String kiXML = XMLHelper.nodeToString(marshaller.marshall(keyInfo));
                String kiBase64 = Base64.encodeBytes(kiXML.getBytes(), 8);
                return kiBase64;
            }
            return null;
        }
        catch (SecurityException e) {
            this.log.error("Error generating KeyInfo from signing credential", (Throwable)e);
            throw new MessageEncodingException("Error generating KeyInfo from signing credential", e);
        }
        catch (MarshallingException e) {
            this.log.error("Error marshalling KeyInfo based on signing credential", (Throwable)e);
            throw new MessageEncodingException("Error marshalling KeyInfo based on signing credential", e);
        }
    }

    protected String buildFormDataToSign(VelocityContext velocityContext, SAMLMessageContext messageContext, String sigAlgURI) {
        StringBuilder builder = new StringBuilder();
        boolean isRequest = false;
        if (velocityContext.get("SAMLRequest") != null) {
            isRequest = true;
        }
        String msgB64 = isRequest ? (String)velocityContext.get("SAMLRequest") : (String)velocityContext.get("SAMLResponse");
        String msg = null;
        try {
            msg = new String(Base64.decode(msgB64), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        if (isRequest) {
            builder.append("SAMLRequest=" + msg);
        } else {
            builder.append("SAMLResponse=" + msg);
        }
        if (messageContext.getRelayState() != null) {
            builder.append("&RelayState=" + messageContext.getRelayState());
        }
        builder.append("&SigAlg=" + sigAlgURI);
        return builder.toString();
    }

    protected String getSignatureAlgorithmURI(Credential credential, SecurityConfiguration config) throws MessageEncodingException {
        SecurityConfiguration secConfig = config != null ? config : Configuration.getGlobalSecurityConfiguration();
        String signAlgo = secConfig.getSignatureAlgorithmURI(credential);
        if (signAlgo == null) {
            throw new MessageEncodingException("The signing credential's algorithm URI could not be derived");
        }
        return signAlgo;
    }

    protected String generateSignature(Credential signingCredential, String algorithmURI, String formData) throws MessageEncodingException {
        this.log.debug(String.format("Generating signature with key type '%s', algorithm URI '%s' over form control string '%s'", SecurityHelper.extractSigningKey(signingCredential).getAlgorithm(), algorithmURI, formData));
        String b64Signature = null;
        try {
            byte[] rawSignature = SigningUtil.signWithURI(signingCredential, algorithmURI, formData.getBytes("UTF-8"));
            b64Signature = Base64.encodeBytes(rawSignature, 8);
            this.log.debug("Generated digital signature value (base64-encoded) {}", (Object)b64Signature);
        }
        catch (SecurityException e) {
            this.log.error("Error during URL signing process", (Throwable)e);
            throw new MessageEncodingException("Unable to sign form control string", e);
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        return b64Signature;
    }
}

