/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.bamboo.action;

import com.atlassian.bamboo.security.xsrf.XsrfTokenUtils;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.miniorange.sso.saml.MoPluginException;
import com.miniorange.sso.saml.bamboo.MoPluginHandler;
import com.miniorange.sso.saml.bamboo.MoSAMLSettings;
import com.miniorange.sso.saml.dto.MoIDPConfig;
import com.miniorange.sso.saml.utils.MoSAMLUtils;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.struts2.ServletActionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoAddIDPConfigurationAction
extends BambooActionSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoAddIDPConfigurationAction.class);
    private UserManager userManager;
    private LoginUriProvider loginUriProvider;
    private MoSAMLSettings settings;
    private String sloResponseLocationUrl;
    private String idpEntityId;
    private String ssoUrl;
    private String ssoBindingType;
    private String sloUrl;
    private String sloBindingType;
    private String nameIdFormat;
    private String x509Certificate;
    private List<String> certificates;
    private String[] x509AllCertificates;
    private Boolean signedRequest;
    private List<String> authnContextClasses;
    private String authnContextClass;
    private String otherAuthnContextClass;
    private String xsrfToken;
    private Boolean submitted;
    private ArrayList<String> metadataOptions;
    private String metadataOption;
    private String inputUrl;
    private Boolean refreshMetadata;
    private String refreshInterval;
    private Integer customRefreshInterval;
    private String customRefreshIntervalUnit;
    private Boolean shouldContainsAddIdp;
    private Boolean shouldShowBackButton;
    private String idpID;
    private String idpName;
    private List<String> idpList;
    private String acsUrl;
    private Boolean addIdpSubmitted;
    private Boolean metadataImported;
    private Boolean fileSubmitted;
    private Boolean urlSubmitted;
    private MoIDPConfig idpConfig;
    private List<String> nameIdFormats;
    private Boolean enableSsoForIdp;

    public MoAddIDPConfigurationAction(UserManager userManager, LoginUriProvider loginUriProvider, MoSAMLSettings settings) {
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.settings = settings;
    }

    public Boolean doValidate() {
        LOGGER.debug("Add IDP Action: validate() called");
        Boolean error = false;
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        if (!BooleanUtils.toBoolean((Boolean)this.addIdpSubmitted)) {
            error = true;
        }
        if (BooleanUtils.toBoolean((Boolean)this.addIdpSubmitted)) {
            if (StringUtils.isBlank(this.idpName)) {
                this.addActionError(this.getText("samlsso.error.config.idpName.empty"));
                error = true;
            }
            if (StringUtils.isBlank(this.ssoUrl)) {
                this.addActionError(this.getText("samlsso.error.config.ssourl.empty"));
                error = true;
            } else {
                try {
                    new URL(this.ssoUrl);
                }
                catch (MalformedURLException e) {
                    this.addActionError(this.getText("samlsso.error.config.ssourl.malformed"));
                    error = true;
                }
            }
            if (StringUtils.isNotBlank(this.sloUrl)) {
                try {
                    new URL(this.sloUrl);
                }
                catch (MalformedURLException e) {
                    this.addActionError(this.getText("samlsso.error.config.slourl.malformed"));
                    error = true;
                }
            }
            if (StringUtils.isNotBlank(this.sloResponseLocationUrl)) {
                try {
                    if (StringUtils.isBlank(this.sloUrl)) {
                        this.addActionError("Single Logout URL is needed for Response location");
                        error = true;
                    } else {
                        new URL(this.sloResponseLocationUrl);
                    }
                }
                catch (MalformedURLException e) {
                    LOGGER.error("Invalid URL", (Throwable)e);
                    this.addActionError(this.getText("samlsso.error.config.sloresponselocationurl.malformed"));
                    error = true;
                }
            }
            if (StringUtils.isBlank(this.idpEntityId)) {
                this.addActionError(this.getText("samlsso.error.config.idpentityid.empty"));
                error = true;
            }
            if (this.x509AllCertificates != null) {
                if (this.x509AllCertificates.length == 1) {
                    if (StringUtils.isBlank(this.x509AllCertificates[0])) {
                        this.addActionError("IDP Signing Certificate cannot be left blank.");
                        error = true;
                    } else if (!MoSAMLUtils.isValidPublicCertificate(this.x509AllCertificates[0]).booleanValue()) {
                        this.addActionError("Invalid IDP Signing Certificate.");
                        error = true;
                    }
                } else {
                    int isBlankCertificate = 0;
                    for (String certificate : this.x509AllCertificates) {
                        if (!MoSAMLUtils.isValidPublicCertificate(certificate).booleanValue() && !StringUtils.isBlank(certificate)) {
                            this.addActionError("Invalid IDP Signing Certificate " + (Arrays.asList(this.x509AllCertificates).indexOf(certificate) + 1));
                            error = true;
                        }
                        if (!StringUtils.isBlank(certificate)) continue;
                        ++isBlankCertificate;
                    }
                    if (isBlankCertificate == this.x509AllCertificates.length) {
                        this.addActionError("Signing Certificate cannot be left blank.");
                        error = true;
                    }
                }
            } else if (StringUtils.isBlank(this.x509Certificate)) {
                this.addActionError("Signing Certificate cannot be left blank.");
                error = true;
            } else if (!MoSAMLUtils.isValidPublicCertificate(this.x509Certificate).booleanValue()) {
                this.addActionError("Invalid IDP Signing Certificate.");
                error = true;
            }
            if (!StringUtils.equals(this.ssoBindingType, "HttpRedirect") && !StringUtils.equals(this.ssoBindingType, "HttpPost")) {
                this.addActionError(this.getText("samlsso.error.config.ssobinding.invalid"));
                error = true;
            }
            if (!StringUtils.equals(this.sloBindingType, "HttpRedirect") && !StringUtils.equals(this.sloBindingType, "HttpPost")) {
                this.addActionError(this.getText("samlsso.error.config.slobinding.invalid"));
                error = true;
            }
        }
        if (super.hasActionErrors()) {
            this.xsrfToken = XsrfTokenUtils.getXsrfToken((HttpServletRequest)request);
            this.initializeSAMLConfig();
        }
        return error;
    }

    public String execute() throws Exception {
        LOGGER.debug("Add IDP Action execute() called");
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        this.xsrfToken = XsrfTokenUtils.getXsrfToken((HttpServletRequest)request);
        this.shouldShowBackButton = false;
        UserProfile user = this.userManager.getRemoteUser();
        if (user != null && this.userManager.isAdmin(user.getUserKey())) {
            try {
                LOGGER.debug("Add IdP Action execute submitted: " + this.submitted);
                if (!this.settings.isValidLicense().booleanValue()) {
                    LOGGER.debug("Invalid License");
                    return "upm";
                }
                this.idpList = this.getIdpList();
                if (StringUtils.isBlank(this.idpID)) {
                    if (StringUtils.isNotBlank(request.getParameter("idpid"))) {
                        this.idpID = request.getParameter("idpid");
                    } else {
                        this.idpID = UUID.randomUUID().toString();
                        if (StringUtils.isNotBlank(this.settings.getSsoServiceUrl())) {
                            LOGGER.debug("Storing old IDP config values and initializing idp: " + this.idpID);
                            this.idpName = "IDP";
                            MoPluginHandler.replaceOldSettingsWithNew(this.idpID, this.idpName);
                        }
                    }
                }
                if (BooleanUtils.toBoolean((Boolean)this.addIdpSubmitted)) {
                    LOGGER.debug("add IDP Submitted..");
                    Boolean error = this.doValidate();
                    if (!error.booleanValue()) {
                        ArrayList<Object> x509allcertificates = new ArrayList<String>();
                        if (this.x509Certificate != null) {
                            x509allcertificates.add(this.x509Certificate);
                        }
                        if (this.x509AllCertificates != null) {
                            x509allcertificates = new ArrayList<String>(Arrays.asList(this.x509AllCertificates));
                            x509allcertificates.removeAll(Arrays.asList(null, ""));
                            if (StringUtils.isBlank(this.x509Certificate)) {
                                this.x509Certificate = (String)x509allcertificates.get(0);
                            }
                        }
                        MoPluginHandler.saveIdPConfiguration(this.idpID, this.idpName, this.idpEntityId, this.ssoBindingType, this.ssoUrl, this.sloBindingType, this.sloUrl, StringUtils.trim(this.sloResponseLocationUrl), x509allcertificates, this.x509Certificate, this.signedRequest, this.nameIdFormat, this.enableSsoForIdp);
                        this.addActionMessage(this.getText("samlsso.success.config"));
                        this.initializeSAMLConfig();
                        return "success";
                    }
                }
                LOGGER.debug("request.getParameter(\"operation\") = " + request.getParameter("operation"));
                if (StringUtils.equalsIgnoreCase("add", request.getParameter("operation")) || this.idpList.size() > 1) {
                    this.shouldShowBackButton = Boolean.TRUE;
                }
                if (MoSAMLSettings.isMetadataUpload.booleanValue()) {
                    MoSAMLSettings.isMetadataUpload = Boolean.FALSE;
                    if (request.getSession().getAttribute("success") != null || request.getSession().getAttribute("error") != null) {
                        if (request.getSession().getAttribute("success") != null) {
                            this.addActionMessage(this.getText("samlsso.success.config"));
                            request.getSession().removeAttribute("success");
                        } else if (request.getSession().getAttribute("error") != null) {
                            this.addActionError(request.getSession().getAttribute("error").toString());
                            request.getSession().removeAttribute("error");
                        }
                    }
                    request.getSession().removeAttribute("error");
                    request.getSession().removeAttribute("success");
                }
                this.initializeSAMLConfig();
                return "success";
            }
            catch (MoPluginException e) {
                e.printStackTrace();
                this.addActionError(e.getMessage());
                return "input";
            }
            catch (Exception e) {
                e.printStackTrace();
                this.addActionError("An error occurred while saving your details. Please check logs for more info.");
                return "input";
            }
        }
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
        return null;
    }

    private void initializeSAMLConfig() {
        this.acsUrl = this.settings.getLoginServletUrl() + "?idp=" + this.idpID;
        MoIDPConfig idpConfig = MoPluginHandler.constructIdpConfigObject(this.idpID);
        if (idpConfig == null) {
            this.initializeNewForm();
            return;
        }
        this.idpName = StringUtils.defaultIfBlank(idpConfig.getIdpName(), "");
        this.idpEntityId = StringUtils.defaultIfBlank(idpConfig.getIdpEntityId(), "");
        this.ssoUrl = StringUtils.defaultIfBlank(idpConfig.getSsoUrl(), "");
        this.sloUrl = StringUtils.defaultIfBlank(idpConfig.getSloUrl(), "");
        this.sloResponseLocationUrl = StringUtils.defaultIfBlank(idpConfig.getSloResponseLocationUrl(), "");
        this.ssoBindingType = StringUtils.defaultIfBlank(idpConfig.getSsoBindingType(), "HttpRedirect");
        this.sloBindingType = StringUtils.defaultIfBlank(idpConfig.getSloBindingType(), "HttpRedirect");
        this.certificates = idpConfig.getCertificates();
        this.x509Certificate = StringUtils.defaultIfBlank(idpConfig.getX509Certificate(), "");
        this.signedRequest = BooleanUtils.toBooleanDefaultIfNull((Boolean)idpConfig.getSignedRequest(), (boolean)true);
        this.refreshMetadata = BooleanUtils.toBooleanDefaultIfNull((Boolean)idpConfig.getRefreshMetadata(), (boolean)false);
        this.refreshInterval = StringUtils.defaultIfBlank(idpConfig.getRefreshInterval(), "hourly");
        this.inputUrl = StringUtils.defaultIfBlank(idpConfig.getInputUrl(), "");
        this.customRefreshInterval = idpConfig.getCustomRefreshInterval() != null ? idpConfig.getCustomRefreshInterval() : 60;
        this.customRefreshIntervalUnit = StringUtils.defaultIfBlank(idpConfig.getCustomRefreshIntervalUnit(), "minutes");
        this.metadataOption = StringUtils.defaultIfBlank(idpConfig.getMetadataOption(), "");
        this.nameIdFormat = StringUtils.defaultIfBlank(idpConfig.getNameIdFormat(), "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
        this.shouldContainsAddIdp = true;
    }

    private void initializeNewForm() {
        this.acsUrl = this.settings.getLoginServletUrl() + "?idp=" + this.idpID;
        this.idpName = "";
        this.idpEntityId = "";
        this.ssoUrl = "";
        this.sloUrl = "";
        this.sloResponseLocationUrl = "";
        this.ssoBindingType = "HttpRedirect";
        this.sloBindingType = "HttpRedirect";
        this.certificates = new ArrayList<String>();
        this.x509Certificate = "";
        this.inputUrl = "";
        this.signedRequest = Boolean.TRUE;
        this.refreshMetadata = Boolean.FALSE;
        this.refreshInterval = "hourly";
        this.customRefreshInterval = 60;
        this.customRefreshIntervalUnit = "minutes";
        this.metadataOption = "";
        this.shouldContainsAddIdp = false;
        this.nameIdFormat = "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified";
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public LoginUriProvider getLoginUriProvider() {
        return this.loginUriProvider;
    }

    public void setLoginUriProvider(LoginUriProvider loginUriProvider) {
        this.loginUriProvider = loginUriProvider;
    }

    public MoSAMLSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoSAMLSettings settings) {
        this.settings = settings;
    }

    public String getIdpEntityId() {
        return this.idpEntityId;
    }

    public void setIdpEntityId(String idpEntityId) {
        this.idpEntityId = idpEntityId;
    }

    public String getSsoUrl() {
        return this.ssoUrl;
    }

    public void setSsoUrl(String ssoUrl) {
        this.ssoUrl = ssoUrl;
    }

    public String getSsoBindingType() {
        return this.ssoBindingType;
    }

    public void setSsoBindingType(String ssoBindingType) {
        this.ssoBindingType = ssoBindingType;
    }

    public String getSloUrl() {
        return this.sloUrl;
    }

    public void setSloUrl(String sloUrl) {
        this.sloUrl = sloUrl;
    }

    public String getSloBindingType() {
        return this.sloBindingType;
    }

    public void setSloBindingType(String sloBindingType) {
        this.sloBindingType = sloBindingType;
    }

    public String getX509Certificate() {
        return this.x509Certificate;
    }

    public void setX509Certificate(String x509Certificate) {
        this.x509Certificate = x509Certificate;
    }

    public List<String> getCertificates() {
        return this.certificates;
    }

    public void setCertificates(List<String> certificates) {
        this.certificates = certificates;
    }

    public String[] getX509AllCertificates() {
        return this.x509AllCertificates;
    }

    public void setX509AllCertificates(String[] x509AllCertificates) {
        this.x509AllCertificates = x509AllCertificates;
    }

    public String getXsrfToken() {
        return this.xsrfToken;
    }

    public void setXsrfToken(String xsrfToken) {
        this.xsrfToken = xsrfToken;
    }

    public Boolean getSubmitted() {
        return this.submitted;
    }

    public void setSubmitted(Boolean submitted) {
        this.submitted = submitted;
    }

    public Boolean getSignedRequest() {
        return this.signedRequest;
    }

    public void setSignedRequest(Boolean signedRequest) {
        this.signedRequest = signedRequest;
    }

    public String getNameIdFormat() {
        return this.nameIdFormat;
    }

    public void setNameIdFormat(String nameIdFormat) {
        this.nameIdFormat = nameIdFormat;
    }

    public ArrayList<String> getMetadataOptions() {
        ArrayList<String> idp = new ArrayList<String>();
        idp.add("ADFS");
        idp.add("Azure AD");
        idp.add("Okta");
        idp.add("OneLogin");
        idp.add("Google G Suite");
        Collections.sort(idp);
        this.metadataOptions = idp;
        return this.metadataOptions;
    }

    public ArrayList<String> getNameIdFormats() {
        ArrayList<String> formats = new ArrayList<String>();
        formats.add("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
        formats.add("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress");
        formats.add("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
        formats.add("urn:oasis:names:tc:SAML:2.0:nameid-format:transient");
        return formats;
    }

    public void setMetadataOptions(ArrayList<String> metadataOptions) {
        this.metadataOptions = metadataOptions;
    }

    public String getMetadataOption() {
        return this.metadataOption;
    }

    public void setMetadataOption(String metadataOption) {
        this.metadataOption = metadataOption;
    }

    public String getInputUrl() {
        return this.inputUrl;
    }

    public void setInputUrl(String inputUrl) {
        this.inputUrl = inputUrl;
    }

    public void setAuthnContextClass(String authnContextClass) {
        this.authnContextClass = authnContextClass;
    }

    public String getAuthnContextClass() {
        return this.authnContextClass;
    }

    public void setOtherAuthnContextClass(String otherAuthnContextClass) {
        this.otherAuthnContextClass = otherAuthnContextClass;
    }

    public String getOtherAuthnContextClass() {
        return this.otherAuthnContextClass;
    }

    public void setAuthnContextClasses(List<String> authnContextClasses) {
        this.authnContextClasses = authnContextClasses;
    }

    public Boolean getAddIdpSubmitted() {
        return this.addIdpSubmitted;
    }

    public void setAddIdpSubmitted(Boolean addIdpSubmitted) {
        this.addIdpSubmitted = addIdpSubmitted;
    }

    public Boolean getMetadataImported() {
        return this.metadataImported;
    }

    public void setMetadataImported(Boolean metadataImported) {
        this.metadataImported = metadataImported;
    }

    public Boolean getFileSubmitted() {
        return this.fileSubmitted;
    }

    public void setFileSubmitted(Boolean fileSubmitted) {
        this.fileSubmitted = fileSubmitted;
    }

    public Boolean getUrlSubmitted() {
        return this.urlSubmitted;
    }

    public void setUrlSubmitted(Boolean urlSubmitted) {
        this.urlSubmitted = urlSubmitted;
    }

    public MoIDPConfig getIdpConfig() {
        return this.idpConfig;
    }

    public void setIdpConfig(MoIDPConfig idpConfig) {
        this.idpConfig = idpConfig;
    }

    public void setNameIdFormats(List<String> nameIdFormats) {
        this.nameIdFormats = nameIdFormats;
    }

    public Boolean getEnableSsoForIdp() {
        return this.enableSsoForIdp;
    }

    public void setEnableSsoForIdp(Boolean enableSsoForIdp) {
        this.enableSsoForIdp = enableSsoForIdp;
    }

    public Boolean getRefreshMetadata() {
        return this.refreshMetadata;
    }

    public void setRefreshMetadata(Boolean refreshMetadata) {
        this.refreshMetadata = refreshMetadata;
    }

    public String getRefreshInterval() {
        return this.refreshInterval;
    }

    public void setRefreshInterval(String refreshInterval) {
        this.refreshInterval = refreshInterval;
    }

    public Integer getCustomRefreshInterval() {
        return this.customRefreshInterval;
    }

    public void setCustomRefreshInterval(Integer customRefreshInterval) {
        this.customRefreshInterval = customRefreshInterval;
    }

    public String getCustomRefreshIntervalUnit() {
        return this.customRefreshIntervalUnit;
    }

    public void setCustomRefreshIntervalUnit(String customRefreshIntervalUnit) {
        this.customRefreshIntervalUnit = customRefreshIntervalUnit;
    }

    public String getIdpID() {
        return this.idpID;
    }

    public void setIdpID(String idpID) {
        this.idpID = idpID;
    }

    public String getIdpName() {
        return this.idpName;
    }

    public void setIdpName(String idpName) {
        this.idpName = idpName;
    }

    public String getSloResponseLocationUrl() {
        return this.sloResponseLocationUrl;
    }

    public void setSloResponseLocationUrl(String sloResponseLocationUrl) {
        this.sloResponseLocationUrl = sloResponseLocationUrl;
    }

    public Boolean getShouldContainsAddIdp() {
        return this.shouldContainsAddIdp;
    }

    public void setShouldContainsAddIdp(Boolean shouldContainsAddIdp) {
        this.shouldContainsAddIdp = shouldContainsAddIdp;
    }

    public List<String> getIdpList() {
        ArrayList<String> idpList = this.settings.getIdPList();
        this.idpList = idpList;
        return this.idpList;
    }

    public void setIdpList(List<String> idpList) {
        this.idpList = idpList;
    }

    public String getAcsUrl() {
        return this.acsUrl;
    }

    public void setAcsUrl(String acsUrl) {
        this.acsUrl = acsUrl;
    }

    public Boolean getShouldShowBackButton() {
        return this.shouldShowBackButton;
    }

    public void setShouldShowBackButton(Boolean shouldShowBackButton) {
        this.shouldShowBackButton = shouldShowBackButton;
    }
}

