/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.bamboo.servlet;

import com.atlassian.bamboo.user.BambooAuthenticationContext;
import com.miniorange.sso.saml.bamboo.MoSAMLSettings;
import com.miniorange.sso.saml.dto.MoIDPConfig;
import com.miniorange.sso.saml.utils.MoHttpUtils;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoSAMLLogoutFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoSAMLLogoutFilter.class);
    private MoSAMLSettings settings;
    private BambooAuthenticationContext bambooAuthenticationContext;
    private MoIDPConfig idpConfig;

    public MoSAMLLogoutFilter(MoSAMLSettings settings, MoIDPConfig idpConfig, BambooAuthenticationContext bambooAuthenticationContext) {
        this.settings = settings;
        this.idpConfig = idpConfig;
        this.bambooAuthenticationContext = bambooAuthenticationContext;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        LOGGER.debug("MoSAMLLogoutFilter doFilter Called");
        try {
            HttpServletRequest req = (HttpServletRequest)request;
            HttpServletResponse res = (HttpServletResponse)response;
            Cookie performLogoutCookie = MoHttpUtils.createCookie(req.getRequestURL().toString(), "PERFORM_LOGOUT", "PerformLogout", false, this.settings.getRememberMeCookieEnabled());
            res.addCookie(performLogoutCookie);
            String url = this.settings.getLogoutServletUrl();
            res.sendRedirect(url);
            chain.doFilter(request, response);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public void destroy() {
    }

    public MoSAMLSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoSAMLSettings settings) {
        this.settings = settings;
    }

    public BambooAuthenticationContext getBambooAuthenticationContext() {
        return this.bambooAuthenticationContext;
    }

    public void setBambooAuthenticationContext(BambooAuthenticationContext bambooAuthenticationContext) {
        this.bambooAuthenticationContext = bambooAuthenticationContext;
    }

    public MoIDPConfig getIdpConfig() {
        return this.idpConfig;
    }

    public void setIdpConfig(MoIDPConfig idpConfig) {
        this.idpConfig = idpConfig;
    }

    private Cookie getCookie(String cookieName, HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(cookieName)) continue;
                return cookie;
            }
        }
        return null;
    }

    public void clearCookie(String cookieName, HttpServletRequest request, HttpServletResponse response) {
        LOGGER.debug("Clearing cookie : " + cookieName);
        Cookie cookie = this.getCookie(cookieName, request);
        if (cookie != null) {
            cookie.setPath("/");
            cookie.setMaxAge(0);
            response.addCookie(cookie);
        }
    }
}

