/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.bamboo.servlet;

import com.atlassian.bamboo.user.BambooUser;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONException;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.user.User;
import com.miniorange.sso.saml.bamboo.MoPluginHandler;
import com.miniorange.sso.saml.bamboo.MoSAMLManager;
import com.miniorange.sso.saml.bamboo.MoSAMLSettings;
import com.miniorange.sso.saml.bamboo.MoSAMLUserManager;
import com.miniorange.sso.saml.utils.MoHttpUtils;
import com.miniorange.sso.saml.utils.MoJSONUtils;
import com.miniorange.sso.saml.utils.MoSAMLUtils;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoAjaxCallsServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoAjaxCallsServlet.class);
    private MoSAMLSettings settings;
    private BambooUserManager bambooUserManager;
    private MoPluginHandler pluginHandler;
    private I18nResolver i18nResolver;
    private MoSAMLManager samlManager;
    private MoSAMLUserManager userManager;

    public MoAjaxCallsServlet(MoSAMLSettings samlSettings, BambooUserManager bambooUserManager, MoPluginHandler pluginHandler, I18nResolver i18nResolver, MoSAMLManager samlManager, MoSAMLUserManager userManager) {
        this.settings = samlSettings;
        this.bambooUserManager = bambooUserManager;
        this.pluginHandler = pluginHandler;
        this.i18nResolver = i18nResolver;
        this.samlManager = samlManager;
        this.userManager = userManager;
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!this.pluginHandler.checkForAdminSession()) {
            LOGGER.error("Access Denied. You will need admin privileges to make this API call");
            resp.sendError(403, "Access Denied. You will need admin privileges to make this API call.");
            return;
        }
        String action = org.apache.commons.lang3.StringUtils.trimToEmpty((String)req.getParameter("action"));
        LOGGER.debug("Parameters: ");
        Enumeration parameterNames = req.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            LOGGER.debug("Parameter " + (String)parameterNames.nextElement());
        }
        String referer = req.getHeader("referer");
        LOGGER.debug("Referer Header:" + referer);
        if (this.settings.getPluginApiAccessRestriction().booleanValue() && !org.apache.commons.lang3.StringUtils.startsWith((CharSequence)referer, (CharSequence)this.settings.getSpBaseUrl())) {
            LOGGER.error("Access Denied. API Restriction is enabled and request is not originated from the Bamboo.");
            resp.sendError(403, "Access Denied. You are not allowed to access this page.");
            LOGGER.error("403. Access Denied.You are not allowed to access this page.");
            return;
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)action)) {
            resp.setContentType("application/json");
            LOGGER.error(" 400.The requested parameter [action] not found or is empty");
            resp.sendError(400, "The requested parameter [action] not found or is empty");
            return;
        }
        switch (action) {
            case "deleteRule": {
                this.deleteRedirectionRule(req, resp);
                break;
            }
            case "clearMigrationValue": {
                this.clearMigrationValue(req, resp);
                break;
            }
            default: {
                resp.setContentType("application/json");
                LOGGER.error(" 405.The requested action is not allowed. Choose valid Action");
                resp.sendError(405, "The requested action is not allowed. Choose valid Action");
                return;
            }
        }
    }

    private void clearMigrationValue(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.settings.setisMigrated(false);
        this.sendSuccessFullResponse(JSONObject.quote("Migration Value Cleared").toString(), resp);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        LOGGER.debug("Ajax Servlet doGet Called");
        String action = req.getParameter("action");
        String referer = req.getHeader("referer");
        LOGGER.debug("Referer Header:" + referer);
        if (this.settings.getPluginApiAccessRestriction().booleanValue() && !StringUtils.startsWith(referer, this.settings.getSpBaseUrl())) {
            LOGGER.error("Access Denied. API Restriction is enabled and request is not originated from the Bamboo.  ");
            resp.sendError(403, "Access Denied. You are not allowed to access this page.");
            return;
        }
        if (StringUtils.isBlank(action)) {
            resp.setContentType("text/html");
            resp.sendError(400, "The requested parameter [action] not found or is empty");
            return;
        }
        switch (action) {
            case "checkBackdoorAccess": {
                this.checkBackdoorAccess(req, resp);
                break;
            }
            case "fetchGroups": {
                if (this.settings.getCurrentBuildNumber() <= 60604) break;
                this.fetchGroups(req, resp);
                break;
            }
            case "setLoginAttempts": {
                this.setLoginAttempts(req, resp);
                break;
            }
            case "deleteLoginAttempts": {
                this.deleteLoginAttempts(req, resp);
                break;
            }
            case "getLoginAttempts": {
                this.getLoginAttempts(req, resp);
                break;
            }
            case "setRememberMeCookie": {
                this.handleRememberMeCookie(req, resp);
                break;
            }
            case "getAttributes": {
                this.getAttributes(req, resp);
                break;
            }
            case "getGroups": {
                this.getGroups(req, resp);
                break;
            }
            case "getRule": {
                this.getRule(req, resp);
                break;
            }
            case "getBambooRedirectionRules": {
                this.getBambooRedirectionRules(req, resp);
                break;
            }
            case "processRedirectionRules": {
                this.processRedirectionRules(req, resp);
                break;
            }
            case "fetchDirectory": {
                this.fetchDirectory(req, resp);
                break;
            }
            case "getConfiguredLifeForIdpCookie": {
                this.getConfiguredLifeForIdpCookie(req, resp);
                break;
            }
            case "setConfiguredLifeForIdpCookie": {
                this.handleConfiguredLifeForIdpCookie(req, resp);
                break;
            }
            case "setRememberMyIdpCookie": {
                this.handleRememberMyIdpCookie(req, resp);
                break;
            }
            case "setUserConsent": {
                this.handleUserConsent(req, resp);
                break;
            }
            case "getUserConsent": {
                this.getUserConsent(req, resp);
                break;
            }
            case "setUserCheckCookie": {
                this.setUserCheckCookie(req, resp);
                break;
            }
            default: {
                resp.setContentType("text/html");
                resp.sendError(405, "The requested action is not allowed. Choose valid Action");
                return;
            }
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (!this.pluginHandler.checkForAdminSession()) {
            LOGGER.error("Access Denied. You will need admin privileges to make this API call");
            resp.sendError(403, "Access Denied. You will need admin privileges to make this API call.");
            return;
        }
        String action = req.getParameter("action");
        LOGGER.debug("Action " + action);
        String referer = req.getHeader("referer");
        LOGGER.debug("Referer Header:" + referer);
        if (this.settings.getPluginApiAccessRestriction().booleanValue() && !StringUtils.startsWith(referer, this.settings.getSpBaseUrl())) {
            LOGGER.error("Access Denied. API Restriction is enabled and request is not originated from the Bamboo.");
            resp.sendError(403, "Access Denied. You are not allowed to access this page.");
            LOGGER.error("403. Access Denied.You are not allowed to access this page.");
            return;
        }
        if (StringUtils.isBlank(action)) {
            resp.setContentType("application/json");
            LOGGER.error(" 400.The requested parameter [action] not found or is empty");
            resp.sendError(400, "The requested parameter [action] not found or is empty");
            return;
        }
        switch (action) {
            case "manualConfiguration": {
                break;
            }
            case "saveAttributeMapping": {
                break;
            }
            case "importFromMetadata": {
                break;
            }
            case "saveSsoConfig": {
                this.saveSSOConfig(req, resp);
                break;
            }
            case "updateUrls": {
                this.updateUrls(req, resp);
                break;
            }
            case "saveDefaultRule": {
                this.saveDefaultRule(req, resp);
                break;
            }
            case "saveDefaultRedirectURL": {
                this.saveDefaultRedirectURL(req, resp);
                break;
            }
            case "saveOrder": {
                this.saveRulesOrder(req, resp);
                break;
            }
            case "setRememberMeCookie": {
                this.handleRememberMeCookie(req, resp);
                break;
            }
            case "setIntroPage": {
                this.setIntroPage(req, resp);
                break;
            }
            case "finishQuickSetup": {
                this.finishQuickSetup(req, resp);
                break;
            }
            default: {
                resp.setContentType("application/json");
                resp.sendError(405, "The requested action is not allowed. Choose valid Action");
                return;
            }
        }
    }

    private void getLoginAttempts(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Cookie attemptCookie = this.getCookie("numberOfAttempts", req);
        JSONObject result = new JSONObject();
        try {
            if (attemptCookie != null) {
                result.put("numberOfAttempts", attemptCookie.getValue());
                LOGGER.debug("VALUE OF BACKDOOR LOGIN ATTEMPT ATTRIBUTE" + attemptCookie.getValue());
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            LOGGER.error("An Error Occurred while fetching login Attempts", (Throwable)e);
        }
        this.sendSuccessFullResponse(result.toString(), resp);
    }

    private void setLoginAttempts(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String numberOfLoginAttempts = this.settings.getNumberOfLoginAttempts();
        LOGGER.debug("setLoginAttempts Called");
        Cookie attemptCookie = this.getCookie("numberOfAttempts", req);
        if (attemptCookie == null) {
            String url = req.getRequestURL().toString();
            attemptCookie = new Cookie("numberOfAttempts", "1");
            attemptCookie.setPath("/plugins/servlet/saml");
            attemptCookie.setSecure(StringUtils.isNotBlank(url) && url.length() > 7 && url.substring(0, 8).equalsIgnoreCase("https://"));
            attemptCookie.setHttpOnly(true);
        } else if (Integer.parseInt(attemptCookie.getValue()) < Integer.parseInt(numberOfLoginAttempts) + 1) {
            int number = Integer.parseInt(attemptCookie.getValue());
            attemptCookie.setValue(Integer.toString(++number));
            attemptCookie.setHttpOnly(true);
            if (number == Integer.parseInt(numberOfLoginAttempts) + 1) {
                LOGGER.debug("LOGIN ATTEMPT LIMIT REACHED");
                attemptCookie.setMaxAge(600);
            }
        }
        resp.addCookie(attemptCookie);
        JSONObject result = new JSONObject();
        try {
            result.put("numberOfAttempts", attemptCookie.getValue());
        }
        catch (JSONException e) {
            e.printStackTrace();
            LOGGER.error("An Error Occurred while updating login Attempts", (Throwable)e);
        }
        this.sendSuccessFullResponse(result.toString(), resp);
    }

    private void deleteLoginAttempts(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        JSONObject result = new JSONObject();
        this.clearCookie("numberOfAttempts", req, resp);
        LOGGER.debug("SESSION DELETED SUCCESSFULLY");
        this.sendSuccessFullResponse(result.toString(), resp);
    }

    private void setIntroPage(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        LOGGER.debug("\n\nSetting Intro Page value to false...");
        this.settings.setShowIntroPage(false);
        JSONObject result = new JSONObject();
        this.sendSuccessFullResponse(result.toString(), resp);
    }

    private void handleRememberMeCookie(HttpServletRequest req, HttpServletResponse resp) {
        Boolean enableRememberMeCookie = org.apache.commons.lang.BooleanUtils.toBoolean(req.getParameter("value"));
        LOGGER.debug("Enable Remember Me : " + enableRememberMeCookie);
        this.settings.setRememberMeCookieEnabled(enableRememberMeCookie);
        try {
            JSONObject result = new JSONObject();
            result.put("result", "Settings saved");
            this.sendSuccessFullResponse(result.toString(), resp);
        }
        catch (JSONException | IOException e) {
            LOGGER.error("An error occurred sending response ", (Throwable)e);
        }
    }

    private void finishQuickSetup(HttpServletRequest req, HttpServletResponse resp) {
        String idpID = req.getParameter("idp");
        try {
            JSONObject idpConfigObject = this.settings.getIdpConfig(idpID);
            idpConfigObject.put("finishQuickSetup", "true");
            this.settings.setIdpConfig(idpConfigObject, idpID);
            MoHttpUtils.clearCookie(req, resp, "miniorange.saml.QUICKSETUP_IDP");
        }
        catch (Exception e) {
            LOGGER.debug("error saving option finish Quick Setup for idp " + idpID);
        }
    }

    private void deleteRedirectionRule(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String ruleId = req.getParameter("key");
        if (StringUtils.isBlank(ruleId)) {
            this.sendErrorResponse(JSONObject.quote(this.i18nResolver.getText("samlsso.error.empty.rule.key")), 400, resp);
            return;
        }
        this.settings.deleteRedirectionRule(ruleId);
        this.sendSuccessFullResponse(JSONObject.quote(this.i18nResolver.getText("samlsso.success.rule.deleted", new Serializable[]{ruleId})), resp);
    }

    private void updateUrls(HttpServletRequest req, HttpServletResponse resp) {
        try {
            LOGGER.debug("Update urls called via ajax call.");
            String updatedSpBaseUrl = StringUtils.trim(req.getParameter("updatedspbaseurl"));
            String updatedSpEntityID = StringUtils.trim(req.getParameter("updatedspentityid"));
            LOGGER.debug("values received : " + updatedSpBaseUrl + ", " + updatedSpEntityID);
            Boolean hasValidURL = Boolean.FALSE;
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)updatedSpBaseUrl)) {
                try {
                    new URL(updatedSpBaseUrl);
                    hasValidURL = Boolean.TRUE;
                }
                catch (MalformedURLException e) {
                    hasValidURL = Boolean.FALSE;
                }
            }
            if (hasValidURL.booleanValue()) {
                MoPluginHandler.saveSPConfiguration(StringUtils.trim(updatedSpBaseUrl), StringUtils.trim(updatedSpEntityID));
                JSONObject result = new JSONObject();
                result.put("loginUrl", this.settings.getLoginServletUrl());
                result.put("newentityid", this.settings.getSpEntityId());
                result.put("metadataUrl", this.settings.getSpBaseUrl() + "/plugins/servlet/saml/metadata");
                this.sendSuccessFullResponse(result.toString(), resp);
            }
        }
        catch (JSONException | IOException e) {
            LOGGER.error("An error occurred while fetching groups ", (Throwable)e);
        }
    }

    private void getBambooRedirectionRules(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        JSONArray rules = this.settings.getRedirectionRules();
        ArrayList<String> ssoEnabledIdpList = this.settings.getSsoEnabledForIdPList();
        Map<String, String> rulesMap = this.settings.getBambooRedirectionRulesMap();
        HashMap<String, String> finalRulesMap = new HashMap<String, String>();
        try {
            for (int i = 0; i < rules.length(); ++i) {
                JSONObject rule = rules.optJSONObject(i);
                String ruleName = rule.getString("name");
                String idpName = rule.getString("idp");
                if (!StringUtils.equals(idpName, "loginPage") && !StringUtils.equals(idpName, "redirectUrl")) {
                    if (!ssoEnabledIdpList.contains(idpName)) continue;
                    finalRulesMap.put(ruleName, rulesMap.get(ruleName));
                    continue;
                }
                finalRulesMap.put(ruleName, rulesMap.get(ruleName));
            }
            LOGGER.debug("finalRulesMap json: " + MoJSONUtils.convertMapToJSON(finalRulesMap));
            this.sendSuccessFullResponse(MoJSONUtils.convertMapToJSON(finalRulesMap), resp);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void getGroups(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String type;
        switch (type = request.getParameter("type")) {
            case "backdoor": {
                this.sendBackdoorGroups(request, response);
                break;
            }
            default: {
                response.setContentType("text/html");
                LOGGER.error("Incorrect Type selected for fetching groups " + type);
                response.sendError(400, "Incorrect type selected for fetching groups. Choose valid type");
            }
        }
    }

    private void getAttributes(HttpServletRequest req, HttpServletResponse resp) {
        try {
            JSONObject idpConfig = this.settings.getIdpConfig(req.getParameter("idpname"));
            String searchParam = StringUtils.trim(req.getParameter("search"));
            if (idpConfig.has("testConfig")) {
                Map<String, List<String>> testConfig = MoSAMLUtils.toMap((JSONObject)this.settings.getIdpConfig(req.getParameter("idpname")).get("testConfig"));
                ArrayList<String> attributesMap = MoPluginHandler.dynamicSearchAttributes(MoSAMLUtils.parseIdpTestConfigObject(testConfig), searchParam);
                JSONObject data = new JSONObject();
                JSONArray resultArray = new JSONArray();
                for (String attribute : attributesMap) {
                    HashMap<String, Object> attributesResultMap = new HashMap<String, Object>();
                    attributesResultMap.put("id", attribute);
                    attributesResultMap.put("text", attribute);
                    resultArray.put(attributesResultMap);
                }
                data.put("results", resultArray);
                this.sendSuccessFullResponse(data.toString(), resp);
            }
        }
        catch (JSONException | IOException e) {
            e.printStackTrace();
            LOGGER.error("An error occurred while fetching groups ", (Throwable)e);
        }
    }

    private void sendBackdoorGroups(HttpServletRequest request, HttpServletResponse response) throws IOException {
        List<String> groups = this.settings.getBackdoorGroups();
        try {
            JSONObject data = new JSONObject();
            JSONArray resultArray = new JSONArray();
            for (String groupName : groups) {
                HashMap<String, Object> groupResultsMap = new HashMap<String, Object>();
                groupResultsMap.put("id", groupName);
                groupResultsMap.put("text", groupName);
                resultArray.put(groupResultsMap);
            }
            data.put("results", resultArray);
            this.sendSuccessFullResponse(data.toString(), response);
        }
        catch (JSONException e) {
            LOGGER.error("An error occurred while fetching groups ", (Throwable)e);
        }
    }

    private void processRedirectionRules(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String username = StringUtils.trim(req.getParameter("mo_username"));
        if (StringUtils.isBlank(username)) {
            resp.setContentType("application/json");
            resp.sendError(400, "The username is empty");
            return;
        }
        String idp = this.samlManager.processRedirectionRulesAndReturnIDP(username);
        if (StringUtils.isBlank(idp)) {
            resp.setContentType("application/json");
            resp.sendError(500, "Some Error Occurred While Processing you username. Please contact your administrator");
            return;
        }
        try {
            JSONObject idpResponse = new JSONObject();
            idpResponse.put("idp", idp);
            if (StringUtils.equalsIgnoreCase(idp, "redirectUrl")) {
                idpResponse.put("defaultRedirectUrl", this.settings.getDefaultRedirectURL());
            }
            this.sendSuccessFullResponse(idpResponse.toString(), resp);
        }
        catch (JSONException e) {
            LOGGER.error("An Error Occurred while creating response ", (Throwable)e);
        }
    }

    private void getRule(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String id = req.getParameter("key");
        JSONObject rule = this.settings.getRedirectionRule(id);
        if (rule == null) {
            this.sendErrorResponse("Rule not found", 500, resp);
            return;
        }
        this.sendSuccessFullResponse(rule.toString(), resp);
    }

    private void sendErrorResponse(String errorMessages, int errorCode, HttpServletResponse resp) throws IOException {
        resp.setContentType("application/json");
        resp.setStatus(errorCode);
        resp.getOutputStream().write(errorMessages.getBytes(StandardCharsets.UTF_8));
        resp.getOutputStream().close();
    }

    private void saveRulesOrder(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String[] ruleNames;
        Map<String, String> redirectionRulesMap = this.settings.getBambooRedirectionRulesMap();
        LinkedHashMap<String, String> newRedirectionRulesMap = new LinkedHashMap<String, String>();
        for (String ruleName : ruleNames = req.getParameterValues("ruleKey")) {
            newRedirectionRulesMap.put(ruleName, redirectionRulesMap.get(ruleName));
        }
        this.pluginHandler.saveBambooRedirectionRules(newRedirectionRulesMap);
        this.sendSuccessFullResponse(null, resp);
    }

    private void saveDefaultRule(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String idpId = req.getParameter("defaultIDP");
        this.settings.setDefaultBambooIDP(idpId);
        this.sendSuccessFullResponse(JSONObject.quote(this.i18nResolver.getText("samlsso.defaultrule.config")), resp);
    }

    private void saveDefaultRedirectURL(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String defaultRedirectURL = org.apache.commons.lang3.StringUtils.trim((String)req.getParameter("defaultRedirectURL"));
        if (StringUtils.isBlank(defaultRedirectURL)) {
            this.sendErrorResponse(this.i18nResolver.getText("samlsso.error.empty.redirect.url.platform"), 400, resp);
            return;
        }
        try {
            new URL(defaultRedirectURL);
        }
        catch (MalformedURLException e) {
            LOGGER.error("Invalid redirect URL", (Throwable)e);
            this.sendErrorResponse(this.i18nResolver.getText("samlsso.error.wrong.redirect.url.platform"), 400, resp);
            return;
        }
        LOGGER.debug("default redirect URL for Bamboo submitted : " + defaultRedirectURL);
        this.settings.setDefaultRedirectURL(defaultRedirectURL);
        this.settings.setDefaultBambooIDP("redirectUrl");
        this.sendSuccessFullResponse(JSONObject.quote(this.i18nResolver.getText("samlsso.defaultrule.config")), resp);
    }

    private void checkBackdoorAccess(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String username = StringUtils.trim(req.getParameter("mo_username"));
        if (StringUtils.isBlank(username)) {
            resp.setContentType("application/json");
            resp.sendError(400, "The username is empty");
            return;
        }
        BambooUser bambooUser = this.bambooUserManager.getBambooUser(username);
        JSONObject result = new JSONObject();
        if (bambooUser != null) {
            List<String> groupList = this.settings.getBackdoorGroups();
            boolean isUserPresentInGroups = this.isUserPresentInGroups(username, groupList);
            LOGGER.debug("isUserPresentInGroups " + isUserPresentInGroups);
            try {
                result.put("isUserAllowedBackdoorAccess", isUserPresentInGroups);
            }
            catch (JSONException e) {
                e.printStackTrace();
                LOGGER.error("An Error Occurred while checking Backdoor Access for User ", (Throwable)e);
            }
        } else {
            LOGGER.debug("User {" + username + "} not found.");
            result.put("isUserAllowedBackdoorAccess", false);
        }
        this.sendSuccessFullResponse(result.toString(), resp);
    }

    private void saveSSOConfig(HttpServletRequest request, HttpServletResponse response) {
        JSONObject result = new JSONObject();
        String idpId = request.getParameter("idpid");
        String isChecked = request.getParameter("isChecked");
        try {
            MoPluginHandler.saveListIDPConfigurations(idpId, BooleanUtils.toBoolean((String)isChecked));
            result.put("result", "Settings saved");
            this.sendSuccessFullResponse(result.toString(), response);
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while saving enable SSO details", (Throwable)e);
        }
    }

    private Boolean isUserPresentInGroups(String username, List<String> groups) {
        LOGGER.debug("Testing for user " + username);
        try {
            BambooUser bambooUser = this.bambooUserManager.getBambooUser(username);
            List existingGroupsOfUser = new ArrayList();
            existingGroupsOfUser = this.bambooUserManager.getGroupNamesAsList((User)bambooUser);
            if (bambooUser != null) {
                for (String group : groups) {
                    if (!existingGroupsOfUser.contains(group)) continue;
                    return true;
                }
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error(e.getMessage());
        }
        return false;
    }

    private void fetchGroups(HttpServletRequest req, HttpServletResponse resp) {
        LOGGER.debug("Ajax Servlet fetchGroup Called");
        try {
            String search = StringUtils.trim(req.getParameter("search"));
            if (StringUtils.equalsIgnoreCase(search, "*")) {
                search = "";
            }
            CrowdService crowdService = (CrowdService)ComponentLocator.getComponent(CrowdService.class);
            EntityQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)GroupTermKeys.NAME).startingWith((Object)search)).returningAtMost(10);
            LOGGER.debug("query =  " + query);
            Iterable groups = crowdService.search((Query)query);
            JSONObject data = new JSONObject();
            JSONArray resultArray = new JSONArray();
            for (Group groupName : groups) {
                HashMap<String, Object> groupResultsMap = new HashMap<String, Object>();
                groupResultsMap.put("id", groupName.getName());
                groupResultsMap.put("text", groupName.getName());
                resultArray.put(groupResultsMap);
            }
            LOGGER.debug("resultArray :" + resultArray.toString());
            data.put("results", resultArray);
            this.sendSuccessFullResponse(data.toString(), resp);
        }
        catch (JSONException | IOException e) {
            e.printStackTrace();
            LOGGER.error("An error occurred while fetching groups ", (Throwable)e);
        }
    }

    private void fetchDirectory(HttpServletRequest req, HttpServletResponse resp) {
        try {
            JSONArray resultArray = new JSONArray();
            JSONObject data = new JSONObject();
            List directoryList = MoPluginHandler.directoryManager.findAllDirectories();
            LOGGER.debug("Directory list size {}" + directoryList.size());
            for (Directory directoryName : directoryList) {
                HashMap<String, Object> directoryResultsMap = new HashMap<String, Object>();
                directoryResultsMap.put("id", directoryName.getName());
                directoryResultsMap.put("text", directoryName.getName());
                resultArray.put(directoryResultsMap);
            }
            data.put("results", resultArray);
            this.sendSuccessFullResponse(data.toString(), resp);
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while fetching Directory ", (Throwable)e);
        }
    }

    private void getConfiguredLifeForIdpCookie(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String life = this.settings.getConfiguredLifeForIdpCookie();
        LOGGER.debug("Configured life for idp cookie : " + life);
        JSONObject result = new JSONObject();
        try {
            result.put("life", life);
        }
        catch (JSONException e) {
            LOGGER.error("An Error Occurred while getting Configured Life For Idp Cookie ", (Throwable)e);
        }
        this.sendSuccessFullResponse(result.toString(), resp);
    }

    private void handleConfiguredLifeForIdpCookie(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            if (!this.pluginHandler.checkForAdminSession()) {
                LOGGER.error("403Admin session not active. This API cannot called without admin privileges.");
                resp.sendError(403, "Admin session not active. This API cannot called without admin privileges.");
                return;
            }
            String configuredLifeForIdpCookie = StringUtils.trim(req.getParameter("value"));
            LOGGER.debug("Configured Life for Idp cookie : " + configuredLifeForIdpCookie);
            this.settings.setConfiguredLifeForIdpCookie(configuredLifeForIdpCookie);
            try {
                JSONObject result = new JSONObject();
                result.put("result", "Settings saved");
                this.sendSuccessFullResponse(result.toString(), resp);
            }
            catch (JSONException | IOException e) {
                LOGGER.error("An error occurred sending response ", (Throwable)e);
            }
        }
        catch (Exception e) {
            LOGGER.error("An error occured while setting configuredLifeForIdpCookie " + e);
        }
    }

    private void handleRememberMyIdpCookie(HttpServletRequest req, HttpServletResponse resp) {
        Boolean enableRememberMyIdpCookie = org.apache.commons.lang.BooleanUtils.toBoolean(req.getParameter("value"));
        LOGGER.debug("Enable Remember My Idp : " + enableRememberMyIdpCookie);
        this.settings.setRememberMyIdpCookieEnabled(enableRememberMyIdpCookie);
        try {
            JSONObject result = new JSONObject();
            result.put("result", "Settings saved");
            this.sendSuccessFullResponse(result.toString(), resp);
        }
        catch (JSONException | IOException e) {
            LOGGER.error("An error occurred sending response ", (Throwable)e);
        }
    }

    private void handleUserConsent(HttpServletRequest req, HttpServletResponse resp) {
        Boolean userConsent = org.apache.commons.lang.BooleanUtils.toBoolean(req.getParameter("value"));
        LOGGER.debug(" userConsent : " + userConsent);
        this.settings.setUserConsent(userConsent);
        try {
            JSONObject result = new JSONObject();
            result.put("result", "Settings saved");
            this.sendSuccessFullResponse(result.toString(), resp);
        }
        catch (JSONException | IOException e) {
            LOGGER.error("An error occurred sending response ", (Throwable)e);
        }
    }

    private void getUserConsent(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Boolean userConsent = false;
        if (this.settings.getRememberMyIdpCookieEnabled().booleanValue()) {
            userConsent = this.settings.getUserConsent();
        }
        LOGGER.debug(" User Consent value : " + userConsent);
        JSONObject result = new JSONObject();
        try {
            result.put("userConsent", userConsent);
        }
        catch (JSONException e) {
            LOGGER.error("An Error Occurred while getting userConsent value ", (Throwable)e);
        }
        this.sendSuccessFullResponse(result.toString(), resp);
    }

    protected void setUserCheckCookie(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Boolean cookieValue = org.apache.commons.lang.BooleanUtils.toBoolean(req.getParameter("value"));
        Integer maxAge = Integer.parseInt(req.getParameter("maxAge"));
        String domain = req.getParameter("domain");
        String path = req.getParameter("path");
        Cookie cookie = MoHttpUtils.createCookie(req.getRequestURL().toString(), "UserCheckCookie", cookieValue.toString(), Boolean.TRUE, this.settings.getRememberMeCookieEnabled());
        resp.addCookie(cookie);
        this.sendSuccessFullResponse("User check cookie added successfully", resp);
    }

    private void sendSuccessFullResponse(String result, HttpServletResponse resp) throws IOException {
        resp.setContentType("application/json");
        resp.setStatus(200);
        if (result != null) {
            resp.getOutputStream().write(result.getBytes(StandardCharsets.UTF_8));
            resp.getOutputStream().close();
        }
    }

    private Cookie getCookie(String cookieName, HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(cookieName)) continue;
                return cookie;
            }
        }
        return null;
    }

    public void clearCookie(String cookieName, HttpServletRequest request, HttpServletResponse response) {
        LOGGER.debug("Clearing cookie : " + cookieName);
        Cookie cookie = this.getCookie(cookieName, request);
        if (cookie != null) {
            cookie.setPath("/plugins/servlet/saml");
            cookie.setMaxAge(0);
            response.addCookie(cookie);
        }
    }

    public MoSAMLSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoSAMLSettings settings) {
        this.settings = settings;
    }

    public BambooUserManager getBambooUserManager() {
        return this.bambooUserManager;
    }

    public void setBambooUserManager(BambooUserManager bambooUserManager) {
        this.bambooUserManager = bambooUserManager;
    }

    public MoPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    public void setPluginHandler(MoPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }

    public I18nResolver getI18nResolver() {
        return this.i18nResolver;
    }

    public void setI18nResolver(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }
}

