/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.bamboo.schedulers;

import com.atlassian.json.jsonorg.JSONException;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.miniorange.sso.saml.bamboo.MoPluginHandler;
import com.miniorange.sso.saml.bamboo.MoSAMLSettings;
import com.miniorange.sso.saml.dto.MoIDPConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoPluginMigrationService
implements LifecycleAware {
    private static Log LOGGER = LogFactory.getLog(MoPluginMigrationService.class);
    public MoSAMLSettings settings;
    public MoPluginHandler pluginHandler;

    public MoPluginMigrationService(MoSAMLSettings settings, MoPluginHandler pluginHandler) {
        this.settings = settings;
        this.pluginHandler = pluginHandler;
    }

    public void onStart() {
        LOGGER.debug((Object)"MoPluginMigrationService afterPropertiesSet Called");
        if (!this.settings.getisMigrated().booleanValue() && !this.settings.getIdPList().isEmpty()) {
            this.migrateSettings();
        }
        this.settings.setisMigrated(true);
    }

    public void onStop() {
    }

    private void migrateSettings() {
        this.addIssuerMap();
        if (this.settings.getUseDomainMapping().booleanValue()) {
            this.migrateDomainMappingSettings();
        }
        this.migrateAutoRedirectToIDP();
        this.migrateAdanceSsoSettings();
        this.migrateMappingAndAdvanceSsoSettings();
        this.settings.setSsoEnabledForIdPList(this.settings.getIdPList());
        if (this.settings.getIdPList().isEmpty()) {
            this.settings.setPrivateSPCertificate(this.settings.getNewPrivateSPCertificate());
            this.settings.setPublicSPCertificate(this.settings.getNewPublicSPCertificate());
        }
    }

    private void addIssuerMap() {
        LOGGER.info((Object)"Adding Issuer Map");
        ArrayList<String> idpList = this.settings.getIdPList();
        HashMap<String, String> issuerMap = new HashMap<String, String>();
        for (String idpId : idpList) {
            MoIDPConfig idpConfig = MoPluginHandler.constructIdpConfigObject(idpId);
            issuerMap.put(idpConfig.getId(), idpConfig.getIdpEntityId());
        }
        this.settings.setIssuerMap(issuerMap);
    }

    private void migrateAutoRedirectToIDP() {
        this.settings.setBackdoorEnabled(true);
        if (this.settings.getDefaultLoginDisabled().booleanValue() && this.settings.getIdPList().size() == 1) {
            ArrayList<String> idpList = this.settings.getIdPList();
            this.settings.setDefaultBambooIDP((String)idpList.get(0));
            return;
        }
        this.settings.setDefaultBambooIDP("loginPage");
    }

    public void migrateAdanceSsoSettings() {
        if (this.settings.getAllowUserCreation().booleanValue()) {
            this.settings.setAllowUserCreation(false);
        } else {
            this.settings.setAllowUserCreation(true);
        }
    }

    private void migrateDomainMappingSettings() {
        LOGGER.debug((Object)"Migrating Domain Mapping Settings");
        String ruleName = "domainMapping_";
        String decisionFactor = "domain";
        String conditionOperation = "equals";
        HashMap<String, String> domainMapping = this.settings.getDomainMapping();
        int i = 0;
        try {
            for (Map.Entry domain : domainMapping.entrySet()) {
                MoPluginHandler.saveRedirectionRules(ruleName + ++i, decisionFactor, conditionOperation, (String)domain.getKey(), (String)domain.getValue());
            }
        }
        catch (JSONException e) {
            LOGGER.error((Object)"An error occurred while migrating domain mapping", (Throwable)e);
        }
    }

    public void migrateMappingAndAdvanceSsoSettings() {
        ArrayList<String> idpList = this.settings.getIdPList();
        String relayStateUrl = this.settings.getRelayState();
        String relayStateRedirectionType = this.settings.getRelayStateRedirectionType();
        this.settings.setSsoEnabledForIdPList(idpList);
        for (String idpId : idpList) {
            MoIDPConfig idpConfig = MoPluginHandler.constructIdpConfigObject(idpId);
            JSONObject importMetadataConfigObj = this.settings.getImportMetadataConfig(idpId);
            if (importMetadataConfigObj != null) {
                idpConfig = MoPluginMigrationService.insertImportMetadataConfig(idpConfig, importMetadataConfigObj);
            }
            Boolean allowUserCreation = Boolean.TRUE;
            if (BooleanUtils.toBoolean((Boolean)idpConfig.getRestrictUserCreation())) {
                allowUserCreation = false;
            }
            Boolean enablePassiveSso = BooleanUtils.toBooleanDefaultIfNull((Boolean)idpConfig.getEnablePassiveSso(), (boolean)false);
            Boolean forceAuthentication = BooleanUtils.toBooleanDefaultIfNull((Boolean)idpConfig.getForceAuthentication(), (boolean)false);
            String timeDelay = (String)StringUtils.defaultIfBlank((CharSequence)idpConfig.getTimeDelay(), (CharSequence)this.settings.getTimeDelay());
            Boolean refreshMetadata = BooleanUtils.toBooleanDefaultIfNull((Boolean)idpConfig.getRefreshMetadata(), (boolean)false);
            String inputUrl = (String)StringUtils.defaultIfBlank((CharSequence)idpConfig.getInputUrl(), (CharSequence)"");
            String refreshInterval = (String)StringUtils.defaultIfBlank((CharSequence)idpConfig.getRefreshInterval(), (CharSequence)"hourly");
            Integer customRefreshInterval = idpConfig.getCustomRefreshInterval() != null ? idpConfig.getCustomRefreshInterval() : 60;
            String customRefreshIntervalUnit = (String)StringUtils.defaultIfBlank((CharSequence)idpConfig.getCustomRefreshIntervalUnit(), (CharSequence)"minutes");
            MoPluginHandler.saveAdvancedOption(idpId, allowUserCreation, forceAuthentication, inputUrl, timeDelay, refreshMetadata, refreshInterval, customRefreshInterval, customRefreshIntervalUnit, relayStateUrl, relayStateRedirectionType, enablePassiveSso, "");
            idpConfig.setKeepExistingUserAttributes(idpConfig.getKeepExistingUserAttributes() == false);
            MoPluginHandler.saveAttributeMapping(idpId, idpConfig.getUsernameAttribute(), idpConfig.getEmailAttribute(), idpConfig.getFullNameAttribute(), idpConfig.getUseSeparateNameAttributes(), idpConfig.getFirstNameAttribute(), idpConfig.getLastNameAttribute(), idpConfig.getKeepExistingUserAttributes(), idpConfig.getRegexPattern(), idpConfig.getRegexPatternEnabled(), idpConfig.getLoginUserAttribute());
            this.settings.setKeepExistingUserAttributes(this.settings.getKeepExistingUserAttributes() == false);
            idpConfig.setKeepExistingUserRoles(idpConfig.getKeepExistingUserRoles() == false);
            MoPluginHandler.saveRoleMapping(idpId, idpConfig.getRoleAttribute(), idpConfig.getCreateUsersIfRoleMapped(), idpConfig.getKeepExistingUserRoles(), idpConfig.getRoleMapping(), idpConfig.getDefaultGroup(), idpConfig.getDefaultGroupsList(), idpConfig.getRestrictUserCreation(), idpConfig.getEnableDefaultGroupsFor(), idpConfig.getOnTheFlyGroupCreation(), idpConfig.getOnTheFlyDoNotRemoveGroups(), idpConfig.getOnTheFlyAssignNewGroupsOnly(), idpConfig.getCreateNewGroups(), idpConfig.getGroupRegexPatternEnabled(), idpConfig.getRegexPatternForGroup(), idpConfig.getRegexGroups(), idpConfig.getTestRegex());
            this.settings.setKeepExistingUserRoles(this.settings.getKeepExistingUserRoles() == false);
        }
        this.settings.setAllowUserCreation(this.settings.getRestrictUserCreation() == false);
    }

    private static MoIDPConfig insertImportMetadataConfig(MoIDPConfig idpConfig, JSONObject importMetadataConfigObj) {
        if (importMetadataConfigObj != null) {
            idpConfig.setRefreshMetadata(importMetadataConfigObj.optBoolean("miniorange.saml.REFRESH_METADATA", false));
            idpConfig.setRefreshInterval(importMetadataConfigObj.optString("miniorange.saml.METADATA_REFRESH_INTERVAL", "hourly"));
            idpConfig.setCustomRefreshInterval(importMetadataConfigObj.optInt("miniorange.saml.CUSTOM_REFRESH_INTERVAL", 60));
            idpConfig.setCustomRefreshIntervalUnit(importMetadataConfigObj.optString("miniorange.saml.CUSTOM_REFRESH_INTERVAL_UNIT", "minutes"));
            idpConfig.setInputUrl(importMetadataConfigObj.optString("miniorange.saml.INPUT_METADATA_URL", ""));
            idpConfig.setIdpMetadataUrl(importMetadataConfigObj.optString("miniorange.saml.IDP_METADATA_URL", ""));
        }
        return idpConfig;
    }
}

