/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.bamboo.action;

import com.atlassian.bamboo.security.xsrf.XsrfTokenUtils;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.plugin.PluginException;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.miniorange.sso.saml.bamboo.MoPluginHandler;
import com.miniorange.sso.saml.bamboo.MoSAMLSettings;
import com.miniorange.sso.saml.utils.MoHttpUtils;
import com.miniorange.sso.saml.utils.MoSAMLUtils;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.apache.struts2.ServletActionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoSpConfigurationAction
extends BambooActionSupport {
    private UserManager userManager;
    private LoginUriProvider loginUriProvider;
    private MoSAMLSettings settings;
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MoSpConfigurationAction.class);
    private String spBaseUrl;
    private String spEntityId;
    private ArrayList idpGuides;
    private Boolean signing;
    private Boolean encryption;
    private String customOrganizationName;
    private String customOrganizationDisplayName;
    private String customOrganizationUrl;
    private String technicalContactName;
    private String technicalContactEmail;
    private String supportContactName;
    private String supportContactEmail;
    private Boolean isJCEInstalled;
    private Boolean certificatesSubmitted;
    private Map<String, String> certificateInfo;
    private Boolean submitted;
    private String xsrfToken;

    public MoSpConfigurationAction(MoSAMLSettings settings, UserManager userManager, LoginUriProvider loginUriProvider) {
        this.settings = settings;
        this.loginUriProvider = loginUriProvider;
        this.userManager = userManager;
    }

    public void validate() {
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        if (!BooleanUtils.toBoolean((Boolean)this.submitted)) {
            return;
        }
        if (BooleanUtils.toBoolean((Boolean)this.submitted)) {
            if (StringUtils.isBlank(this.spBaseUrl)) {
                this.addActionError(this.getText("samlsso.error.config.spbaseurl.empty"));
            } else {
                try {
                    new URL(this.spBaseUrl);
                }
                catch (MalformedURLException e) {
                    this.addActionError(this.getText("samlsso.error.config.spbaseurl.malformed"));
                }
            }
            if (StringUtils.isBlank(this.spEntityId)) {
                this.addActionError("SP Entity ID can not be left blank.");
            }
        }
        if (super.hasActionErrors()) {
            this.xsrfToken = XsrfTokenUtils.getXsrfToken((HttpServletRequest)request);
            this.initializeSAMLConfig();
        }
        super.validate();
    }

    public String execute() throws Exception {
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        this.xsrfToken = XsrfTokenUtils.getXsrfToken((HttpServletRequest)request);
        UserProfile user = this.userManager.getRemoteUser();
        if (user != null && this.userManager.isAdmin(user.getUserKey())) {
            try {
                LOGGER.debug("SP Configure Action execute Submitted: " + this.submitted);
                if (!this.settings.isValidLicense().booleanValue()) {
                    return "upm";
                }
                if (StringUtils.isNotBlank(this.settings.getSsoServiceUrl())) {
                    String idpID = UUID.randomUUID().toString();
                    String idpName = "IDP";
                    MoPluginHandler.replaceOldSettingsWithNew(idpID, idpName);
                }
                if (this.settings.getIdPList().isEmpty()) {
                    this.setCertificates(this.settings.getNewPrivateSPCertificate(), this.settings.getNewPublicSPCertificate());
                }
                String validTo = this.getCertificateInfo().get("Valid To");
                this.setSPCertExpirayDate(validTo);
                if (request.getParameter("reset") != null && StringUtils.equalsIgnoreCase(request.getParameter("reset"), "success")) {
                    this.addActionMessage("SAML settings reset successfully!!!");
                }
                if (BooleanUtils.toBoolean((Boolean)this.submitted)) {
                    MoPluginHandler.saveSPConfiguration(this.spBaseUrl, this.spEntityId);
                    this.addActionMessage(this.getText("samlsso.success.config"));
                } else if (BooleanUtils.toBoolean((Boolean)this.certificatesSubmitted)) {
                    MoPluginHandler.saveSPCertificates(this.signing, this.encryption);
                    this.addActionMessage(this.getText("samlsso.success.config"));
                }
                this.certificateInfo = MoSAMLUtils.getCertificateInfo(this.settings.getPublicSPCertificate());
                if (this.certificateInfo != null) {
                    LOGGER.debug("Certificate Info: " + this.certificateInfo.toString());
                }
                this.initializeSAMLConfig();
                return "success";
            }
            catch (PluginException e) {
                e.printStackTrace();
                this.addActionError(e.getMessage());
                return "input";
            }
            catch (Exception e) {
                e.printStackTrace();
                this.addActionError("An error occurred while saving your details. Please check logs for more info.");
                return "input";
            }
        }
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
        return null;
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    public boolean isJCEEnable() {
        try {
            return Cipher.getMaxAllowedKeyLength("SHA256") == Integer.MAX_VALUE;
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("No Such Algorithm Exception" + e);
            return false;
        }
    }

    private void initializeSAMLConfig() {
        this.spBaseUrl = this.settings.getSpBaseUrl();
        this.spEntityId = this.settings.getSpEntityId();
        this.signing = this.settings.getSigning();
        this.encryption = this.settings.getEncryption();
        this.customOrganizationName = this.settings.getOrganizationName();
        this.customOrganizationDisplayName = this.settings.getOrganizationDisplayName();
        this.customOrganizationUrl = this.settings.getOrganizationUrl();
        this.technicalContactName = this.settings.getTechnicalContactName();
        this.technicalContactEmail = this.settings.getTechnicalContactEmail();
        this.supportContactName = this.settings.getSupportContactName();
        this.supportContactEmail = this.settings.getSupportContactEmail();
        this.isJCEInstalled = this.isJCEEnable();
    }

    public ArrayList<String> getIdpGuides() {
        ArrayList<String> idp = new ArrayList<String>();
        idp.add("ADFS");
        idp.add("GoogleApps");
        idp.add("Centrify");
        idp.add("Okta");
        idp.add("OneLogin");
        idp.add("Salesforce");
        idp.add("JBoss Keycloak");
        idp.add("Oracle(OEM)");
        idp.add("Bitium");
        idp.add("PingFederate");
        idp.add("Ping One");
        idp.add("WSO2");
        idp.add("OpenAM");
        idp.add("miniOrange");
        idp.add("Simplesaml");
        idp.add("Azure AD");
        idp.add("Shibboleth 2");
        idp.add("Shibboleth 3");
        idp.add("RSA SecurID");
        idp.add("AuthAnvil");
        idp.add("Auth0");
        idp.add("CA Identity");
        idp.add("AWS");
        Collections.sort(idp);
        this.idpGuides = idp;
        return this.idpGuides;
    }

    public void setCertificates(String privateCertificate, String publicCertificate) {
        ArrayList<NameValuePair> postParameters = new ArrayList<NameValuePair>();
        postParameters.add((NameValuePair)new BasicNameValuePair("action", "setCert"));
        postParameters.add((NameValuePair)new BasicNameValuePair("privateCertificate", privateCertificate));
        postParameters.add((NameValuePair)new BasicNameValuePair("publicCertificate", publicCertificate));
        MoHttpUtils.sendPostRequest(this.settings.getBaseUrl().concat("/plugins/servlet/saml/mogencert"), postParameters, "application/x-www-form-urlencoded", null);
    }

    public void setSPCertExpirayDate(String validTo) {
        ArrayList<NameValuePair> postParameters = new ArrayList<NameValuePair>();
        postParameters.add((NameValuePair)new BasicNameValuePair("action", "setExpirayDate"));
        postParameters.add((NameValuePair)new BasicNameValuePair("validTo", validTo));
        MoHttpUtils.sendPostRequest(this.settings.getBaseUrl().concat("/plugins/servlet/saml/mogencert"), postParameters, "application/x-www-form-urlencoded", null);
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public LoginUriProvider getLoginUriProvider() {
        return this.loginUriProvider;
    }

    public void setLoginUriProvider(LoginUriProvider loginUriProvider) {
        this.loginUriProvider = loginUriProvider;
    }

    public ArrayList<String> getIdpList() {
        return this.settings.getIdPList();
    }

    public HashMap<String, String> getIdpMap() {
        return this.settings.getIdpMap();
    }

    public String getSpBaseUrl() {
        return this.spBaseUrl;
    }

    public void setSpBaseUrl(String spBaseUrl) {
        this.spBaseUrl = spBaseUrl;
    }

    public String getSpEntityId() {
        return this.spEntityId;
    }

    public void setSpEntityId(String spEntityId) {
        this.spEntityId = spEntityId;
    }

    public Boolean getSubmitted() {
        return this.submitted;
    }

    public void setSubmitted(Boolean submitted) {
        this.submitted = submitted;
    }

    public MoSAMLSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoSAMLSettings settings) {
        this.settings = settings;
    }

    public static long getSerialversionuid() {
        return 1L;
    }

    public static Logger getLogger() {
        return LOGGER;
    }

    public BambooUserManager getBambooUserManager() {
        return this.bambooUserManager;
    }

    public void setBambooUserManager(BambooUserManager bambooUserManager) {
        this.bambooUserManager = bambooUserManager;
    }

    public String getXsrfToken() {
        return this.xsrfToken;
    }

    public void setXsrfToken(String xsrfToken) {
        this.xsrfToken = xsrfToken;
    }

    public Boolean getSigning() {
        return this.signing;
    }

    public void setSigning(Boolean signing) {
        this.signing = signing;
    }

    public Boolean getEncryption() {
        return this.encryption;
    }

    public void setEncryption(Boolean encryption) {
        this.encryption = encryption;
    }

    public Boolean getCertificatesSubmitted() {
        return this.certificatesSubmitted;
    }

    public void setCertificatesSubmitted(Boolean certificatesSubmitted) {
        this.certificatesSubmitted = certificatesSubmitted;
    }

    public Boolean getIsJCEInstalled() {
        return this.isJCEInstalled;
    }

    public void setIsJCEInstalled(Boolean isJCEInstalled) {
        this.isJCEInstalled = isJCEInstalled;
    }

    public Map<String, String> getCertificateInfo() {
        return MoSAMLUtils.getCertificateInfo(this.settings.getPublicSPCertificate());
    }

    public void setCertificateInfo(Map<String, String> certificateInfo) {
        this.certificateInfo = certificateInfo;
    }

    public String getCustomOrganizationName() {
        return this.customOrganizationName;
    }

    public void setCustomOrganizationName(String customOrganizationName) {
        this.customOrganizationName = customOrganizationName;
    }

    public String getCustomOrganizationDisplayName() {
        return this.customOrganizationDisplayName;
    }

    public void setCustomOrganizationDisplayName(String customOrganizationDisplayName) {
        this.customOrganizationDisplayName = customOrganizationDisplayName;
    }

    public String getCustomOrganizationUrl() {
        return this.customOrganizationUrl;
    }

    public void setCustomOrganizationUrl(String customOrganizationUrl) {
        this.customOrganizationUrl = customOrganizationUrl;
    }

    public String getTechnicalContactName() {
        return this.technicalContactName;
    }

    public void setTechnicalContactName(String technicalContactName) {
        this.technicalContactName = technicalContactName;
    }

    public String getTechnicalContactEmail() {
        return this.technicalContactEmail;
    }

    public void setTechnicalContactEmail(String technicalContactEmail) {
        this.technicalContactEmail = technicalContactEmail;
    }

    public String getSupportContactName() {
        return this.supportContactName;
    }

    public void setSupportContactName(String supportContactName) {
        this.supportContactName = supportContactName;
    }

    public String getSupportContactEmail() {
        return this.supportContactEmail;
    }

    public void setSupportContactEmail(String supportContactEmail) {
        this.supportContactEmail = supportContactEmail;
    }
}

