/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.dto;

import com.miniorange.sso.saml.MoPluginException;
import com.miniorange.sso.saml.utils.MoSAMLUtils;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.parsers.DOMParser;
import org.opensaml.Configuration;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml2.metadata.SingleLogoutService;
import org.opensaml.saml2.metadata.SingleSignOnService;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.Unmarshaller;
import org.opensaml.xml.io.UnmarshallerFactory;
import org.opensaml.xml.security.credential.UsageType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class MoIDPMetadata {
    private static Log LOGGER = LogFactory.getLog(MoIDPMetadata.class);
    private String metadata;
    private EntityDescriptor entityDescriptor;
    public static String entityId;
    private Map<String, String> singleSignOnServices;
    private Map<String, Map> singleLogoutServices;
    public static List<String> signingCertificates;
    public static String certificate;
    public static String nameIdFormat;
    public static String authnContextClass;
    public static String otherAuthnContextClass;

    public MoIDPMetadata(String metadata) {
        try {
            if (StringUtils.isNotBlank((CharSequence)metadata) && metadata.trim().startsWith("<") && metadata.trim().endsWith(">")) {
                this.metadata = StringUtils.trimToEmpty((String)metadata);
                MoSAMLUtils.doBootstrap();
                DOMParser parser = new DOMParser();
                parser.parse(new InputSource(new StringReader(this.metadata)));
                Document document = parser.getDocument();
                Element element = document.getDocumentElement();
                UnmarshallerFactory unmarshallerFactory = Configuration.getUnmarshallerFactory();
                Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(element);
                XMLObject xmlObj = unmarshaller.unmarshall(element);
                this.entityDescriptor = (EntityDescriptor)xmlObj;
                IDPSSODescriptor idpssoDescriptor = this.entityDescriptor.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
                if (idpssoDescriptor != null) {
                    String location;
                    String binding;
                    entityId = this.entityDescriptor.getEntityID();
                    LOGGER.debug((Object)("EntityID: " + entityId));
                    this.singleSignOnServices = new HashMap<String, String>();
                    for (SingleSignOnService ssoService : idpssoDescriptor.getSingleSignOnServices()) {
                        binding = ssoService.getBinding();
                        location = ssoService.getLocation();
                        if (!StringUtils.equals((CharSequence)binding, (CharSequence)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect") && !StringUtils.equals((CharSequence)binding, (CharSequence)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST")) continue;
                        LOGGER.debug((Object)("SingleSignOnService Binding: " + binding + ", Location: " + location));
                        this.singleSignOnServices.put(binding, location);
                    }
                    this.singleLogoutServices = new HashMap<String, Map>();
                    for (SingleLogoutService sloService : idpssoDescriptor.getSingleLogoutServices()) {
                        binding = sloService.getBinding();
                        location = sloService.getLocation();
                        final String responseLocation = sloService.getResponseLocation();
                        if (!StringUtils.equals((CharSequence)binding, (CharSequence)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect") && !StringUtils.equals((CharSequence)binding, (CharSequence)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST")) continue;
                        LOGGER.debug((Object)("SingleLogoutService Binding: " + binding + ", Location: " + location));
                        this.singleLogoutServices.put(binding, new HashMap<String, String>(){
                            {
                                this.put("location", location);
                                this.put("responseLocation", responseLocation);
                            }
                        });
                    }
                    nameIdFormat = !idpssoDescriptor.getNameIDFormats().isEmpty() ? (String)StringUtils.defaultIfBlank((CharSequence)idpssoDescriptor.getNameIDFormats().get(0).getFormat(), (CharSequence)"urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified") : "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified";
                    signingCertificates = new ArrayList<String>();
                    for (KeyDescriptor key : idpssoDescriptor.getKeyDescriptors()) {
                        certificate = null;
                        if (key.getKeyInfo().getX509Datas().size() > 0 && key.getKeyInfo().getX509Datas().get(0).getX509Certificates().size() > 0) {
                            certificate = key.getKeyInfo().getX509Datas().get(0).getX509Certificates().get(0).getValue();
                        }
                        if (StringUtils.isBlank((CharSequence)certificate)) break;
                        if (UsageType.UNSPECIFIED.equals((Object)key.getUse()) && MoSAMLUtils.isValidPublicCertificate(certificate).booleanValue()) {
                            signingCertificates.add(certificate);
                        }
                        if (!UsageType.SIGNING.equals((Object)key.getUse()) || !MoSAMLUtils.isValidPublicCertificate(certificate).booleanValue()) continue;
                        signingCertificates.add(certificate);
                    }
                    if (StringUtils.isNotBlank((CharSequence)entityId) && this.singleSignOnServices.size() > 0 && !signingCertificates.isEmpty()) {
                        return;
                    }
                }
            }
        }
        catch (Throwable t) {
            LOGGER.error((Object)MoPluginException.PluginErrorCode.METADATA_PARSE.getMessage(), t);
            throw new MoPluginException(MoPluginException.PluginErrorCode.METADATA_PARSE, t.getMessage(), t);
        }
        throw new MoPluginException(MoPluginException.PluginErrorCode.METADATA_PARSE, MoPluginException.PluginErrorCode.METADATA_PARSE.getMessage());
    }

    public EntityDescriptor getEntityDescriptor() {
        return this.entityDescriptor;
    }

    public void setEntityDescriptor(EntityDescriptor entityDescriptor) {
        this.entityDescriptor = entityDescriptor;
    }

    public String getEntityId() {
        return entityId;
    }

    public void setEntityId(String entityId) {
        MoIDPMetadata.entityId = entityId;
    }

    public Map<String, String> getSingleSignOnServices() {
        return this.singleSignOnServices;
    }

    public void setSingleSignOnServices(Map<String, String> singleSignOnServices) {
        this.singleSignOnServices = singleSignOnServices;
    }

    public Map<String, Map> getSingleLogoutServices() {
        return this.singleLogoutServices;
    }

    public void setSingleLogoutServices(Map<String, Map> singleLogoutServices) {
        this.singleLogoutServices = singleLogoutServices;
    }

    public List<String> getSigningCertificates() {
        return signingCertificates;
    }

    public void setSigningCertificates(List<String> signingCertificates) {
        MoIDPMetadata.signingCertificates = signingCertificates;
    }

    public static String getCertificate() {
        return certificate;
    }

    public static void setCertificate(String certificate) {
        MoIDPMetadata.certificate = certificate;
    }

    public static String getNameIdFormat() {
        return nameIdFormat;
    }

    public static void setNameIdFormat(String nameIdFormat) {
        MoIDPMetadata.nameIdFormat = nameIdFormat;
    }
}

