/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.bamboo.action;

import com.atlassian.bamboo.security.xsrf.XsrfTokenUtils;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.miniorange.sso.saml.bamboo.MoPluginHandler;
import com.miniorange.sso.saml.bamboo.MoSAMLSettings;
import com.miniorange.sso.saml.bamboo.action.MoCustomCertificatesAction;
import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.struts2.ServletActionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoCustomTemplateAction
extends BambooActionSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoCustomCertificatesAction.class);
    private String xsrfToken;
    private String errorMsgTemplate;
    private String logoutTemplate;
    private Boolean enableErrorMsgTemplate;
    private Boolean customtemplatesSubmitted;
    private UserManager userManager;
    private MoSAMLSettings settings;
    private LoginUriProvider loginUriProvider;

    public MoCustomTemplateAction(UserManager userManager, MoSAMLSettings settings, LoginUriProvider loginUriProvider) {
        this.userManager = userManager;
        this.settings = settings;
        this.loginUriProvider = loginUriProvider;
    }

    public String execute() throws Exception {
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        this.xsrfToken = XsrfTokenUtils.getXsrfToken((HttpServletRequest)request);
        UserProfile user = this.userManager.getRemoteUser();
        if (user != null && this.userManager.isAdmin(user.getUserKey())) {
            if (BooleanUtils.toBoolean((Boolean)this.customtemplatesSubmitted)) {
                MoPluginHandler.saveCustomTemplate(this.errorMsgTemplate, this.logoutTemplate, this.enableErrorMsgTemplate);
                this.addActionMessage(this.getText("samlsso.success.config"));
            }
            this.initializeSAMLConfig();
            return "success";
        }
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
        return null;
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    private void initializeSAMLConfig() {
        this.errorMsgTemplate = this.settings.getErrorMsgTemplate();
        this.logoutTemplate = this.settings.getLogoutTemplate();
        this.enableErrorMsgTemplate = this.settings.getEnableErrorMsgTemplate();
    }

    public String getXsrfToken() {
        return this.xsrfToken;
    }

    public void setXsrfToken(String xsrfToken) {
        this.xsrfToken = xsrfToken;
    }

    public String getErrorMsgTemplate() {
        return this.errorMsgTemplate;
    }

    public void setErrorMsgTemplate(String errorMsgTemplate) {
        this.errorMsgTemplate = errorMsgTemplate;
    }

    public String getLogoutTemplate() {
        return this.logoutTemplate;
    }

    public void setLogoutTemplate(String logoutTemplate) {
        this.logoutTemplate = logoutTemplate;
    }

    public Boolean getEnableErrorMsgTemplate() {
        return this.enableErrorMsgTemplate;
    }

    public void setEnableErrorMsgTemplate(Boolean enableErrorMsgTemplate) {
        this.enableErrorMsgTemplate = enableErrorMsgTemplate;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public MoSAMLSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoSAMLSettings settings) {
        this.settings = settings;
    }

    public LoginUriProvider getLoginUriProvider() {
        return this.loginUriProvider;
    }

    public void setLoginUriProvider(LoginUriProvider loginUriProvider) {
        this.loginUriProvider = loginUriProvider;
    }

    public Boolean getCustomtemplatesSubmitted() {
        return this.customtemplatesSubmitted;
    }

    public void setCustomtemplatesSubmitted(Boolean customtemplatesSubmitted) {
        this.customtemplatesSubmitted = customtemplatesSubmitted;
    }
}

