/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.bamboo;

import com.atlassian.bamboo.user.BambooUser;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.user.User;
import com.atlassian.user.search.SearchResult;
import com.atlassian.user.search.page.Pager;
import com.miniorange.sso.saml.MoSAMLException;
import com.miniorange.sso.saml.utils.MoHttpUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class MoSAMLUserManager {
    private static Log LOGGER = LogFactory.getLog(MoSAMLUserManager.class);
    private BambooUserManager bambooUserManager;

    public MoSAMLUserManager(BambooUserManager bambooUserManager) {
        this.bambooUserManager = bambooUserManager;
    }

    public static void replaceOldSettingsWithNew(String url, String idpID, String idpName) {
        ArrayList<NameValuePair> postParameters = new ArrayList<NameValuePair>();
        postParameters.add((NameValuePair)new BasicNameValuePair("idpID", idpID));
        postParameters.add((NameValuePair)new BasicNameValuePair("idpName", idpName));
        String result = MoHttpUtils.sendPostRequest(url, postParameters, "application/x-www-form-urlencoded", null);
    }

    public BambooUser getUserByUsernameOrEmail(String usernameOrEmail) {
        BambooUser user = this.searchUserByUsername(usernameOrEmail);
        if (user != null) {
            return user;
        }
        try {
            String username = this.searchUserByEmail(usernameOrEmail);
            user = this.searchUserByUsername(username);
            if (username != null) {
                return user;
            }
        }
        catch (MoSAMLException e) {
            LOGGER.error((Object)"An error occurred while searching for user ", (Throwable)e);
        }
        return null;
    }

    public BambooUser searchUserByUsername(String username) {
        LOGGER.debug((Object)("Searching for Bamboo user with username : " + username));
        BambooUser user = this.bambooUserManager.getBambooUser(username);
        return user;
    }

    public String searchUserByEmail(String email) {
        LOGGER.debug((Object)("Searching for Bamboo user with email : " + email));
        int count = 0;
        String username = "";
        SearchResult searchResult = this.bambooUserManager.getUsersByEmail(email);
        Pager pager = searchResult.pager();
        for (User user : pager) {
            username = user.getName();
            ++count;
        }
        if (count > 1) {
            throw new MoSAMLException(MoSAMLException.SAMLErrorCode.MULTIPLE_USER_FOUND);
        }
        LOGGER.debug((Object)("Found user by email = " + username));
        return username;
    }

    public Boolean isUserPresentInGroups(String username, List<String> groups) {
        LOGGER.debug((Object)("Testing for user " + username));
        try {
            BambooUser bambooUser = this.bambooUserManager.getBambooUser(username);
            List existingGroupsOfUser = new ArrayList();
            existingGroupsOfUser = this.bambooUserManager.getGroupNamesAsList((User)bambooUser);
            if (bambooUser != null) {
                for (String group : groups) {
                    if (!existingGroupsOfUser.contains(group)) continue;
                    return true;
                }
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error((Object)e.getMessage());
            return false;
        }
        return false;
    }

    public List<String> getUserGroupName(String username) {
        BambooUser bambooUser = this.bambooUserManager.getBambooUser(username);
        ArrayList<String> existingGroupsOfUser = new ArrayList();
        existingGroupsOfUser = this.bambooUserManager.getGroupNamesAsList((User)bambooUser);
        return existingGroupsOfUser;
    }

    public BambooUserManager getBambooUserManager() {
        return this.bambooUserManager;
    }

    public void setBambooUserManager(BambooUserManager bambooUserManager) {
        this.bambooUserManager = bambooUserManager;
    }
}

