/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.bamboo.servlet;

import com.atlassian.bamboo.user.BambooAuthenticationContext;
import com.atlassian.user.User;
import com.miniorange.sso.saml.bamboo.MoSAMLSettings;
import com.miniorange.sso.saml.utils.MoSAMLUtils;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoSAMLLoginFilter
implements Filter {
    private static Log LOGGER = LogFactory.getLog(MoSAMLLoginFilter.class);
    private MoSAMLSettings settings;
    private BambooAuthenticationContext bambooAuthenticationContext;

    public MoSAMLLoginFilter(MoSAMLSettings settings, BambooAuthenticationContext bambooAuthenticationContext) {
        this.settings = settings;
        this.bambooAuthenticationContext = bambooAuthenticationContext;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            HttpServletRequest req = (HttpServletRequest)request;
            HttpServletResponse res = (HttpServletResponse)response;
            LOGGER.debug((Object)"Filter based auth called");
            User bambooUser = this.bambooAuthenticationContext.getUser();
            if (bambooUser != null) {
                chain.doFilter(request, response);
                return;
            }
            if (this.settings.getIdPList().size() != 1 && this.settings.getBambooRedirectionRulesMap().size() > 0) {
                LOGGER.debug((Object)"Multiple IDPs configured");
                chain.doFilter(request, response);
                return;
            }
            Boolean redirect = false;
            Boolean backdoor = false;
            String idp = "";
            Boolean backdoorEnabled = this.settings.getBackdoorEnabled();
            String backdoorKey = this.settings.getBackdoorKey();
            String backdoorValue = this.settings.getBackdoorValue();
            Boolean enableAutoRedirectDelay = this.settings.getEnableAutoRedirectDelay();
            boolean isLogout = Boolean.parseBoolean(StringUtils.defaultString((String)req.getParameter("logout"), (String)"false"));
            if (req.getParameter(backdoorKey) != null) {
                backdoor = req.getParameter(backdoorKey).equals(backdoorValue);
            }
            if (this.settings.getBambooRedirectionRulesMap().size() == 0 && !this.settings.getDefaultBambooIDP().equals("loginPage") && !this.settings.getDefaultBambooIDP().equals("redirectUrl") && this.settings.getEnableSAMLSSO().booleanValue()) {
                LOGGER.debug((Object)"Redirect changed from False to true");
                redirect = true;
                idp = this.settings.getDefaultBambooIDP();
                LOGGER.debug((Object)("idp is:" + idp));
            }
            if (req.getParameter("moskipsso") != null && StringUtils.equals((CharSequence)req.getParameter("moskipsso"), (CharSequence)"true")) {
                HttpSession session = req.getSession();
                Boolean noSSO = false;
                noSSO = (Boolean)session.getAttribute("noSSO");
                LOGGER.debug((Object)("noSSO = " + noSSO));
                if (BooleanUtils.isTrue(noSSO)) {
                    LOGGER.debug((Object)"Switching off redirection.");
                    redirect = false;
                } else {
                    redirect = true;
                }
            }
            if (!redirect.booleanValue() || enableAutoRedirectDelay.booleanValue() || backdoorEnabled.booleanValue() && backdoor.booleanValue()) {
                LOGGER.debug((Object)"No redirection through filter");
                chain.doFilter(request, response);
                return;
            }
            StringBuffer buffer = new StringBuffer(this.settings.getLoginServletUrl());
            String redirectTo = "";
            if (req.getParameter("os_destination") != null) {
                LOGGER.debug((Object)("Value of os_destination = " + req.getParameter("os_destination")));
                redirectTo = req.getParameter("os_destination");
            }
            if (StringUtils.isNotBlank((CharSequence)redirectTo)) {
                LOGGER.debug((Object)"Sanitizing the redirectTo value");
                redirectTo = MoSAMLUtils.sanitizeText(redirectTo);
                redirectTo = URLEncoder.encode(redirectTo, StandardCharsets.UTF_8.toString());
                LOGGER.debug((Object)("RedirectTo after sanitization and URL encoding " + redirectTo));
                buffer.append("?return_to=").append(redirectTo);
                if (StringUtils.isNotEmpty((CharSequence)idp)) {
                    buffer.append("&idp=").append(idp);
                }
            } else if (StringUtils.isNotEmpty((CharSequence)idp)) {
                buffer.append("?idp=").append(idp);
            }
            LOGGER.debug((Object)("Buffer : " + buffer));
            res.sendRedirect(buffer.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void destroy() {
    }

    public void setSettings(MoSAMLSettings settings) {
        this.settings = settings;
    }

    public BambooAuthenticationContext getBambooAuthenticationContext() {
        return this.bambooAuthenticationContext;
    }

    public void setBambooAuthenticationContext(BambooAuthenticationContext bambooAuthenticationContext) {
        this.bambooAuthenticationContext = bambooAuthenticationContext;
    }

    public MoSAMLSettings getSettings() {
        return this.settings;
    }
}

