/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.sitemesh;

import com.opensymphony.module.sitemesh.Decorator;
import com.opensymphony.module.sitemesh.Page;
import com.opensymphony.module.sitemesh.filter.PageFilter;
import com.opensymphony.webwork.config.Configuration;
import com.opensymphony.webwork.views.velocity.VelocityManager;
import com.opensymphony.xwork.ActionContext;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.Template;
import org.apache.velocity.context.Context;

public class VelocityPageFilter
extends PageFilter {
    private static final Log LOG = LogFactory.getLog(VelocityPageFilter.class);
    private FilterConfig filterConfig;

    public void init(FilterConfig filterConfig) {
        super.init(filterConfig);
        this.filterConfig = filterConfig;
    }

    protected void applyDecorator(Page page, Decorator decorator, HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        try {
            VelocityManager vm = VelocityManager.getInstance();
            ServletContext servletContext = this.filterConfig.getServletContext();
            ActionContext ctx = ActionContext.getContext();
            vm.init(servletContext);
            String encoding = this.getEncoding();
            Template template = vm.getVelocityEngine().getTemplate(decorator.getPage(), encoding);
            Context context = vm.createContext(ctx.getValueStack(), req, res);
            context.put("page", page);
            PrintWriter writer = res.getWriter();
            template.merge(context, writer);
            writer.flush();
        }
        catch (Exception e) {
            String msg = "Error applying decorator: " + e.getMessage();
            LOG.error(msg, e);
            throw new ServletException(msg, (Throwable)e);
        }
    }

    protected String getEncoding() {
        String encoding = (String)Configuration.get("webwork.i18n.encoding");
        if (encoding == null) {
            encoding = System.getProperty("file.encoding");
        }
        if (encoding == null) {
            encoding = "UTF-8";
        }
        return encoding;
    }
}

