/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.portlet.util;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CookieUtils {
    private static final Log log = LogFactory.getLog(CookieUtils.class);
    public static final String COOKIES_TO_SEND = "atlassian.core.web.cookies.unsent";
    private static final char DELIMITER = '\u0013';
    private static final int ENCODE_XORMASK = 90;
    private static final char ENCODE_CHAR_OFFSET1 = 'C';
    private static final char ENCODE_CHAR_OFFSET2 = 'i';

    public static void invalidateCookie(HttpServletRequest request, HttpServletResponse response, String cookieName, String path) {
        log.debug("CookieUtils.invalidateCookie " + cookieName + " for path " + path);
        CookieUtils.setCookie(request, response, cookieName, null, 0, path);
    }

    public static void invalidateCookie(HttpServletRequest request, HttpServletResponse response, String cookieName) {
        CookieUtils.invalidateCookie(request, response, cookieName, "/");
    }

    public static Cookie getCookie(HttpServletRequest request, String name) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null || name == null || name.length() == 0) {
            return null;
        }
        for (int i = 0; i < cookies.length; ++i) {
            if (!cookies[i].getName().equals(name)) continue;
            return cookies[i];
        }
        return null;
    }

    public static Cookie setCookie(HttpServletRequest request, HttpServletResponse response, String name, String value, int maxAge, String path) {
        log.debug("CookieUtils.setCookie " + name + ":" + value);
        Cookie cookie = new Cookie(name, value);
        cookie.setMaxAge(maxAge);
        cookie.setPath(path);
        response.addCookie(cookie);
        return cookie;
    }

    public static String getCookieValue(HttpServletRequest request, String name) {
        Cookie cookie = CookieUtils.getCookie(request, name);
        if (cookie != null) {
            return cookie.getValue();
        }
        return null;
    }

    public static String encodePasswordCookie(String username, String password) {
        return CookieUtils.encodePasswordCookie(username, password, new String(new char[]{'\u0013', 'C', 'i'}));
    }

    public static String encodePasswordCookie(String username, String password, String encoding) {
        StringBuffer buf = new StringBuffer();
        if (username != null && password != null) {
            int offset1 = encoding != null && encoding.length() > 1 ? (int)encoding.charAt(1) : 67;
            int offset2 = encoding != null && encoding.length() > 2 ? (int)encoding.charAt(2) : 105;
            byte[] bytes = (username + '\u0013' + password).getBytes();
            for (int n = 0; n < bytes.length; ++n) {
                int b = bytes[n] ^ 90 + n;
                buf.append((char)(offset1 + (b & 0xF)));
                buf.append((char)(offset2 + (b >> 4 & 0xF)));
            }
        }
        return buf.toString();
    }

    public static String[] decodePasswordCookie(String cookieVal) {
        return CookieUtils.decodePasswordCookie(cookieVal, new String(new char[]{'\u0013', 'C', 'i'}));
    }

    public static String[] decodePasswordCookie(String cookieVal, String encoding) {
        if (cookieVal == null || cookieVal.length() <= 0) {
            return null;
        }
        int offset1 = encoding != null && encoding.length() > 1 ? (int)encoding.charAt(1) : 67;
        int offset2 = encoding != null && encoding.length() > 2 ? (int)encoding.charAt(2) : 105;
        char[] chars = cookieVal.toCharArray();
        byte[] bytes = new byte[chars.length / 2];
        int m = 0;
        for (int n = 0; n < bytes.length; ++n) {
            int b = chars[m++] - offset1;
            bytes[n] = (byte)((b |= chars[m++] - offset2 << 4) ^ 90 + n);
        }
        cookieVal = new String(bytes);
        int pos = cookieVal.indexOf(19);
        String username = pos < 0 ? "" : cookieVal.substring(0, pos);
        String password = pos < 0 ? "" : cookieVal.substring(pos + 1);
        return new String[]{username, password};
    }
}

