/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.portlet.sitemesh;

import com.opensymphony.webwork.portlet.sitemesh.InfrastructureException;
import com.opensymphony.webwork.views.velocity.VelocityManager;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class VelocityUtils {
    private static final Log log = LogFactory.getLog(VelocityUtils.class);

    public static String getRenderedTemplate(String templateName, Map contextMap) {
        return VelocityUtils.getRenderedTemplate(templateName, new VelocityContext(contextMap));
    }

    public static String getRenderedTemplate(String templateName, Context context) {
        try {
            return VelocityUtils.getRenderedTemplateWithoutSwallowingErrors(templateName, context);
        }
        catch (Exception e) {
            log.error("Error occurred rendering template: " + templateName, e);
            return "";
        }
    }

    public static String getRenderedTemplateWithoutSwallowingErrors(String templateName, Context context) throws Exception {
        Template template = VelocityUtils.getTemplate(templateName);
        StringWriter tempWriter = new StringWriter();
        template.merge(context, tempWriter);
        return tempWriter.toString();
    }

    public static Template getTemplate(String templateName) throws Exception {
        VelocityEngine velocityEngine = VelocityManager.getInstance().getVelocityEngine();
        String encoding = "UTF-8";
        Template template = velocityEngine.getTemplate(templateName, encoding);
        return template;
    }

    public static String getRenderedContent(String templateContent, Map contextMap) {
        try {
            StringWriter tempWriter = new StringWriter();
            VelocityContext context = new VelocityContext(contextMap);
            VelocityManager.getInstance().getVelocityEngine().evaluate((Context)context, (Writer)tempWriter, "getRenderedContent", templateContent);
            return tempWriter.toString();
        }
        catch (Exception e) {
            log.error("Error occurred rendering template content", e);
            throw new InfrastructureException("Error occurred rendering template content", e);
        }
    }
}

