/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.portlet;

import com.opensymphony.util.FileManager;
import com.opensymphony.webwork.config.Configuration;
import com.opensymphony.webwork.portlet.SessionMap;
import com.opensymphony.webwork.portlet.WebWorkPortletStatics;
import com.opensymphony.webwork.portlet.context.PortletContext;
import com.opensymphony.webwork.portlet.util.PortalContainer;
import com.opensymphony.webwork.portlet.util.PortletMessaging;
import com.opensymphony.webwork.util.AttributeMap;
import com.opensymphony.webwork.views.JspSupportServlet;
import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.ActionGlobalContext;
import com.opensymphony.xwork.ActionProxy;
import com.opensymphony.xwork.ActionProxyFactory;
import com.opensymphony.xwork.util.OgnlValueStack;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortalContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.pluto.core.impl.PortletConfigImpl;

public class WebWorkPortlet
extends GenericPortlet
implements WebWorkPortletStatics {
    private static final String NAME_RESULT = "result";
    private static final String NAME_ACTION = "wwAction";
    private static final String NAME_XACTION = "wwXAction";
    private static final String NAME_LINK = "wwLink";
    private static final String NAME_DEFAULT_VIEW_FILE = "defaultViewFile";
    private static final String NAME_DEFAULT_EDIT_FILE = "defaultEditFile";
    private static final String NAME_DEFAULT_HELP_FILE = "defaultHelpFile";
    private String helpFileName = "";
    private String mockHelpFileName = "";
    private Map cheatRequestMap = null;

    public void init() throws PortletException {
        if ("true".equalsIgnoreCase(Configuration.getString("webwork.configuration.xml.reload"))) {
            FileManager.setReloadingConfigs((boolean)true);
        }
        this.helpFileName = this.getInitParameter(NAME_DEFAULT_HELP_FILE);
        int jspIndex = this.helpFileName.lastIndexOf(".jsp");
        if (jspIndex >= 0) {
            this.mockHelpFileName = this.helpFileName.substring(0, jspIndex) + ".jspt";
        } else {
            int index = this.helpFileName.lastIndexOf(".");
            this.mockHelpFileName = this.helpFileName.substring(0, index) + ".vm";
        }
    }

    protected void doHelp(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        response.setContentType("text/html");
        ActionContext.getContext().put((Object)"template", (Object)this.helpFileName);
        PortletRequestDispatcher rd = this.getPortletContext().getRequestDispatcher(this.mockHelpFileName);
        try {
            rd.include(request, response);
        }
        catch (PortletException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.doService(request, response, NAME_DEFAULT_EDIT_FILE);
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.doService(request, response, NAME_DEFAULT_VIEW_FILE);
    }

    private void doService(RenderRequest request, RenderResponse response, String defalutFile) throws IOException, PortletException {
        try {
            response.setContentType("text/html");
            PortletContext portletContext = (PortletContext)PortletMessaging.receive((PortletRequest)request, "PortletContext");
            PortletContext.setContext(portletContext);
            ActionContext actionContext = (ActionContext)PortletMessaging.receive((PortletRequest)request, "ActionContext");
            ActionContext.setContext((ActionContext)actionContext);
            PortletURL portletURL = response.createActionURL();
            String actionURL = portletURL.toString();
            PortletContext.getContext().setActionURL(actionURL);
            String template = (String)request.getPortletSession().getAttribute("com.opensymphony.webwork.portlet.RenderTemplate");
            if (template == null || "".equals(template)) {
                template = this.getInitParameter(defalutFile);
            }
            if (!template.startsWith("/")) {
                template = "/" + template;
            }
            ActionContext.getContext().put((Object)"template", (Object)template);
            int jspIndex = template.lastIndexOf(".jsp");
            String dispatchTemplate = template;
            if (jspIndex >= 0) {
                dispatchTemplate = template.substring(0, jspIndex) + ".jspt";
            }
            OgnlValueStack stack = ActionContext.getContext().getValueStack();
            request.setAttribute("webwork.valueStack", (Object)stack);
            PortletRequestDispatcher rd = this.getPortletContext().getRequestDispatcher(dispatchTemplate);
            rd.include(request, response);
            ActionContext.setContext(null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        try {
            try {
                JspSupportServlet servlet = JspSupportServlet.jspSupportServlet;
                if (servlet != null) {
                    PortletContext.getContext().setServletContext(servlet.getServletContext());
                }
            }
            catch (Exception e) {
                PortletContext.getContext().setServletConfig(((PortletConfigImpl)this.getPortletConfig()).getServletConfig());
            }
            String nameAction = request.getParameter(NAME_ACTION);
            String nameXAction = request.getParameter(NAME_XACTION);
            String templateFileName = request.getParameter(NAME_LINK);
            String cheatKey = "";
            String cheatValue = "";
            if (nameXAction != null && !"".equals(nameXAction)) {
                int beginIdx = nameXAction.indexOf("./");
                nameAction = nameXAction.substring(beginIdx == -1 ? 0 : beginIdx + 1, nameXAction.length());
                int beginPIdx = nameAction.indexOf("?");
                int beginPEIdx = nameAction.indexOf("=");
                if (beginPIdx >= 0 && beginPEIdx > 0) {
                    cheatKey = nameAction.substring(beginPIdx + 1, beginPEIdx);
                    cheatValue = nameAction.substring(beginPEIdx + 1, nameAction.length());
                }
            }
            if (nameAction == null || "".equals(nameAction)) {
                if (templateFileName == null) {
                    templateFileName = "";
                }
                request.getPortletSession().setAttribute("com.opensymphony.webwork.portlet.RenderTemplate", (Object)templateFileName);
                PortletMessaging.publish((PortletRequest)request, "ActionContext", ActionContext.getContext());
                PortletMessaging.publish((PortletRequest)request, "PortletContext", PortletContext.getContext());
                return;
            }
            String nameSpace = "";
            int lastIndex = nameAction.lastIndexOf("/");
            if (lastIndex > 0) {
                nameSpace = nameAction.substring(0, lastIndex);
            }
            String actionName = this.getActionName(nameAction);
            HashMap contextMap = this.createContextMap(this.getRequestMap((PortletRequest)request), request.getParameterMap(), this.getSessionMap((PortletRequest)request), this.getApplicationMap((PortletRequest)request), (PortletRequest)request, (PortletResponse)response, cheatKey, cheatValue);
            contextMap.put("com.opensymphony.webwork.portlet.PortletDispatcher", this);
            try {
                ActionProxy proxy = ActionProxyFactory.getFactory().createActionProxy(nameSpace, actionName, (Map)contextMap);
                proxy.execute();
                ActionGlobalContext.setContext(null);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            PortletMessaging.publish((PortletRequest)request, "ActionContext", ActionContext.getContext());
            PortletMessaging.publish((PortletRequest)request, "PortletContext", PortletContext.getContext());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private HashMap createContextMap(Map requestMap, Map parameterMap, Map sessionMap, Map applicationMap, PortletRequest request, PortletResponse response, String cheatKey, String cheatValue) {
        HashMap<String, Object> extraContext = new HashMap<String, Object>();
        String[] cheatValues = new String[]{cheatValue};
        if (!"".equals(cheatKey) && !"".equals(cheatValue)) {
            parameterMap.put(cheatKey, cheatValues);
        }
        extraContext.put("com.opensymphony.xwork.ActionContext.parameters", parameterMap);
        extraContext.put("com.opensymphony.xwork.ActionContext.session", sessionMap);
        extraContext.put("com.opensymphony.xwork.ActionContext.application", applicationMap);
        extraContext.put("com.opensymphony.xwork.ActionContext.locale", request.getLocale());
        extraContext.put("com.opensymphony.webwork.portlet.PortletRequest", request);
        extraContext.put("com.opensymphony.webwork.portlet.PortletResponse", response);
        extraContext.put("com.opensymphony.webwork.portlet.context.PortletContext", this.getPortletContext());
        extraContext.put("request", requestMap);
        extraContext.put("session", sessionMap);
        extraContext.put("application", applicationMap);
        extraContext.put("parameters", parameterMap);
        AttributeMap attrMap = new AttributeMap(extraContext);
        extraContext.put("attr", attrMap);
        return extraContext;
    }

    private Map getSessionMap(PortletRequest request) {
        return new SessionMap(request);
    }

    private Map getApplicationMap(PortletRequest request) {
        HashMap<String, String> result = new HashMap<String, String>();
        PortalContext context = request.getPortalContext();
        if (context == null) {
            return result;
        }
        boolean isJetSpeed = 1 == PortalContainer.get();
        Enumeration propNames = context.getPropertyNames();
        while (propNames.hasMoreElements()) {
            String key = (String)propNames.nextElement();
            if (key == null || isJetSpeed & key != null & key.startsWith("supported.")) continue;
            String value = request.getPortalContext().getProperty(key);
            result.put(key, value);
        }
        return result;
    }

    private Map getRequestMap(PortletRequest request) {
        Enumeration attNames = request.getAttributeNames();
        HashMap<String, Object> result = new HashMap<String, Object>();
        while (attNames.hasMoreElements()) {
            String key = (String)attNames.nextElement();
            Object value = request.getAttribute(key);
            result.put(key, value);
        }
        return result;
    }

    private String getActionName(String name) {
        int beginIdx = name.lastIndexOf("/");
        name = name.substring(beginIdx == -1 ? 0 : beginIdx + 1, name.length());
        int endIdx = name.indexOf(".");
        return name.substring(0, endIdx == -1 ? name.length() : endIdx);
    }
}

