/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.portlet;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;

public class SessionMap
extends AbstractMap
implements Serializable {
    PortletSession session;
    Set entries;

    public SessionMap(PortletRequest request) {
        this.session = request.getPortletSession(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        PortletSession portletSession = this.session;
        synchronized (portletSession) {
            this.entries = null;
            this.session.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set entrySet() {
        PortletSession portletSession = this.session;
        synchronized (portletSession) {
            if (this.entries == null) {
                this.entries = new HashSet();
                Enumeration enumeration = this.session.getAttributeNames();
                while (enumeration.hasMoreElements()) {
                    final String key = enumeration.nextElement().toString();
                    final Object value = this.session.getAttribute(key);
                    this.entries.add(new Map.Entry(){

                        public boolean equals(Object obj) {
                            Map.Entry entry = (Map.Entry)obj;
                            return (key == null ? entry.getKey() == null : key.equals(entry.getKey())) && (value == null ? entry.getValue() == null : value.equals(entry.getValue()));
                        }

                        public int hashCode() {
                            return (key == null ? 0 : key.hashCode()) ^ (value == null ? 0 : value.hashCode());
                        }

                        public Object getKey() {
                            return key;
                        }

                        public Object getValue() {
                            return value;
                        }

                        public Object setValue(Object obj) {
                            SessionMap.this.session.setAttribute(key.toString(), obj);
                            return value;
                        }
                    });
                }
            }
        }
        return this.entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key) {
        PortletSession portletSession = this.session;
        synchronized (portletSession) {
            return this.session.getAttribute(key.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object key, Object value) {
        PortletSession portletSession = this.session;
        synchronized (portletSession) {
            this.entries = null;
            this.session.setAttribute(key.toString(), value);
            return this.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object key) {
        PortletSession portletSession = this.session;
        synchronized (portletSession) {
            this.entries = null;
            Object value = this.get(key);
            this.session.removeAttribute(key.toString());
            return value;
        }
    }
}

