/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.dispatcher.multipart;

import com.opensymphony.webwork.config.Configuration;
import com.opensymphony.webwork.dispatcher.multipart.MultiPartRequest;
import http.utils.multipartrequest.MultipartRequest;
import http.utils.multipartrequest.ServletMultipartRequest;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class PellMultiPartRequest
extends MultiPartRequest {
    private ServletMultipartRequest multi;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PellMultiPartRequest(HttpServletRequest servletRequest, String saveDir, int maxSize) throws IOException {
        PellMultiPartRequest pellMultiPartRequest = this;
        synchronized (pellMultiPartRequest) {
            PellMultiPartRequest.setEncoding();
            this.multi = new ServletMultipartRequest(servletRequest, saveDir, maxSize);
        }
    }

    public Enumeration getFileParameterNames() {
        return this.multi.getFileParameterNames();
    }

    public String[] getContentType(String fieldName) {
        return new String[]{this.multi.getContentType(fieldName)};
    }

    public File[] getFile(String fieldName) {
        return new File[]{this.multi.getFile(fieldName)};
    }

    public String[] getFileNames(String fieldName) {
        return new String[]{this.multi.getFile(fieldName).getName()};
    }

    public String[] getFilesystemName(String fieldName) {
        return new String[]{this.multi.getFileSystemName(fieldName)};
    }

    public String getParameter(String name) {
        return this.multi.getURLParameter(name);
    }

    public Enumeration getParameterNames() {
        return this.multi.getParameterNames();
    }

    public String[] getParameterValues(String name) {
        Enumeration enumeration = this.multi.getURLParameters(name);
        if (!enumeration.hasMoreElements()) {
            return null;
        }
        ArrayList values = new ArrayList();
        while (enumeration.hasMoreElements()) {
            values.add(enumeration.nextElement());
        }
        return values.toArray(new String[values.size()]);
    }

    public List getErrors() {
        return Collections.EMPTY_LIST;
    }

    private static void setEncoding() {
        String encoding = null;
        try {
            encoding = Configuration.getString("webwork.i18n.encoding");
            if (encoding != null) {
                MultipartRequest.setEncoding((String)encoding);
            } else {
                MultipartRequest.setEncoding((String)"UTF-8");
            }
        }
        catch (IllegalArgumentException e) {
            log.info("Could not get encoding property 'webwork.i18n.encoding' for file upload.  Using system default");
        }
        catch (UnsupportedEncodingException e) {
            log.error("Encoding " + encoding + " is not a valid encoding.  Please check your webwork.properties file.");
        }
    }
}

